/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import javax.xml.transform.TransformerException;

public class Loader {
    private static boolean tracing = false;

    public static synchronized void setTracing(boolean bl) {
        tracing = bl;
    }

    public static Class getClass(String string) throws TransformerException {
        if (tracing) {
            System.err.println("Loading " + string);
        }
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader != null) {
                try {
                    return classLoader.loadClass(string);
                }
                catch (Exception exception) {
                    return Class.forName(string);
                }
            }
            return Class.forName(string);
        }
        catch (Exception exception) {
            if (tracing) {
                System.err.println("No Java class " + string + " could be loaded");
            }
            throw new TransformerException("Failed to load " + string, exception);
        }
    }

    public static Object getInstance(String string) throws TransformerException {
        Class clazz = Loader.getClass(string);
        try {
            return clazz.newInstance();
        }
        catch (Exception exception) {
            throw new TransformerException("Failed to instantiate class " + string, exception);
        }
    }
}

