/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import java.io.IOException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.Controller;
import net.sf.saxon.event.ContentHandlerProxy;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public class Filter
implements XMLFilter {
    private Controller controller;
    private XMLReader parser;
    private ContentHandler contentHandler;
    private LexicalHandler lexicalHandler;

    protected Filter(Controller controller) {
        this.controller = controller;
    }

    public void setParent(XMLReader xMLReader) {
        this.parser = xMLReader;
    }

    public XMLReader getParent() {
        return this.parser;
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals("http://xml.org/sax/features/namespaces")) {
            return true;
        }
        if (string.equals("http://xml.org/sax/features/namespace-prefixes")) {
            return false;
        }
        throw new SAXNotRecognizedException(string);
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals("http://xml.org/sax/features/namespaces")) {
            if (!bl) {
                throw new SAXNotSupportedException(string);
            }
        } else if (string.equals("http://xml.org/sax/features/namespace-prefixes")) {
            if (bl) {
                throw new SAXNotSupportedException(string);
            }
        } else {
            throw new SAXNotRecognizedException(string);
        }
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals("http://xml.org/sax/properties/lexical-handler")) {
            return this.lexicalHandler;
        }
        throw new SAXNotRecognizedException(string);
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals("http://xml.org/sax/properties/lexical-handler")) {
            if (!(object instanceof LexicalHandler)) {
                throw new SAXNotSupportedException("Lexical Handler must be instance of org.xml.sax.ext.LexicalHandler");
            }
        } else {
            throw new SAXNotRecognizedException(string);
        }
        this.lexicalHandler = (LexicalHandler)object;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
        if (contentHandler instanceof LexicalHandler && this.lexicalHandler == null) {
            this.lexicalHandler = (LexicalHandler)((Object)contentHandler);
        }
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
    }

    public ErrorHandler getErrorHandler() {
        return null;
    }

    public void parse(InputSource inputSource) throws IOException, SAXException {
        if (this.parser == null) {
            try {
                this.parser = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
            }
            catch (Exception exception) {
                throw new SAXException(exception);
            }
        }
        SAXSource sAXSource = new SAXSource();
        sAXSource.setInputSource(inputSource);
        sAXSource.setXMLReader(this.parser);
        ContentHandlerProxy contentHandlerProxy = new ContentHandlerProxy();
        contentHandlerProxy.setNamePool(this.controller.getNamePool());
        contentHandlerProxy.setUnderlyingContentHandler(this.contentHandler);
        if (this.lexicalHandler != null) {
            contentHandlerProxy.setLexicalHandler(this.lexicalHandler);
        }
        try {
            this.controller.transform(sAXSource, contentHandlerProxy);
        }
        catch (TransformerException transformerException) {
            Throwable throwable = transformerException.getException();
            if (throwable != null && throwable instanceof SAXException) {
                throw (SAXException)throwable;
            }
            if (throwable != null && throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            throw new SAXException(transformerException);
        }
    }

    public void parse(String string) throws IOException, SAXException {
        InputSource inputSource = new InputSource(string);
        this.parse(inputSource);
    }

    public Transformer getTransformer() {
        return this.controller;
    }
}

