/*
 * Decompiled with CFR 0.152.
 */
package jasmin;

abstract class ScannerUtils {
    ScannerUtils() {
    }

    public static Number convertInt(String str, int radix) throws NumberFormatException {
        long x = Long.parseLong(str, radix);
        if (x <= Integer.MAX_VALUE && x >= Integer.MIN_VALUE) {
            return new Integer((int)x);
        }
        return new Long(x);
    }

    public static Number convertNumber(String str) throws NumberFormatException {
        if (str.startsWith("+")) {
            return new Integer(str.substring(1, str.length()));
        }
        if (str.startsWith("0x")) {
            return ScannerUtils.convertInt(str.substring(2), 16);
        }
        if (str.indexOf(46) != -1) {
            double x = new Double(str);
            if (x <= 3.4028234663852886E38 && x >= (double)1.4E-45f) {
                return new Float((float)x);
            }
            return new Double(x);
        }
        return ScannerUtils.convertInt(str, 10);
    }

    public static String convertDots(String orig_name) {
        return ScannerUtils.convertChars(orig_name, ".", '/');
    }

    public static String convertChars(String orig_name, String chars, char toChar) {
        StringBuffer tmp = new StringBuffer(orig_name);
        for (int i = 0; i < tmp.length(); ++i) {
            if (chars.indexOf(tmp.charAt(i)) == -1) continue;
            tmp.setCharAt(i, toChar);
        }
        return new String(tmp);
    }

    public static String[] splitClassMethodSignature(String name) {
        String[] result = new String[3];
        int pos = 0;
        int sigpos = 0;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '.' || c == '/') {
                pos = i;
                continue;
            }
            if (c != '(') continue;
            sigpos = i;
            break;
        }
        try {
            result[0] = ScannerUtils.convertDots(name.substring(0, pos));
            result[1] = name.substring(pos + 1, sigpos);
            result[2] = ScannerUtils.convertDots(name.substring(sigpos));
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("malformed signature : " + name);
        }
        return result;
    }

    public static String[] splitClassField(String name) {
        String[] result = new String[2];
        int pos = -1;
        boolean sigpos = false;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c != '.' && c != '/') continue;
            pos = i;
        }
        if (pos == -1) {
            result[0] = null;
            result[1] = name;
        } else {
            result[0] = ScannerUtils.convertDots(name.substring(0, pos));
            result[1] = name.substring(pos + 1);
        }
        return result;
    }

    public static String[] splitMethodSignature(String name) {
        String[] result = new String[2];
        int sigpos = 0;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c != '(') continue;
            sigpos = i;
            break;
        }
        result[0] = name.substring(0, sigpos);
        result[1] = ScannerUtils.convertDots(name.substring(sigpos));
        return result;
    }
}

