/*
 * Copyright (c) 2022-2023 Arm Limited.
 *
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

#if defined(ARM_COMPUTE_ENABLE_SME2)

#include <algorithm>
#include <cstddef>

namespace arm_conv {
namespace depthwise {

void sme2_fp32bf16fp32_planar_5x5_s1_4rows_dot_za_impl(
  const float *inptr,
  size_t ld_in_row,
  size_t ld_in_col,
  size_t ld_in_vl,
  unsigned int pad_top,
  unsigned int valid_input_rows,
  unsigned int pad_left,
  unsigned int valid_input_cols,
  const float *weights,
  const float *bias,
  float **outptrs,
  const size_t *outlds,
  const size_t *outvllds,
  unsigned int output_cols,
  unsigned int start_channel,
  unsigned int valid_channels,
  float act_min,
  float act_max
)
{
  struct Args
  {
    const float *inptr;
    size_t ld_in_vl;
    long unsigned int pad_top, pad_bottom, pad_left;
    const float *weights;
    const float *bias;
    long unsigned int input_cols, output_cols;
    float **outptrs;
    const size_t *ld_out_cols;
    const size_t *ld_out_vls;
    long unsigned int current_channel, n_channels;
    float clamp_min, clamp_max;
  };

  Args args = { inptr, ld_in_vl, pad_top, 8u - std::min(8u, pad_top + valid_input_rows), pad_left, weights, bias, valid_input_cols, output_cols, outptrs, outlds, outvllds, start_channel, valid_channels, act_min, act_max };

  __asm__ __volatile__(
    "ldr x4, [%x[args], %[offsetof_Args_pad_bottom]]\n"
    "mov x20, #0x8\n"
    ".inst 0xd503477f  // SMSTART ZA\n"
    "sub x20, x20, x4\n"
    "ldr x6, [%x[args], %[offsetof_Args_pad_top]]\n"
    "ptrue p2.b\n"
    ".inst 0x25207812  // ptrue pn10.b\n"
    "ld1rw { z29.s }, p2/Z, [%x[args], %[offsetof_Args_clamp_min]]\n"
    "ldr x7, [%x[args], %[offsetof_Args_n_channels]]\n"
    "whilelt p1.s, XZR, x7\n"
    "whilelt p9.s, XZR, x20\n"
    "ld1rw { z28.s }, p2/Z, [%x[args], %[offsetof_Args_clamp_max]]\n"
    "whilelt p8.s, XZR, x6\n"
    "addvl SP, SP, #-30\n"
    "ldr x17, [%x[args], %[offsetof_Args_current_channel]]\n"
    "eor p8.b, p2/Z, p8.b, p9.b\n"
    "1:"  // Channel loop
    "ldr x21, [%x[args], %[offsetof_Args_bias]]\n"
    "fmov z30.s, #0x0\n"
    "cbz x21, 2f\n"
    "ld1w { z30.s }, p1/Z, [x21, x17, LSL #2]\n"
    "2:"  // Load bias: Done
    "ldr x21, [%x[args], %[offsetof_Args_weights]]\n"
    "mov x20, x21\n"
    "ld1w { z12.s }, p2/Z, [x20]\n"
    "incb x20, ALL, MUL #5\n"
    "ld1w { z24.s }, p2/Z, [x20]\n"
    "incb x20, ALL, MUL #5\n"
    "fmov z11.s, #0x0\n"
    "incb x21\n"
    "ld1w { z3.s }, p2/Z, [x20]\n"
    "incb x20, ALL, MUL #5\n"
    ".inst 0x658aa99a  // bfcvt z26.h, p2/M, z12.s\n"
    ".inst 0x658aab10  // bfcvt z16.h, p2/M, z24.s\n"
    "ld1w { z20.s }, p2/Z, [x20]\n"
    "incb x20, ALL, MUL #5\n"
    "addvl x24, SP, #30\n"
    ".inst 0x648aa98b  // bfcvtnt z11.h, p2/M, z12.s\n"
    "ld1w { z25.s }, p2/Z, [x20]\n"
    "mov x20, x21\n"
    ".inst 0x658aa875  // bfcvt z21.h, p2/M, z3.s\n"
    "addvl x24, x24, #-6\n"
    "ld1w { z6.s }, p2/Z, [x20]\n"
    ".inst 0x658aaa9b  // bfcvt z27.h, p2/M, z20.s\n"
    "incb x20, ALL, MUL #5\n"
    "st1h { z11.h }, p2, [x24]\n"
    ".inst 0x648aab1a  // bfcvtnt z26.h, p2/M, z24.s\n"
    "ld1w { z14.s }, p2/Z, [x20]\n"
    "incb x20, ALL, MUL #5\n"
    "fmov z11.s, #0x0\n"
    "st1h { z26.h }, p2, [x24, #1, MUL VL]\n"
    ".inst 0x648aa870  // bfcvtnt z16.h, p2/M, z3.s\n"
    "ld1w { z19.s }, p2/Z, [x20]\n"
    "incb x20, ALL, MUL #5\n"
    ".inst 0x658aa8c9  // bfcvt z9.h, p2/M, z6.s\n"
    ".inst 0x648aaa95  // bfcvtnt z21.h, p2/M, z20.s\n"
    "incb x21\n"
    "ld1w { z12.s }, p2/Z, [x20]\n"
    "incb x20, ALL, MUL #5\n"
    "st1h { z16.h }, p2, [x24, #2, MUL VL]\n"
    ".inst 0x648aab3b  // bfcvtnt z27.h, p2/M, z25.s\n"
    ".inst 0x658aab37  // bfcvt z23.h, p2/M, z25.s\n"
    "ld1w { z5.s }, p2/Z, [x20]\n"
    ".inst 0x658aa9c8  // bfcvt z8.h, p2/M, z14.s\n"
    "mov x23, x21\n"
    "st1h { z21.h }, p2, [x24, #3, MUL VL]\n"
    ".inst 0x648aa8cb  // bfcvtnt z11.h, p2/M, z6.s\n"
    ".inst 0x658aaa79  // bfcvt z25.h, p2/M, z19.s\n"
    "ld1w { z4.s }, p2/Z, [x23]\n"
    "incb x23, ALL, MUL #5\n"
    "st1h { z27.h }, p2, [x24, #4, MUL VL]\n"
    ".inst 0x648aa9c9  // bfcvtnt z9.h, p2/M, z14.s\n"
    ".inst 0x658aa991  // bfcvt z17.h, p2/M, z12.s\n"
    "incb x21\n"
    "st1h { z23.h }, p2, [x24, #5, MUL VL]\n"
    "addvl x24, x24, #-6\n"
    "ld1w { z26.s }, p2/Z, [x23]\n"
    "incb x23, ALL, MUL #5\n"
    "st1h { z11.h }, p2, [x24]\n"
    "fmov z2.s, #0x0\n"
    ".inst 0x648aaa68  // bfcvtnt z8.h, p2/M, z19.s\n"
    "ldr x25, [%x[args], %[offsetof_Args_input_cols]]\n"
    "st1h { z9.h }, p2, [x24, #1, MUL VL]\n"
    "ld1w { z27.s }, p2/Z, [x23]\n"
    "incb x23, ALL, MUL #5\n"
    ".inst 0x658aa893  // bfcvt z19.h, p2/M, z4.s\n"
    "st1h { z8.h }, p2, [x24, #2, MUL VL]\n"
    ".inst 0x648aa999  // bfcvtnt z25.h, p2/M, z12.s\n"
    "ld1w { z7.s }, p2/Z, [x23]\n"
    "incb x23, ALL, MUL #5\n"
    ".inst 0x658aab4e  // bfcvt z14.h, p2/M, z26.s\n"
    ".inst 0x648aa8b1  // bfcvtnt z17.h, p2/M, z5.s\n"
    "st1h { z25.h }, p2, [x24, #3, MUL VL]\n"
    "ldr x16, [%x[args], %[offsetof_Args_inptr]]\n"
    ".inst 0x658aa8ab  // bfcvt z11.h, p2/M, z5.s\n"
    "ld1w { z18.s }, p2/Z, [x23]\n"
    "mov x20, x21\n"
    ".inst 0x648aa882  // bfcvtnt z2.h, p2/M, z4.s\n"
    ".inst 0x658aab66  // bfcvt z6.h, p2/M, z27.s\n"
    "ld1w { z15.s }, p2/Z, [x20]\n"
    "incb x20, ALL, MUL #5\n"
    "st1h { z17.h }, p2, [x24, #4, MUL VL]\n"
    "st1h { z11.h }, p2, [x24, #5, MUL VL]\n"
    "addvl x24, x24, #-6\n"
    ".inst 0x648aab53  // bfcvtnt z19.h, p2/M, z26.s\n"
    ".inst 0x658aa8fa  // bfcvt z26.h, p2/M, z7.s\n"
    "ld1w { z11.s }, p2/Z, [x20]\n"
    "incb x20, ALL, MUL #5\n"
    "st1h { z2.h }, p2, [x24]\n"
    ".inst 0x648aab6e  // bfcvtnt z14.h, p2/M, z27.s\n"
    "ld1w { z4.s }, p2/Z, [x20]\n"
    "fmov z21.s, #0x0\n"
    "st1h { z19.h }, p2, [x24, #1, MUL VL]\n"
    "incb x20, ALL, MUL #5\n"
    ".inst 0x658aa9ea  // bfcvt z10.h, p2/M, z15.s\n"
    "st1h { z14.h }, p2, [x24, #2, MUL VL]\n"
    ".inst 0x648aa8e6  // bfcvtnt z6.h, p2/M, z7.s\n"
    "incb x21\n"
    "ld1w { z17.s }, p2/Z, [x20]\n"
    "incb x20, ALL, MUL #5\n"
    ".inst 0x658aa973  // bfcvt z19.h, p2/M, z11.s\n"
    "st1h { z6.h }, p2, [x24, #3, MUL VL]\n"
    ".inst 0x648aaa5a  // bfcvtnt z26.h, p2/M, z18.s\n"
    ".inst 0x658aaa45  // bfcvt z5.h, p2/M, z18.s\n"
    "ld1w { z12.s }, p2/Z, [x20]\n"
    "mov x21, x21\n"
    ".inst 0x658aa897  // bfcvt z23.h, p2/M, z4.s\n"
    ".inst 0x648aa9f5  // bfcvtnt z21.h, p2/M, z15.s\n"
    "ld1w { z24.s }, p2/Z, [x21]\n"
    "incb x21, ALL, MUL #5\n"
    ".inst 0x648aa96a  // bfcvtnt z10.h, p2/M, z11.s\n"
    "ld1w { z3.s }, p2/Z, [x21]\n"
    "incb x21, ALL, MUL #5\n"
    "st1h { z26.h }, p2, [x24, #4, MUL VL]\n"
    ".inst 0x648aa893  // bfcvtnt z19.h, p2/M, z4.s\n"
    ".inst 0x658aaa30  // bfcvt z16.h, p2/M, z17.s\n"
    "ld1w { z2.s }, p2/Z, [x21]\n"
    "incb x21, ALL, MUL #5\n"
    ".inst 0x648aaa37  // bfcvtnt z23.h, p2/M, z17.s\n"
    "ld1w { z26.s }, p2/Z, [x21]\n"
    "st1h { z5.h }, p2, [x24, #5, MUL VL]\n"
    "addvl x24, x24, #-6\n"
    "st1h { z21.h }, p2, [x24]\n"
    ".inst 0x648aa990  // bfcvtnt z16.h, p2/M, z12.s\n"
    "incb x21, ALL, MUL #5\n"
    "fmov z8.s, #0x0\n"
    "st1h { z10.h }, p2, [x24, #1, MUL VL]\n"
    ".inst 0x658aab04  // bfcvt z4.h, p2/M, z24.s\n"
    ".inst 0x658aa985  // bfcvt z5.h, p2/M, z12.s\n"
    "sub x20, x25, #0x1\n"
    "st1h { z19.h }, p2, [x24, #2, MUL VL]\n"
    ".inst 0x658aa871  // bfcvt z17.h, p2/M, z3.s\n"
    "ld1w { z25.s }, p2/Z, [x21]\n"
    "orr x23, x20, %x[ld_in_col], LSL #18\n"
    "st1h { z23.h }, p2, [x24, #3, MUL VL]\n"
    ".inst 0x658aa857  // bfcvt z23.h, p2/M, z2.s\n"
    "orr x23, x7, x23, LSL #20\n"
    "mov x22, #0x8\n"
    "st1h { z16.h }, p2, [x24, #4, MUL VL]\n"
    ".inst 0x658aab4e  // bfcvt z14.h, p2/M, z26.s\n"
    "add x21, x6, x4\n"
    "lsl x20, %x[ld_in_row], #0x2\n"
    "st1h { z5.h }, p2, [x24, #5, MUL VL]\n"
    "addvl x24, x24, #-6\n"
    "mov z31.d, z30.d\n"
    ".inst 0x648aab08  // bfcvtnt z8.h, p2/M, z24.s\n"
    "st1h { z8.h }, p2, [x24]\n"
    ".inst 0x648aa864  // bfcvtnt z4.h, p2/M, z3.s\n"
    ".inst 0x648aa851  // bfcvtnt z17.h, p2/M, z2.s\n"
    "mov x11, #0x0\n"
    "st1h { z4.h }, p2, [x24, #1, MUL VL]\n"
    ".inst 0x648aab57  // bfcvtnt z23.h, p2/M, z26.s\n"
    ".inst 0x648aab2e  // bfcvtnt z14.h, p2/M, z25.s\n"
    "mov x8, #0x8\n"
    "st1h { z17.h }, p2, [x24, #2, MUL VL]\n"
    ".inst 0x658aab26  // bfcvt z6.h, p2/M, z25.s\n"
    "ldr x15, [%x[args], %[offsetof_Args_output_cols]]\n"
    "lsl x23, x23, #0x2\n"
    "st1h { z23.h }, p2, [x24, #3, MUL VL]\n"
    "sub x22, x22, x21\n"
    "madd x20, x20, x6, x16\n"
    "st1h { z14.h }, p2, [x24, #4, MUL VL]\n"
    "st1h { z6.h }, p2, [x24, #5, MUL VL]\n"
    "3:"  // Issue prefetches
    "subs x22, x22, #0x1\n"
    ".inst 0xf8b74a9c  // rprfm pldstrm, x23, [x20]\n"
    "add x20, x20, %x[ld_in_col], LSL #2\n"
    "bgt 3b\n"
    "ldr x23, [%x[args], %[offsetof_Args_outptrs]]\n"
    "lsl x20, %x[ld_in_row], #0x2\n"
    "msub x16, x6, x20, x16\n"
    ".inst 0xc0046bc0  // mova za.d[x11, #0], { z30.d-z31.d }\n"
    "ldr x20, [%x[args], %[offsetof_Args_ld_out_cols]]\n"
    ".inst 0xc0046bc1  // mova za.d[x11, #1], { z30.d-z31.d }\n"
    "mov x22, #0x4\n"
    "ldp x14, x13, [x23], #0x10\n"
    ".inst 0xc0046bc2  // mova za.d[x11, #2], { z30.d-z31.d }\n"
    "ldp x5, x10, [x20], #0x10\n"
    ".inst 0xc0046bc3  // mova za.d[x11, #3], { z30.d-z31.d }\n"
    "ldr x21, [%x[args], %[offsetof_Args_pad_left]]\n"
    ".inst 0xc0046bc4  // mova za.d[x11, #4], { z30.d-z31.d }\n"
    "ldp x9, x28, [x23], #0x10\n"
    ".inst 0xc0046bc5  // mova za.d[x11, #5], { z30.d-z31.d }\n"
    "ldp x27, x26, [x20], #0x10\n"
    ".inst 0xc0046bc6  // mova za.d[x11, #6], { z30.d-z31.d }\n"
    ".inst 0xc0046bc7  // mova za.d[x11, #7], { z30.d-z31.d }\n"
    ".inst 0xc0040bc0  // mova za.d[x8, #0], { z30.d-z31.d }\n"
    ".inst 0xc0040bc1  // mova za.d[x8, #1], { z30.d-z31.d }\n"
    "cbz x21, 5f\n"
    "cmp x21, x22\n"
    "csel x20, x21, x22, LT\n"
    "sub x21, x21, x20\n"
    "sub x22, x22, x20\n"
    "cbz x21, 5f\n"
    ".inst 0xc0066804  // mova { z4.d-z5.d }, za.d[x11, #0]\n"
    "sub x15, x15, x21\n"
    ".inst 0xc0066826  // mova { z6.d-z7.d }, za.d[x11, #1]\n"
    ".inst 0xc1bccba4  // fclamp { z4.s-z7.s }, z29.s, z28.s\n"
    "4:"  // Left padding
    "subs x21, x21, #0x1\n"
    "st1w { z4.s }, p1, [x14]\n"
    "add x14, x14, x5, LSL #2\n"
    "st1w { z6.s }, p1, [x13]\n"
    "add x13, x13, x10, LSL #2\n"
    "st1w { z5.s }, p1, [x9]\n"
    "add x9, x9, x27, LSL #2\n"
    "st1w { z7.s }, p1, [x28]\n"
    "add x28, x28, x26, LSL #2\n"
    "bgt 4b\n"
    "5:"  // Left padding: End
    "adds XZR, x6, x4\n"
    "bne 12f\n"
    "cbz x22, 10f\n"
    "cmp x22, #0x1\n"
    "sub x25, x25, x22\n"
    "beq 9f\n"
    "cmp x22, #0x2\n"
    "beq 8f\n"
    "cmp x22, #0x3\n"
    "beq 7f\n"
    "6:"  // Unpadded: 4 priming loads
    "add x21, x16, %x[ld_in_row], LSL #2\n"
    "ld1w { z21.s }, p1/Z, [x16]\n"
    ".inst 0x658aaab2  // bfcvt z18.h, p2/M, z21.s\n"
    "addvl x20, SP, #24\n"
    "ld1w { z11.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aa972  // bfcvtnt z18.h, p2/M, z11.s\n"
    "add x16, x16, %x[ld_in_col], LSL #2\n"
    "ld1w { z17.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa33  // bfcvt z19.h, p2/M, z17.s\n"
    "ld1w { z12.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aa993  // bfcvtnt z19.h, p2/M, z12.s\n"
    "ld1w { z7.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aa8f4  // bfcvt z20.h, p2/M, z7.s\n"
    "ld1w { z12.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aa994  // bfcvtnt z20.h, p2/M, z12.s\n"
    ".inst 0xa0402a8c  // ld1h { z12.h-z13.h }, pn10.b/Z, [x20]\n"
    ".inst 0xc12d7250  // bfdot za.s[x11, 0], { z18.h-z19.h }, z13.h\n"
    "ld1w { z6.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aa8d5  // bfcvt z21.h, p2/M, z6.s\n"
    ".inst 0xc12c7251  // bfdot za.s[x11, 1], { z18.h-z19.h }, z12.h\n"
    ".inst 0xa0412a8a  // ld1h { z10.h-z11.h }, pn10.b/Z, [x20, #0x2, MUL VL]\n"
    ".inst 0xc12b7270  // bfdot za.s[x11, 0], { z19.h-z20.h }, z11.h\n"
    "ld1w { z27.s }, p1/Z, [x21]\n"
    ".inst 0x648aab75  // bfcvtnt z21.h, p2/M, z27.s\n"
    ".inst 0xc12a7271  // bfdot za.s[x11, 1], { z19.h-z20.h }, z10.h\n"
    ".inst 0xa0422a8a  // ld1h { z10.h-z11.h }, pn10.b/Z, [x20, #0x4, MUL VL]\n"
    ".inst 0xc12b7290  // bfdot za.s[x11, 0], { z20.h-z21.h }, z11.h\n"
    ".inst 0xc12a7291  // bfdot za.s[x11, 1], { z20.h-z21.h }, z10.h\n"
    "7:"  // Unpadded: 3 priming loads
    "add x22, x16, %x[ld_in_row], LSL #2\n"
    "ld1w { z6.s }, p1/Z, [x16]\n"
    ".inst 0x658aa8d7  // bfcvt z23.h, p2/M, z6.s\n"
    "addvl x21, SP, #18\n"
    "ld1w { z1.s }, p1/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aa837  // bfcvtnt z23.h, p2/M, z1.s\n"
    "addvl x20, SP, #24\n"
    "ld1w { z15.s }, p1/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aa9f8  // bfcvt z24.h, p2/M, z15.s\n"
    "add x16, x16, %x[ld_in_col], LSL #2\n"
    "ld1w { z16.s }, p1/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aaa18  // bfcvtnt z24.h, p2/M, z16.s\n"
    "ld1w { z1.s }, p1/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aa839  // bfcvt z25.h, p2/M, z1.s\n"
    "ld1w { z9.s }, p1/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aa939  // bfcvtnt z25.h, p2/M, z9.s\n"
    ".inst 0xa1402aa1  // ld1h { z1.h, z9.h }, pn10.b/Z, [x21]\n"
    ".inst 0xc12972f0  // bfdot za.s[x11, 0], { z23.h-z24.h }, z9.h\n"
    "ld1w { z16.s }, p1/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa1a  // bfcvt z26.h, p2/M, z16.s\n"
    ".inst 0xc12172f1  // bfdot za.s[x11, 1], { z23.h-z24.h }, z1.h\n"
    ".inst 0xa1402a87  // ld1h { z7.h, z15.h }, pn10.b/Z, [x20]\n"
    ".inst 0xc12f72f2  // bfdot za.s[x11, 2], { z23.h-z24.h }, z15.h\n"
    ".inst 0xa1412aa1  // ld1h { z1.h, z9.h }, pn10.b/Z, [x21, #0x2, MUL VL]\n"
    ".inst 0xc12772f3  // bfdot za.s[x11, 3], { z23.h-z24.h }, z7.h\n"
    "ld1w { z16.s }, p1/Z, [x22]\n"
    ".inst 0x648aaa1a  // bfcvtnt z26.h, p2/M, z16.s\n"
    ".inst 0xc1297310  // bfdot za.s[x11, 0], { z24.h-z25.h }, z9.h\n"
    ".inst 0xc1217311  // bfdot za.s[x11, 1], { z24.h-z25.h }, z1.h\n"
    ".inst 0xa1412a87  // ld1h { z7.h, z15.h }, pn10.b/Z, [x20, #0x2, MUL VL]\n"
    ".inst 0xa1422aa3  // ld1h { z3.h, z11.h }, pn10.b/Z, [x21, #0x4, MUL VL]\n"
    ".inst 0xc12f7312  // bfdot za.s[x11, 2], { z24.h-z25.h }, z15.h\n"
    ".inst 0xc1277313  // bfdot za.s[x11, 3], { z24.h-z25.h }, z7.h\n"
    ".inst 0xc12b7330  // bfdot za.s[x11, 0], { z25.h-z26.h }, z11.h\n"
    ".inst 0xc1237331  // bfdot za.s[x11, 1], { z25.h-z26.h }, z3.h\n"
    ".inst 0xa0422a82  // ld1h { z2.h-z3.h }, pn10.b/Z, [x20, #0x4, MUL VL]\n"
    ".inst 0xc1237332  // bfdot za.s[x11, 2], { z25.h-z26.h }, z3.h\n"
    ".inst 0xc1227333  // bfdot za.s[x11, 3], { z25.h-z26.h }, z2.h\n"
    "8:"  // Unpadded: 2 priming loads
    "add x23, x16, %x[ld_in_row], LSL #2\n"
    "ld1w { z24.s }, p1/Z, [x16]\n"
    ".inst 0x658aab02  // bfcvt z2.h, p2/M, z24.s\n"
    "addvl x22, SP, #12\n"
    "ld1w { z16.s }, p1/Z, [x23]\n"
    "add x23, x23, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aaa02  // bfcvtnt z2.h, p2/M, z16.s\n"
    "addvl x21, SP, #18\n"
    "ld1w { z16.s }, p1/Z, [x23]\n"
    "add x23, x23, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa03  // bfcvt z3.h, p2/M, z16.s\n"
    "addvl x20, SP, #24\n"
    "ld1w { z16.s }, p1/Z, [x23]\n"
    "add x23, x23, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aaa03  // bfcvtnt z3.h, p2/M, z16.s\n"
    "add x16, x16, %x[ld_in_col], LSL #2\n"
    "ld1w { z1.s }, p1/Z, [x23]\n"
    "add x23, x23, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aa824  // bfcvt z4.h, p2/M, z1.s\n"
    "ld1w { z19.s }, p1/Z, [x23]\n"
    "add x23, x23, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aaa64  // bfcvtnt z4.h, p2/M, z19.s\n"
    ".inst 0xa1402ac7  // ld1h { z7.h, z15.h }, pn10.b/Z, [x22]\n"
    ".inst 0xc12f7050  // bfdot za.s[x11, 0], { z2.h-z3.h }, z15.h\n"
    "ld1w { z0.s }, p1/Z, [x23]\n"
    "add x23, x23, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aa805  // bfcvt z5.h, p2/M, z0.s\n"
    ".inst 0xc1277051  // bfdot za.s[x11, 1], { z2.h-z3.h }, z7.h\n"
    ".inst 0xa1402aa7  // ld1h { z7.h, z15.h }, pn10.b/Z, [x21]\n"
    ".inst 0xc12f7052  // bfdot za.s[x11, 2], { z2.h-z3.h }, z15.h\n"
    ".inst 0xa1412ac6  // ld1h { z6.h, z14.h }, pn10.b/Z, [x22, #0x2, MUL VL]\n"
    ".inst 0xc1277053  // bfdot za.s[x11, 3], { z2.h-z3.h }, z7.h\n"
    "ld1w { z10.s }, p1/Z, [x23]\n"
    ".inst 0x648aa945  // bfcvtnt z5.h, p2/M, z10.s\n"
    ".inst 0xc12e7070  // bfdot za.s[x11, 0], { z3.h-z4.h }, z14.h\n"
    ".inst 0xa1402a87  // ld1h { z7.h, z15.h }, pn10.b/Z, [x20]\n"
    ".inst 0xc1267071  // bfdot za.s[x11, 1], { z3.h-z4.h }, z6.h\n"
    ".inst 0xa0412aac  // ld1h { z12.h-z13.h }, pn10.b/Z, [x21, #0x2, MUL VL]\n"
    ".inst 0xc12f7054  // bfdot za.s[x11, 4], { z2.h-z3.h }, z15.h\n"
    ".inst 0xa1422ac0  // ld1h { z0.h, z8.h }, pn10.b/Z, [x22, #0x4, MUL VL]\n"
    ".inst 0xc1277055  // bfdot za.s[x11, 5], { z2.h-z3.h }, z7.h\n"
    ".inst 0xc12d7072  // bfdot za.s[x11, 2], { z3.h-z4.h }, z13.h\n"
    ".inst 0xc12c7073  // bfdot za.s[x11, 3], { z3.h-z4.h }, z12.h\n"
    ".inst 0xa0412a8e  // ld1h { z14.h-z15.h }, pn10.b/Z, [x20, #0x2, MUL VL]\n"
    ".inst 0xc1287090  // bfdot za.s[x11, 0], { z4.h-z5.h }, z8.h\n"
    ".inst 0xc1207091  // bfdot za.s[x11, 1], { z4.h-z5.h }, z0.h\n"
    ".inst 0xa0422aa6  // ld1h { z6.h-z7.h }, pn10.b/Z, [x21, #0x4, MUL VL]\n"
    ".inst 0xc12f7074  // bfdot za.s[x11, 4], { z3.h-z4.h }, z15.h\n"
    ".inst 0xc12e7075  // bfdot za.s[x11, 5], { z3.h-z4.h }, z14.h\n"
    ".inst 0xc1277092  // bfdot za.s[x11, 2], { z4.h-z5.h }, z7.h\n"
    ".inst 0xc1267093  // bfdot za.s[x11, 3], { z4.h-z5.h }, z6.h\n"
    ".inst 0xa1422a80  // ld1h { z0.h, z8.h }, pn10.b/Z, [x20, #0x4, MUL VL]\n"
    ".inst 0xc1287094  // bfdot za.s[x11, 4], { z4.h-z5.h }, z8.h\n"
    ".inst 0xc1207095  // bfdot za.s[x11, 5], { z4.h-z5.h }, z0.h\n"
    "9:"  // Unpadded: 1 priming loads
    "add x24, x16, %x[ld_in_row], LSL #2\n"
    "ld1w { z18.s }, p1/Z, [x16]\n"
    ".inst 0x658aaa4c  // bfcvt z12.h, p2/M, z18.s\n"
    "addvl x23, SP, #6\n"
    "ld1w { z7.s }, p1/Z, [x24]\n"
    "add x24, x24, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aa8ec  // bfcvtnt z12.h, p2/M, z7.s\n"
    "addvl x22, SP, #12\n"
    "ld1w { z20.s }, p1/Z, [x24]\n"
    "add x24, x24, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa8d  // bfcvt z13.h, p2/M, z20.s\n"
    "addvl x21, SP, #18\n"
    "ld1w { z0.s }, p1/Z, [x24]\n"
    "add x24, x24, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aa80d  // bfcvtnt z13.h, p2/M, z0.s\n"
    "addvl x20, SP, #24\n"
    "ld1w { z10.s }, p1/Z, [x24]\n"
    "add x24, x24, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aa94e  // bfcvt z14.h, p2/M, z10.s\n"
    "add x16, x16, %x[ld_in_col], LSL #2\n"
    "ld1w { z0.s }, p1/Z, [x24]\n"
    "add x24, x24, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aa80e  // bfcvtnt z14.h, p2/M, z0.s\n"
    ".inst 0xa0402ae0  // ld1h { z0.h-z1.h }, pn10.b/Z, [x23]\n"
    ".inst 0xc1217190  // bfdot za.s[x11, 0], { z12.h-z13.h }, z1.h\n"
    "ld1w { z17.s }, p1/Z, [x24]\n"
    "add x24, x24, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa2f  // bfcvt z15.h, p2/M, z17.s\n"
    ".inst 0xc1207191  // bfdot za.s[x11, 1], { z12.h-z13.h }, z0.h\n"
    ".inst 0xa0402aca  // ld1h { z10.h-z11.h }, pn10.b/Z, [x22]\n"
    ".inst 0xc12b7192  // bfdot za.s[x11, 2], { z12.h-z13.h }, z11.h\n"
    ".inst 0xa0412ae0  // ld1h { z0.h-z1.h }, pn10.b/Z, [x23, #0x2, MUL VL]\n"
    ".inst 0xc12a7193  // bfdot za.s[x11, 3], { z12.h-z13.h }, z10.h\n"
    "ld1w { z18.s }, p1/Z, [x24]\n"
    ".inst 0x648aaa4f  // bfcvtnt z15.h, p2/M, z18.s\n"
    ".inst 0xc12171b0  // bfdot za.s[x11, 0], { z13.h-z14.h }, z1.h\n"
    ".inst 0xa1402aa2  // ld1h { z2.h, z10.h }, pn10.b/Z, [x21]\n"
    ".inst 0xc12071b1  // bfdot za.s[x11, 1], { z13.h-z14.h }, z0.h\n"
    ".inst 0xa0412ac6  // ld1h { z6.h-z7.h }, pn10.b/Z, [x22, #0x2, MUL VL]\n"
    ".inst 0xc12a7194  // bfdot za.s[x11, 4], { z12.h-z13.h }, z10.h\n"
    ".inst 0xa0422aea  // ld1h { z10.h-z11.h }, pn10.b/Z, [x23, #0x4, MUL VL]\n"
    ".inst 0xc1227195  // bfdot za.s[x11, 5], { z12.h-z13.h }, z2.h\n"
    ".inst 0xa0402a88  // ld1h { z8.h-z9.h }, pn10.b/Z, [x20]\n"
    ".inst 0xc12771b2  // bfdot za.s[x11, 2], { z13.h-z14.h }, z7.h\n"
    ".inst 0xc12671b3  // bfdot za.s[x11, 3], { z13.h-z14.h }, z6.h\n"
    ".inst 0xa0412aa0  // ld1h { z0.h-z1.h }, pn10.b/Z, [x21, #0x2, MUL VL]\n"
    ".inst 0xc12b71d0  // bfdot za.s[x11, 0], { z14.h-z15.h }, z11.h\n"
    ".inst 0xc12a71d1  // bfdot za.s[x11, 1], { z14.h-z15.h }, z10.h\n"
    ".inst 0xa1422ac2  // ld1h { z2.h, z10.h }, pn10.b/Z, [x22, #0x4, MUL VL]\n"
    ".inst 0xc1297196  // bfdot za.s[x11, 6], { z12.h-z13.h }, z9.h\n"
    ".inst 0xc1287197  // bfdot za.s[x11, 7], { z12.h-z13.h }, z8.h\n"
    ".inst 0xc12171b4  // bfdot za.s[x11, 4], { z13.h-z14.h }, z1.h\n"
    ".inst 0xc12071b5  // bfdot za.s[x11, 5], { z13.h-z14.h }, z0.h\n"
    ".inst 0xa1412a83  // ld1h { z3.h, z11.h }, pn10.b/Z, [x20, #0x2, MUL VL]\n"
    ".inst 0xc12a71d2  // bfdot za.s[x11, 2], { z14.h-z15.h }, z10.h\n"
    ".inst 0xc12271d3  // bfdot za.s[x11, 3], { z14.h-z15.h }, z2.h\n"
    ".inst 0xa0422aa6  // ld1h { z6.h-z7.h }, pn10.b/Z, [x21, #0x4, MUL VL]\n"
    ".inst 0xc12b71b6  // bfdot za.s[x11, 6], { z13.h-z14.h }, z11.h\n"
    ".inst 0xc12371b7  // bfdot za.s[x11, 7], { z13.h-z14.h }, z3.h\n"
    ".inst 0xc12771d4  // bfdot za.s[x11, 4], { z14.h-z15.h }, z7.h\n"
    ".inst 0xc12671d5  // bfdot za.s[x11, 5], { z14.h-z15.h }, z6.h\n"
    ".inst 0xa0422a86  // ld1h { z6.h-z7.h }, pn10.b/Z, [x20, #0x4, MUL VL]\n"
    ".inst 0xc12771d6  // bfdot za.s[x11, 6], { z14.h-z15.h }, z7.h\n"
    ".inst 0xc12671d7  // bfdot za.s[x11, 7], { z14.h-z15.h }, z6.h\n"
    "10:"  // Unpadded: 0 priming loads
    ".inst 0xa1402be6  // ld1h { z6.h, z14.h }, pn10.b/Z, [SP]\n"
    ".inst 0xa1412be5  // ld1h { z5.h, z13.h }, pn10.b/Z, [SP, #0x2, MUL VL]\n"
    ".inst 0xa1422be4  // ld1h { z4.h, z12.h }, pn10.b/Z, [SP, #0x4, MUL VL]\n"
    "cbz x25, 20f\n"
    "add x20, x16, %x[ld_in_row], LSL #2\n"
    "ld1w { z1.s }, p1/Z, [x16]\n"
    ".inst 0x658aa834  // bfcvt z20.h, p2/M, z1.s\n"
    "sub x25, x25, #0x1\n"
    "ld1w { z10.s }, p1/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    "sub x15, x15, #0x1\n"
    ".inst 0x648aa954  // bfcvtnt z20.h, p2/M, z10.s\n"
    "ld1w { z16.s }, p1/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa15  // bfcvt z21.h, p2/M, z16.s\n"
    "cmp x25, x15\n"
    "ld1w { z19.s }, p1/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    "csel x25, x25, x15, LT\n"
    ".inst 0x648aaa75  // bfcvtnt z21.h, p2/M, z19.s\n"
    "ld1w { z23.s }, p1/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaaf6  // bfcvt z22.h, p2/M, z23.s\n"
    "add x16, x16, %x[ld_in_col], LSL #2\n"
    "ld1w { z27.s }, p1/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aab76  // bfcvtnt z22.h, p2/M, z27.s\n"
    "sub x15, x15, x25\n"
    "ld1w { z15.s }, p1/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aa9f7  // bfcvt z23.h, p2/M, z15.s\n"
    "ld1w { z16.s }, p1/Z, [x20]\n"
    ".inst 0x648aaa17  // bfcvtnt z23.h, p2/M, z16.s\n"
    "cbz x25, 19f\n"
    "11:"  // Unpadded: Main loop
    "addvl x24, SP, #6\n"
    ".inst 0xc12e7290  // bfdot za.s[x11, 0], { z20.h-z21.h }, z14.h\n"
    "addvl x23, SP, #12\n"
    "ld1w { z27.s }, p1/Z, [x16]\n"
    ".inst 0xc1267291  // bfdot za.s[x11, 1], { z20.h-z21.h }, z6.h\n"
    ".inst 0xa1402b01  // ld1h { z1.h, z9.h }, pn10.b/Z, [x24]\n"
    "addvl x22, SP, #18\n"
    "addvl x21, SP, #24\n"
    ".inst 0xc1297292  // bfdot za.s[x11, 2], { z20.h-z21.h }, z9.h\n"
    "add x20, x16, %x[ld_in_row], LSL #2\n"
    "ld1w { z26.s }, p1/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0xc1217293  // bfdot za.s[x11, 3], { z20.h-z21.h }, z1.h\n"
    ".inst 0xa1402ae6  // ld1h { z6.h, z14.h }, pn10.b/Z, [x23]\n"
    "subs x25, x25, #0x1\n"
    "add x16, x16, %x[ld_in_col], LSL #2\n"
    ".inst 0xc12d72b0  // bfdot za.s[x11, 0], { z21.h-z22.h }, z13.h\n"
    "ld1w { z25.s }, p1/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0xc12572b1  // bfdot za.s[x11, 1], { z21.h-z22.h }, z5.h\n"
    ".inst 0xa1412b07  // ld1h { z7.h, z15.h }, pn10.b/Z, [x24, #0x2, MUL VL]\n"
    ".inst 0xc12e7294  // bfdot za.s[x11, 4], { z20.h-z21.h }, z14.h\n"
    "ld1w { z24.s }, p1/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0xc1267295  // bfdot za.s[x11, 5], { z20.h-z21.h }, z6.h\n"
    ".inst 0xa1402ac5  // ld1h { z5.h, z13.h }, pn10.b/Z, [x22]\n"
    ".inst 0xc12f72b2  // bfdot za.s[x11, 2], { z21.h-z22.h }, z15.h\n"
    "ld1w { z19.s }, p1/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0xc12772b3  // bfdot za.s[x11, 3], { z21.h-z22.h }, z7.h\n"
    ".inst 0xa1412ae6  // ld1h { z6.h, z14.h }, pn10.b/Z, [x23, #0x2, MUL VL]\n"
    ".inst 0xc12c72d0  // bfdot za.s[x11, 0], { z22.h-z23.h }, z12.h\n"
    "ld1w { z18.s }, p1/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0xc12472d1  // bfdot za.s[x11, 1], { z22.h-z23.h }, z4.h\n"
    ".inst 0xa1422b07  // ld1h { z7.h, z15.h }, pn10.b/Z, [x24, #0x4, MUL VL]\n"
    ".inst 0xc12d7296  // bfdot za.s[x11, 6], { z20.h-z21.h }, z13.h\n"
    "ld1w { z17.s }, p1/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0xc1257297  // bfdot za.s[x11, 7], { z20.h-z21.h }, z5.h\n"
    ".inst 0xa1402aa4  // ld1h { z4.h, z12.h }, pn10.b/Z, [x21]\n"
    ".inst 0xc12e72b4  // bfdot za.s[x11, 4], { z21.h-z22.h }, z14.h\n"
    "ld1w { z16.s }, p1/Z, [x20]\n"
    ".inst 0xc12672b5  // bfdot za.s[x11, 5], { z21.h-z22.h }, z6.h\n"
    ".inst 0xa1412ac6  // ld1h { z6.h, z14.h }, pn10.b/Z, [x22, #0x2, MUL VL]\n"
    ".inst 0xc12f72d2  // bfdot za.s[x11, 2], { z22.h-z23.h }, z15.h\n"
    ".inst 0xc12772d3  // bfdot za.s[x11, 3], { z22.h-z23.h }, z7.h\n"
    ".inst 0xa1422ae7  // ld1h { z7.h, z15.h }, pn10.b/Z, [x23, #0x4, MUL VL]\n"
    ".inst 0xc12e72b6  // bfdot za.s[x11, 6], { z21.h-z22.h }, z14.h\n"
    ".inst 0xc12672b7  // bfdot za.s[x11, 7], { z21.h-z22.h }, z6.h\n"
    ".inst 0xa1412aa5  // ld1h { z5.h, z13.h }, pn10.b/Z, [x21, #0x2, MUL VL]\n"
    ".inst 0xc12f72d4  // bfdot za.s[x11, 4], { z22.h-z23.h }, z15.h\n"
    ".inst 0xc12772d5  // bfdot za.s[x11, 5], { z22.h-z23.h }, z7.h\n"
    ".inst 0xa0422ace  // ld1h { z14.h-z15.h }, pn10.b/Z, [x22, #0x4, MUL VL]\n"
    ".inst 0xc12f72d6  // bfdot za.s[x11, 6], { z22.h-z23.h }, z15.h\n"
    ".inst 0xc12e72d7  // bfdot za.s[x11, 7], { z22.h-z23.h }, z14.h\n"
    ".inst 0xa1422aa1  // ld1h { z1.h, z9.h }, pn10.b/Z, [x21, #0x4, MUL VL]\n"
    ".inst 0xc12c1290  // bfdot za.s[x8, 0], { z20.h-z21.h }, z12.h\n"
    ".inst 0xc1241291  // bfdot za.s[x8, 1], { z20.h-z21.h }, z4.h\n"
    ".inst 0x658aab74  // bfcvt z20.h, p2/M, z27.s\n"
    ".inst 0xa1402be6  // ld1h { z6.h, z14.h }, pn10.b/Z, [SP]\n"
    ".inst 0xc12d12b0  // bfdot za.s[x8, 0], { z21.h-z22.h }, z13.h\n"
    ".inst 0x648aab54  // bfcvtnt z20.h, p2/M, z26.s\n"
    ".inst 0xc12512b1  // bfdot za.s[x8, 1], { z21.h-z22.h }, z5.h\n"
    ".inst 0x658aab35  // bfcvt z21.h, p2/M, z25.s\n"
    ".inst 0xa1412be5  // ld1h { z5.h, z13.h }, pn10.b/Z, [SP, #0x2, MUL VL]\n"
    ".inst 0xc12912d0  // bfdot za.s[x8, 0], { z22.h-z23.h }, z9.h\n"
    ".inst 0x648aab15  // bfcvtnt z21.h, p2/M, z24.s\n"
    ".inst 0xc12112d1  // bfdot za.s[x8, 1], { z22.h-z23.h }, z1.h\n"
    ".inst 0x658aaa76  // bfcvt z22.h, p2/M, z19.s\n"
    ".inst 0x658aaa37  // bfcvt z23.h, p2/M, z17.s\n"
    "add x8, x8, #0x2\n"
    ".inst 0xc0066808  // mova { z8.d-z9.d }, za.d[x11, #0]\n"
    ".inst 0xa1422be4  // ld1h { z4.h, z12.h }, pn10.b/Z, [SP, #0x4, MUL VL]\n"
    ".inst 0x648aaa56  // bfcvtnt z22.h, p2/M, z18.s\n"
    ".inst 0xc006682a  // mova { z10.d-z11.d }, za.d[x11, #1]\n"
    ".inst 0xc1bccba8  // fclamp { z8.s-z11.s }, z29.s, z28.s\n"
    "st1w { z8.s }, p1, [x14]\n"
    "add x14, x14, x5, LSL #2\n"
    "st1w { z10.s }, p1, [x13]\n"
    "add x13, x13, x10, LSL #2\n"
    "add x11, x11, #0x2\n"
    ".inst 0xc0040bc0  // mova za.d[x8, #0], { z30.d-z31.d }\n"
    "st1w { z9.s }, p1, [x9]\n"
    "add x9, x9, x27, LSL #2\n"
    ".inst 0xc0040bc1  // mova za.d[x8, #1], { z30.d-z31.d }\n"
    ".inst 0x648aaa17  // bfcvtnt z23.h, p2/M, z16.s\n"
    "st1w { z11.s }, p1, [x28]\n"
    "add x28, x28, x26, LSL #2\n"
    "bgt 11b\n"
    "b 19f\n"
    "12:"  // Padded
    "cbz x22, 17f\n"
    "cmp x22, #0x1\n"
    "sub x25, x25, x22\n"
    "beq 16f\n"
    "cmp x22, #0x2\n"
    "beq 15f\n"
    "cmp x22, #0x3\n"
    "beq 14f\n"
    "13:"  // Padded: 4 priming loads
    "mov x12, #0x0\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "ld1w { z16.s }, p0/Z, [x16]\n"
    ".inst 0x658aaa06  // bfcvt z6.h, p2/M, z16.s\n"
    "add x21, x16, %x[ld_in_row], LSL #2\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "ld1w { z16.s }, p0/Z, [x21]\n"
    ".inst 0x648aaa06  // bfcvtnt z6.h, p2/M, z16.s\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "ld1w { z16.s }, p0/Z, [x21]\n"
    ".inst 0x658aaa07  // bfcvt z7.h, p2/M, z16.s\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    "ld1w { z16.s }, p0/Z, [x21]\n"
    ".inst 0x648aaa07  // bfcvtnt z7.h, p2/M, z16.s\n"
    "mov x12, #0x4\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "ld1w { z16.s }, p0/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa08  // bfcvt z8.h, p2/M, z16.s\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "addvl x20, SP, #24\n"
    "ld1w { z16.s }, p0/Z, [x21]\n"
    ".inst 0x648aaa08  // bfcvtnt z8.h, p2/M, z16.s\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    ".inst 0xa0402a8e  // ld1h { z14.h-z15.h }, pn10.b/Z, [x20]\n"
    ".inst 0xc12f70d0  // bfdot za.s[x11, 0], { z6.h-z7.h }, z15.h\n"
    "ld1w { z9.s }, p0/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    ".inst 0x658aa929  // bfcvt z9.h, p2/M, z9.s\n"
    ".inst 0xc12e70d1  // bfdot za.s[x11, 1], { z6.h-z7.h }, z14.h\n"
    ".inst 0xa0412a8e  // ld1h { z14.h-z15.h }, pn10.b/Z, [x20, #0x2, MUL VL]\n"
    "add x16, x16, %x[ld_in_col], LSL #2\n"
    "ld1w { z16.s }, p0/Z, [x21]\n"
    ".inst 0x648aaa09  // bfcvtnt z9.h, p2/M, z16.s\n"
    ".inst 0xc12f70f0  // bfdot za.s[x11, 0], { z7.h-z8.h }, z15.h\n"
    ".inst 0xc12e70f1  // bfdot za.s[x11, 1], { z7.h-z8.h }, z14.h\n"
    ".inst 0xa0422a82  // ld1h { z2.h-z3.h }, pn10.b/Z, [x20, #0x4, MUL VL]\n"
    ".inst 0xc1237110  // bfdot za.s[x11, 0], { z8.h-z9.h }, z3.h\n"
    ".inst 0xc1227111  // bfdot za.s[x11, 1], { z8.h-z9.h }, z2.h\n"
    "14:"  // Padded: 3 priming loads
    "mov x12, #0x0\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "ld1w { z16.s }, p0/Z, [x16]\n"
    ".inst 0x658aaa09  // bfcvt z9.h, p2/M, z16.s\n"
    "add x22, x16, %x[ld_in_row], LSL #2\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "ld1w { z16.s }, p0/Z, [x22]\n"
    ".inst 0x648aaa09  // bfcvtnt z9.h, p2/M, z16.s\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "ld1w { z16.s }, p0/Z, [x22]\n"
    ".inst 0x658aaa0a  // bfcvt z10.h, p2/M, z16.s\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    "ld1w { z16.s }, p0/Z, [x22]\n"
    ".inst 0x648aaa0a  // bfcvtnt z10.h, p2/M, z16.s\n"
    "mov x12, #0x4\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "ld1w { z16.s }, p0/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa0b  // bfcvt z11.h, p2/M, z16.s\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "addvl x21, SP, #18\n"
    "ld1w { z16.s }, p0/Z, [x22]\n"
    ".inst 0x648aaa0b  // bfcvtnt z11.h, p2/M, z16.s\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    ".inst 0xa1402aa7  // ld1h { z7.h, z15.h }, pn10.b/Z, [x21]\n"
    ".inst 0xc12f7130  // bfdot za.s[x11, 0], { z9.h-z10.h }, z15.h\n"
    "ld1w { z16.s }, p0/Z, [x22]\n"
    "addvl x20, SP, #24\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa0c  // bfcvt z12.h, p2/M, z16.s\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    ".inst 0xc1277131  // bfdot za.s[x11, 1], { z9.h-z10.h }, z7.h\n"
    ".inst 0xa1402a86  // ld1h { z6.h, z14.h }, pn10.b/Z, [x20]\n"
    "add x16, x16, %x[ld_in_col], LSL #2\n"
    ".inst 0xa1412aa7  // ld1h { z7.h, z15.h }, pn10.b/Z, [x21, #0x2, MUL VL]\n"
    ".inst 0xc12e7132  // bfdot za.s[x11, 2], { z9.h-z10.h }, z14.h\n"
    "ld1w { z16.s }, p0/Z, [x22]\n"
    ".inst 0xc1267133  // bfdot za.s[x11, 3], { z9.h-z10.h }, z6.h\n"
    ".inst 0x648aaa0c  // bfcvtnt z12.h, p2/M, z16.s\n"
    ".inst 0xc12f7150  // bfdot za.s[x11, 0], { z10.h-z11.h }, z15.h\n"
    ".inst 0xa1422aa5  // ld1h { z5.h, z13.h }, pn10.b/Z, [x21, #0x4, MUL VL]\n"
    ".inst 0xc1277151  // bfdot za.s[x11, 1], { z10.h-z11.h }, z7.h\n"
    ".inst 0xa0412a8e  // ld1h { z14.h-z15.h }, pn10.b/Z, [x20, #0x2, MUL VL]\n"
    ".inst 0xc12f7152  // bfdot za.s[x11, 2], { z10.h-z11.h }, z15.h\n"
    ".inst 0xc12e7153  // bfdot za.s[x11, 3], { z10.h-z11.h }, z14.h\n"
    ".inst 0xc12d7170  // bfdot za.s[x11, 0], { z11.h-z12.h }, z13.h\n"
    ".inst 0xc1257171  // bfdot za.s[x11, 1], { z11.h-z12.h }, z5.h\n"
    ".inst 0xa0422a8e  // ld1h { z14.h-z15.h }, pn10.b/Z, [x20, #0x4, MUL VL]\n"
    ".inst 0xc12f7172  // bfdot za.s[x11, 2], { z11.h-z12.h }, z15.h\n"
    ".inst 0xc12e7173  // bfdot za.s[x11, 3], { z11.h-z12.h }, z14.h\n"
    "15:"  // Padded: 2 priming loads
    "mov x12, #0x0\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "ld1w { z16.s }, p0/Z, [x16]\n"
    ".inst 0x658aaa12  // bfcvt z18.h, p2/M, z16.s\n"
    "add x23, x16, %x[ld_in_row], LSL #2\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "ld1w { z16.s }, p0/Z, [x23]\n"
    ".inst 0x648aaa12  // bfcvtnt z18.h, p2/M, z16.s\n"
    "add x23, x23, %x[ld_in_row], LSL #2\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "ld1w { z16.s }, p0/Z, [x23]\n"
    ".inst 0x658aaa13  // bfcvt z19.h, p2/M, z16.s\n"
    "add x23, x23, %x[ld_in_row], LSL #2\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    "ld1w { z16.s }, p0/Z, [x23]\n"
    ".inst 0x648aaa13  // bfcvtnt z19.h, p2/M, z16.s\n"
    "mov x12, #0x4\n"
    "add x23, x23, %x[ld_in_row], LSL #2\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "ld1w { z16.s }, p0/Z, [x23]\n"
    "add x23, x23, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa14  // bfcvt z20.h, p2/M, z16.s\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "addvl x22, SP, #12\n"
    "ld1w { z16.s }, p0/Z, [x23]\n"
    ".inst 0x648aaa14  // bfcvtnt z20.h, p2/M, z16.s\n"
    "add x23, x23, %x[ld_in_row], LSL #2\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    ".inst 0xa1402ac1  // ld1h { z1.h, z9.h }, pn10.b/Z, [x22]\n"
    ".inst 0xc1297250  // bfdot za.s[x11, 0], { z18.h-z19.h }, z9.h\n"
    "ld1w { z26.s }, p0/Z, [x23]\n"
    "addvl x21, SP, #18\n"
    "add x23, x23, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aab55  // bfcvt z21.h, p2/M, z26.s\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    ".inst 0xc1217251  // bfdot za.s[x11, 1], { z18.h-z19.h }, z1.h\n"
    ".inst 0xa1402aa6  // ld1h { z6.h, z14.h }, pn10.b/Z, [x21]\n"
    "addvl x20, SP, #24\n"
    ".inst 0xa1412ac7  // ld1h { z7.h, z15.h }, pn10.b/Z, [x22, #0x2, MUL VL]\n"
    ".inst 0xc12e7252  // bfdot za.s[x11, 2], { z18.h-z19.h }, z14.h\n"
    "add x16, x16, %x[ld_in_col], LSL #2\n"
    "ld1w { z16.s }, p0/Z, [x23]\n"
    ".inst 0xc1267253  // bfdot za.s[x11, 3], { z18.h-z19.h }, z6.h\n"
    ".inst 0x648aaa15  // bfcvtnt z21.h, p2/M, z16.s\n"
    ".inst 0xa1402a85  // ld1h { z5.h, z13.h }, pn10.b/Z, [x20]\n"
    ".inst 0xc12f7270  // bfdot za.s[x11, 0], { z19.h-z20.h }, z15.h\n"
    ".inst 0xc1277271  // bfdot za.s[x11, 1], { z19.h-z20.h }, z7.h\n"
    ".inst 0xa1412aa6  // ld1h { z6.h, z14.h }, pn10.b/Z, [x21, #0x2, MUL VL]\n"
    ".inst 0xa1422ac7  // ld1h { z7.h, z15.h }, pn10.b/Z, [x22, #0x4, MUL VL]\n"
    ".inst 0xc12d7254  // bfdot za.s[x11, 4], { z18.h-z19.h }, z13.h\n"
    ".inst 0xc1257255  // bfdot za.s[x11, 5], { z18.h-z19.h }, z5.h\n"
    ".inst 0xc12e7272  // bfdot za.s[x11, 2], { z19.h-z20.h }, z14.h\n"
    ".inst 0xc1267273  // bfdot za.s[x11, 3], { z19.h-z20.h }, z6.h\n"
    ".inst 0xa1412a85  // ld1h { z5.h, z13.h }, pn10.b/Z, [x20, #0x2, MUL VL]\n"
    ".inst 0xc12f7290  // bfdot za.s[x11, 0], { z20.h-z21.h }, z15.h\n"
    ".inst 0xc1277291  // bfdot za.s[x11, 1], { z20.h-z21.h }, z7.h\n"
    ".inst 0xa0422aae  // ld1h { z14.h-z15.h }, pn10.b/Z, [x21, #0x4, MUL VL]\n"
    ".inst 0xc12d7274  // bfdot za.s[x11, 4], { z19.h-z20.h }, z13.h\n"
    ".inst 0xc1257275  // bfdot za.s[x11, 5], { z19.h-z20.h }, z5.h\n"
    ".inst 0xc12f7292  // bfdot za.s[x11, 2], { z20.h-z21.h }, z15.h\n"
    ".inst 0xc12e7293  // bfdot za.s[x11, 3], { z20.h-z21.h }, z14.h\n"
    ".inst 0xa0422a82  // ld1h { z2.h-z3.h }, pn10.b/Z, [x20, #0x4, MUL VL]\n"
    ".inst 0xc1237294  // bfdot za.s[x11, 4], { z20.h-z21.h }, z3.h\n"
    ".inst 0xc1227295  // bfdot za.s[x11, 5], { z20.h-z21.h }, z2.h\n"
    "16:"  // Padded: 1 priming loads
    "mov x12, #0x0\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "ld1w { z16.s }, p0/Z, [x16]\n"
    ".inst 0x658aaa09  // bfcvt z9.h, p2/M, z16.s\n"
    "add x24, x16, %x[ld_in_row], LSL #2\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "ld1w { z16.s }, p0/Z, [x24]\n"
    ".inst 0x648aaa09  // bfcvtnt z9.h, p2/M, z16.s\n"
    "add x24, x24, %x[ld_in_row], LSL #2\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "ld1w { z16.s }, p0/Z, [x24]\n"
    ".inst 0x658aaa0a  // bfcvt z10.h, p2/M, z16.s\n"
    "add x24, x24, %x[ld_in_row], LSL #2\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    "ld1w { z16.s }, p0/Z, [x24]\n"
    ".inst 0x648aaa0a  // bfcvtnt z10.h, p2/M, z16.s\n"
    "mov x12, #0x4\n"
    "add x24, x24, %x[ld_in_row], LSL #2\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "ld1w { z16.s }, p0/Z, [x24]\n"
    "add x24, x24, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa0b  // bfcvt z11.h, p2/M, z16.s\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "addvl x23, SP, #6\n"
    "ld1w { z16.s }, p0/Z, [x24]\n"
    ".inst 0x648aaa0b  // bfcvtnt z11.h, p2/M, z16.s\n"
    "add x24, x24, %x[ld_in_row], LSL #2\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    ".inst 0xa1402ae7  // ld1h { z7.h, z15.h }, pn10.b/Z, [x23]\n"
    ".inst 0xc12f7130  // bfdot za.s[x11, 0], { z9.h-z10.h }, z15.h\n"
    "ld1w { z16.s }, p0/Z, [x24]\n"
    "addvl x22, SP, #12\n"
    "add x24, x24, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa0c  // bfcvt z12.h, p2/M, z16.s\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    ".inst 0xc1277131  // bfdot za.s[x11, 1], { z9.h-z10.h }, z7.h\n"
    ".inst 0xa1402ac6  // ld1h { z6.h, z14.h }, pn10.b/Z, [x22]\n"
    "addvl x21, SP, #18\n"
    ".inst 0xa1412ae7  // ld1h { z7.h, z15.h }, pn10.b/Z, [x23, #0x2, MUL VL]\n"
    ".inst 0xc12e7132  // bfdot za.s[x11, 2], { z9.h-z10.h }, z14.h\n"
    "addvl x20, SP, #24\n"
    "add x16, x16, %x[ld_in_col], LSL #2\n"
    "ld1w { z16.s }, p0/Z, [x24]\n"
    ".inst 0xc1267133  // bfdot za.s[x11, 3], { z9.h-z10.h }, z6.h\n"
    ".inst 0x648aaa0c  // bfcvtnt z12.h, p2/M, z16.s\n"
    ".inst 0xa1402aa5  // ld1h { z5.h, z13.h }, pn10.b/Z, [x21]\n"
    ".inst 0xc12f7150  // bfdot za.s[x11, 0], { z10.h-z11.h }, z15.h\n"
    ".inst 0xc1277151  // bfdot za.s[x11, 1], { z10.h-z11.h }, z7.h\n"
    ".inst 0xa1412ac7  // ld1h { z7.h, z15.h }, pn10.b/Z, [x22, #0x2, MUL VL]\n"
    ".inst 0xa1422ae6  // ld1h { z6.h, z14.h }, pn10.b/Z, [x23, #0x4, MUL VL]\n"
    ".inst 0xc12d7134  // bfdot za.s[x11, 4], { z9.h-z10.h }, z13.h\n"
    ".inst 0xc1257135  // bfdot za.s[x11, 5], { z9.h-z10.h }, z5.h\n"
    ".inst 0xa1402a85  // ld1h { z5.h, z13.h }, pn10.b/Z, [x20]\n"
    ".inst 0xc12f7152  // bfdot za.s[x11, 2], { z10.h-z11.h }, z15.h\n"
    ".inst 0xc1277153  // bfdot za.s[x11, 3], { z10.h-z11.h }, z7.h\n"
    ".inst 0xa1412aa7  // ld1h { z7.h, z15.h }, pn10.b/Z, [x21, #0x2, MUL VL]\n"
    ".inst 0xc12e7170  // bfdot za.s[x11, 0], { z11.h-z12.h }, z14.h\n"
    ".inst 0xc1267171  // bfdot za.s[x11, 1], { z11.h-z12.h }, z6.h\n"
    ".inst 0xa1422ac6  // ld1h { z6.h, z14.h }, pn10.b/Z, [x22, #0x4, MUL VL]\n"
    ".inst 0xc12d7136  // bfdot za.s[x11, 6], { z9.h-z10.h }, z13.h\n"
    ".inst 0xc1257137  // bfdot za.s[x11, 7], { z9.h-z10.h }, z5.h\n"
    ".inst 0xc12f7154  // bfdot za.s[x11, 4], { z10.h-z11.h }, z15.h\n"
    ".inst 0xc1277155  // bfdot za.s[x11, 5], { z10.h-z11.h }, z7.h\n"
    ".inst 0xa1412a87  // ld1h { z7.h, z15.h }, pn10.b/Z, [x20, #0x2, MUL VL]\n"
    ".inst 0xc12e7172  // bfdot za.s[x11, 2], { z11.h-z12.h }, z14.h\n"
    ".inst 0xc1267173  // bfdot za.s[x11, 3], { z11.h-z12.h }, z6.h\n"
    ".inst 0xa1422aa1  // ld1h { z1.h, z9.h }, pn10.b/Z, [x21, #0x4, MUL VL]\n"
    ".inst 0xc12f7156  // bfdot za.s[x11, 6], { z10.h-z11.h }, z15.h\n"
    ".inst 0xc1277157  // bfdot za.s[x11, 7], { z10.h-z11.h }, z7.h\n"
    ".inst 0xc1297174  // bfdot za.s[x11, 4], { z11.h-z12.h }, z9.h\n"
    ".inst 0xc1217175  // bfdot za.s[x11, 5], { z11.h-z12.h }, z1.h\n"
    ".inst 0xa0422a80  // ld1h { z0.h-z1.h }, pn10.b/Z, [x20, #0x4, MUL VL]\n"
    ".inst 0xc1217176  // bfdot za.s[x11, 6], { z11.h-z12.h }, z1.h\n"
    ".inst 0xc1207177  // bfdot za.s[x11, 7], { z11.h-z12.h }, z0.h\n"
    "17:"  // Padded: 0 priming loads
    ".inst 0xa1402be6  // ld1h { z6.h, z14.h }, pn10.b/Z, [SP]\n"
    ".inst 0xa1412be5  // ld1h { z5.h, z13.h }, pn10.b/Z, [SP, #0x2, MUL VL]\n"
    ".inst 0xa1422be4  // ld1h { z4.h, z12.h }, pn10.b/Z, [SP, #0x4, MUL VL]\n"
    "cbz x25, 20f\n"
    "mov x12, #0x0\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "ld1w { z16.s }, p0/Z, [x16]\n"
    ".inst 0x658aaa14  // bfcvt z20.h, p2/M, z16.s\n"
    "add x20, x16, %x[ld_in_row], LSL #2\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "ld1w { z16.s }, p0/Z, [x20]\n"
    ".inst 0x648aaa14  // bfcvtnt z20.h, p2/M, z16.s\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "ld1w { z16.s }, p0/Z, [x20]\n"
    ".inst 0x658aaa15  // bfcvt z21.h, p2/M, z16.s\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    "ld1w { z16.s }, p0/Z, [x20]\n"
    ".inst 0x648aaa15  // bfcvtnt z21.h, p2/M, z16.s\n"
    "mov x12, #0x4\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "ld1w { z16.s }, p0/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa16  // bfcvt z22.h, p2/M, z16.s\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "ld1w { z16.s }, p0/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aaa16  // bfcvtnt z22.h, p2/M, z16.s\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "ld1w { z16.s }, p0/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa17  // bfcvt z23.h, p2/M, z16.s\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    "ld1w { z16.s }, p0/Z, [x20]\n"
    "sub x25, x25, #0x1\n"
    ".inst 0x648aaa17  // bfcvtnt z23.h, p2/M, z16.s\n"
    "sub x15, x15, #0x1\n"
    "cmp x25, x15\n"
    "csel x25, x25, x15, LT\n"
    "add x16, x16, %x[ld_in_col], LSL #2\n"
    "sub x15, x15, x25\n"
    "cbz x25, 19f\n"
    "18:"  // Padded: Main loop
    "addvl x24, SP, #6\n"
    ".inst 0xc12e7290  // bfdot za.s[x11, 0], { z20.h-z21.h }, z14.h\n"
    "addvl x23, SP, #12\n"
    ".inst 0xc1267291  // bfdot za.s[x11, 1], { z20.h-z21.h }, z6.h\n"
    ".inst 0xa0402b02  // ld1h { z2.h-z3.h }, pn10.b/Z, [x24]\n"
    "mov x12, #0x0\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    ".inst 0xc1237292  // bfdot za.s[x11, 2], { z20.h-z21.h }, z3.h\n"
    "ld1w { z16.s }, p0/Z, [x16]\n"
    "add x22, x16, %x[ld_in_row], LSL #2\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    ".inst 0xc1227293  // bfdot za.s[x11, 3], { z20.h-z21.h }, z2.h\n"
    ".inst 0xa1402ae6  // ld1h { z6.h, z14.h }, pn10.b/Z, [x23]\n"
    "addvl x21, SP, #18\n"
    "addvl x20, SP, #24\n"
    ".inst 0xc12d72b0  // bfdot za.s[x11, 0], { z21.h-z22.h }, z13.h\n"
    "ld1w { z19.s }, p0/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    ".inst 0xc12572b1  // bfdot za.s[x11, 1], { z21.h-z22.h }, z5.h\n"
    ".inst 0xa1412b07  // ld1h { z7.h, z15.h }, pn10.b/Z, [x24, #0x2, MUL VL]\n"
    "subs x25, x25, #0x1\n"
    "add x16, x16, %x[ld_in_col], LSL #2\n"
    ".inst 0xc12e7294  // bfdot za.s[x11, 4], { z20.h-z21.h }, z14.h\n"
    "ld1w { z17.s }, p0/Z, [x22]\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    "mov x12, #0x4\n"
    ".inst 0xc1267295  // bfdot za.s[x11, 5], { z20.h-z21.h }, z6.h\n"
    ".inst 0xa1402aa6  // ld1h { z6.h, z14.h }, pn10.b/Z, [x21]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0xc12f72b2  // bfdot za.s[x11, 2], { z21.h-z22.h }, z15.h\n"
    "ld1w { z27.s }, p0/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    ".inst 0xc12772b3  // bfdot za.s[x11, 3], { z21.h-z22.h }, z7.h\n"
    ".inst 0xa1412ae7  // ld1h { z7.h, z15.h }, pn10.b/Z, [x23, #0x2, MUL VL]\n"
    ".inst 0xc12c72d0  // bfdot za.s[x11, 0], { z22.h-z23.h }, z12.h\n"
    "ld1w { z10.s }, p0/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    ".inst 0xc12472d1  // bfdot za.s[x11, 1], { z22.h-z23.h }, z4.h\n"
    ".inst 0xa1422b04  // ld1h { z4.h, z12.h }, pn10.b/Z, [x24, #0x4, MUL VL]\n"
    ".inst 0xc12e7296  // bfdot za.s[x11, 6], { z20.h-z21.h }, z14.h\n"
    "ld1w { z8.s }, p0/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    ".inst 0xc1267297  // bfdot za.s[x11, 7], { z20.h-z21.h }, z6.h\n"
    ".inst 0xa1402a85  // ld1h { z5.h, z13.h }, pn10.b/Z, [x20]\n"
    ".inst 0xc12f72b4  // bfdot za.s[x11, 4], { z21.h-z22.h }, z15.h\n"
    "ld1w { z11.s }, p0/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    ".inst 0xc12772b5  // bfdot za.s[x11, 5], { z21.h-z22.h }, z7.h\n"
    ".inst 0xa0412aae  // ld1h { z14.h-z15.h }, pn10.b/Z, [x21, #0x2, MUL VL]\n"
    ".inst 0xc12c72d2  // bfdot za.s[x11, 2], { z22.h-z23.h }, z12.h\n"
    "ld1w { z18.s }, p0/Z, [x22]\n"
    ".inst 0xc12472d3  // bfdot za.s[x11, 3], { z22.h-z23.h }, z4.h\n"
    ".inst 0xa1422ae4  // ld1h { z4.h, z12.h }, pn10.b/Z, [x23, #0x4, MUL VL]\n"
    ".inst 0xc12f72b6  // bfdot za.s[x11, 6], { z21.h-z22.h }, z15.h\n"
    ".inst 0xc12e72b7  // bfdot za.s[x11, 7], { z21.h-z22.h }, z14.h\n"
    ".inst 0xa1412a87  // ld1h { z7.h, z15.h }, pn10.b/Z, [x20, #0x2, MUL VL]\n"
    ".inst 0xc12c72d4  // bfdot za.s[x11, 4], { z22.h-z23.h }, z12.h\n"
    ".inst 0xc12472d5  // bfdot za.s[x11, 5], { z22.h-z23.h }, z4.h\n"
    ".inst 0xa0422aa0  // ld1h { z0.h-z1.h }, pn10.b/Z, [x21, #0x4, MUL VL]\n"
    ".inst 0xc12172d6  // bfdot za.s[x11, 6], { z22.h-z23.h }, z1.h\n"
    ".inst 0xc12072d7  // bfdot za.s[x11, 7], { z22.h-z23.h }, z0.h\n"
    ".inst 0xa0422a80  // ld1h { z0.h-z1.h }, pn10.b/Z, [x20, #0x4, MUL VL]\n"
    ".inst 0xc12d1290  // bfdot za.s[x8, 0], { z20.h-z21.h }, z13.h\n"
    ".inst 0xc1251291  // bfdot za.s[x8, 1], { z20.h-z21.h }, z5.h\n"
    ".inst 0x658aaa14  // bfcvt z20.h, p2/M, z16.s\n"
    ".inst 0xa1402be6  // ld1h { z6.h, z14.h }, pn10.b/Z, [SP]\n"
    ".inst 0xc12f12b0  // bfdot za.s[x8, 0], { z21.h-z22.h }, z15.h\n"
    ".inst 0x648aaa74  // bfcvtnt z20.h, p2/M, z19.s\n"
    ".inst 0xc12712b1  // bfdot za.s[x8, 1], { z21.h-z22.h }, z7.h\n"
    ".inst 0x658aaa35  // bfcvt z21.h, p2/M, z17.s\n"
    ".inst 0xa1412be5  // ld1h { z5.h, z13.h }, pn10.b/Z, [SP, #0x2, MUL VL]\n"
    ".inst 0xc12112d0  // bfdot za.s[x8, 0], { z22.h-z23.h }, z1.h\n"
    ".inst 0x648aab75  // bfcvtnt z21.h, p2/M, z27.s\n"
    ".inst 0xc12012d1  // bfdot za.s[x8, 1], { z22.h-z23.h }, z0.h\n"
    ".inst 0x658aa956  // bfcvt z22.h, p2/M, z10.s\n"
    ".inst 0x658aa977  // bfcvt z23.h, p2/M, z11.s\n"
    "add x8, x8, #0x2\n"
    ".inst 0xc0066800  // mova { z0.d-z1.d }, za.d[x11, #0]\n"
    ".inst 0xa1422be4  // ld1h { z4.h, z12.h }, pn10.b/Z, [SP, #0x4, MUL VL]\n"
    ".inst 0x648aa916  // bfcvtnt z22.h, p2/M, z8.s\n"
    ".inst 0xc0066822  // mova { z2.d-z3.d }, za.d[x11, #1]\n"
    ".inst 0xc1bccba0  // fclamp { z0.s-z3.s }, z29.s, z28.s\n"
    "st1w { z0.s }, p1, [x14]\n"
    "add x14, x14, x5, LSL #2\n"
    "st1w { z2.s }, p1, [x13]\n"
    "add x13, x13, x10, LSL #2\n"
    "add x11, x11, #0x2\n"
    ".inst 0xc0040bc0  // mova za.d[x8, #0], { z30.d-z31.d }\n"
    "st1w { z1.s }, p1, [x9]\n"
    "add x9, x9, x27, LSL #2\n"
    ".inst 0xc0040bc1  // mova za.d[x8, #1], { z30.d-z31.d }\n"
    ".inst 0x648aaa57  // bfcvtnt z23.h, p2/M, z18.s\n"
    "st1w { z3.s }, p1, [x28]\n"
    "add x28, x28, x26, LSL #2\n"
    "bgt 18b\n"
    "19:"  // Main loop tail
    "addvl x23, SP, #6\n"
    ".inst 0xc12e7290  // bfdot za.s[x11, 0], { z20.h-z21.h }, z14.h\n"
    "addvl x22, SP, #12\n"
    ".inst 0xc1267291  // bfdot za.s[x11, 1], { z20.h-z21.h }, z6.h\n"
    ".inst 0xa0402ae0  // ld1h { z0.h-z1.h }, pn10.b/Z, [x23]\n"
    "addvl x21, SP, #18\n"
    "addvl x20, SP, #24\n"
    ".inst 0xc1217292  // bfdot za.s[x11, 2], { z20.h-z21.h }, z1.h\n"
    ".inst 0xc1207293  // bfdot za.s[x11, 3], { z20.h-z21.h }, z0.h\n"
    ".inst 0xa1402ac6  // ld1h { z6.h, z14.h }, pn10.b/Z, [x22]\n"
    ".inst 0xc12d72b0  // bfdot za.s[x11, 0], { z21.h-z22.h }, z13.h\n"
    ".inst 0xc12572b1  // bfdot za.s[x11, 1], { z21.h-z22.h }, z5.h\n"
    ".inst 0xa1412ae7  // ld1h { z7.h, z15.h }, pn10.b/Z, [x23, #0x2, MUL VL]\n"
    ".inst 0xc12e7294  // bfdot za.s[x11, 4], { z20.h-z21.h }, z14.h\n"
    ".inst 0xc1267295  // bfdot za.s[x11, 5], { z20.h-z21.h }, z6.h\n"
    ".inst 0xa1402aa5  // ld1h { z5.h, z13.h }, pn10.b/Z, [x21]\n"
    ".inst 0xc12f72b2  // bfdot za.s[x11, 2], { z21.h-z22.h }, z15.h\n"
    ".inst 0xc12772b3  // bfdot za.s[x11, 3], { z21.h-z22.h }, z7.h\n"
    ".inst 0xa1412ac7  // ld1h { z7.h, z15.h }, pn10.b/Z, [x22, #0x2, MUL VL]\n"
    ".inst 0xc12c72d0  // bfdot za.s[x11, 0], { z22.h-z23.h }, z12.h\n"
    ".inst 0xc12472d1  // bfdot za.s[x11, 1], { z22.h-z23.h }, z4.h\n"
    ".inst 0xa1422ae6  // ld1h { z6.h, z14.h }, pn10.b/Z, [x23, #0x4, MUL VL]\n"
    ".inst 0xc12d7296  // bfdot za.s[x11, 6], { z20.h-z21.h }, z13.h\n"
    ".inst 0xc1257297  // bfdot za.s[x11, 7], { z20.h-z21.h }, z5.h\n"
    ".inst 0xa1402a85  // ld1h { z5.h, z13.h }, pn10.b/Z, [x20]\n"
    ".inst 0xc12f72b4  // bfdot za.s[x11, 4], { z21.h-z22.h }, z15.h\n"
    ".inst 0xc12772b5  // bfdot za.s[x11, 5], { z21.h-z22.h }, z7.h\n"
    ".inst 0xa1412aa7  // ld1h { z7.h, z15.h }, pn10.b/Z, [x21, #0x2, MUL VL]\n"
    ".inst 0xc12e72d2  // bfdot za.s[x11, 2], { z22.h-z23.h }, z14.h\n"
    ".inst 0xc12672d3  // bfdot za.s[x11, 3], { z22.h-z23.h }, z6.h\n"
    ".inst 0xa1422ac6  // ld1h { z6.h, z14.h }, pn10.b/Z, [x22, #0x4, MUL VL]\n"
    ".inst 0xc12f72b6  // bfdot za.s[x11, 6], { z21.h-z22.h }, z15.h\n"
    ".inst 0xc12772b7  // bfdot za.s[x11, 7], { z21.h-z22.h }, z7.h\n"
    ".inst 0xa1412a87  // ld1h { z7.h, z15.h }, pn10.b/Z, [x20, #0x2, MUL VL]\n"
    ".inst 0xc12e72d4  // bfdot za.s[x11, 4], { z22.h-z23.h }, z14.h\n"
    ".inst 0xc12672d5  // bfdot za.s[x11, 5], { z22.h-z23.h }, z6.h\n"
    ".inst 0xa1422aa3  // ld1h { z3.h, z11.h }, pn10.b/Z, [x21, #0x4, MUL VL]\n"
    ".inst 0xc12b72d6  // bfdot za.s[x11, 6], { z22.h-z23.h }, z11.h\n"
    ".inst 0xc12372d7  // bfdot za.s[x11, 7], { z22.h-z23.h }, z3.h\n"
    ".inst 0xa0422a82  // ld1h { z2.h-z3.h }, pn10.b/Z, [x20, #0x4, MUL VL]\n"
    ".inst 0xc12d1290  // bfdot za.s[x8, 0], { z20.h-z21.h }, z13.h\n"
    ".inst 0xc1251291  // bfdot za.s[x8, 1], { z20.h-z21.h }, z5.h\n"
    ".inst 0xc12f12b0  // bfdot za.s[x8, 0], { z21.h-z22.h }, z15.h\n"
    ".inst 0xc12712b1  // bfdot za.s[x8, 1], { z21.h-z22.h }, z7.h\n"
    ".inst 0xc12312d0  // bfdot za.s[x8, 0], { z22.h-z23.h }, z3.h\n"
    ".inst 0xc12212d1  // bfdot za.s[x8, 1], { z22.h-z23.h }, z2.h\n"
    "add x8, x8, #0x2\n"
    ".inst 0xc0066814  // mova { z20.d-z21.d }, za.d[x11, #0]\n"
    ".inst 0xc0066836  // mova { z22.d-z23.d }, za.d[x11, #1]\n"
    ".inst 0xc1bccbb4  // fclamp { z20.s-z23.s }, z29.s, z28.s\n"
    "st1w { z20.s }, p1, [x14]\n"
    "add x14, x14, x5, LSL #2\n"
    "st1w { z22.s }, p1, [x13]\n"
    "add x13, x13, x10, LSL #2\n"
    "add x11, x11, #0x2\n"
    ".inst 0xc0040bc0  // mova za.d[x8, #0], { z30.d-z31.d }\n"
    "st1w { z21.s }, p1, [x9]\n"
    "add x9, x9, x27, LSL #2\n"
    ".inst 0xc0040bc1  // mova za.d[x8, #1], { z30.d-z31.d }\n"
    "st1w { z23.s }, p1, [x28]\n"
    "add x28, x28, x26, LSL #2\n"
    "20:"  // Main loop skip tail
    "cbz x15, 22f\n"
    "21:"  // Right padding loop
    ".inst 0xc0066800  // mova { z0.d-z1.d }, za.d[x11, #0]\n"
    "add x8, x8, #0x2\n"
    "subs x15, x15, #0x1\n"
    ".inst 0xc0066822  // mova { z2.d-z3.d }, za.d[x11, #1]\n"
    ".inst 0xc1bccba0  // fclamp { z0.s-z3.s }, z29.s, z28.s\n"
    "st1w { z0.s }, p1, [x14]\n"
    "add x14, x14, x5, LSL #2\n"
    "st1w { z2.s }, p1, [x13]\n"
    "add x13, x13, x10, LSL #2\n"
    "add x11, x11, #0x2\n"
    ".inst 0xc0040bc0  // mova za.d[x8, #0], { z30.d-z31.d }\n"
    "st1w { z1.s }, p1, [x9]\n"
    "add x9, x9, x27, LSL #2\n"
    ".inst 0xc0040bc1  // mova za.d[x8, #1], { z30.d-z31.d }\n"
    "st1w { z3.s }, p1, [x28]\n"
    "add x28, x28, x26, LSL #2\n"
    "bgt 21b\n"
    "22:"  // End
    "ldr x20, [%x[args], %[offsetof_Args_weights]]\n"
    "incb x20, ALL, MUL #16\n"
    "incb x20, ALL, MUL #9\n"
    "str x20, [%x[args], %[offsetof_Args_weights]]\n"
    "ldr x21, [%x[args], %[offsetof_Args_ld_in_vl]]\n"
    "incw x17\n"
    "whilelt p1.s, x17, x7\n"
    "ldr x20, [%x[args], %[offsetof_Args_inptr]]\n"
    "add x20, x20, x21, LSL #2\n"
    "str x20, [%x[args], %[offsetof_Args_inptr]]\n"
    "ldr x25, [%x[args], %[offsetof_Args_outptrs]]\n"
    "ldr x24, [%x[args], %[offsetof_Args_ld_out_vls]]\n"
    "ldp x23, x22, [x25, #0x0]\n"
    "ldp x21, x20, [x24, #0x0]\n"
    "add x23, x23, x21, LSL #2\n"
    "add x22, x22, x20, LSL #2\n"
    "stp x23, x22, [x25, #0x0]\n"
    "ldp x23, x22, [x25, #0x10]\n"
    "ldp x21, x20, [x24, #0x10]\n"
    "add x23, x23, x21, LSL #2\n"
    "add x22, x22, x20, LSL #2\n"
    "stp x23, x22, [x25, #0x10]\n"
    "b.any 1b\n"
    "addvl SP, SP, #30\n"
    ".inst 0xd503467f  // SMSTOP\n"
    :
    : [args] "r" (&args), [ld_in_col] "r" (ld_in_col), [ld_in_row] "r" (ld_in_row), [offsetof_Args_bias] "I" (offsetof(Args, bias)), [offsetof_Args_clamp_max] "I" (offsetof(Args, clamp_max)), [offsetof_Args_clamp_min] "I" (offsetof(Args, clamp_min)), [offsetof_Args_current_channel] "I" (offsetof(Args, current_channel)), [offsetof_Args_inptr] "I" (offsetof(Args, inptr)), [offsetof_Args_input_cols] "I" (offsetof(Args, input_cols)), [offsetof_Args_ld_in_vl] "I" (offsetof(Args, ld_in_vl)), [offsetof_Args_ld_out_cols] "I" (offsetof(Args, ld_out_cols)), [offsetof_Args_ld_out_vls] "I" (offsetof(Args, ld_out_vls)), [offsetof_Args_n_channels] "I" (offsetof(Args, n_channels)), [offsetof_Args_outptrs] "I" (offsetof(Args, outptrs)), [offsetof_Args_output_cols] "I" (offsetof(Args, output_cols)), [offsetof_Args_pad_bottom] "I" (offsetof(Args, pad_bottom)), [offsetof_Args_pad_left] "I" (offsetof(Args, pad_left)), [offsetof_Args_pad_top] "I" (offsetof(Args, pad_top)), [offsetof_Args_weights] "I" (offsetof(Args, weights))
    : "cc", "memory", "p0", "p1", "p2", "p3", "p4", "p5", "p6", "p7", "p8", "p9", "p10", "p11", "p12", "p13", "p14", "p15", "x4", "x5", "x6", "x7", "x8", "x9", "x10", "x11", "x12", "x13", "x14", "x15", "x16", "x17", "x20", "x21", "x22", "x23", "x24", "x25", "x26", "x27", "x28", "z0", "z1", "z2", "z3", "z4", "z5", "z6", "z7", "z8", "z9", "z10", "z11", "z12", "z13", "z14", "z15", "z16", "z17", "z18", "z19", "z20", "z21", "z22", "z23", "z24", "z25", "z26", "z27", "z28", "z29", "z30", "z31"
  );
}

}  // namespace depthwise
}  // namespace arm_conv

#endif  // defined(ARM_COMPUTE_ENABLE_SME2)
