/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.RuntimeConfigurable;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;

public class Target
implements TaskContainer {
    private String name;
    private String ifCondition = "";
    private String unlessCondition = "";
    private Vector dependencies = new Vector(2);
    private Vector children = new Vector(5);
    private Project project;
    private String description = null;

    public void setProject(Project project) {
        this.project = project;
    }

    public Project getProject() {
        return this.project;
    }

    public void setDepends(String depS) {
        if (depS.length() > 0) {
            StringTokenizer tok = new StringTokenizer(depS, ",", true);
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken().trim();
                if (token.equals("") || token.equals(",")) {
                    throw new BuildException("Syntax Error: Depend attribute for target \"" + this.getName() + "\" has an empty string for dependency.");
                }
                this.addDependency(token);
                if (!tok.hasMoreTokens()) continue;
                token = tok.nextToken();
                if (tok.hasMoreTokens() && token.equals(",")) continue;
                throw new BuildException("Syntax Error: Depend attribute for target \"" + this.getName() + "\" ends with a , character");
            }
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void addTask(Task task) {
        this.children.addElement(task);
    }

    public void addDataType(RuntimeConfigurable r) {
        this.children.addElement(r);
    }

    public Task[] getTasks() {
        Vector tasks = new Vector(this.children.size());
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            Object o = enumeration.nextElement();
            if (!(o instanceof Task)) continue;
            tasks.addElement(o);
        }
        Object[] retval = new Task[tasks.size()];
        tasks.copyInto(retval);
        return retval;
    }

    public void addDependency(String dependency) {
        this.dependencies.addElement(dependency);
    }

    public Enumeration getDependencies() {
        return this.dependencies.elements();
    }

    public void setIf(String property) {
        this.ifCondition = property == null ? "" : property;
    }

    public void setUnless(String property) {
        this.unlessCondition = property == null ? "" : property;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.name;
    }

    public void execute() throws BuildException {
        if (this.testIfCondition() && this.testUnlessCondition()) {
            Enumeration enumeration = this.children.elements();
            while (enumeration.hasMoreElements()) {
                Object o = enumeration.nextElement();
                if (o instanceof Task) {
                    Task task = (Task)o;
                    task.perform();
                    continue;
                }
                RuntimeConfigurable r = (RuntimeConfigurable)o;
                r.maybeConfigure(this.project);
            }
        } else if (!this.testIfCondition()) {
            this.project.log(this, "Skipped because property '" + this.ifCondition + "' not set.", 3);
        } else {
            this.project.log(this, "Skipped because property '" + this.unlessCondition + "' set.", 3);
        }
    }

    public final void performTasks() {
        try {
            this.project.fireTargetStarted(this);
            this.execute();
            this.project.fireTargetFinished(this, null);
        }
        catch (RuntimeException exc) {
            this.project.fireTargetFinished(this, exc);
            throw exc;
        }
    }

    /*
     * WARNING - void declaration
     */
    void replaceChild(Task el, RuntimeConfigurable o) {
        int index;
        while ((index = this.children.indexOf(el)) >= 0) {
            void var3_3;
            this.children.setElementAt(o, (int)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    void replaceChild(Task el, Task o) {
        int index;
        while ((index = this.children.indexOf(el)) >= 0) {
            void var3_3;
            this.children.setElementAt(o, (int)var3_3);
        }
    }

    private boolean testIfCondition() {
        if ("".equals(this.ifCondition)) {
            return true;
        }
        String test = this.project.replaceProperties(this.ifCondition);
        return this.project.getProperty(test) != null;
    }

    private boolean testUnlessCondition() {
        if ("".equals(this.unlessCondition)) {
            return true;
        }
        String test = this.project.replaceProperties(this.unlessCondition);
        return this.project.getProperty(test) == null;
    }
}

