# -*- coding: utf-8 -*-
#####################################################################
#  Rafael Proença <cypherbios@ubuntu.com>
#  Laudeci Oliveira <laudeci@gmail.com> 
#
#  Copyright 2006 APTonCD DevTeam.
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published
#  by the Free Software Foundation; version 2 only.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#####################################################################
import gtk

from APTonCD.core import *
from APTonCD.core import gui 
from APTonCD.core import constants
import APTonCD.core.utils
from APTonCD.core.utils import get_icon

WINDOW_NAME = 'dlgSkipped'

class SkippedDialog(controller.IController):

    """
        This class will handle a list of packages skipped..
    """
    def __init__(self, controller = None, pkg_list = []):
        """
        Constructor
        """
        self.controller = controller
        self.packages = pkg_list
        self.glade = gui.get_glade(constants.PROPERTY_GUI, WINDOW_NAME)
            
        #Main widget
        self.window = gui.get_widget(self.glade, WINDOW_NAME)
        self.window.set_icon_name(constants.APP_ICON_NAME)
        
        self.tvPkgSkipped = gui.get_widget(self.glade, 'tvPkgSkipped')
        self.cellRendererText = gtk.CellRendererText()
        
        # add the check column to the tree view widget
        column = gtk.TreeViewColumn('', self.cellRendererText, text = 0)
        self.tvPkgSkipped.append_column(column)
        self.model = gtk.ListStore(str)
        
        self.lblMessage = gui.get_widget(self.glade, 'lblMessage')
        if self.controller:
            self.window.set_transient_for(self.controller.get_main_window())
            self.window.set_position(gtk.WIN_POS_CENTER_ON_PARENT)
        
        self.load_list()    
        self.window.set_modal(True)
    
    def run(self):
        return self.window.run()

    def destroy(self):
        self.window.destroy()

    def set_message(self, msg =''):
        if msg != '':
            self.lblMessage.set_markup(msg)
            
    def get_main_window(self):
        """
            implements IController interface method.
            for access the class windows object.
        """
        if self.controller:
            return self.controller.get_main_window()
        else:
            return self.window

    def get_parent_widget(self):
        """
            implements IController interface method.
            for container widget
        """
        if self.controller:
            self.controller.get_parent_widget()
        else:
            return self.window.get_children()[0]
        
    def load_list(self):
        for n in self.packages:
            self.model.append([n])
        self.tvPkgSkipped.set_model(self.model)
