/*
 * Copyright (C) 2021 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.window.extensions;

import android.annotation.NonNull;

/**
 * Provides the OEM implementation of {@link WindowExtensions}.
 */
public class WindowExtensionsProvider {

    private static final WindowExtensions sWindowExtensions = new WindowExtensionsImpl();

    /**
     * Returns the OEM implementation of {@link WindowExtensions}. This method is implemented in
     * the library provided on the device and overwrites one in the Jetpack library included in
     * apps.
     * @return the OEM implementation of {@link WindowExtensions}
     */
    @NonNull
    public static WindowExtensions getWindowExtensions() {
        return sWindowExtensions;
    }
}
