# C.2 Why is capitalism exploitative?

For anarchists, capitalism is marked by the exploitation of labour by capital.
While this is most famously expressed by Proudhon's _**"property is theft,"**_
this perspective can be found in all forms of anarchism. For Bakunin,
capitalism was marked by an _"economic relationship between the exploiter and
exploited"_ as it meant the few have _"the power and right to live by
exploiting the labour of someone else, the right to exploit the labour of
those who possess neither property nor capital and who thus are forced to sell
their productive power to the lucky owners of both."_ [ **The Political
Philosophy of Bakunin** , p. 183] This means that when a worker _"sells his
labour to an employee . . . some part of the value of his produce will be
unjustly taken by the employer."_ [Kropotkin, **Anarchism and Anarchist-
Communism** , p. 52]

At the root this criticism is based, ironically enough, on the **capitalist**
defence of private property as the product of labour. As noted in [section
B.4.2](secB4.md#secb42), Locke defended private property in terms of labour
yet allowed that labour to be sold to others. This allowed the buyers of
labour (capitalists and landlords) to appropriate the product of other
people's labour (wage workers and tenants) and so, in the words of dissident
economist David Ellerman, _"capitalist production, i.e. production based on
the employment contract denies workers the right to the (positive and
negative) fruit of their labour. Yet people's right to the fruits of their
labour has always been the natural basis for private property appropriation.
Thus capitalist production, far from being founded on private property, in
fact denies the natural basis for private property appropriation."_ [ **The
Democratic worker-owned firm** , p. 59] This was expressed by Proudhon in the
following way:

> _"Whoever labours becomes a proprietor -- this is an inevitable deduction
> from the principles of political economy and jurisprudence. And when I say
> proprietor, I do not mean simply (as do our hypocritical economists)
> proprietor of his allowance, his salary, his wages, -- I mean proprietor of
> the value his creates, and by which the master alone profits . . . **The
> labourer retains, even after he has received his wages, a natural right in
> the thing he was produced.** "_ [ **What is Property?** , pp. 123-4]

In other words, taking the moral justification for capitalism, anarchists
argue that it fails to meet its own criteria ( _"With me who, as a labourer,
have a right to the possession of the products of Nature and my own industry
-- and who, as a proletaire [wage labourer], enjoy none of them."_ [Proudhon,
**Op. Cit.** , p. 65]). Whether this principle should be applied in a free
society is a moot point within anarchism. Individualist and mutualist
anarchists argue it should be and, therefore, say that individual workers
should receive the product of their toil (and so argue for distribution
according to deed). Communist-anarchists argue that _"social ownership and
sharing according to need . . . would be the best and most just economic
arrangement."_ This is for two reasons. Firstly, because _"in modern
industry"_ there is _"no such thing"_ as an individual product as _"all labour
and the products of labour are social."_ [Berkman, **What is Anarchism?** ,
pp. 169-70] Secondly, in terms of simple justice need is not related to the
ability to work and, of course, it would be wrong to penalise those who cannot
work (i.e. the sick, the young and the old). Yet, while anarchists disagree
over exactly how this should be most justly realised, they all agree that
labour should control **all** that it produces (either individually or
collectively) and, consequently, non-labour income is exploitation (it should
be stressed that as both schemes are voluntary, there is no real contradiction
between them). Anarchists tend to call non-labour income "surplus-value" or
"usury" and these terms are used to group together profits, rent and interest
(see [section C.2.1](secC2.md#secc21) for details).

That this critique is a problem for capitalism can be seen from the many
varied and wonderful defences created by economists to justify non-labour
income. Economists, at least in the past, saw the problem clear enough. John
Stuart Mill, the final great economist of the classical school, presented the
typical moral justification of capitalism, along with the problems it causes.
As he explains in his classic introduction to economics, the _"institution of
property, when limited to its essential elements, consists in the recognition,
in each person, of a right to the exclusive disposal of what he or she have
produced by their own exertions . . . The foundation of the whole is, the
right of producers to what they themselves have produced."_ He then notes the
obvious contradiction -- workers do **not** receive what they have produced.
Thus it _"may be objected"_ that capitalist society _"recognises rights of
property in individuals over which they have not produced,"_ for example _"the
operatives in a manufactory create, by their labour and skill, the whole
produce; yet, instead of it belonging to them, the law gives them only their
stipulated hire [wages], and transfers the produce to someone who has merely
supplied the funds, without perhaps contributing to the work itself."_ [
**Principles of Political Economy** , p. 25] With the rise of neoclassical
economics, the problem remained and so did need to justify capitalism
continued to drive economics. J. B. Clark, for example, knew what was at stake
and, like Mill, expressed it:

> _"When a workman leaves the mill, carrying his pay in his pocket, the civil
> law guarantees to him what he thus takes away; but before he leaves the mill
> he is the rightful owner of a part of the wealth that the day's industry has
> brought forth. Does the economic law which, in some way that he does not
> understand, determines what his pay shall be, make it to correspond with the
> amount of his portion of the day's product, or does it force him to leave
> some of his rightful share behind him? A plan of living that should force
> men to leave in their employer's hands anything that by right of creation is
> theirs, would be an institutional robbery -- a legally established violation
> of the principle on which property is supposed to rest."_ [ **The
> Distribution of Wealth** , pp. 8-9]

Why should the owners of land, money and machinery get an income in the first
place? Capitalist economics argues that everything involves a cost and, as
such, people should be rewarded for the sacrifices they suffer when they
contribute to production. Labour, in this schema, is considered a cost to
those who labour and, consequently, they should be rewarded for it. Labour is
thought of a disutility, i.e. something people do not want, rather than
something with utility, i.e. something people do want. Under capitalism (like
any class system), this perspective makes some sense as workers are bossed
about and often subject to long and difficult labour. Most people will happily
agree that labour is an obvious cost and should be rewarded.

Economists, unsurprisingly, have tended to justify surplus value by arguing
that it involves as much cost and sacrifice as labour. For Mill, labour
_"cannot be carried on without materials and machinery . . . All these things
are the fruits of previous production. If the labourers possessed of them,
they would not need to divide the produce with any one; but while they have
them not, an equivalent must be given to those who have."_ [ **Op. Cit.** , p.
25] This rationale for profits is called the "abstinence" or "waiting" theory.
Clark, like Mill, expressed a defence of non-labour income in the face of
socialist and anarchist criticism, namely the idea of marginal productivity to
explain and justify non-labour income. Other theories have been developed as
the weaknesses of previous ones have been exposed and we will discuss some of
them in subsequent sections.

The ironic thing is that, well over 200 years after it came of age with Adam
Smith's **Wealth of Nations** , economics has no agreed explanation for the
source of surplus value. As dissident economists Michele I. Naples and Nahid
Aslanbeigui show, introductory economics texts provide _"no consistent, widely
accepted theory"_ on the profit rate. Looking at the top three introductions
to economics, they discovered that there was a _"strange amalgam"_ of theories
which is _"often confusing, incomplete and inconsistent."_ Given that internal
consistency is usually heralded as one of the hallmarks of neoclassical
theory, _"the theory must be questioned."_ This _"failure . . . to provide a
coherent theory of the rate of profit in the short run or long run"_ is
damning, as the _"absence of a coherent explanation for the profit rate
represents a fundamental failure for the neoclassical model."_ [ _"What
**does** determine the profit rate? The neoclassical theories present in
introductory textbooks,"_ pp. 53-71, **Cambridge Journal of Economics** , vol.
20, p. 53, p. 54, p. 69 and p. 70]

As will become clear, anarchists consider defences of _"surplus value"_ to be
essentially ideological and without an empirical base. As we will attempt to
indicate, capitalists are not justified in appropriating surplus value from
workers for no matter how this appropriation is explained by capitalist
economics, we find that inequality in wealth and power are the real reasons
for this appropriation rather than some actual productive act on the part of
capitalists, investors or landlords. Mainstream economic theories generally
seek to justify the distribution of income and wealth rather than to
understand it. They are parables about what should be rather than what is. We
argue that any scientific analysis of the source of _"surplus value"_ cannot
help conclude that it is due, primarily, to inequalities of wealth and,
consequently, inequalities of power on the market. In other words, that
Rousseau was right:

> _"The terms of social compact between these two estates of men may be summed
> up in a few words: 'You have need of me, because I am rich and you are poor.
> We will therefore come to an agreement. I will permit you to have the honour
> of serving me, on condition that you bestow on me that little you have left,
> in return for the pains I shall take to command you.'"_ [ **The Social
> Contract and Discourses** , p. 162]

This is the analysis of exploitation we present in more detail in [section
C.2.2](secC2.md#secc22). To summarise it, labour faces social inequality
when it passes from the market to production. In the workplace, capitalists
exercise social power over how labour is used and this allows them to produce
more value from the productive efforts of workers than they pay for in wages.
This social power is rooted in social dependence, namely the fact that workers
have little choice but to sell their liberty to those who own the means of
life. To ensure the creation and appropriation of surplus-value, capitalists
must not only own the production process and the product of the workers'
labour, they must own the labour of the workers itself. In other words, they
must control the workers. Hence capitalist production must be, to use
Proudhon's term, _"despotism."_ How much surplus-value can be produced depends
on the relative economic power between bosses and workers as this determines
the duration of work and the intensity of labour, however its roots are the
same -- the hierarchical and class nature of capitalist society.

## C.2.1 What is _"surplus value"_?

Before discussing how surplus-value exists and the flaws in capitalist
defences of it, we need to be specific about what we mean by the term
_**"surplus value."**_ To do this we must revisit the difference between
possession and private property we discussed in [section B.3](secB3.md). For
anarchists, private property (or capital) is _"the power to produce without
labour."_ [Proudhon, **What is Property?** , p. 161] As such, surplus value is
created when the owners of property let others use them and receive an income
from so doing. Therefore something only becomes capital, producing surplus
value, under specific social relationships.

Surplus value is _"the difference between the value produced by the workers
and the wages they receive"_ and is _"appropriated by the landlord and
capitalist class . . . absorbed by the non-producing classes as profits,
interest, rent, etc."_ [Charlotte Wilson, **Anarchist Essays** , pp. 46-7] It
basically refers to any non-labour income (some anarchists, particularly
individualist anarchists, have tended to call _"surplus value"_ usury). As
Proudhon noted, it _"receives different names according to the thing by which
it is yielded: if by land, **ground-rent** ; if by houses and furniture,
**rent** ; if by life-investments, **revenue** ; if by money, **interest** ;
if by exchange, **advantage** , **gain** , **profit** (three things which must
not be confounded with the wages of legitimate price of labour)."_ [ **Op.
Cit.** , p. 159]

For simplicity, we will consider _"surplus value"_ to have three component
parts: profits, interest and rent. All are based on payment for letting
someone else use your property. Rent is what we pay to be allowed to exist on
part of the earth (or some other piece of property). Interest is what we pay
for the use of money. Profit is what we pay to be allowed to work a farm or
use piece of machinery. Rent and interest are easy to define, they are
obviously the payment for using someone else's property and have existed long
before capitalism appeared. Profit is a somewhat more complex economic
category although, ultimately, is still a payment for using someone else's
property.

The term "profit" is often used simply, but incorrectly, to mean an excess
over costs. However, this ignores the key issue, namely how a workplace is
organised. In a co-operative, for example, while there is a surplus over
costs, _"there is no profit, only income to be divided among members. Without
employees the labour-managed firm does not have a wage bill, and labour costs
are not counted among the expenses to be extracted from profit, as they are in
the capitalist firm."_ This means that the _" **economic category of profit
does not exist in the labour-managed firm,** as it does in the capitalist firm
where wages are a cost to be subtracted from gross income before a residual
profit is determined . . . Income shared among all producers is net income
generated by the firm: the total of value added by human labour applied to the
means of production, less payment of all costs of production and any reserves
for depreciation of plant and equipment."_ [Christopher Eaton Gunn, **Workers'
Self-Management in the United States** , p. 41 and p. 45] Gunn, it should be
noted, follows both Proudhon and Marx in his analysis ( _"Let us suppose the
workers are themselves in possession of their respective means of production
and exchange their commodities with one another. These commodities would not
be products of capital."_ [Marx, **Capital** , vol. 3, p. 276]).

In other words, by profits we mean income that flows to the owner of a
workplace or land who hires others to do the work. As such returns to capital
are as unique to capitalism as unemployment is. This means that a farmer who
works their own land receives a labour income when they sell the crop while
one who hires labourers to work the land will receives a non-labour income,
profit. Hence the difference between _**possession**_ and _**private
property**_ (or _**capital**_ ) and anarchist opposition to _"capitalist
property, that is, property which allows some to live by the work of others
and which therefore presupposes a class of . . . people, obliged to sell their
labour power to the property-owners for less than its value."_ [Malatesta,
**Errico Malatesta: His Life and Ideas** , p. 102]

Another complication arises due to the fact that the owners of private
property sometimes do work on them (i.e. be a boss) or hire others to do boss-
like work on their behalf (i.e. executives and other managerial staff). It
could be argued that bosses and executives are also _"workers"_ and so
contribute to the value of the commodities produced. However, this is not the
case. Exploitation does not just happen, it needs to be organised and managed.
In other words, exploitation requires labour ( _"There is work and there is
work,"_ as Bakunin noted, _"There is productive labour and there is the labour
of exploitation."_ [ **The Political Philosophy of Bakunin** , p. 180]). The
key is that while a workplace would grind to a halt without workers, the
workers could happily do without a boss by organising themselves into an
association to manage their own work. As such, while bosses may work, they are
not taking part in productive activity but rather exploitative activity.

Much the same can be said of executives and managers. Though they may not own
the instruments of production, they are certainly buyers and controllers of
labour power, and under their auspices production is still **capitalist**
production. The creation of a "salary-slave" strata of managers does not alter
the capitalist relations of production. In effect, the management strata are
**de facto** capitalists and they are like "working capitalist" and,
consequently, their "wages" come from the surplus value appropriated from
workers and realised on the market. Thus the exploitative role of managers,
even if they can be fired, is no different from capitalists. Moreover,
_"shareholders and managers/technocrats share common motives: to make profits
and to reproduce hierarchy relations that exclude most of the employees from
effective decision making"_ [Takis Fotopoulos, _"The Economic Foundations of
an Ecological Society"_ , pp. 1-40, **Society and Nature** , No.3, p. 16] In
other words, the high pay of the higher levels of management is a share of
profits **not** a labour income based on their contribution to production but
rather due to their position in the economic hierarchy and the power that
gives them.

So management is paid well because they monopolise power in the company and
can get away with it. As Bakunin argued, within the capitalist workplace
_"administrative work . . . [is] monopolised . . . if I concentrate in my
hands the administrative power, it is not because the interests of production
demand it, but in order to serve my own ends, the ends of exploitation. As
absolute boss of my establishment I get for my labours [many] . . . times more
than my workers get for theirs."_ [ **Op. Cit.** , p. 186] Given this, it is
irrelevant whether those in the hierarchy simply control (in the case of
managers) or actually own the means of production. What counts is that those
who do the actual work are excluded from the decision making process.

This is not to say that 100 percent of what managers do is exploitative. The
case is complicated by the fact that there is a legitimate need for co-
ordination between various aspects of complex production processes -- a need
that would remain under libertarian socialism and would be filled by elected
and recallable (and in some cases rotating) managers (see [section
I.3](secI3.md)). But under capitalism, managers become parasitic in
proportion to their proximity to the top of the pyramid. In fact, the further
the distance from the production process, the higher the salary; whereas the
closer the distance, the more likely that a "manager" is a worker with a
little more power than average. In capitalist organisations, the less you do,
the more you get. In practice, executives typically call upon subordinates to
perform managerial (i.e. co-ordinating) functions and restrict themselves to
broader policy-making decisions. As their decision-making power comes from the
hierarchical nature of the firm, they could be easily replaced if policy
making was in the hands of those who are affected by it. As such, their role
as managers do not require them to make vast sums. They are paid that well
currently because they monopolise power in the company and can, consequently,
get away with deciding that they, unsurprisingly, contribute most to the
production of useful goods rather than those who do the actual work.

Nor are we talking, as such, of profits generated by buying cheap and selling
dear. We are discussing the situation at the level of the economy as a whole,
**not** individual transactions. The reason is obvious. If profits could just
explained in terms of buying cheap in order to sell dear then, over all, such
transactions would cancel each other out when we look at the market as a whole
as any profit will cancel any loss. For example, if someone buys a product at,
say, £20 and sells it at £25 then there would be no surplus overall as someone
else will have to pay £20 for something which cost £25. In other words, what
one person gains as a seller, someone else will lose as a buyer and no net
surplus has been created. Capitalists, in other words, do not simply profit at
each other's expense. There is a creation of surplus rather than mere
redistribution of a given product. This means that we are explaining why
production results in a aggregate surplus and why it gets distributed between
social classes under capitalism.

This means that capitalism is based on the creation of surplus rather than
mere redistribution of a given sum of products. If this were not the case then
the amount of goods in the economy would not increase, growth would not exist
and all that would happen is that the distribution of goods would change,
depending on the transactions made. Such a world would be one without
production and, consequently, not realistic. Unsurprisingly, as we noted in
[section C.1](secC1.md), this is the world of neoclassical economics. This
shows the weakness of attempts to explain the source of profits in terms of
the market rather than production. While the market can explain how, perhaps,
a specific set of goods and surplus is distributed, it cannot explain how a
surplus is generated in the first place. To understand how a surplus is
created we need to look at the process of value creation. For this, it is
necessary to look at production to see if there is something which produces
more than it gets paid for. Anarchists, like other socialists, argue that this
is labour and, consequently, that capitalism is an exploitative system. We
discuss why in the [next section](secC2.md#secc22).

Obviously, pro-capitalist economics argues against this theory of how a
surplus arises and the conclusion that capitalism is exploitative. We will
discuss the more common arguments below. However, one example will suffice
here to see why labour is the source of a surplus, rather than (say)
"waiting", risk or the productivity of capital (to list some of the more
common explanations for capitalist appropriation of surplus value). This is a
card game. A good poker-player uses equipment (capital), takes risks, delays
gratification, engages in strategic behaviour, tries new tricks (innovates),
not to mention cheats, and can make large winnings. However, no surplus
product results from such behaviour; the gambler's winnings are simply
redistributions from others with no new production occurring. For one to win,
the rest must lose. Thus risk-taking, abstinence, entrepreneurship, and so on
might be necessary for an individual to receive profits but they are far from
sufficient for them not to be the result a pure redistribution from others.

In short, our discussion of exploitation under capitalism is first and
foremost an economy-wide one. We are concentrating on how value (goods and
services) and surplus value (profits, rent and interest) are produced rather
than how they are distributed. The distribution of goods between people and
the division of income into wages and surplus value between classes is a
secondary concern as this can only occur under capitalism if workers produce
goods and services to sell (this is the direct opposite of mainstream
economics which assumes a static economy with almost no discussion of how
scarce means are organised to yield outputs, the whole emphasis is on
exchanges of ready made goods).

Nor is this distribution somehow fixed. As we discuss in [section
C.3](secC3.md), how the amount of value produced by workers is divided
between wages and surplus value is source of much conflict and struggle, the
outcome of which depends on the balance of power between and within classes.
The same can be said of surplus value. This is divided between profits,
interest and rent -- capitalists, financiers and landlords. This does not
imply that these sections of the exploiting class see eye to eye or that there
is not competition between them. Struggle goes on within classes and well as
between classes and this applies at the top of the economic hierarchy as at
the bottom. The different sections of the ruling elite fight over their share
of surplus value. This can involve fighting over control of the state to
ensure that their interests are favoured over others. For example, the
Keynesian post-war period can be considered a period when industrial
capitalists shaped state policy while the period after 1973 represents a shift
in power towards finance capital.

We must stress, therefore, that the exploitation of workers is not defined as
payment less than competitive ("free market") for their labour. Rather,
exploitation occurs even if they are paid the market wage. This is because
workers are paid for their ability to labour (their _"labour-power,"_ to use
Marx's term) rather the labour itself. This means that for a given hour's work
(labour), the capitalist expects the worker to produce more than their wage
(labour power). How much more is dependent on the class struggle and the
objective circumstances each side faces. Indeed, a rebellious workforce
willing to take direct action in defence of their interests will not allow
subjection or its resulting exploitation.

Similarly, it would be wrong to confuse exploitation with low wages. Yes,
exploitation is often associated with paying low wages but it is more than
possible for real wages to go up while the rate of exploitation falls or
rises. While some anarchists in the nineteenth century did argue that
capitalism was marked by falling real wages, this was more a product of the
time they were living through rather than an universal law. Most anarchists
today argue that whether wages rise or fall depends on the social and economic
power of working people and the historic context of a given society. This
means, in other words, that labour is exploited not because workers have a low
standard of living (although it can) but because labour produces the whole of
the value created in any process of production or creation of a service but
gets only part of it back.

As such, it does not matter **if** real wages do go up or not. Due to the
accumulation of capital, the social and economic power of the capitalists and
their ability to extract surplus-value can go up at a higher rate than real
wages. The key issue is one of freedom rather than the possibility of
consuming more. Bosses are in a position, due to the hierarchical nature of
the capitalist workplace, to make workers produce more than they pay them in
wages. The absolute level of those wages is irrelevant to the creation and
appropriation of value and surplus-value as this happens at all times within
capitalism.

As an example, since the 1970s American workers have seen their wages stagnate
and have placed themselves into more and more debt to maintain an expected
standard of living. During this time, productivity has increased and so they
have been increasingly exploited. However, between 1950s and 1970s wages did
increase along with productivity. Strong unions and a willingness to strike
mitigated exploitation and increased living standards but exploitation
continued. As Doug Henwood notes, while _"average incomes have risen
considerably"_ since 1945, _"the amount of work necessary to earn those
incomes has risen with equal relentlessness . . . So, despite the fact that
productivity overall is up more than threefold"_ over this time _"the average
worker would have to toil six months longer to make the average family
income."_ [ **After the New Economy** , pp. 39-40] In other words, rising
exploitation **can** go hand in hand with rising wages.

Finally, we must stress that we are critiquing economics mostly in its own
terms. On average workers sell their labour-power at a "fair" market price and
still exploitation occurs. As sellers of a commodity (labour-power) they do
not receive its full worth (i.e. what they actually produce). Even if they
did, almost all anarchists would still be against the system as it is based on
the worker becoming a wage-slave and subject to hierarchy. In other words,
they are not free during production and, consequently, they would still being
robbed, although this time it is as human beings rather than a factor of
production (i.e. they are oppressed rather than exploited). As Bookchin put
it:

> _"To the modern mind, labour is viewed as a rarefied, abstract activity, a
> process extrinsic to human notions of genuine self-actualisation. One
> usually 'goes to work' the way a condemned person 'goes' to a place of
> confinement: the workplace is little more than a penal institution in which
> mere existence must a penalty in the form of mindless labour . . . We
> 'measure' labour in hours, products, and efficiency, but rarely do we
> understand it as a concrete human activity. Aside from the earnings it
> generates, labour is normally alien to human fulfilment . . . [as] the
> rewards one acquires by submitting to a work discipline. By definition,
> these rewards are viewed as incentives for submission, rather than for the
> freedom that should accompany creativity and self-fulfilment. We commonly
> are 'paid' for supinely working on our knees, not for heroically standing in
> our feet."_ [ **The Ecology of Freedom** , p. 308]

Almost all anarchists seek to change this, combat oppression and alienation as
well as exploitation (some individualist anarchists are the exception on this
issue). Needless to say, the idea that we could be subject to oppression
during working hours and **_not_** be exploited is one most anarchists would
dismiss as a bad joke and, as a result, follow Proudhon and demand the
abolition of wage labour (most take it further and advocate the abolition of
the wages system as well, i.e. support libertarian communism).

## C.2.2 How does exploitation happen?

In order to make more money, money must be transformed into capital, i.e.,
workplaces, machinery and other _"capital goods."_ By itself, however, capital
(like money) produces nothing. While a few even talk about _"making money work
for you"_ (as if pieces of paper can actually do any form of work!) obviously
this is not the case -- human beings have to do the actual work. As Kropotkin
put it, _"if [the capitalist] locks [his money] up, it will not increase,
because [it] does not grow like seed, and after a lapse of a twelve month he
will not find £110 in his drawer if he only put £100 into it._ [ **The Place
of Anarchism in Socialistic Evolution** , p. 4] Capital only becomes
productive in the labour process when workers use it:

> _"Values created by net product are classed as savings and capitalised in
> the most highly exchangeable form, the form which is freest and least
> susceptible of depreciation, -- in a word, the form of specie, the only
> constituted value. Now, if capital leaves this state of freedom and
> **engages itself** , -- that is, takes the form of machines, buildings,
> etc., -- it will still be susceptible of exchange, but much more exposed
> than before to the oscillations of supply and demand. Once engaged, it
> cannot be **disengaged** without difficulty; and the sole resource of its
> owner will be exploitation. Exploitation alone is capable of maintaining
> engaged capital at its nominal value."_ [ **System of Economical
> Contradictions** , p. 291]

Under capitalism, workers not only create sufficient value (i.e. produced
commodities) to maintain existing capital and their own existence, they also
produce a surplus. This surplus expresses itself as a surplus of goods and
services, i.e. an excess of commodities compared to the number a workers'
wages could buy back. The wealth of the capitalists, in other words, is due to
them _"accumulating the product of the labour of others."_ [Kropotkin, **Op.
Cit.** , p. 3] Thus Proudhon:

> _"The working man cannot . . . repurchase that which he has produced for his
> master. It is thus with all trades whatsoever. . . since, producing for a
> master who in one form or another makes a profit, they are obliged to pay
> more for their own labour than they get for it."_ [ **What is Property** ,
> p. 189]

In other words, the price of all produced goods is greater than the money
value represented by the workers' wages (plus raw materials and overheads such
as wear and tear on machinery) when those goods were produced. The labour
contained in these "surplus-products" is the source of profit, which has to be
realised on the market (in practice, of course, the value represented by these
surplus-products is distributed throughout all the commodities produced in the
form of profit -- the difference between the cost price and the market price).
In summary, surplus value is unpaid labour and hence capitalism is based on
exploitation. As Proudhon noted, _" **Products,** say economists, **are only
bought by products**. This maxim is property's condemnation. The proprietor
producing neither by his own labour nor by his implement, and receiving
products in exchange for nothing, is either a parasite or a thief."_ [ **Op.
Cit.** , p. 170]

It is this appropriation of wealth from the worker by the owner which
differentiates capitalism from the simple commodity production of artisan and
peasant economies. All anarchists agree with Bakunin when he stated that:

> _" **what is property, what is capital in their present form?** For the
> capitalist and the property owner they mean the power and the right,
> guaranteed by the State, to live without working . . . [and so] the power
> and right to live by exploiting the work of someone else . . . those . . .
> [who are] forced to sell their productive power to the lucky owners of
> both."_ [ **The Political Philosophy of Bakunin** , p. 180]

It is the nature of capitalism for the monopolisation of the worker's product
by others to exist. This is because of private property in the means of
production and so in _"consequence of [which] . . . [the] worker, when he is
able to work, finds no acre to till, no machine to set in motion, unless he
agrees to sell his labour for a sum inferior to its real value."_ [Peter
Kropotkin, **Anarchism** , p. 55]

Therefore workers have to sell their labour on the market. However, as this
"commodity" _"cannot be separated from the person of the worker like pieces of
property. The worker's capacities are developed over time and they form an
integral part of his self and self-identity; capacities are internally not
externally related to the person. Moreover, capacities or labour power cannot
be used without the worker using his will, his understanding and experience,
to put them into effect. The use of labour power requires the presence of its
'owner'. . . To contract for the use of labour power is a waste of resources
unless it can be used in the way in which the new owner requires . . . The
employment contract must, therefore, create a relationship of command and
obedience between employer and worker."_ So, _"the contract in which the
worker allegedly sells his labour power is a contract in which, since he
cannot be separated from his capacities, he sells command over the use of his
body and himself. . . The characteristics of this condition are captured in
the term **wage slave.** "_ [Carole Pateman, **The Sexual Contract** , pp.
150-1]

Or, to use Bakunin's words, _"the worker sells his person and his liberty for
a given time"_ and so _"concluded for a term only and reserving to the worker
the right to quit his employer, this contract constitutes a sort of
**voluntary** and **transitory** serfdom."_ [ **The Political Philosophy of
Bakunin** , p. 187] This domination is the source of the surplus, for _"wage
slavery is not a consequence of exploitation -- exploitation is a consequence
of the fact that the sale of labour power entails the worker's subordination.
The employment contract creates the capitalist as master; he has the political
right to determine how the labour of the worker will be used, and --
consequently -- can engage in exploitation."_ [Pateman, **Op. Cit.** , p. 149]

So profits exist because the worker sells themselves to the capitalist, who
then owns their activity and, therefore, controls them (or, more accurately,
**tries** to control them) like a machine. Benjamin Tucker's comments with
regard to the claim that capital is entitled to a reward are of use here. He
notes that some _"combat. . . the doctrine that surplus value -- oftener
called profits -- belong to the labourer because he creates it, by arguing
that the horse. . . is rightly entitled to the surplus value which he creates
for his owner. So he will be when he has the sense to claim and the power to
take it. . . Th[is] argument . . is based upon the assumption that certain men
are born owned by other men, just as horses are. Thus its **reductio ad
absurdum** turns upon itself."_ [ **Instead of a Book** , pp. 495-6] In other
words, to argue that capital should be rewarded is to implicitly assume that
workers are just like machinery, another "factor of production" rather than
human beings and the creator of things of value. So profits exists because
during the working day the capitalist controls the activity and output of the
worker (i.e. owns them during working hours as activity cannot be separated
from the body and _"[t]here is an integral relationship between the body and
self. The body and self are not identical, but selves are inseparable from
bodies."_ [Carole Pateman, **Op. Cit.** , p. 206]).

Considered purely in terms of output, this results in, as Proudhon noted,
workers working _"for an entrepreneur who pays them and keeps their
products."_ [quoted by Martin Buber, **Paths in Utopia** , p. 29] The ability
of capitalists to maintain this kind of monopolisation of another's time and
output is enshrined in _"property rights"_ enforced by either public or
private states. In short, therefore, property _"is the right to enjoy and
dispose at will of another's goods - the fruit of an other's industry and
labour."_ [P-J Proudhon, **What is Property** , p. 171] And because of this
"right," a worker's wage will always be less than the wealth that he or she
produces.

The surplus value produced by labour is divided between profits, interest and
rent (or, more correctly, between the owners of the various factors of
production other than labour). In practice, this surplus is used by the owners
of capital for: (a) investment (b) to pay themselves dividends on their stock,
if any; (c) to pay for rent and interest payments; and (d) to pay their
executives and managers (who are sometimes identical with the owners
themselves) much higher salaries than workers. As the surplus is being divided
between different groups of capitalists, this means that there can be clashes
of interest between (say) industrial capitalists and finance capitalists. For
example, a rise in interest rates can squeeze industrial capitalists by
directing more of the surplus from them into the hands of rentiers. Such a
rise could cause business failures and so a slump (indeed, rising interest
rates is a key way of regulating working class power by generating
unemployment to discipline workers by fear of the sack). The surplus, like the
labour used to reproduce existing capital, is embodied in the finished
commodity and is realised once it is sold. This means that workers do not
receive the full value of their labour, since the surplus appropriated by
owners for investment, etc. represents value added to commodities by workers
-- value for which they are not paid nor control.

The size of this surplus, the amount of unpaid labour, can be changed by
changing the duration and intensity of work (i.e. by making workers labour
longer and harder). If the duration of work is increased, the amount of
surplus value is increased absolutely. If the intensity is increased, e.g. by
innovation in the production process, then the amount of surplus value
increases relatively (i.e. workers produce the equivalent of their wage sooner
during their working day resulting in more unpaid labour for their boss).
Introducing new machinery, for example, increases surplus-value by reducing
the amount of work required per unit of output. In the words of economist
William Lazonick:

> _"As a general rule, all market prices, including wages, are given to the
> particular capitalist. Moreover, in a competitive world a particular
> capitalist cannot retain privileged access to process or product innovations
> for any appreciable period of time. But the capitalist does have privileged
> access to, and control over, the workers that he employs. Precisely because
> the work is not perfectly mobile but is dependent on the capitalist to gain
> a living, the capitalist is not subject to the dictates of market forces in
> dealing with the worker in the production process. The more dependent the
> worker is on his or her particular employer, the more power the capitalist
> has to demand longer and harder work in return for a day's pay. The
> resultant unremunerated increase in the productivity of the worker per unit
> of time is the source of surplus-value.  
>  _
>
> _"The measure of surplus-value is the difference between the value-added by
> and the value paid to the worker. As owner of the means of production, the
> industrial capitalist has a legal right to keep the surplus-value for
> himself."_ [ **Competitive Advantage on the Shop Floor** , p. 54]

Such surplus indicates that labour, like any other commodity, has a use value
and an exchange value. Labour's exchange value is a worker's wages, its use
value their ability to work, to do what the capitalist who buys it wants. Thus
the existence of "surplus products" indicates that there is a difference
between the exchange value of labour and its use value, that labour can
**potentially** create **more** value than it receives back in wages. We
stress potentially, because the extraction of use value from labour is not a
simple operation like the extraction of so many joules of energy from a ton of
coal. Labour power cannot be used without subjecting the labourer to the will
of the capitalist - unlike other commodities, labour power remains inseparably
embodied in human beings. Both the extraction of use value and the
determination of exchange value for labour depends upon - and are profoundly
modified by - the actions of workers. Neither the effort provided during an
hours work, nor the time spent in work, nor the wage received in exchange for
it, can be determined without taking into account the worker's resistance to
being turned into a commodity, into an order taker. In other words, the amount
of "surplus products" extracted from a worker is dependent upon the resistance
to dehumanisation within the workplace, to the attempts by workers to resist
the destruction of liberty during work hours.

Thus unpaid labour, the consequence of the authority relations explicit in
private property, is the source of profits. Part of this surplus is used to
enrich capitalists and another to increase capital, which in turn is used to
increase profits, in an endless cycle (a cycle, however, which is not a steady
increase but is subject to periodic disruption by recessions or depressions -
"The business cycle." The basic causes for such crises will be discussed
later, in sections [C.7](secC7.md) and [C.8](secC8.md)).

It should be noted that few economists deny that the "value added" by workers
in production must exceed the wages paid. It has to, if a profit is to be
made. As Adam Smith put it:

> _"As soon as stock has accumulated in the hands of particular persons, some
> of them will naturally employ it in setting to work industrious people, whom
> they will supply with materials and subsistence, in order to make a profit
> by the sale of their work, or by what their labour adds to the value of the
> materials . . . The value which the workmen add to the materials, therefore,
> resolves itself in this case into two parts, of which one pays their wages,
> the other the profits of their employer upon the whole stock of materials
> and wages which he advanced. He could have no interest to employ them,
> unless he expected from the sale of their work something more than what was
> sufficient to replace his stock to him."_ [ **The Wealth of Nations** , p.
> 42]

That surplus value consists of unpaid labour is a simple fact. The difference
is that non-socialist economists refuse to explain this in terms of
exploitation. Like Smith, David Ricardo argued in a similar manner and
justified surplus value appropriation in spite of this analysis. Faced with
the obvious interpretation of non-labour income as exploitation which could
easily be derived from classical economics, subsequent economists have sought
to obscure this fact and have produced a series of rationales to justify the
appropriation of workers labour by capitalists. In other words, to explain and
justify the fact that capitalism is not based on its own principle that labour
creates and justifies property. These rationales have developed over time,
usually in response to socialist and anarchist criticism of capitalism and its
economics (starting in response to the so-called Ricardian Socialists who
predated Proudhon and Marx and who first made such an analysis commonplace).
These have been based on many factors, such as the abstinence or waiting by
the capitalist, the productivity of capital, "time-preference,"
entrepreneurialism and so forth. We discuss most rationales and indicate their
weaknesses in subsequent sections.

## C.2.3 Is owning capital sufficient reason to justify profits?

No, it does not. To understand why, we must first explain the logic behind
this claim. It is rooted in what is termed "marginal productivity" theory. In
the words of one of its developers:

> _"If each productive function is paid for according to the amount of its
> product, then each man get what he himself produces. If he works, he gets
> what he creates by working; if he provides capital, he gets what his capital
> produces; and if, further, he renders service by co-ordinating labour and
> capital, he gets the product that can be separately traced to that function.
> Only in one of these ways can a man produce anything. If he receives all
> that he brings into existence through any one of these three functions, he
> receives all that he creates at all."_ [John Bates Clark, **The Distribution
> of Wealth** , p.7]

Needless to say, this analysis was based on the need to justify the existing
system, for it was _"the purpose of this work to show that the distribution of
income to society is controlled by a natural law, and that this law, if it
worked without friction, would give to every agent of production the amount of
wealth which that agent creates."_ In other words, _"what a social class gets
is, under natural law, what it contributes to the general output of
industry."_ [Clark, **Op. Cit.** , p. v and p. 313] And only mad people can
reject a _"natural law"_ like gravity -- or capitalism!

Most schools of capitalist economics, when they bother to try and justify non-
labour income, hold to this theory of productivity. Unsurprisingly, as it
proves what right-wing economist Milton Friedman called the _"capitalist
ethic"_ : _"To each according to what he and the instruments he owns
produces."_ [ **Capitalism and Freedom** , pp. 161-162] As such, this is one
of the key defences of capitalism, based as it is on the productive
contribution of each factor (labour, land and capital). Anarchists as
unconvinced.

Unsurprisingly, this theory took some time to develop given the theoretical
difficulties involved. After all, you need all three factors to produce a
commodity, say a bushel of wheat. How can we determine that percentage of the
price is due to the land, what percentage to labour and what percentage to
capital? You cannot simply say that the "contribution" of each factor just
happens to be identical to its cost (i.e. the contribution of land is what the
market rent is) as this is circular reasoning. So how is it possible to
specify contribution of each factor of production independently of the market
mechanism in such a way as to show, firstly, that the contributions add up to
100 percent and, secondly, that the free market will in fact return to each
factor its respective contribution?

This is where marginal productivity theory comes in. In neo-classical theory,
the contribution of a specific factor is defined as the marginal product of
that factor when the other factors are left constant. Take, as an example, a
hundred bushels of wheat produced by X acres of land being worked by Y workers
using £Z worth of capital. The contribution of land can then be defined as the
increase in wheat that an extra acre of land would produce (X+1) if the same
number of workers employed the same capital worked it. Similarly, the
contribution of a worker would be the increase that would result if an
addition worker was hired (Y + 1) to work the same land (X) with the same
capital (£Z). The contribution of capital, obviously, would be the increase in
wheat produced by the same number of workers (X) working the same amount of
land (Y) using one more unit of capital (£Z+1). Then mathematics kicks in. If
enough assumptions are made in terms of the substitutability of factors,
diminishing returns, and so forth, then a mathematical theorem (Euler's
Theorem) can be used to show that the sum of these marginal contributions
would be a hundred bushels. Applying yet more assumptions to ensure "perfect
competition" it can be mathematically proven that the rent per acre set by
this perfect market will be precisely the contribution of the land, that the
market wage will be the contribution of the worker, and the market interest
rate will be the contribution of capital. In addition, it can be shown that
any monopoly power will enable a factor owner to receive more than it
contributes, so exploiting the others.

While this is impressive, the problems are obvious. As we discuss in [section
C.2.5](secC2.md#secc25), this model does not (indeed, cannot) describe any
actual real economy. However, there is a more fundamental issue than mere
practicality or realism, namely that it confuses a **moral** principle (that
factors should receive in accordance with their productive contributions) with
an ownership issue. This is because even if we want to say that land and
capital "contribute" to the final product, we cannot say the same for the
landowner or the capitalist. Using our example above, it should be noted that
neither the capitalist nor the landowner actually engages in anything that
might be called a productive activity. Their roles are purely passive, they
simply allow what they own to be used by the people who do the actual work,
the labourers.

Marginal productivity theory shows that with declining marginal productivity,
the contribution of labour is less than the total product. The difference is
claimed to be precisely the contribution of capital and land. But what is this
"contribution" of capital and land? Without any labourers there would be no
output. In addition, in physical terms, the marginal product of, say, capital
is simply the amount by which production would decline is one piece of capital
were taken out of production. It does not reflect any productive activity
whatsoever on the part of the owner of said capital. **It does not, therefore,
measure his or her productive contribution.** In other words, capitalist
economics tries to confuse the owners of capital with the machinery they own.
Unlike labour, whose "ownership" cannot be separated from the productive
activities being done, capital and land can be rewarded without their owners
actually doing anything productive at all.

For all its amazing mathematics, the neo-classical solution fails simply
because it is not only irrelevant to reality, it is not relevant ethically.

To see why, let us consider the case of land and labour (capital is more
complex and will be discussed in the next two sections). Marginal productivity
theory can show, given enough assumptions, that five acres of land can produce
100 bushels of wheat with the labour of ten men and that the contribution of
land and labour are, respectively, 40 and 60 bushels each. In other words,
that each worker receives a wage representing 6 bushels of wheat while the
landlord receives an income of 40 bushels. As socialist David Schweickart
notes, _"we have derived both the contribution of labour and the contribution
of land from purely technical considerations. We have made no assumptions
about ownership, competition, or any other social or political relationship.
No covert assumptions about capitalism have been smuggled into the analysis."_
[ **After Capitalism** , p. 29]

Surely this means that economics has produced a defence of non-labour income?
Not so, as it ignores the key issue of what represents a valid contribution.
The conclusion that the landlord (or capitalist) is entitled to their income
_"in no way follows from the technical premises of the argument. Suppose our
ten workers had cultivated the five acres **as a worker collective.** In this,
they would receive the entire product, all one hundred bushels, instead of
sixty. Is this unfair? To whom should the other forty bushels go? To the land,
for its 'contribution'? Should the collective perhaps burn forty bushels as an
offering to the Land-God? (Is the Land-Lord the representative on Earth of
this Land-God?)."_ [ **Op. Cit.** , p. 30] It should be noted that Schweickart
is echoing the words of Proudhon:

> _"How much does the proprietor increase the utility of his tenant's
> products? Has he ploughed, sowed, reaped, mowed, winnowed, weeded? . . . I
> admit that the land is an implement; but who made it? Did the proprietor?
> Did he -- by the efficacious virtue of the right of property, by this
> **moral quality** infused into the soil -- endow it with vigour and
> fertility? Exactly there lies the monopoly of the proprietor, though he did
> not make the implement, he asks pay for its use. When the Creator shall
> present himself and claim farm-rent, we will consider the matter with him;
> or even when the proprietor -- his pretended representative -- shall exhibit
> his power of attorney."_ [ **What is Property?** , pp. 166-7]

In other words, granting permission cannot be considered as a "contribution"
or a "productive" act:

> _"We can see that a moral sleight-of-hand has been performed. A technical
> demonstration has passed itself off as a moral argument by its choice of
> terminology, namely, by calling a marginal product a 'contribution.' The
> 'contribution = ethical entitlement' of the landowner has been identified
> with the 'contribution = marginal product' of the land . . . What is the
> nature of the landowner's 'contribution' here? We can say that the landlord
> **contributed the land** to the workers, but notice the qualitative
> difference between his 'contribution' and the contribution of his workforce.
> He 'contributes' his land -- but the land remains intact and remains his at
> the end of the harvest, whereas the labour contributed by each labourer is
> gone. If the labourers do not expend **more** labour next harvest, they will
> get nothing more, whereas the landowner can continue to 'contribute' year
> after year (lifting not a finger), and be rewarded year after year for doing
> so."_ [Schweickart, **Op. Cit.** , p. 30]

As the examples of the capitalist and co-operative farms shows, the
"contribution" of land and capital can be rewarded without their owners doing
anything at all. So what does it mean, "capital's share"? After all, no one
has ever given money to a machine or land. That money goes to the owner, not
the technology or resource used. When "land" gets its "reward" it involves
money going to the landowner **not** fertiliser being spread on the land.
Equally, if the land and the capital were owned by the labourers then
"capital" and "land" would receive nothing despite both being used in the
productive process and, consequently, having "aided" production. Which shows
the fallacy of the idea that profits, interest and rent represent a form of
"contribution" to the productive process by land and capital which needs
rewarded. They only get a "reward" when they hire labour to work them, i.e.
they give permission for others to use the property in question in return for
telling them what to do and keeping the product of their labour.

As Proudhon put it, _"[w]ho is entitled to the rent of the land? The producer
of the land, without doubt. Who made the land? God. Then, proprietor,
retire!"_ [ **Op. Cit.** , p. 104] Much the same can be said of "capital"
(workplaces, machinery, etc.) as well. The capitalist, argued Berkman, _"gives
you a job; that is permission to work in the factory or mill which was not
built by him but by other workers like yourself. And for that permission you
help to support him for the rest of your life or as long as you work for
him."_ [ **What is Anarchism?** , p. 14]

So non-labour income exists **not** because of the owners of capital and land
"contribute" to production but because they, as a class, **own** the means of
life and workers have to sell their labour and liberty to them to gain access:

> _"We cry shame on the feudal baron who forbade the peasant to turn a clod of
> earth unless he surrendered to his lord a fourth of his crop. We called
> those the barbarous times, But if the forms have changed, the relations have
> remained the same, and the worker is forced, under the name of free
> contract, to accept feudal obligations."_ [Kropotkin, **The Conquest of
> Bread** , pp. 31-2]

It is capitalist property relations that allow this monopolisation of wealth
by those who own (or boss) but do not produce. The workers do not get the full
value of what they produce, nor do they have a say in how the surplus value
produced by their labour gets used (e.g. investment decisions). Others have
monopolised both the wealth produced by workers and the decision-making power
within the company. This is a private form of taxation without representation,
just as the company is a private form of statism.

Therefore, providing capital is **not** a productive act, and keeping the
profits that are produced by those who actually do use capital is an act of
theft. This does not mean, of course, that creating capital goods is not
creative nor that it does not aid production. Far from it! But owning the
outcome of such activity and renting it does not justify capitalism or
profits. In other words, while we need machinery, workplaces, houses and raw
materials to produce goods we do **not** need landlords and capitalists.

The problem with the capitalists' "contribution to production" argument is
that one must either assume (a) a strict definition of who is the producer of
something, in which case one must credit only the worker(s), or (b) a looser
definition based on which individuals have contributed to the circumstances
that made the productive work possible. Since the worker's productivity was
made possible in part by the use of property supplied by the capitalist, one
can thus credit the capitalist with "contributing to production" and so claim
that he or she is entitled to a reward, i.e. profit.

However, if one assumes (b), one must then explain why the chain of credit
should stop with the capitalist. Since all human activity takes place within a
complex social network, many factors might be cited as contributing to the
circumstances that allowed workers to produce -- e.g. their upbringing and
education, the contribution of other workers in providing essential products,
services and infrastructure that permits their place of employment to operate,
and so on (even the government, which funds infrastructure and education).
Certainly the property of the capitalist contributed in this sense. But his
contribution was less important than the work of, say, the worker's mother.
Yet no capitalist, so far as we know, has proposed compensating workers'
mothers with any share of the firm's revenues, and particularly not with a
**greater** share than that received by capitalists! Plainly, however, if they
followed their own logic consistently, capitalists would have to agree that
such compensation would be fair.

In summary, while some may consider that profit is the capitalist's
"contribution" to the value of a commodity, the reality is that it is nothing
more than the reward for owning capital and giving permission for **others**
to produce using it. As David Schweickart puts it, _"'providing capital' means
nothing more than 'allowing it to be used.' But an act of granting permission,
in and of itself, is not a productive activity. If labourers cease to labour,
production ceases in any society. But if owners cease to grant permission,
production is affected only if their **authority** over the means of
production is respected."_ [ **Against Capitalism** , p. 11]

This authority, as discussed earlier, derives from the coercive mechanisms of
the state, whose primary purpose is to ensure that capitalists have this
ability to grant or deny workers access to the means of production. Therefore,
not only is "providing capital" not a productive activity, it depends on a
system of organised coercion which requires the appropriation of a
considerable portion of the value produced by labour, through taxes, and hence
is actually parasitic. Needless to say, rent can also be considered as
"profit", being based purely on "granting permission" and so not a productive
activity. The same can be said of interest, although the arguments are
somewhat different (see [section C.2.6](secC2.md#secc26)).

So, even if we assume that capital and land **are** productive, it does not
follow that owning those resources entitles the owner to an income. However,
this analysis is giving too much credit to capitalist ideology. The simple
fact is that capital is **not** productive at all. Rather, _"capital"_ only
contributes to production when used by labour (land does produce use values,
of course, but these only become available once labour is used to pick the
fruit, reap the corn or dig the coal). As such, profit is not the reward for
the productivity of capital. Rather **labour** produces the marginal
productivity of capital. This is discussed in the [next
section](secC2.md#secc24).

## C.2.4 Is profit the reward for the productivity of capital?

In a word, no. As Proudhon pointed out, _"Capital, tools, and machinery are
likewise unproductive. . . The proprietor who asks to be rewarded for the use
of a tool or for the productive power of his land, takes for granted, then,
that which is radically false; namely, that capital produces by its own effort
-- and, in taking pay for this imaginary product, he literally receives
something for nothing."_ [ **What is Property?** , p. 169] In other words,
only labour is productive and profit is not the reward for the productivity of
capital.

Needless to say, capitalist economists disagree. _"Here again the philosophy
of the economists is wanting. To defend usury they have pretended that capital
was productive, and they have changed a metaphor into a reality,"_ argued
Proudhon. The socialists had _"no difficulty in overturning their sophistry;
and through this controversy the theory of capital has fallen into such
disfavour that today, in the minds of the people, **capitalist** and **idler**
are synonymous terms."_ [ **System of Economical Contradictions** , p. 290]

Sadly, since Proudhon's time, the metaphor has become regained its hold,
thanks in part to neo-classical economics and the "marginal productivity"
theory. We explained this theory in the [last section](secC2.md#secc23) as
part of our discussion on why, even if we assume that land and capital **are**
productive this does not, in itself, justify capitalist profit. Rather,
profits accrue to the capitalist simply because he or she gave their
permission for others to use their property. However, the notion that profits
represent that "productivity" of capital is deeply flawed for other reasons.
The key one is that, by themselves, capital and land produce nothing. As
Bakunin put it, _"neither property nor capital produces anything when not
fertilised by labour."_ [ **The Political Philosophy of Bakunin** , p. 183]

In other words, capital is "productive" simply because people use it. This is
hardly a surprising conclusion. Mainstream economics recognises it in its own
way (the standard economic terminology for this is that _"factors usually do
not work alone"_ ). Needless to say, the conclusions anarchists and defenders
of capitalism draw from this obvious fact are radically different.

The standard defence of class inequalities under capitalism is that people get
rich by producing what other people want. That, however, is hardly ever true.
Under capitalism, people get rich by hiring other people to produce what other
people want or by providing land, money or machinery to those who do the
hiring. The number of people who have became rich purely by their own labour,
without employing others, is tiny. When pressed, defenders of capitalism will
admit the basic point and argue that, in a free market, everyone gets in
income what their contribution in producing these goods indicates. Each factor
of production (land, capital and labour) is treated in the same way and their
marginal productivity indicates what their contribution to a finished product
is and so their income. Thus wages represent the marginal productivity of
labour, profit the marginal productivity of capital and rent the marginal
productivity of land. As we have used land and labour in the [previous
section](secC2.md#secc23), we will concentrate on land and "capital" here.
We must note, however, that marginal productivity theory has immense
difficulties with capital and has been proven to be internally incoherent on
this matter (see [next section](secC2.md#secc25)). However, as mainstream
economics ignores this, so will we for the time being.

So what of the argument that profits represent the contribution of capital?
The reason why anarchists are not impressed becomes clear when we consider ten
men digging a hole with spades. Holding labour constant means that we add
spades to the mix. Each new spade increases productivity by the same amount
(because we assume that labour is homogenous) until we reach the eleventh
spade. At that point, the extra spade lies unused and so the marginal
contribution of the spade ("capital") is zero. This suggests that the
socialists are correct, capital **is** unproductive and, consequently, does
not deserve any reward for its use.

Of course, it will be pointed out that the eleventh spade cost money and, as a
result, the capitalist would have stopped at ten spades and the marginal
contribution of capital equals the amount the tenth spade added. Yet the only
reason that spade added anything to production was because there was a worker
to use it. In other words, as economist David Ellerman stresses, the _"point
is that capital itself does not 'produce' at all; capital is used by Labour to
produce the outputs . . . Labour produces the marginal product **of capital.**
"_ [ **Property and Contract in Economics** , p. 204] As such, to talk of the
"marginal product" of capital is meaningless as holding labour constant is
meaningless:

> _"Consider, for example, the 'marginal product of a shovel' in a simple
> production process wherein three workers use two shovels and a wheelbarrow
> to dig out a cellar. Two of the workers use two shovels to fill the
> wheelbarrow which the third worker pushes a certain distance to dump the
> dirt. The marginal productivity of a shovel is defined as the extra product
> produced when an extra shovel is added and the other factors, such as
> labour, are held constant. The labour is the human activity of carrying out
> this production process. If labour was held 'constant' is the sense of
> carrying out the same human activity, then any third shovel would just lie
> unused and the extra product would be identically zero.  
>  _
>
> _"'Holding labour constant' really means reorganising the human activity in
> a more capital intensive way so that the extra shovel will be optimally
> utilised. For instance, all three workers could use the three shovels to
> fill the wheelbarrow and then they could take turns emptying the
> wheelbarrow. In this manner, the workers would use the extra shovel and by
> so doing they would produce some extra product (additional earth moved
> during the same time period). This extra product would be called the
> 'marginal product of the shovel, but in fact it is produced by the workers
> who are also using the additional shovel . . . [Capital] does not 'produce'
> its marginal product. Capital does not 'produce' at all. Capital is used by
> Labour to produce the output. When capital is increased, Labour produces
> extra output by using up the extra capital . . . In short, **Labour produced
> the marginal product of capital** (and used up the extra capital
> services)."_ [ **Op. Cit.** , pp. 207-9]

Therefore, the idea that profits equals the marginal productivity of capital
is hard to believe. Capital, in this perspective, is not only a tree which
bears fruit even if its owner leaves it uncultivated, it is a tree which also
picks its own fruit, prepares it and serves it for dinner! Little wonder the
classical economists (Smith, Ricardo, John Stuart Mill) considered capital to
be unproductive and explained profits and interest in other, less obviously
false, means.

Perhaps the "marginal productivity" of capital is simply what is left over
once workers have been paid their "share" of production, i.e. once the
marginal productivity of labour has been rewarded. Obviously the marginal
product of labour and capital are related. In a production process, the
contribution of capital will (by definition) be equal to total price minus the
contribution of labour. You define the marginal product of labour, it is
necessary to keep something else constant. This means either the physical
inputs other than labour are kept constant, or the rate of profit on capital
is kept constant. As economist Joan Robinson noted:

> _"I found this satisfactory, for it destroys the doctrine that wages are
> regulated by marginal productivity. In a short-period case, where equipment
> is given, at full-capacity operation the marginal physical product of labour
> is indeterminate. When nine men with nine spades are digging a hole, to add
> a tenth man could increase output only to the extent that nine dig better if
> they have a rest from time to time. On the other hand, to subtract the ninth
> man would reduce output by more or less the average amount. The wage must
> lie somewhere between the average value of output per head and zero, so that
> marginal product is greater or much less than the wage according as
> equipment is being worked below or above its designed capacity."_ [
> **Contributions to Modern Economics** , p. 104]

If wages are not regulated by marginal productivity theory, then neither is
capital (or land). Subtracting labour while keeping capital constant simply
results in unused equipment and unused equipment, by definition, produces
nothing. What the "contribution" of capital is dependent, therefore, on the
economic power the owning class has in a given market situation (as we discuss
in [section C.3](secC3.md)). As William Lazonick notes, the neo-classical
theory of marginal productivity has two key problems which flow from its
flawed metaphor that capital is "productive":

> _"The first flaw is the assumption that, at any point in time, the
> productivity of a technology is given to the firm, irrespective of the
> social context in which the firm attempts to utilise the technology . . .
> this assumption, typically implicit in mainstream economic analysis and [is]
> derived from an ignorance of the nature of the production process as much as
> everything else . . ."  
>  _
>
> _"The second flaw in the neo-classical theoretical structure is the
> assumption that factor prices are independent of factor productivities. On
> the basis of this assumption, factor productivities arising from different
> combinations of capital and labour can be taken as given to the firm; hence
> the choice of technique depends only on variations in relative factor
> prices. It is, however, increasingly recognised by economists who speak of
> 'efficiency wages' that factor prices and factor productivities may be
> linked, particularly for labour inputs . . . the productivity of a
> technology depends on the amount of effort that workers choose to supply."_
> [ **Competitive Advantage on the Shop Floor** , p. 130 and pp. 133-4]

In other words, neo-classical economics forgets that technology has to be used
by workers and so its "productivity" depends on how it is applied. If profit
did flow as a result of some property of machinery then bosses could do
without autocratic workplace management to ensure profits. They would have no
need to supervise workers to ensure that adequate amounts of work are done in
excess of what they pay in wages. This means the idea (so beloved by pro-
capitalist economics) that a worker's wage **is** the equivalent of what she
produces is one violated everyday within reality:

> _"Managers of a capitalist enterprise are not content simply to respond to
> the dictates of the market by equating the wage to the value of the marginal
> product of labour. Once the worker has entered the production process, the
> forces of the market have, for a time at least, been superseded. The effort-
> pay relation will depend not only on market relations of exchange but also.
> . . on the hierarchical relations of production -- on the relative power of
> managers and workers within the enterprise."_ [William Lazonick, **Business
> Organisation and the Myth of the Market Economy** , pp. 184-5]

But, then again, capitalist economics is more concerned with justifying the
status quo than being in touch with the real world. To claim that a workers
wage represents her contribution and profit capital's is simply false. Capital
cannot produce anything (never mind a surplus) unless used by labour and so
profits do not represent the productivity of capital. In and of themselves,
fixed costs do not create value. Whether value is created depends on how
investments are developed and used once in place. Which brings us back to
labour (and the social relationships which exist within an economy) as the
fundamental source of surplus value.

Then there is the concept of profit sharing, whereby workers are get a share
of the profits made by the company. Yet profits are the return to capital.
This shatters the notion that profits represent the contribution of capital.
**If** profits were the contribution of the productivity of equipment, then
sharing profits would mean that capital was not receiving its full
_"contribution"_ to production (and so was being exploited by labour!). It is
unlikely that bosses would implement such a scheme unless they knew they would
get more profits out of it. As such, profit sharing is usually used as a
technique to **increase** productivity and profits. Yet in neo-classical
economics, it seems strange that such a technique would be required if
profits, in fact, **did** represent capital's "contribution." After all, the
machinery which the workers are using is the same as before profit sharing was
introduced -- how could this unchanged capital stock produce an increased
"contribution"? It could only do so if, in fact, capital was unproductive and
it was the unpaid efforts, skills and energy of workers' that actually was the
source of profits. Thus the claim that profit equals capital's "contribution"
has little basis in fact.

As capital is not autonomously productive and goods are the product of human
(mental and physical) labour, Proudhon was right to argue that _"Capital,
tools, and machinery are likewise unproductive . . . The proprietor who asks
to be rewarded for the use of a tool or for the productive power of his land,
takes for granted, then, that which is radically false; namely, that capital
produces by its own effort - and, in taking pay for this imaginary product, he
literally receives something for nothing."_ [ **What is Property?** , p. 169]

It will be objected that while capital is not productive in itself, its use
does make labour more productive. As such, surely its owner is entitled to
some share of the larger output produced by its aid. Surely this means that
the owners of capital deserve a reward? Is this difference not the
"contribution" of capital? Anarchists are not convinced. Ultimately, this
argument boils down to the notion that giving permission to use something is a
productive act, a perspective we rejected in the [last
section](secC2.md#secc23). In addition, providing capital is unlike normal
commodity production. This is because capitalists, unlike workers, get paid
multiple times for one piece of work (which, in all likelihood, they paid
others to do) and **keep** the result of that labour. As Proudhon argued:

> _"He [the worker] who manufactures or repairs the farmer's tools receives
> the price **once** , either at the time of delivery, or in several payments;
> and when this price is once paid to the manufacturer, the tools which he has
> delivered belong to him no more. Never can he claim double payment for the
> same tool, or the same job of repairs. If he annually shares in the products
> of the farmer, it is owing to the fact that he annually does something for
> the farmer.  
>  _
>
> _"The proprietor, on the contrary, does not yield his implement; eternally
> he is paid for it, eternally he keeps it."_ [ **Op. Cit.** , pp. 169-170]

While the capitalist, in general, gets their investment back plus something
extra, the workers can never get their time back. That time has gone, forever,
in return for a wage which allows them to survive in order to sell their time
and labour (i.e. liberty) again. Meanwhile, the masters have accumulated more
capital and their the social and economic power and, consequently, their
ability to extract surplus value goes up at a higher rate than the wages they
have to pay (as we discuss in [section C.7](secC7.md), this process is not
without problems and regularly causes economic crisis to break out).

Without labour nothing would have been produced and so, in terms of justice,
**at best** it could be claimed that the owners of capital deserve to be paid
only for what has been used of their capital (i.e. wear and tear and damages).
While it is true that the value invested in fixed capital is in the course of
time transferred to the commodities produced by it and through their sale
transformed into money, this does not represent any actual labour by the
owners of capital. Anarchists reject the ideological sleight-of-hand that
suggests otherwise and recognise that (mental and physical) labour is the
**only** form of contribution that can be made by humans to a productive
process. Without labour, nothing can be produced nor the value contained in
fixed capital transferred to goods. As Charles A. Dana pointed out in his
popular introduction to Proudhon's ideas, _"[t]he labourer without capital
would soon supply his wants by its production . . . but capital with no
labourers to consume it can only lie useless and rot."_ [ **Proudhon and his
"Bank of the People"** , p. 31] If workers do not control the full value of
their contributions to the output they produce then they are exploited and so,
as indicated, capitalism is based upon exploitation.

Of course, as long as "capital" **is** owned by a different class than as
those who use it, this is extremely unlikely that the owners of capital will
simply accept a "reward" of damages. This is due to the hierarchical
organisation of production of capitalism. In the words of the early English
socialist Thomas Hodgskin _"capital does not derive its utility from previous,
but present labour; and does not bring its owner a profit because it has been
stored up, but because it is a means of obtaining a command over labour."_ [
**Labour Defended against the Claims of Capital** ] It is more than a strange
coincidence that the people with power in a company, when working out who
contributes most to a product, decide it is themselves!

This means that the notion that labour gets its "share" of the products
created is radically false for, as _"a description of **property rights** ,
the distributive shares picture is quite misleading and false. The simple fact
is that one legal party owns all the product. For example, General Motors
doesn't just own 'Capital's share' of the GM cars produced; it owns all of
them."_ [Ellerman, **Op. Cit.** , p. 27] Or as Proudhon put it, _"Property is
the right to enjoy and dispose of another's goods, -- the fruit of another's
industry and labour."_ The only way to finally abolish exploitation is for
workers to manage their own work and the machinery and tools they use. This is
implied, of course, in the argument that labour is the source of property for
_"if labour is the sole basis of property, I cease to be a proprietor of my
field as soon as I receive rent for it from another . . . It is the same with
all capital."_ Thus, _"all production being necessarily collective"_ and _"all
accumulated capital being social property, no one can be its exclusive
proprietor."_ [ **What is Property?** , p. 171, p. 133 and p. 130]

The reason why capital gets a "reward" is simply due to the current system
which gives capitalist class an advantage which allows them to refuse access
to their property except under the condition that they command the workers to
make more than they have to pay in wages and keep their capital at the end of
the production process to be used afresh the next. So while capital is not
productive and owning capital is not a productive act, under capitalism it is
an enriching one and will continue to be so until such time as that system is
abolished. In other words, profits, interest and rent are not founded upon any
permanent principle of economic or social life but arise from a specific
social system which produce specific social relationships. Abolish wage labour
by co-operatives, for example, and the issue of the "productivity" of
"capital" disappears as "capital" no longer exists (a machine is a machine, it
only becomes capital when it is used by wage labour).

So rather that the demand for labour being determined by the technical
considerations of production, it is determined by the need of the capitalist
to make a profit. This is something the neo-classical theory implicitly
admits, as the marginal productivity of labour is just a roundabout way of
saying that labour-power will be bought as long as the wage is not higher than
the profits that the workers produce. In other words, wages do not rise above
the level at which the capitalist will be able to produce and realise surplus-
value. To state that workers will be hired as long as the marginal
productivity of their labour exceeds the wage is another way of saying that
workers are exploited by their boss. So even if we do ignore reality for the
moment, this defence of profits does **not** prove what it seeks to -- it
shows that labour **is** exploited under capitalism.

However, as we discuss in the [next section](secC5.md), this whole
discussion is somewhat beside the point. This is because marginal productivity
theory has been conclusively proven to be flawed by dissident economics and
has been acknowledged as such by leading neo-classical economists.

## C.2.5 Do profits represent the contribution of capital to production?

In a word, no. While we have assumed the validity of "marginal productivity"
theory in relation to capital in the previous two sections, the fact is that
the theory is deeply flawed. This is on two levels. Firstly, it does not
reflect reality in any way. Secondly, it is logically flawed and, even worse,
this has been known to economists for decades. While the first objection will
hardly bother most neo-classical economists (what part of that dogma **does**
reflect reality?), the second should as intellectual coherence is what
replaces reality in economics. However, in spite of "marginal productivity"
theory being proven to be nonsense and admitted as such by leading neo-
classical economists, it is still taught in economic classes and discussed in
text books as if it were valid.

We will discuss each issue in turn.

The theory is based on a high level of abstraction and the assumptions used to
allow the mathematics to work are so extreme that no real world example could
possibly meet them. The first problem is determining the level at which the
theory should be applied. Does it apply to individuals, groups, industries or
the whole economy? For depending on the level at which it is applied, there
are different problems associated with it and different conclusions to be
drawn from it. Similarly, the time period over which it is to be applied has
an impact. As such, the theory is so vague that it would be impossible to test
as its supporters would simply deny the results as being inapplicable to
**their** particular version of the model.

Then there are problems with the model itself. While it has to assume that
factors are identical in order to invoke the necessary mathematical theory,
none of the factors used are homogenous in the real world. Similarly, for
Euler's theory to be applied, there must be constant returns to scale and this
does not apply either (it would be fair to say that the assumption of constant
returns to scale was postulated to allow the theorem to be invoked in the
first place rather than as a result of a scientific analysis of real
industrial conditions). Also, the model assumes an ideal market which cannot
be realised and any real world imperfections make it redundant. In the model,
such features of the real world as oligopolistic markets (i.e. markets
dominated by a few firms), disequilibrium states, market power, informational
imperfections of markets, and so forth do not exist. Including any of these
real features invalidates the model and no "factor" gets its just rewards.

Moreover, like neo-classical economics in general, this theory just assumes
the original distribution of ownership. As such, it is a boon for those who
have benefited from previous acts of coercion -- their ill-gotten gains can
now be used to generate income for them!

Finally, "marginal productivity" theory ignores the fact that most production
is collective in nature and, as a consequence, the idea of subtracting a
single worker makes little or no sense. As soon as there is _"a division of
labour and an interdependence of different jobs, as is the case generally in
modern industry,"_ its _"absurdity can immediately be shown."_ For example,
_"[i]f, in a coal-fired locomotive, the train's engineer is eliminated, one
does not 'reduce a little' of the product (transportation), one eliminates it
completely; and the same is true if one eliminates the fireman. The 'product'
of this indivisible team of engineer and fireman obeys a law of all or
nothing, and there is no 'marginal product' of the one that can be separated
from the other. The same thing goes on the shop floor, and ultimately for the
modern factory as a whole, where jobs are closely interdependent."_ [Cornelius
Castoriadis, **Political and Social Writings** , vol. 3, p. 213] Kropotkin
made the same point, arguing it _"is utterly impossible to draw a distinction
between the work"_ of the individuals collectively producing a product as all
_"contribute . . . in proportion to their strength, their energy, their
knowledge, their intelligence, and their skill."_ [ **The Conquest of Bread**
, p. 170 and p. 169]

This suggests another explanation for the existence of profits than the
"marginal productivity" of capital. Let us assume, as argued in marginal
productivity theory, that a worker receives exactly what she has produced
because if she ceases to work, the total product will decline by precisely the
value of her wage. However, this argument has a flaw in it. This is because
the total product will decline by more than that value if two or more workers
leave. This is because the wage each worker receives under conditions of
perfect competition is assumed to be the product of the **last** labourer in
neo-classical theory. The neo-classical argument presumes a "declining
marginal productivity," i.e. the marginal product of the last worker is
assumed to be less than the second last and so on. In other words, in neo-
classical economics, all workers bar the mythical "last worker" do not receive
the full product of their labour. They only receive what the **last** worker
is claimed to produce and so everyone **bar** the last worker does not receive
exactly what he or she produces. In other words, all the workers are exploited
bar the last one.

However, this argument forgets that co-operation leads to increased
productivity which the capitalists appropriate for themselves. This is
because, as Proudhon argued, _"the capitalist has paid as many times one day's
wages"_ rather than the workers collectively and, as such, _"he has paid
nothing for that immense power which results from the union and harmony of
labourers, and the convergence and simultaneousness of their efforts. Two
hundred grenadiers stood the obelisk of Luxor upon its base in a few hours; do
you suppose that one man could have accomplished the same task in two hundred
days? Nevertheless, on the books of the capitalist, the amount of wages would
have been the same."_ Therefore, the capitalist has _"paid all the individual
forces"_ but _"the collective force still remains to be paid. Consequently,
there remains a right of collective property"_ which the capitalist _"enjoy[s]
unjustly."_ [ **What is Property?** , p. 127 and p. 130]

As usual, therefore, we must distinguish between the ideology and reality of
capitalism. As we indicated in [section C.1](secC1.md), the model of perfect
competition has no relationship with the real world. Unsurprisingly, marginal
productivity theory is likewise unrelated to reality. This means that the
assumptions required to make "marginal productivity" theory work are so unreal
that these, in themselves, should have made any genuine scientist reject the
idea out of hand. Note, we are **not** opposing abstract theory, **every**
theory abstracts from reality is some way. We are arguing that, to be valid, a
theory has to reflect the real situation it is seeking to explain in some
meaningful way. Any abstractions or assumptions used must be relatively
trivial and, when relaxed, not result in the theory collapsing. This is not
the case with marginal productivity theory. It is important to recognise that
there are degrees of abstraction. There are _"negligibility assumptions"_
which state that some aspect of reality has little or no effect on what is
being analysed. Sadly for marginal productivity theory, its assumptions are
not of this kind. Rather, they are _"domain assumptions"_ which specify _"the
conditions under which a particular theory will apply. If those conditions do
not apply, then neither does the theory."_ [Steve Keen, **Debunking
Economics** , p. 151] This is the case here.

However, most economists will happily ignore this critique for, as noted
repeatedly, basing economic theory on reality or realistic models is not
considered a major concern by neoclassical economists. However, "marginal
productivity" theory applied to capital is riddled with logical
inconsistencies which show that it is simply wrong. In the words of the noted
left-wing economist Joan Robinson:

> _"The neo-classicals evidently had not been told that the neo-classical
> theory did not contain a solution of the problems of profits or of the value
> of capital. They have erected a towering structure of mathematical theorems
> on a foundation that does not exist. Recently [in the 1960s, leading neo-
> classical economist] Paul Samuelson was sufficiently candid to admit that
> the basis of his system does not hold, but the theorems go on pouring out
> just the same."_ [ **Contributions to Modern Economics** , p. 186]

If profits **are** the result of private property and the inequality it
produces, then it is unsurprising that neoclassical theory would be as
foundationless as Robinson argues. After all, this is a **political** question
and neo-classical economics was developed to ignore such questions. Marginal
productivity theory has been subject to intense controversy, precisely because
it claims to show that labour is not exploited under capitalism (i.e. that
each factor gets what it contributes to production). We will now summarise
this successful criticism.

The first major theoretical problem is obvious: how do you measure capital? In
neoclassical economics, capital is referred to as machinery of all sorts as
well as the workplaces that house them. Each of these items is, in turn, made
up of a multitude of other commodities and many of these are assemblies of
other commodities. So what does it mean to say, as in marginal productivity
theory, that "capital" is varied by one unit? The only thing these products
have in common is a price and that is precisely what economists **do** use to
aggregate capital. Sadly, though, shows _"that there is no meaning to be given
to a 'quantity of capital' apart from the rate of profit, so that the
contention that the 'marginal product of capital' determines the rate of
profit is meaningless."_ [Robinson, **Op. Cit.** , p. 103] This is because
argument is based on circular reasoning:

> _"For long-period problems we have to consider the meaning of the rate of
> profit on capital . . . the value of capital equipment, reckoned as its
> future earnings discounted at a rate of interest equal to the rate of
> profit, is equal to its initial cost, which involves prices including profit
> at the same rate on the value of the capital involved in producing it,
> allowing for depreciation at the appropriate rate over its life up to date.  
>  _
>
> _"The value of a stock of capital equipment, therefore, involves the rate of
> profit. There is no meaning in a 'quantity of capital' apart from the rate
> of profit."_ [ **Collected Economic Papers** , vol. 4, p. 125]

Looking at it another way, neo-classical economics seeks to simultaneously
solve the problems of production and income distribution. It attempts to show
how the level of employment of capital and labour is determined as well as how
national income is divided between the two. The latter is done by multiplying
the quantities of labour and capital by the equilibrium wage and interest
rate, respectively. In the long term, equilibrium conditions are governed by
the net marginal productivity of each factor, with each supplied until its net
marginal revenue is zero. This is why the market rate of interest is used as
capital is assumed to have marginal productivity and the existing market
interest reflects that.

Yet in what sense can we say that capital has marginal productivity? How is
the stock of capital to be measured? One measure is to take the present value
of the income stream expected to accrue to capital owners. However, where does
this discount rate and net income stream come from? To find a value for these,
it is necessary to estimate a national income and the division of income
between labour and capital but that is what the analysis was meant to produce.
In other words, the neo-classical theory requires assumptions which are, in
fact, the solution. This means that value of capital is dependent on the
distribution of income. As there is no rationale offered for choosing one
income distribution over another, the neo-classical theory does not solve the
problem it set out to investigate but rather simply assumes it away. It is a
tautology. It asks how the rate of profit is determined and answers by
referencing the quantity of capital and its marginal revenue product. When
asked how these are determined, the reply is based on assuming a division of
future income and the discounting of the returns of capital with the market
rate of interest. That is, it simply says that the market rate of interest is
a function of the market rate of interest (and an assumed distribution of
income).

In other words, according to neoclassical theory, the rate of profit and
interest depends on the amount of capital, and the amount of capital depends
on the rate of profit and interest. One has to assume a rate of profit in
order to demonstrate the equilibrium rate of return is determined. This issue
is avoided in neo-classical economics simply by ignoring it (it must be noted
that the same can be said of the "Austrian" concept of _"roundaboutness"_ as
_"it is impossible to define one way of producing a commodity as 'more
roundabout' than another independently of the rate of profit . . . Therefore
the Austrian notion of roundaboutness is as internally inconsistent as the
neoclassical concept of the marginal productivity of capital."_ [Steve Keen,
**Debunking Economics** , p. 302]).

The next problem with the theory is that "capital" is treated as something
utterly unreal. Take, for example, leading neoclassical Dennis Robertson's
1931 attempt to explain the marginal productivity of labour when holding
"capital" constant:

> _"If ten men are to be set out to dig a hole instead of nine, they will be
> furnished with ten cheaper spades instead of nine more expensive ones; or
> perhaps if there is no room for him to dig comfortably, the tenth man will
> be furnished with a bucket and sent to fetch beer for the other nine."_ [
> _"Wage-grumbles"_ , **Economic Fragments** , p. 226]

So to work out the marginal productivity of the factors involved, _"ten
cheaper spades"_ somehow equals nine more expensive spades? How is this
keeping capital constant? And how does this reflect reality? Surely, any real
world example would involve sending the tenth digger to get another spade? And
how do nine expensive spades become nine cheaper ones? In the real world, this
is impossible but in neoclassical economics this is not only possible but
required for the theory to work. As Robinson argued, in neo-classical theory
the _"concept of capital all the man-made factors are boiled into one, which
we may call **leets** . . . [which], though all made up of one physical
substance, is endowed with the capacity to embody various techniques of
production . . . and a change of technique can be made simply by squeezing up
or spreading out leets, instantaneously and without cost."_ [ **Contributions
to Modern Economics** , p. 106]

This allows economics to avoid the obvious aggregation problems with
"capital", make sense of the concept of adding an extra unit of capital to
discover its "marginal productivity" and allows capital to be held "constant"
so that the "marginal productivity" of labour can be found. For when _"the
stock of means of production in existence can be represented as a quantity of
ectoplasm, we can say, appealing to Euler's theorem, that the rent per unit of
ectoplasm is equal to the marginal product of the given quantity of ectoplasm
when it is fully utilised. This does seem to add anything of interest to the
argument."_ [ **Op. Cit.** , p. 99] This ensures reality has to be ignored and
so economic theory need not discuss any practical questions:

> _"When equipment is made of leets, there is no distinction between long and
> short-period problems . . . Nine spades are lumps of leets; when the tenth
> man turns up it is squeezed out to provide him with a share of equipment
> nine-tenths of what each man had before . . . There is no room for imperfect
> competition. There is no possibility of disappointed expectations . . .
> There is no problem of unemployment . . . Unemployed workers would bid down
> wages and the pre-existing quantity of leets would be spread out to
> accommodate them."_ [ **Op. Cit.** , p. 107]

The concept that capital goods are made of ectoplasm and can be remoulded into
the profit maximising form from day to day was invented in order to prove that
labour and capital both receive their contribution to society, to show that
labour is not exploited. It is not meant to be taken literally, it is only a
parable, but without it the whole argument (and defence of capitalism)
collapses. Once capital equipment is admitted to being actual, specific
objects that cannot be squeezed, without cost, into new objects to accommodate
more or less workers, such comforting notions that profits equal the
(marginal) contribution of "capital" or that unemployment is caused by wages
being too high have to be discarded for the wishful thinking they most surely
are.

The last problem arises when ignore these issues and assume that marginal
productivity theory is correct. Consider the notion of the short run, where at
least one factor of production cannot be varied. To determine its marginal
productivity then capital has to be the factor which is varied. However,
common sense suggests that capital is the least flexible factor and if that
can be varied then every other one can be as well? As dissident economist
Piero Sraffa argued, when a market is defined broadly enough, then the key
neoclassical assumption that the demand and supply of a commodity are
independent breaks down. This was applied by another economist, Amit Bhaduri,
to the "capital market" (which is, by nature, a broadly defined industry).
Steve Keen usually summarises these arguments, noting that _"at the aggregate
level [of the economy as a whole], the desired relationship -- the rate of
profit equals the marginal productivity of capital -- will not hold true"_ as
it only applies _"when the capital to labour ratio is the same in all
industries -- which is effectively the same as saying there is only one
industry."_ This _"proves Sraffa's assertion that, when a broadly defined
industry is considered, changes in its conditions of supply and demand will
affect the distribution of income."_ This means that a _"change in the capital
input will change output, but it also changes the wage, and the rate of profit
. . . As a result, the distribution of income is neither meritocratic nor
determined by the market. The distribution of income is to some significant
degree determined independently of marginal productivity and the impartial
blades of supply and demand . . . To be able to work out prices, it is first
necessary to know the distribution of income . . . There is therefore nothing
sacrosanct about the prices that apply in the economy, and equally nothing
sacrosanct about the distribution of income. It reflects the relative power of
different groups in society."_ [ **Op. Cit.** , p. 135]

It should be noted that this critique bases itself on the neoclassical
assumption that it is possible to define a factor of production called
capital. In other words, even if we assume that neo-classical economics theory
of capital is not circular reasoning, it's theory of distribution is still
logically wrong.

So mainstream economics is based on a theory of distribution which is utterly
irrelevant to the real world and is incoherent when applied to capital. This
would not be important except that it is used to justify the distribution of
income in the real world. For example, the widening gap between rich and poor
(it is argued) simply reflects a market efficiently rewarding more productive
people. Thus the compensation for corporate chief executives climbs so sharply
because it reflects their marginal productivity. Except, of course, the theory
supports no such thing -- except in a make believe world which cannot exist
(lassiez fairy land, anyone?).

It must be noted that this successful critique of neoclassical economics by
dissident economists was first raised by Joan Robinson in the 1950s (it
usually called the Cambridge Capital Controversy). It is rarely mentioned
these days. While most economic textbooks simply repeat the standard theory,
the fact is that this theory has been successfully debunked by dissident
economists over four decades go. As Steve Keen notes, while leading
neoclassical economists admitted that the critique was correct in the 1960s,
today _"economic theory continues to use exactly the same concepts which
Sraffa's critique showed to be completely invalid"_ in spite the _"definitive
capitulation by as significant an economist as Paul Samuelson."_ As he
concludes: _"There is no better sign of the intellectual bankruptcy of
economics than this."_ [ **Op. Cit.** , p. 146, p. 129 and p. 147]

Why? Simply because the Cambridge Capital Controversy would expose the student
of economics to some serious problems with neo-classical economics and they
may start questioning the internal consistency of its claims. They would also
be exposed to alternative economic theories and start to question whether
profits **are** the result of exploitation. As this would put into jeopardy
the role of economists as, to quote Marx, the _"hired prize-fighters"_ for
capital who replace _"genuine scientific research"_ with _"the bad conscience
and evil intent of apologetics."_ Unsurprisingly, he characterised this as
_"vulgar economics."_ [ **Capital** , vol. 1, p. 97]

## C.2.6 Does interest represent the "time value" of money?

One defence of interest is the notion of the "time value" of money, that
individuals have different "time preferences." Most individuals prefer, it is
claimed, to consume now rather than later while a few prefer to save now on
the condition that they can consume more later. Interest, therefore, is the
payment that encourages people to defer consumption and so is dependent upon
the subjective evaluations of individuals. It is, in effect, an exchange over
time and so surplus value is generated by the exchange of present goods for
future goods.

Based on this argument, many supporters of capitalism claim that it is
legitimate for the person who provided the capital to get back **more** than
they put in, because of the "time value of money." This is because investment
requires savings and the person who provides those had to postpone a certain
amount of current consumption and only agree to do this only if they get an
increased amount later (i.e. a portion, over time, of the increased output
that their saving makes possible). This plays a key role in the economy as it
provide the funds from which investment can take place and the economy grow.

In this theory, interest rates are based upon this "time value" of money and
the argument is rooted in the idea that individuals have different "time
preferences." Some economic schools, like the Austrian school, argue that the
actions by banks and states to artificially lower interest rates (by, for
example, creating credit or printing money) create the business cycle as this
distorts the information about people's willingness to consume now rather than
later leading to over investment and so to a slump.

That the idea of doing nothing (i.e. not consuming) can be considered as
productive says a lot about capitalist theory. However, this is beside the
point as the argument is riddled with assumptions and, moreover, ignores key
problems with the notion that savings always lead to investment.

The fundamental weakness of the theory of time preference must be that it is
simply an unrealistic theory and does not reflect where the supply of capital
does come from. It **may** be appropriate to the decisions of households
between saving and consumption, but the main source of new capital is previous
profit under capitalism. The motivation of making profits is not the provision
of future means of consumption, it is profits for their own sake. The nature
of capitalism requires profits to be accumulated into capital for if
capitalists **did** only consume the system would break down. While from the
point of view of the mainstream economics such profit-making for its own sake
is irrational in reality it is imposed on the capitalist by capitalist
competition. It is only by constantly investing, by introducing new
technology, work practices and products, can the capitalists keep their
capital (and income) intact. Thus the motivation of capitalists to invest is
imposed on them by the capitalist system, not by subjective evaluations
between consuming more later rather than now.

Ignoring this issue and looking at the household savings, the theory still
raises questions. The most obvious problem is that an individual's psychology
is conditioned by the social situation they find themselves in. Ones "time
preference" is determined by ones social position. If one has more than enough
money for current needs, one can more easily "discount" the future (for
example, workers will value the future product of their labour less than their
current wages simply because without those wages there will be no future). We
will discuss this issue in more detail later and will not do so here (see
[section C.2.7](secC2.md#secc27)).

The second thing to ask is why should the supply price of waiting be assumed
to be positive? If the interest rate simply reflects the subjective
evaluations of individuals then, surely, it could be negative or zero.
Deferred gratification is as plausible a psychological phenomenon as the
overvaluation of present satisfactions, while uncertainty is as likely to
produce immediate consumption as it is to produce provision for the future
(saving). Thus Joan Robinson:

> _"The rate of interest (excess of repayment over original loan) would settle
> at the level which equated supply and demand for loans. Whether it was
> positive or negative would depend upon whether spendthrifts or prudent
> family men happened to predominate in the community. There is no **a
> priori** presumption in favour of a positive rate. Thus, the rate of
> interest cannot be account for as the 'cost of waiting.'  
>  _
>
> _"The reason why there is always a demand for loans at a positive rate of
> interest, in an economy where there is property in the means of production
> and means of production are scarce, is that finance expended now can be used
> to employ labour in productive processes which will yield a surplus in the
> future over costs of production. Interest is positive because profits are
> positive (though at the same time the cost and difficulty of obtaining
> finance play a part in keeping productive equipment scarce, and so
> contribute to maintaining the level of profits)."_ [ **Contributions to
> Modern Economics** , p. 83]

It is only because money provides the authority to allocate resources and
exploit wage labour that money now is more valuable ( _"we know that mere
saving itself brings in nothing, so long as the pence saved are not used to
exploit."_ [Kropotkin, **The Conquest of Bread** , p. 59]). The capitalist
does not supply "time" (as the "time value" theory argues), the loan provides
authority/power and so the interest rate does not reflect "time preference"
but rather the utility of the loan to capitalists, i.e. whether it can be used
to successfully exploit labour. If the expectations of profits by capitalists
are low (as in, say, during a depression), loans would not be desired no
matter how low the interest rate became. As such, the interest rate is shaped
by the general profit level and so be independent of the "time preference" of
individuals.

Then there is the problem of circularity. In any real economy, interest rates
obviously shape people's saving decisions. This means that an individual's
"time preference" is shaped by the thing it is meant to explain:

> _"But there may be some savers who have the psychology required by the text
> books and weigh a preference for present spending against an increment of
> income (interest, dividends and capital gains) to be had from an increment
> of wealth. But what then? Each individual goes on saving or dis-saving till
> the point where his individual subjective rate of discount is equal to the
> market rate of interest. There has to be a market rate of interest for him
> to compare his rate of discount to."_ [Joan Robinson, **Op. Cit.** , pp.
> 11-12]

Looking at the individuals whose subjective evaluations allegedly determine
the interest rate, there is the critical question of motivation. Looking at
lenders, do they **really** charge interest because they would rather spend
more money later than now? Hardly, their motivation is far more complicated
than that. It is doubtful that many people actually sit down and work out how
much their money is going to be "worth" to them a year or more from now. Even
if they did, the fact is that they really have no idea how much it will be
worth. The future is unknown and uncertain and, consequently, it is
implausible that "time preference" plays the determining role in the decision
making process.

In most economies, particularly capitalism, the saver and lender are rarely
the same person. People save and the banks use it to loan it to others. The
banks do not do this because they have a low "time preference" but because
they want to make profits. They are a business and make their money by
charging more interest on loans than they give on savings. Time preference
does not enter into it, particularly as, to maximise profits, banks loan out
more (on credit) than they have in savings and, consequently, make the actual
interest rate totally independent of the rate "time preference" would (in
theory) produce.

Given that it would be extremely difficult, indeed impossible, to stop banks
acting in this way, we can conclude that even if "time preference" were true,
it would be of little use in the real world. This, ironically, is recognised
by the same free market capitalist economists who advocate a "time preference"
perspective on interest. Usually associated with the "Austrian" school, they
argue that banks should have 100% reserves (i.e. they loan out only what they
have in savings, backed by gold). This implicitly admits that the interest
rate does not reflect "time preference" but rather the activities (such as
credit creation) of banks (not to mention other companies who extend business
credit to consumers). As we discuss in [section C.8](secC8.md), this is not
due to state meddling with the money supply or the rate of interest but rather
the way capitalism works.

Moreover, as the banking industry is marked, like any industry, by
oligopolistic competition, the big banks will be able to add a mark up on
services, so distorting any interest rates set even further from any abstract
"time preference" that exists. Therefore, the structure of that market will
have a significant effect on the interest rate. Someone in the same
circumstances with the same "time preference" will get radically different
interest rates depending on the "degree of monopoly" of the banking sector
(see [section C.5](secC5.md) for "degree of monopoly"). An economy with a
multitude of small banks, implying low barriers of entry, will have different
interest rates than one with a few big firms implying high barriers (if banks
are forced to have 100% gold reserves, as desired by many "free market"
capitalists, then these barriers may be even higher). As such, it is highly
unlikely that "time preference" rather than market power is a more significant
factor in determining interest rates in any **real** economy. Unless, of
course, the rather implausible claim is made that the interest rate would be
the same no matter how competitive the banking market was -- which, of course,
is what the "time preference" argument does imply.

Nor is "time preference" that useful when we look at the saver. People save
money for a variety of motives, few (if any) of which have anything to do with
"time preference." A common motive is, unsurprisingly, uncertainty about the
future. Thus people put money into savings accounts to cover possible mishaps
and unexpected developments (as in _"saving for a rainy day"_ ). Indeed, in an
uncertain world future money may be its own reward for immediate consumption
is often a risky thing to do as it reduces the ability to consumer in the
future (for example, workers facing unemployment in the future could value the
same amount of money more then than now). Given that the future is uncertain,
many save precisely for precautionary reasons and increasing current
consumption is viewed as a disutility as it is risky behaviour. Another common
reason would be to save because they do not have enough money to buy what they
want now. This is particularly the case with working class families who face
stagnating or falling income or face financial difficulties.[Henwood, **Wall
Street** , p. 65] Again, "time preference" does not come into it as economic
necessity forces the borrowers to consume more now in order to be around in
the future.

Therefore, money lending is, for the poor person, not a choice between more
consumption now/less later and less consumption now/more later. If there is no
consumption now, there will not be any later. So not everybody saves money
because they want to be able to spend more at a future date. As for borrowing,
the real reason for it is necessity produced by the circumstances people find
themselves in. As for the lender, their role is based on generating a current
and future income stream, like any business. So if "time preference" seems
unlikely for the lender, it seems even more unlikely for the borrower or
saver. Thus, while there is an element of time involved in decisions to save,
lend and borrow, it would be wrong to see interest as the consequence of "time
preference." Most people do not think in terms of it and, therefore,
predicting their behaviour using it would be silly.

At the root of the matter is that for the vast majority of cases in a
capitalist economy, an individual's "time preference" is determined by their
social circumstances, the institutions which exist, uncertainty and a host of
other factors. As inequality drives "time preference," there is no reason to
explain interest rates by the latter rather than the former. Unless, of
course, you are seeking to rationalise and justify the rich getting richer.
Ultimately, interest is an expression of inequality, **not** exchange:

> _"If there is chicanery afoot in calling 'money now' a different good than
> 'money later,' it is by no means harmless, for the intended effect is to
> subsume money lending under the normative rubric of exchange . . . [but]
> there are obvious differences . . . [for in normal commodity exchange] both
> parties have something [while in loaning] he has something you don't . . .
> [so] inequality dominates the relationship. He has more than you have now,
> and he will get back more than he gives."_ [Schweickart, **Against
> Capitalism** , p. 23]

While the theory is less than ideal, the practice is little better. Interest
rates have numerous perverse influences in any real economy. In neo-classical
and related economics, saving does not have a negative impact on the economy
as it is argued that non-consumed income must be invested. While this could be
the case when capitalism was young, when the owners of firms ploughed their
profits back into them, as financial institutions grew this became less so.
Saving and investment became different activities, governed by the rate of
interest. If the supply of savings increased, the interest rate would drop and
capitalists would invest more. If the demand for loans increased, then the
interest rate would rise, causing more savings to occur.

While the model is simple and elegant, it does have its flaws. These are first
analysed by Keynes during the Great Depression of the 1930s, a depression
which the neo-classical model said was impossible.

For example, rather than bring investment into line with savings, a higher
interest can cause savings to fall as _"[h]ousehold saving, of course, is
mainly saving up to spend later, and . . . it is likely to respond the wrong
way. A higher rate of return means that 'less' saving is necessary to get a
given pension or whatever."_ [Robinson, **Op. Cit.** , p. 11] Similarly,
higher interest rates need not lead to higher investment as higher interest
payments can dampen profits as both consumers and industrial capitalists have
to divert more of their finances away from real spending and towards debt
services. The former causes a drop in demand for products while the latter
leaves less for investing.

As argued by Keynes, the impact of saving is not as positive as some like to
claim. Any economy is a network, where decisions affect everyone. In a
nutshell, the standard model fails to take into account changes of income that
result from decisions to invest and save (see Michael Stewart's **Keynes and
After** for a good, if basic, introduction). This meant that if some people do
not consume now, demand falls for certain goods, production is turned away
from consumption goods, and this has an effect on all. Some firms will find
their sales failing and may go under, causing rising unemployment. Or, to put
it slightly differently, aggregate demand -- and so aggregate supply -- is
changed when some people postpone consumption, and this affects others. The
decrease in the demand for consumer goods affects the producers of these
goods. With less income, the producers would reduce their expenditure and this
would have repercussions on other people's incomes. In such circumstances, it
is unlikely that capitalists would be seeking to invest and so rising savings
would result in falling investment in spite of falling interest rates. In an
uncertain world, investment will only be done if capitalists think that they
will end up with more money than they started with and this is unlikely to
happen when faced with falling demand.

Whether rising interest rates do cause a crisis is dependent on the strength
of the economy. During a strong expansion, a modest rise in interest rates may
be outweighed by rising wages and profits. During a crisis, falling rates will
not counteract the general economic despair. Keynes aimed to save capitalism
from itself and urged state intervention to counteract the problems associated
with free market capitalism. As we discuss in [section
C.8.1](secC8.md#secc81), this ultimately failed partly due to the mainstream
economics gutting Keynes' work of key concepts which were incompatible with
it, partly due to Keynes' own incomplete escape from neoclassical economics,
partly due the unwillingness of rentiers to agree to their own euthanasia but
mostly because capitalism is inherently unstable due to the hierarchical (and
so oppressive and exploitative) organisation of production.

Which raises the question of whether someone who saves deserve a reward for so
doing? Simply put, no. Why? Because the act of saving is no more an act of
production than is purchasing a commodity (most investment comes from retained
profits and so the analogy is valid). Clearly the reward for purchasing a
commodity is that commodity. By analogy, the reward for saving should be not
interest but one's savings -- the ability to consume at a later stage.
Particularly as the effects of interest rates and savings can have such
negative impacts on the rest of the economy. It seems strange, to say the
least, to reward people for helping do so. Why should someone be rewarded for
a decision which may cause companies to go bust, so **reducing** the available
means of production as reduced demand results in job loses and idle factories?
Moreover, this problem _"becomes ever more acute the richer or more
inegalitarian the society becomes, since wealthy people tend to save more than
poor people."_ [Schweickart, **After Capitalism** , p. 43]

Supporters of capitalists assume that people will not save unless promised the
ability to consume **more** at a later stage, yet close examination of this
argument reveals its absurdity. People in many different economic systems save
in order to consume later, but only in capitalism is it assumed that they need
a reward for it beyond the reward of having those savings available for
consumption later. The peasant farmer "defers consumption" in order to have
grain to plant next year, even the squirrel "defers consumption" of nuts in
order to have a stock through winter. Neither expects to see their stores
increase in size over time. Therefore, saving is rewarded by saving, as
consuming is rewarded by consuming. In fact, the capitalist "explanation" for
interest has all the hallmarks of apologetics. It is merely an attempt to
justify an activity without careful analysing it.

To be sure, there is an economic truth underlying this argument for justifying
interest, but the formulation by supporters of capitalism is inaccurate and
unfortunate. There is a sense in which 'waiting' is a condition for capital
**increase** , though not for capital per se. Any society which wishes to
increase its stock of capital goods may have to postpone some gratification.
Workplaces and resources turned over to producing capital goods cannot be used
to produce consumer items, after all. How that is organised differs from
society to society. So, like most capitalist economics there is a grain of
truth in it but this grain of truth is used to grow a forest of half-truths
and confusion.

As such, this notion of "waiting" only makes sense in a 'Robinson Crusoe"
style situation, **not** in any form of real economy. In a real economy, we do
not need to "wait" for our consumption goods until investment is complete
since the division of labour/work has replaced the succession in time by a
succession in place. We are dealing with an already well developed system of
**social** production and an economy based on a social distribution of labour
in which there are available all the various stages of the production process.
As such, the notion that "waiting" is required makes little sense. This can be
seen from the fact that it is not the capitalist who grants an advance to the
worker. In almost all cases the worker is paid by their boss **after** they
have completed their work. That is, it is the worker who makes an advance of
their labour power to the capitalist. This waiting is only possible because
_"no species of labourer depends on any previously prepared stock, for in fact
no such stock exists; but every species of labourer does constantly, and at
all times, depend for his supplies on the co-existing labour of some other
labourers."_ [Thomas Hodgskin, **Labour Defended Against the Claims of
Capital** ] This means that the workers, as a class, creates the fund of goods
out of which the capitalists pay them.

Ultimately, selling the use of money (paid for by interest) is not the same as
selling a commodity. The seller of the commodity does not receive the
commodity back as well as its price, unlike the typical lender of money. In
effect, as with rent and profits, interest is payment for permission to use
something and, therefore, not a productive act which should be rewarded. It is
**not** the same as other forms of exchange. Proudhon pointed out the
difference:

> _"Comparing a loan to a **sale** , you say: Your argument is as valid
> against the latter as against the former, for the hatter who sells hats does
> not **deprive** himself.  
>  _
>
> _"No, for he receives for his hats -- at least he is reputed to receive for
> them -- their exact value immediately, neither **more** nor **less**. But
> the capitalist lender not only is not deprived, since he recovers his
> capital intact, but he receives more than his capital, more than he
> contributes to the exchange; he receives in addition to his capital an
> interest which represents no positive product on his part. Now, a service
> which costs no labour to him who renders it is a service which may become
> gratuitous."_ [ **Interest and Principal: The Circulation of Capital, Not
> Capital Itself, Gives Birth to Progress** ]

The reason why interest rates do not fall to zero is due to the class nature
of capitalism, **not** "time preference." That it is ultimately rooted in
social institutions can be seen from Böhm-Bawerk's acknowledgement that
monopoly can result in exploitation by increasing the rate of interest above
the rate specified by "time preference" (i.e. the market):

> _"Now, of course, the circumstances unfavourable to buyers may be corrected
> by active competition among sellers . . . But, every now and then, something
> will suspend the capitalists' competition, and then those unfortunates, whom
> fate has thrown on a local market ruled by monopoly, are delivered over to
> the discretion of the adversary. Hence direct usury, of which the poor
> borrower is only too often the victim; and hence the low wages forcibly
> exploited from the workers. . .  
>  _
>
> _"It is not my business to put excesses like these, where there actually is
> exploitation, under the aegis of that favourable opinion I pronounced above
> as to the essence of interest. But, on the other hand, I must say with all
> emphasis, that what we might stigmatise as 'usury' does not consist in the
> obtaining of a gain out of a loan, or out of the buying of labour, but in
> the immoderate extent of that gain . . . Some gain or profit on capital
> there would be if there were no compulsion on the poor, and no monopolising
> of property; and some gain there must be. It is only the height of this gain
> where, in particular cases, it reaches an excess, that is open to criticism,
> and, of course, the very unequal conditions of wealth in our modern
> communities bring us unpleasantly near the danger of exploitation and of
> usurious rates of interest."_ [ **The Positive Theory of Capital** , p. 361]

Little wonder, then, that Proudhon continually stressed the need for working
people to organise themselves and credit (which, of course, they would have
done naturally, if it were not for the state intervening to protect the
interests, income and power of the ruling class, i.e. of itself and the
economically dominant class). If, as Böhm-Bawerk admitted, interest rates
could be high due to institutional factors then, surely, they do not reflect
the "time preferences" of individuals. This means that they could be lower
(effectively zero) if society organised itself in the appropriate manner. The
need for savings could be replaced by, for example, co-operation and credit
(as already exists, in part, in any developed economy). Organising these could
ensure a positive cycle of investment, growth and savings (Keynes, it should
be noted, praised Proudhon's follower Silvio Gesell in **The General Theory**.
For a useful discussion see Dudley Dillard's essay _"Keynes and Proudhon"_ [
**The Journal of Economic History** , vol. 2, No. 1, pp. 63-76]).

Thus the key flaw in the theory is that of capitalist economics in general. By
concentrating on the decisions of individuals, it ignores the social
conditions in which these decisions are made. By taking the social
inequalities and insecurities of capitalism as a given, the theory ignores the
obvious fact that an individual's "time preference" will be highly shaped by
their circumstances. Change those circumstances and their "time preference"
will also change. In other words, working people have a different "time
preference" to the rich because they are poorer. Similarly, by focusing on
individuals, the "time preference" theory fails to take into account the
institutions of a given society. If working class people have access to credit
in other forms than those supplied by capitalists then their "time preference"
will differ radically. As an example, we need only look at credit unions. In
communities with credit unions the poor are less likely to agree to get into
an agreement from a loan shark. It seems unlikely, to say the least, that the
"time preference" of those involved have changed. They are subject to the same
income inequalities and pressures as before, but by uniting with their fellows
they give themselves better alternatives.

As such, "time preference" is clearly not an independent factor. This means
that it cannot be used to justify capitalism or the charging of interest. It
simply says, in effect, that in a society marked by inequality the rich will
charge the poor as much interest as they can get away with. This is hardly a
sound basis to argue that charging interest is a just or a universal fact. It
reflects social inequality, the way a given society is organised and the
institutions it creates. Put another way, there is no "natural" rate of
interest which reflects the subjective "time preferences" of abstract
individuals whose decisions are made without any social influence. Rather, the
interest rate depends on the conditions and institutions within the economy as
a whole. The rate of interest is positive under capitalism because it is a
class society, marked by inequality and power, **not** because of the "time
preference" of abstract individuals.

In summary, providing capital and charging interest are not productive acts.
As Proudhon argued, _"all rent received (nominally as damages, but really as
payment for a loan) is an act of property -- of robbery."_ [ **What is
Property** , p. 171]

## C.2.7 Are interest and profit not the reward for waiting?

Another defence of surplus value by capitalist economics is also based on
time. This argument is related to the "time preference" one we have discussed
in the [last section](secC6.md) and is, likewise, rooted in the idea that
money now is different than money later and, as a consequence, surplus value
represents (in effect) an exchange of present goods for future ones. This
argument has two main forms, depending on whether it is interest or profits
which are being defended, but both are based on this perspective. We will
discuss each in turn.

One of the oldest defences of interest is the "abstinence" theory first
postulated by Nassau Senior in 1836. For Senior, abstinence is a sacrifice of
present enjoyment for the purpose achieving some distant result. This demands
the same heavy sacrifice as does labour, for to _"abstain from the enjoyment
which is in our power, or to seek distant rather than immediate results, are
among the most painful exertions of the human will."_ Thus wages and
interest/profit _"are to be considered as the rewards of peculiar sacrifices,
the former the remuneration for labour, and the latter for abstinence from
immediate enjoyment."_ [ **An Outline of the Science of Political Economy** ,
p. 60 and p. 91]

Today, the idea that interest is the reward for "abstinence" on the part of
savers is still a common one in capitalist economics. However, by the end of
the nineteenth century, Senior's argument had become known as the "waiting"
theory while still playing the same role in justifying non-labour income. One
of the leading neo-classical economists of his day, Alfred Marshall, argued
that _"[i]f we admit [a commodity] is the product of labour alone, and not of
labour and waiting, we can no doubt be compelled by an inexorable logic to
admit that there is no justification of interest, the reward for waiting."_ [
**Principles of Economics** , p. 587] While implicitly recognising that labour
is the source of all value in capitalism (and that abstinence is not the
**source** of profits), it is claimed that interest is a justifiable claim on
the surplus value produced by a worker.

Why is this the case? Capitalist economics claims that by "deferring
consumption," the capitalist allows new means of production to be developed
and so should be rewarded for this sacrifice. In other words, in order to have
capital available as an input -- i.e. to bear costs now for returns in the
future -- someone has to be willing to postpone his or her consumption. That
is a real cost, and one that people will pay only if rewarded for it:

> _"human nature being what it is, we are justified in speaking of the
> interest on capital as the reward of the sacrifice involved in waiting for
> the enjoyment of material resources, because few people would save much
> without reward; just as we speak of wages as the reward of labour, because
> few people would work hard without reward."_ [ **Op. Cit.** , p. 232]

The interest rate is, in neo-classical economic theory, set when the demand
for loans meets the supply of savings. The interest rate stems from the fact
that people prefer present spending over future spending. If someone borrows
£200 for one year at 5%, this is basically the same as saying that there would
rather have £200 now than £210 a year from now. Thus interest is the cost of
providing a service, namely time. People are able to acquire today what they
would otherwise not have until sometime in the future. With a loan, interest
is the price of the advantage obtained from having money immediately rather
than having to wait for.

This, on first appears, seems plausible. If you accept the logic of capitalist
economics and look purely at individuals and their preferences independently
of their social circumstances then it can make sense. However, once you look
wider you start to see this argument start to fall apart. Why is it that the
wealthy are willing to save and provide funds while it is the working class
who do not save and get into debt? Surely a person's "time preference" is
dependent on their socio-economic position? As we argued in the [last
section](secC2.md#secc26), this means that any subjective evaluation of the
present and future is dependent on, not independent of, the structure of
market prices and income distribution. It varies with the income of individual
and their class position, since the latter will condition the degree or
urgency of present wants and needs.

So this theory appears ludicrous to a critic of capitalism -- simply put, does
the mine owner really sacrifice more than a miner, a rich stockholder more
than an autoworker working in their car plant, a millionaire investor more
than a call centre worker? As such, the notion that "waiting" explains
interest is question begging in the extreme as it utterly ignores inequality
within a society. After all, it is far easier for a rich person to "defer
consumption" than for someone on an average income. This is borne out by
statistics, for as Simon Kuznets has noted, _"only the upper income groups
save; the total savings of groups below the top decile are fairly close to
zero."_ [ **Economic Growth and Structure** , p. 263] Obviously, therefore, in
modern society it is the capitalist class, the rich, who refrain from
expending their income on immediate consumption and _"abstain."_
Astonishingly, working class people show no such desire to abstain from
spending their wages on immediate consumption. It does not take a genius to
work out why, although many economists have followed Senior in placing the
blame on working class lack of abstinence on poor education rather than, say,
the class system they live in (for Senior, _"the worse educated"_ classes
_"are always the most improvident, and consequently the least abstinent."_ [
**Op. Cit.** , p. 60]).

Therefore, the plausibility of interest as payment for the pain of deferring
consumption rests on the premise that the typical saving unit is a small or
medium-income household. But in contemporary capitalist societies, this is not
the case. Such households are not the source of most savings; the bulk of
interest payments do not go to them. As such, interest is the dependent factor
and so "waiting" cannot explain interest. Rather, interest is product of
social inequality and the social relationships produced by an economy. Lenders
lend because they have the funds to do so while borrowers borrow because
without money now they may not be around later. As those with funds are hardly
going without by lending, it does not make much sense to argue that they would
spend even more today without the temptation of more income later.

To put this point differently, the capitalist proponents of interest only
consider "postponing consumption" as an abstraction, without making it
concrete. For example, a capitalist may "postpone consumption" of his 10th
Rolls Royce because he needs the money to upgrade some machinery in his
factory; whereas a single mother may have to "postpone consumption" of food or
adequate housing in order to attempt to better take care of her children. The
two situations are vastly different, yet the capitalist equates them. This
equation implies that "not being able to buy anything you want" is the same as
"not being able to buy things you need", and is thus skewing the obvious
difference in costs of such postponement of consumption!

Thus Proudhon's comments that the loaning of capital _"does not involve an
actual sacrifice on the part of the capitalist"_ and so _"does not deprive
himself. . . of the capital which be lends. He lends it, on the contrary,
precisely because the loan is not a deprivation to him; he lends it because he
has no use for it himself, being sufficiently provided with capital without
it; be lends it, finally, because he neither intends nor is able to make it
valuable to him personally, -- because, if he should keep it in his own hands,
this capital, sterile by nature, would remain sterile, whereas, by its loan
and the resulting interest, it yields a profit which enables the capitalist to
live without working. Now, to live without working is, in political as well as
moral economy, a contradictory proposition, an impossible thing."_ [
**Interest and Principal: A Loan is a Service** ]

In other words, contra Marshall, saving is **not** a sacrifice for the wealthy
and, as such, not deserving a reward. Proudhon goes on:

> _"The proprietor who possesses two estates, one at Tours, and the other at
> Orleans, and who is obliged to fix his residence on the one which he uses,
> and consequently to abandon his residence on the other, can this proprietor
> claim that he deprives himself of anything, because he is not, like God,
> ubiquitous in action and presence? As well say that we who live in Paris are
> deprived of a residence in New York! Confess, then, that the privation of
> the capitalist is akin to that of the master who has lost his slave, to that
> of the prince expelled by his subjects, to that of the robber who, wishing
> to break into a house, finds the dogs on the watch and the inmates at the
> windows."_

Given how much income this "abstinence" or "waiting" results in, we can only
conclude that it is the most painful of decisions possible for a multi-
millionaire to decide **not** to buy that fifth house and instead save the
money. The effort to restrain themselves from squandering their entire
fortunes all at once must be staggering. In the capitalist's world, an
industrialist who decides not to consume a part of their riches "suffers" a
cost equivalent to that of someone who postpones consumption of their meagre
income to save enough to get something they need. Similarly, if the
industrialist "earns" hundred times more in interest than the wage of the
worker who toils in their workplace, the industrialist "suffers" hundred times
more discomfort living in his palace than, say, the coal miner does working at
the coal face in dangerous conditions or the worker stuck in a boring McJob
they hate. The "disutility" of postponing consumption while living in luxury
is obviously 100 times greater than the "disutility" of, say, working for a
living and so should be rewarded appropriately.

As there is no direct relationship between interest received and the
"sacrifice" involved (if anything, it is an **inverse** relationship), the
idea that interest is the reward for waiting is simply nonsense. You need be
no anarchist to come to this obvious conclusion. It was admitted as much by a
leading capitalist economist and his argument simply echoes Proudhon's earlier
critique:

> _"the existence and height of interest by no means invariably correspond
> with the existence and the height of a 'sacrifice of abstinence.' Interest,
> in exceptional cases, is received where there has been no individual
> sacrifice of abstinence. High interest is often got where the sacrifice of
> the abstinence is very trifling -- as in the case of [a] millionaire -- and
> 'low interest' is often got where the sacrifice entailed by the abstinence
> is very great. The hardly saved sovereign which the domestic servant puts in
> the savings bank bears, absolutely and relatively, less interest than the
> lightly spared thousands which the millionaire puts to fructify in debenture
> and mortgage funds. These phenomena fit badly into a theory which explains
> interest quite universally as a 'wage of abstinence.'"_ [Eugen von Böhm-
> Bawerk, **Capital and Interest** , p. 277]

All in all, as Joan Robinson pointed out, _"that the rate of interest is the
'reward for waiting' but 'waiting' only means owning wealth . . . In short, a
man who refrains from blowing his capital in orgies and feasts can continue to
get interest on it. This seems perfectly correct, but as a theory of
distribution it is only a circular argument."_ [ **Contributions to Modern
Economics** , p. 11] Interest is not the reward for "waiting," rather it is
one of the (many) rewards for being rich. This was admitted as much by
Marshall himself, who noted that the _"power to save depends on an excess of
income over necessary expenditure; and this is greatest among the wealthy."_ [
**Op. Cit.** , p. 229]

Little wonder, then, that neo-classical economists introduced the term
**waiting** as an "explanation" for returns to capital (such as interest).
Before this change in the jargon of economics, mainstream economists used the
notion of "abstinence" (the term used by Nassau Senior) to account for (and so
justify) interest. Just as Senior's "theory" was seized upon to defend returns
to capital, so was the term "waiting" after it was introduced in the 1880s.
Interestingly, while describing **exactly** the same thing, "waiting" became
the preferred term simply because it had a less apologetic ring to it. Both
describe the _"sacrifice of present pleasure for the sake of future"_ yet,
according to Marshall, the term _"abstinence"_ was _"liable to be
misunderstood"_ because there were just too many wealthy people around who
received interest and dividends without ever having abstained from anything.
As he admitted, the _"greatest accumulators of wealth are very rich persons,
some [!] of whom live in luxury, and certainly do not practise abstinence in
that sense of the term in which it is convertible with abstemiousness."_ So he
opted for the term "waiting" because there was _"advantage"_ in its use to
describe _"the accumulation of wealth"_ as the _"result of a postponement of
enjoyment."_ [ **Op. Cit.** , pp. 232-3] This is particularly the case as
socialists had long been pointing out the obvious fact that capitalists do not
_"abstain"_ from anything.

The lesson is obvious, in mainstream economics if reality conflicts with your
theory, do not reconsider the theory, change its name!

The problems of "waiting" and "abstinence" as the source of interest becomes
even clearer when we look at inherited wealth. Talking about "abstinence" or
"waiting" when discussing a capitalist inheriting a company worth millions is
silly. Senior recognised this, arguing that income in this case is not profit,
but rather _"has all the attributes of rent."_ [ **Op. Cit.** , p. 129] That
such a huge portion of capitalist revenue would not be considered profit shows
the bankruptcy of any theory which see profit as the reward for "waiting."
However, Senior's argument does show that interest payments need not reflect
any positive contribution to production by those who receive it. Like the
landlord receiving payment for owning a gift of nature, the capitalist
receives income for simply monopolising the work of previous generations and,
as Smith put it, the _"rent of land, considered as the price paid for the use
of land, is naturally a monopoly price."_ [ **The Wealth of Nations** , p.
131]

Even capitalist economists, while seeking to justify interest, admit that it
_"arises independently of any personal act of the capitalist. It accrues to
him even though he has not moved any finger in creating it . . . And it flows
without ever exhausting that capital from which it arises, and therefore
without any necessary limit to its continuance. It is, if one may use such an
expression in mundane matters, capable of everlasting life."_ [Böhm-Bawerk,
**Op. Cit.** , p. 1] Little wonder we argued in [section
C.2.3](secC2.md#secc23) that simply owning property does not justify non-
labour income.

In other words, due to **one** decision not to do anything (i.e. **not** to
consume), a person (and his or her heirs) may receive **forever** a reward
that is not tied to any productive activity. Unlike the people actually doing
the work (who only get a reward every time they "contribute" to creating a
commodity), the capitalist will get rewarded for just **one** act of
abstention. This is hardly a just arrangement. As David Schweickart has
pointed out, _"Capitalism does reward some individuals perpetually. This, if
it is to be justified by the canon of contribution, one must defend the claim
that some contributions are indeed eternal."_ [ **Against Capitalism** , p.
17] As we noted in [section C.1.1](secC1.md#secc11), current and future
generations should not be dominated by the actions of the long dead.

The "waiting" theory, of course, simply seeks to justify interest rather than
explain its origin. If the capitalist really **did** deserve an income as a
reward for their abstinence, where does it come from? It cannot be created
passively, merely by the decision to save, so interest exists because the
exploitation of labour exists. As Joan Robinson summarised:

> _"Obviously, the reward of saving is owning some more wealth. One of the
> advantages, though by no means the only one, of owning wealth is the
> possibility of getting interest on it.  
>  _
>
> _"But why is it possible to get interest? Because businesses make profits
> and are willing to borrow."_ [ **Collected Economic Papers** , vol. 5, p.
> 36]

This is the key. If ones ability and willingness to "wait" is dependent on
social facts (such as available resources, ones class, etc.), then interest
cannot be based upon subjective evaluations, as these are not the independent
factor. In other words, saving does not express "waiting", it simply expresses
the extent of inequality and interest expresses the fact that workers have to
sell their labour to others in order to survive:

> _"The notion that human beings discount the future certainly seems to
> correspond to everyone's subjective experience, but the conclusion drawn
> from it is a **non sequitor** , for most people have enough sense to want to
> be able to exercise consuming power as long as fate permits, and many people
> are in the situation of having a higher income in the present than they
> expect in the future (salary earners will have to retire, business may be
> better now than it seems likely to be later, etc.) and many look beyond
> their own lifetime and wish to leave consuming power to their heirs. Thus a
> great many . . . are eagerly looking for a reliable vehicle to carry
> purchasing power into the future . . . It is impossible to say what price
> would rule if there were a market for present **versus** future purchasing
> power, unaffected by any other influence except the desires of individuals
> about the time-pattern of their consumption. It might will be such a market
> would normally yield a negative rate of discount . . .  
>  _
>
> _"The rate of interest is normally positive for a quite different reason.
> Present purchasing power is valuable partly because, under the capitalist
> rules of the game, it permits its owner . . . to employ labour and undertake
> production which will yield a surplus of receipts over costs. In an economy
> in which the rate of profit is expected to be positive, the rate of interest
> is positive . . . [and so] the present value of purchasing power exceeds its
> future value to the corresponding extent. . . This is nothing whatever to do
> with the subjective **rate of discount of the future** of the individual
> concerned. . ."_ [ **The Accumulation of Capital** , p. 395]

So, interest has little to do with "waiting" and a lot more to do with the
inequalities associated with the capitalist system. In effect, the "waiting"
theory assumes what it is trying to prove. Interest is positive simply because
capitalists can appropriate surplus value from workers and so current money is
more valuable than future money because of this fact. Ironically, therefore,
the pro-capitalist theories of who abstains are wrong, _"since saving is
mainly out of profits, and real wages tend to be lower the higher the rate of
profit, the abstinence associated with saving is mainly done by the workers,
who do not receive any share in the 'reward.'"_ [Robinson, **Op. Cit.** , p.
393]

In other words, "waiting" does not produce a surplus, labour does. As such, to
_"say that those who hold financial instruments can lay claim to a portion of
the social product by abstaining or waiting provides no explanation of what
makes the production process profitable, and hence to what extent interest
claims or dividends can be paid. Reliance on a waiting theory of the return to
capital represented nothing less than a reluctance of economists to confront
the sources of value creation and analyse the process of economic
development."_ [William Lazonick, **Competitive Advantage on the Shop Floor**
, p. 267] This would involve having to analyse the social relations between
workers and managers/bosses on the shop floor, which would be to bring into
question the whole nature of capitalism and any claims it was based upon
freedom.

To summarise, the idea that interest is the "reward" for waiting simply
ignores the reality of class society and, in effect, rewards the wealthy for
being wealthy. Neo-classical economics implies that being rich is the ultimate
disutility. The hardships ("sacrifices") of having to decide to consume or
invest their riches weighs as heavily on the elite as they do on the scales of
utility. Compared to, say, working in a sweatshop, fearing unemployment
(sorry, maximising "leisure") or not having to worry about saving (as your
income just covers your out-goings) it is clear which are the greatest
sacrifices and which are rewarded accordingly under capitalism.

Much the same argument can be applied to "time-preference" theories of profit.
These argue that profits are the result of individuals preferring present
goods to future ones. Capitalists pay workers wages, allowing them to consumer
now rather than later. This is the providing of time and this is rewarded by
profits. This principle was first stated clearly by Eugen von Böhm-Bawerk and
has been taken as the basis of the "Austrian" school of capitalist economics
(see [section C.1.6](secC1.md#secc16)). After rejecting past theories of
interest (including, as noted above, "abstinence" theories, which he concluded
the socialists were right to mock), Böhm-Bawerk argued that profits could only
by explained by means of time preference:

> _" **The loan is a real exchange of present goods against future goods** . .
> . present goods invariably possess a greater value than future goods of the
> same number and kind, and therefore a definite sum of present goods can, as
> a rule, only be purchased by a larger sum of future goods. Present goods
> possess an agio in future goods. **This agio is interest.** It is not a
> separate equivalent for a separate and durable use of the loaned goods, for
> that is inconceivable; it is a part equivalent of the loaned sum, kept
> separate for practical reasons. The replacement of the capital + the
> interest constitutes the full equivalent."_ [ **Capital and Interest** , p.
> 259]

For him, time preference alone is the reason for profit/interest due to the
relative low value of future goods, compared to present goods. Capital goods,
although already present in their physical state, are really **future** goods
in their _"economic nature"_ as is labour. This means that workers are paid
the amount their labour creates in terms of **future** goods, not **current**
goods. This difference between the high value of current goods and low value
of future goods is the source of surplus value:

> _"This, and nothing else, is the foundation of the so-called 'cheap' buying
> of production instruments, and especially of labour, which the Socialists
> rightly explain as the source of profit on capital, but wrongly interpret .
> . . as the result of a robbery or exploitation of the working classes by the
> propertied classes."_ [ **The Positive Theory of Capital** , p. 301]

The capitalists are justified in keeping this surplus value because they
provided the time required for the production process to occur. Thus surplus
value is the product of an exchange, the exchange of present goods for future
ones. The capitalist bought labour at its full present value (i.e. the value
of its future product) and so there is no exploitation as the future goods are
slowly maturing during the process of production and can then be sold at its
full value as a present commodity. Profit, like interest, is seen as resulting
from varying estimates of the present and future needs.

As should be obvious, our criticisms of the "waiting" theory of interest apply
to this justification of profits. Money in itself does not produce profit any
more than interest. It can only do that when invested in **actual** means of
production which are put to work by actual people. As such, "time preference"
only makes sense in an economy where there is a class of property-less people
who are unable to "wait" for future goods as they would have died of
starvation long before they arrived.

So it is the **class** position of workers which explains their time
preferences, as Böhm-Bawerk **himself** acknowledged. Thus capitalism was
marked by an _"enormous number of wage-earners who cannot employ their labour
remuneratively by working on their own account, and are accordingly, as a
body, inclined and ready to sell the future product of their labour for a
considerably less amount of present goods."_ So, being poor, meant that they
lacked the resources to "wait" for "future" goods and so became dependent (as
a class) on those who do. This was, in his opinion the _"sole ground of that
much-talked-of and much-deplored dependence of labourer on capitalist."_ It is
_"only because the labourers cannot wait till the roundabout process . . .
delivers up its products ready for consumption, that they become economically
dependent on the capitalists who already hold in their possession what we have
called 'intermediate products.'"_ [ **Op. Cit.** , p. 330 and p. 83]

Böhm-Bawerk, ironically, simply repeats (although in different words) **and
agrees** with the socialist critique of capitalism which, as we discussed in
[section C.2.2](secC2.md#secc22), is also rooted in the class dependence of
workers to capitalists (Bakunin, for example, argued that the capitalists were
_"profiting by the economic dependence of the worker"_ in order to exploit
them by _"turn[ing] the worker into a subordinate."_ [ **The Political
Philosophy of Bakunin** , p. 188]). The difference is that Böhm-Bawerk thinks
that the capitalists deserve their income from wealth while anarchists, like
other socialists, argue they do not as they simply are being rewarded for
being wealthy. Böhm-Bawerk simply cannot bring himself to acknowledge that an
individual's psychology, their subjective evaluations, are conditioned by
their social circumstances and so cannot comprehend the **class** character of
capitalism and profit. After all, a landless worker will, of course, estimate
the "sacrifice" or "disutility" of selling their labour to a master as much
less than the peasant farmer or artisan who possesses their own land or tools.
The same can be said of workers organised into a union.

As such, Böhm-Bawerk ignores the obvious, that the source of non-labour income
is not in individual subjective evaluations but rather the **social** system
within which people live. The worker does not sell her labour power because
she "underestimates" the value of future goods but because she lacks the means
of obtaining any sort of goods at all except by the selling of her labour
power. There is no real choice between producing for herself or working for a
boss -- she has no real opportunity of doing the former at all and so **has**
to do the latter. This means that workers sells their labour (future goods)
"voluntarily" for an amount less than its value (present goods) because their
class position ensures that they cannot "wait." So, if profit is the price of
time, then it is a monopoly price produced by the class monopoly of wealth
ownership under capitalism. Needless to say, as capital is accumulated from
surplus value, the dependence of the working class on the capitalists will
tend to grow over time as the "waiting" required to go into business will tend
to increase also.

An additional irony of Böhm-Bawerk's argument is that is very similar to the
"abstinence" theory he so rightly mocked and which he admitted the socialists
were right to reject. This can be seen from one of his followers,
right-"libertarian" Murray Rothbard:

> _"What has been the contribution of these product-owners, or 'capitalists',
> to the production process? It is this: the saving and restriction of
> consumption, instead of being done by the owners of land and labour, has
> been done by the **capitalists.** The capitalists originally saved, say, 95
> ounces of gold which they could have then spent on consumers' goods. They
> refrained from doing so, however, and, instead, **advanced** the money to
> the original owners of the factors. They **paid** the latter for their
> services while they were working, thus advancing them money before the
> product was actually produced and sold to the consumers. The capitalists,
> therefore, made an essential contribution to production. They relieved the
> owners of the original factors from the necessity of sacrificing present
> goods and waiting for future goods."_ [ **Man, Economy, and State** , pp.
> 294-95]

This meant that without risk, _"[e]ven if financial returns and consumer
demand are certain, **the capitalists are still providing present goods to the
owners of labour and land** and thus relieving them of the burden of waiting
until the future goods are produced and finally transformed into consumers'
goods."_ [ **Op. Cit.** , p. 298] Capitalists pay out, say, £100,000 this year
in wages and reap £200,000 next year not because of exploitation but because
both parties prefer this amount of money this year rather than next year.
Capitalists, in other words, pay out wages in advance and then wait for a
sale. They will only do so if compensated by profit.

Rothbard's argument simply assumes a **class** system in which there is a
minority of rich and a majority of property-less workers. The reason why
workers cannot "wait" is because if they did they would starve to death.
Unsurprisingly, then, they prefer their wages now rather than next year.
Similarly, the reason why they do not save and form their own co-operatives is
that they simply cannot "wait" until their workplace is ready and their
products are sold before eating and paying rent. In other words, their
decisions are rooted in their class position while the capitalists (the rich)
have shouldered the "burden" of abstinence so that they can be rewarded with
even more money in the future. Clearly, the time preference position and the
"waiting" or "abstinence" perspective are basically the same (Rothbard even
echoes Senior's lament about the improvident working class, arguing that _"the
major problem with the lower-class poor is irresponsible present-mindedness."_
[ **For a New Liberty** , p. 154]). As such, it is subject to the same
critique (as can be found in, say, the works of a certain Eugen von Böhm-
Bawerk).

In other words, profit has a **social** basis, rooted in the different
economic situation of classes within capitalism. It is not the fact of
"waiting" which causes profits but rather the monopoly of the means of life by
the capitalist class which is the basis of _"economic dependence."_ Any
economic theory which fails to acknowledge and analyse this social inequality
is doomed to failure from the start.

To conclude, the arguments that "waiting" or "time preference" explain or
justify surplus value are deeply flawed simply because they ignore the reality
of class society. By focusing on individual subjective evaluations, they
ignore the social context in which these decisions are made and, as a result,
fail to take into account the class character of interest and profit. In
effect, they argue that the wealthy deserve a reward for being wealthy.
Whether it is to justify profits or interest, the arguments used simply show
that we have an economic system that works only by bribing the rich!

## C.2.8 Are profits the result of entrepreneurial activity and innovation?

One of the more common arguments in favour of profits is the notion that they
are the result of innovation or entrepreneurial activity, that the creative
spirit of the capitalist innovates profits into existence. This perspective is
usually associated with the so-called "Austrian" school of capitalist
economics but has become more common in the mainstream of economics,
particularly since the 1970s.

There are two related themes in this defence of profits -- innovation and
entrepreneurial activity. While related, they differ in one key way. The
former (associated with Joseph Schumpeter) is rooted in production while the
former seeks to be of more general application. Both are based on the idea of
"discovery", the subjective process by which people use their knowledge to
identify gaps in the market, new products or services or new means of
producing existing goods. When entrepreneurs discover, for example, a use of
resources, they bring these resources into a new (economic) existence.
Accordingly, they have created something **ex nihilo** (out of nothing) and
therefore are entitled to the associated profit on generally accepted moral
principle of _"finders keepers."_

Anarchists, needless to say, have some issues with such an analysis. The most
obvious objection is that while _"finders keepers"_ may be an acceptable
ethical position on the playground, it is hardly a firm basis to justify an
economic system marked by inequalities of liberty and wealth. Moreover,
discovering something does **not** entitle you to an income from it. Take, for
example, someone who discovers a flower in a wood. That, in itself, will
generate no income of any kind. Unless the flower is picked and taken to a
market, the discoverer cannot "profit" from discovering it. If the flower is
left untouched then it is available for others to appropriate unless some
means are used to stop them (such as guarding the flower). This means, of
course, limiting the discovery potential of others, like the state enforcing
copyright stops the independent discovery of the same idea, process or
product.

As such, "discovery" is not sufficient to justify non-labour income as an idea
remains an idea unless someone applies it. To generate an income (profit) from
a discovery you need to somehow take it to the market and, under capitalism,
this means getting funds to invest in machinery and workplaces. However, these
in themselves do nothing and, consequently, workers need to be employed to
produce the goods in question. If the costs of producing these goods is less
than the market price, then a profit is made. Does this profit represent the
initial "discovery"? Hardly for without funds the idea would have remained
just that. Does the profit represent the contribution of "capital"? Hardly,
for without the labour of the workers the workplace would have remained still
and the product would have remained an idea.

Which brings us to the next obvious problem, namely that "entrepreneurial"
activity becomes meaningless when divorced from owning capital. This is
because any action which is taken to benefit an individual and involves
"discovery" is considered entrepreneurial. Successfully looking for a better
job? Your new wages are entrepreneurial profit. Indeed, successfully finding
**any** job makes the wages entrepreneurial profit. Workers successfully
organising and striking to improve their pay and conditions? An
entrepreneurial act whose higher wages are, in fact, entrepreneurial profit.
Selling your shares in one company and buying others? Any higher dividends are
entrepreneurial profit. Not selling your shares? Likewise. What income flow
could **not** be explained by "entrepreneurial" activity if we try hard
enough?

In other words, the term becomes meaningless unless it is linked to owning
capital and so any non-trivial notion of entrepreneurial activity requires
private property, i.e. property which functions as capital. This can be seen
from an analysis of whether entrepreneurship which is **not** linked to owning
capital or land creates surplus value (profits) or not. It is possible, for
example, that an entrepreneur can make a profit by buying cheap in one market
and selling dear in another. However, this simply redistributes existing
products and surplus value, it does not **create** them. This means that the
entrepreneur does not create something from nothing, he takes something
created by others and sells it at a higher price and so gains a slice of the
surplus value created by others. If buying high and selling low **was** the
cause of surplus value, then profits overall would be null as any gainer would
be matched by a loser. Ironically, for all its talk of being concerned about
process, this defence of entrepreneurial profits rests on the same a
**static** vision of capitalism as does neo-classical economics.

Thus entrepreneurship is inherently related to inequalities in economic power,
with those at the top of the market hierarchy having more ability to gain
benefits of it than those at the bottom. Entrepreneurship, in other words,
rather than an independent factor is rooted in social inequality. The larger
one's property, the more able they are to gather and act on information
advantages, i.e. act in as an entrepreneur. Moreover the ability to exercise
the entrepreneurial spirit or innovate is restricted by the class system of
capitalism. To implement a new idea, you need money. As it is extremely
difficult for entrepreneurs to act on the opportunities they have observed
without the ownership of property, so profits due to innovation simply becomes
yet another reward for already being wealthy or, at best, being able to
convince the wealthy to loan you money in the expectation of a return. Given
that credit is unlikely to be forthcoming to those without collateral (and
most working class people are asset-poor), entrepreneurs are almost always
capitalists because of social inequality. Entrepreneurial opportunities are,
therefore, not available to everyone and so it is inherently linked to private
property (i.e. capital).

So while entrepreneurship in the abstract may help explain the distribution of
income, it neither explains why surplus value exists in the first place nor
does it justify the entrepreneur's appropriation of part of that surplus. To
explain why surplus value exists and why capitalists may be justified in
keeping it, we need to look at the other aspect of entrepreneurship,
innovation as this is rooted in the actual production process.

Innovation occurs in order to expand profits and so survive competition from
other companies. While profits can be redistributed in circulation (for
example by oligopolistic competition or inflation) this can only occur at the
expense of other people or capitals (see sections [C.5](secC5.md) and
[C.7](secC7.md)). Innovation, however, allows the generation of profits
directly from the new or increased productivity (i.e. exploitation) of labour
it allows. This is because it is in production that commodities, and so
profits, are created and innovation results in new products and/or new
production methods. New products mean that the company can reap excess profits
until competitors enter the new market and force the market price down by
competition. New production methods allow the intensity of labour to be
increased, meaning that workers do more work relative to their wages (in other
words, the cost of production falls relative to the market price, meaning
extra profits).

So while competition ensures that capitalist firms innovate, innovation is the
means by which companies can get an edge in the market. This is because
innovation means that _"capitalist excess profits come from the production
process. . . when there is an above-average rise in labour productivity; the
reduced costs then enable firms to earn higher than average profits in their
products. But this form of excess profits is only temporary and disappears
again when improved production methods become more general."_ [Paul Mattick,
**Economics, Politics and the Age of Inflation** , p. 38] Capitalists, of
course, use a number of techniques to stop the spread of new products or
production methods in order to maintain their position, such as state enforced
intellectual property rights.

Innovation as the source of profits is usually associated with economist
Joseph Schumpeter who described and praised capitalism's genius for _"creative
destruction"_ caused by capitalists who innovate, i.e. introduce new goods and
means of production. Schumpeter's analysis of capitalism is more realistic
than the standard neo-classical perspective. He recognised that capitalism was
marked by a business cycle which he argued flowed from cycles of innovation
conducted by capitalists. He also rejected the neo-classical assumption of
perfect competition, arguing that the _"introduction of new methods of
production and new commodities is hardly compatible with perfect and perfectly
prompt competition from the start . . . As a matter of fact, perfect
competition has always been temporarily stemmed whenever anything new is being
introduced."_ [ **Capitalism, Socialism and Democracy** , p. 104]

This analysis presents a picture of capitalism more like it actually is rather
than what economics would like it to be. However, this does not mean that its
justification for profits is correct, far from it. Anarchists do agree that it
is true that individuals do see new potential and act in innovative ways to
create new products or processes. However, this is not the source of surplus
value. This is because an innovation only becomes a source of profits once it
actually produced, i.e. once workers have toiled to create it (in the case of
new goods) or used it (in the case of new production techniques). An idea in
and of itself produces nothing unless it is applied. The reason why profits
result from innovation is due to the way the capitalist firm is organised
rather than any inherent aspect of innovation.

Ultimately, entrepreneurialism is just a fancy name for decision making and,
as such, it is a **labour** income (labour refers to physical **and** mental
activities). However, as noted above, there are two types of labour under
capitalism, the labour of production and the labour of exploitation. Looking
at entrepreneurialism in a workplace situation, it is obvious that it is
**not** independent of owning or managing capital and so it is impossible to
distinguish profits produced by "entrepreneurial" activity and profits
resulting from a return on property (and so the labour of others). In other
words, it is the labour of exploitation and any income from it is simply
monopoly profit. This is because the capitalist or manager has a monopoly of
power within the workplace and, consequently, can reap the benefits this
privileged position ensures. The workers have their opportunities for
entrepreneurialism restricted and monopolised by the few in power who, when
deciding who contributes most to production, strangely enough decide it is
themselves.

This can be seen from the fact that innovation in terms of new technology is
used to help win the class war at the point of production for the capitalists.
As the aim of capitalist production is to maximise the profits available for
capitalists and management to control, it follows that capitalism will
introduce technology that will allow more surplus value to be extracted from
workers. As Cornelius Castoriadis argues, capitalism _"does not utilise a
socially neutral technology for capitalist ends. Capitalism has created
capitalist technology, which is by no means neutral. The real essence of
capitalist technology is not to develop production for production's sake: It
is to subordinate and dominate the producers."_ [ **Political and Social
Writings** , vol. 2, p. 104] Therefore, "innovation" (technological
improvement) can be used to increase the power of capital over the workforce,
to ensure that workers will do as they are told. In this way innovation can
maximise surplus value production by trying to increase domination during
working hours as well as by increasing productivity by new processes.

These attempts to increase profits by using innovation is the key to
capitalist expansion and accumulation. As such innovation plays a key role
within the capitalist system. However, the source of profits does not change
and remains in the labour, skills and creativity of workers in the workplace.
As such, innovation results in profits because labour is exploited in the
production process, **not** due to some magical property of innovation.

The question now arises whether profits are justified as a reward for those
who made the decision to innovate in the first place. This, however, fails for
the obvious reason that capitalism is marked by a hierarchical organisation of
production. It is designed so that a few make all the decisions while the
majority are excluded from power. As such, to say that capitalists or managers
deserve their profits due to innovation is begging the question. Profits which
are claimed to flow from innovation are, in fact, the reward for having a
monopoly, namely the monopoly of decision making within the workplace, rather
than some actual contribution to production. The only thing management does is
decide which innovations to pursue and to reap the benefits they create. In
other words, they gain a reward simply due to their monopoly of decision
making power within a firm. Yet this hierarchy only exists because of
capitalism and so can hardly be used to defend that system and the
appropriation of surplus value by capitalists.

Thus, if entrepreneurial spirit is the source of profit then we can reply that
under capitalism the means of exercising that spirit is monopolised by certain
classes and structures. The monopoly of decision making power in the hands of
managers and bosses in a capitalist firm ensure that they also monopolise the
rewards of the entrepreneurialism their workforce produce. This, in turn,
reduces the scope for innovation as this division of society into people who
do mental and physical labour _"destroy[s] the love of work and the capacity
for invention"_ and under such a system, the worker _"lose[s] his intelligence
and his spirit of invention."_ [Kropotkin, **The Conquest of Bread** , p. 183
and p. 181]

These issues should be a key concern **if** entrepreneurialism **really** were
considered as the unique source of profit. However, such issues as management
power is rarely, if ever, discussed by the Austrian school. While they thunder
against state restrictions on entrepreneurial activity, boss and management
restrictions are always defended (if mentioned at all). Similarly, they argue
that state intervention (say, anti-monopoly laws) can only harm consumers as
it tends to discourage entrepreneurial activity yet ignore the restrictions to
entrepreneurship imposed by inequality, the hierarchical structure of the
capitalist workplace and negative effects both have on individuals and their
development (as discussed in [section B.1.1](secB1.md#secb11)).

This, we must stress, is the key problem with the idea that innovation is the
root of surplus value. It focuses attention to the top of the capitalist
hierarchy, to business leaders. This implies that they, the bosses, create
"wealth" and without them nothing would be done. For example, leading
"Austrian" economist Israel Kirzner talks of _"the necessarily indivisible
entrepreneur"_ who _"is responsible for the entire product, The contributions
of the factor inputs, being without an entrepreneurial component, are
irrelevant for the ethical position being taken."_ [ _"Producer, Entrepreneur,
and the Right to Property,"_ pp. 185-199, **Perception, Opportunity, and
Profit** , p. 195] The workforce is part of the _"factor inputs"_ who are
considered _"irrelevant."_ He quotes economist Frank Knight to bolster this
analysis that the entrepreneur solely creates wealth and, consequently,
deserves his profits:

> _"Under the enterprise system, a special social class, the businessman,
> direct economic activity: **they are in the strict sense the producers,
> while the great mass of the population merely furnishes them with productive
> services, placing their persons and their property at the disposal of this
> class.** "_ [quoted by Kirzner, **Op. Cit.** , p. 189]

If, as Chomsky stresses, the capitalist firm is organised in a fascist way,
the "entrepreneurial" defence of profits is its ideology, its
**"Führerprinzip"** (the German for _"leader principle"_ ). This ideology sees
each organisation as a hierarchy of leaders, where every leader (Führer, in
German) has absolute responsibility in his own area, demands absolute
obedience from those below him and answers only to his superiors. This
ideology was most infamously applied by fascism but its roots lie in military
organisations which continue to use a similar authority structure today.

Usually defenders of capitalism contrast the joys of "individualism" with the
evils of "collectivism" in which the individual is sub-merged into the group
or collective and is made to work for the benefit of the group. Yet when it
comes to capitalist industry, they stress the abilities of the people at the
top of the company, the owner, the entrepreneur, and treat as unpeople those
who do the actual work (and ignore the very real subordination of those lower
down the hierarchy). The entrepreneur is considered the driving force of the
market process and the organisations and people they govern are ignored,
leading to the impression that the accomplishments of a firm are the personal
triumphs of the capitalists, as though their subordinates are merely tools not
unlike the machines on which they labour.

The ironic thing about this argument is that if it were true, then the economy
would grind to a halt (we discuss this more fully in our critique of Engels's
diatribe against anarchism _"On Authority"_ in [section
H.4.4](secH4.md#sech44)). It exposes a distinct contradiction within
capitalism. While the advocates of entrepreneurialism assert that the
entrepreneur is the only real producer of wealth in society, the fact is that
the entrepreneurialism of the workforce industry is required to implement the
decisions made by the bosses. Without this unacknowledged input, the
entrepreneur would be impotent. Kropotkin recognised this fact when he talked
of the workers _"who have added to the original invention"_ little additions
and contributions _"without which the most fertile idea would remain
fruitless."_ Nor does the idea itself develop out of nothing as _"every
invention is a synthesis, the resultant of innumerable inventions which have
preceded it."_ [ **Op. Cit.** , p. 30] Thus Cornelius Castoriadis:

> _"The capitalist organisation of production is profoundly contradictory . .
> . It claims to reduce the worker to a limited and determined set of tasks,
> but it is obliged at the same time to rely upon the universal capacities he
> develops both as a function of and in opposition to the situation in which
> he is placed . . . Production can be carried out only insofar as the worker
> himself organises his work and goes beyond his theoretical role of pure and
> simply executant,"_ [ **Political and Social Writings** , vol. 2, p. 181]

Moreover, such a hierarchical organisation cannot help but generate wasted
potential. Most innovation is the cumulative effect of lots of incremental
process improvements and the people most qualified to identify opportunities
for such improvements are, obviously, those involved in the process. In the
hierarchical capitalist firm, those most aware of what would improve
efficiency have the least power to do anything about it. They also have the
least incentive as well as any productivity increases resulting from their
improvements will almost always enrich their bosses and investors, not them.
Indeed, any gains may be translated into layoffs, soaring stock prices, and
senior management awarding itself a huge bonus for "cutting costs." What
worker in his right mind would do something to help their worst enemy? As
such, capitalism hinders innovation:

> _"capitalism divides society into a narrow stratum of directors (whose
> function is to decide and organise everything) and the vast majority of the
> population, who are reduced to carrying out (executing) the decisions made
> by these directors. As a result of this very fact, most people experience
> their own lives as something alien to them . . . It is nonsensical to seek
> to organise people . . . as if they were mere objects . . . In real life,
> capitalism is obliged to base itself on people's capacity for self-
> organisation, on the individual and collective creativity of the producers.
> Without making use of these abilities the system would not survive a day.
> But the whole 'official' organisation of modern society both ignores and
> seeks to suppress these abilities to the utmost. The result is not only an
> enormous waste due to untapped capacity. The system does more: It
> **necessarily** engenders opposition, a struggle against it by those upon
> whom it seeks to impose itself . . . The net result is not only waste but
> perpetual conflict."_ [Castoriadis, **Op. Cit.** , p. 93]

While workers make the product and make entrepreneurial decisions every day,
in the face of opposition of the company hierarchy, the benefits of those
decisions are monopolised by the few who take all the glory for themselves.
The question now becomes, why should capitalists and managers have a monopoly
of power and profits when, in practice, they do not and cannot have a monopoly
of entrepreneurialism within a workplace? If the output of a workplace is the
result of the combined mental and physical activity (entrepreneurialism) of
all workers, there is no justification either for the product or "innovation"
(i.e. decision making power) to be monopolised by the few.

We must also stress that innovation itself is a form of labour -- mental
labour. Indeed, many companies have Research and Development groups in which
workers are paid to generate new and innovative ideas for their employers.
This means that innovation is not related to property ownership at all. In
most modern industries, as Schumpeter himself acknowledged, innovation and
technical progress is conducted by _"teams of trained specialists, who turn
out what is required and make it work in predictable ways"_ and so _"[b]ureau
and committee work tends to replace individual action."_ This meant that _"the
leading man . . . is becoming just another office worker -- and one who is not
always difficult to replace."_ [ **Op. Cit.** , p. 133] And we must also point
out that many new innovations come from individuals who combine mental and
physical labour outside of capitalist companies. Given this, it is difficult
to argue that profits are the result of innovation of a few exceptional people
rather than by workers when the innovations, as well as being worked or
produced by workers are themselves are created by teams of workers.

As such, "innovation" and "entrepreneurialism" is not limited to a few great
people but rather exists in all of us. While the few may currently monopolise
"entrepreneurialism" for their own benefit, an economy does not need to work
this way. Decision making need **not** be centralised in a few hands. Ordinary
workers can manage their own productive activity, innovate and make decisions
to meet social and individual needs (i.e. practice "entrepreneurialism"). This
can be seen from various experiments in workers' control where increased
equality within the workplace actually increases productivity and innovation.
As these experiments show workers, when given the chance, can develop numerous
"good ideas" **and** , equally as important, produce them. A capitalist with a
"good idea," on the other hand, would be powerless to produce it without
workers and it is this fact that shows that innovation, in and of itself, is
not the source of surplus value.

So, contrary to much capitalist apologetics, innovation is not the monopoly of
an elite class of humans. It is part of all of us, although the necessary
social environment needed to nurture and develop it in all is crushed by the
authoritarian workplaces of capitalism and the effects of inequalities of
wealth and power within society as a whole. If workers were truly incapable of
innovation, any shift toward greater control of production by workers should
result in decreased productivity. What one actually finds, however, is just
the opposite: productivity increased dramatically as ordinary people were
given the chance, usually denied them, to apply their skills and talents. They
show the kind of ingenuity and creativity people naturally bring to a
challenging situation -- if they are allowed to, if they are participants
rather than servants or subordinates.

In fact, there is _"a growing body of empirical literature that is generally
supportive of claims for the economic efficiency of the labour-managed firm.
Much of this literature focuses on productivity, frequently finding it to be
positively correlated with increasing levels of participation . . . Studies
that encompass a range of issues broader than the purely economic also tend to
support claims for the efficiency of labour managed and worker-controlled
firms . . . In addition, studies that compare the economic preference of
groups of traditionally and worker-controlled forms point to the stronger
performance of the latter."_ [Christopher Eaton Gunn, **Workers' Self-
Management in the United States** , pp. 42-3] This is confirmed by David
Noble, who points out that _"the self-serving claim"_ that _"centralised
management authority is the key to productivity"_ is _"belied by nearly every
sociological study of work."_ [ **Progress without People** , p. 65]

During the Spanish Revolution of 1936-39, workers self-managed many factories
following the principles of participatory democracy. Productivity and
innovation in the Spanish collectives was exceptionally high (particularly
given the difficult economic and political situation they faced). As Jose
Peirats notes, industry was _"transformed from top to bottom . . . there were
achieved feats pregnant with significance for people who had always striven to
deny the reality of the wealth of popular initiatives unveiled by
revolutions."_ Workers made suggestions and presented new inventions,
_"offering the product of their discoveries, genius or imaginings."_ [ **The
CNT in the Spanish Revolution** , vol. 2, p. 86]

The metal-working industry is a good example. As Augustine Souchy observes, at
the outbreak of the Civil War, the metal industry in Catalonia was _"very
poorly developed."_ Yet within months, the Catalonian metal workers had
rebuilt the industry from scratch, converting factories to the production of
war materials for the anti-fascist troops. A few days after the July 19th
revolution, the Hispano-Suiza Automobile Company was already converted to the
manufacture of armoured cars, ambulances, weapons, and munitions for the
fighting front. _"Experts were truly astounded,"_ Souchy writes, _"at the
expertise of the workers in building new machinery for the manufacture of arms
and munitions. Very few machines were imported. In a short time, two hundred
different hydraulic presses of up to 250 tons pressure, one hundred seventy-
eight revolving lathes, and hundreds of milling machines and boring machines
were built."_ [ **The Anarchist Collectives: Workers' Self-management in the
Spanish Revolution, 1936-1939** , Sam Dolgoff (ed.), p. 96]

Similarly, there was virtually no optical industry in Spain before the July
revolution, only some scattered workshops. After the revolution, the small
workshops were voluntarily converted into a production collective. _"The
greatest innovation,"_ according to Souchy, _"was the construction of a new
factory for optical apparatuses and instruments. The whole operation was
financed by the voluntary contributions of the workers. In a short time the
factory turned out opera glasses, telemeters, binoculars, surveying
instruments, industrial glassware in different colours, and certain scientific
instruments. It also manufactured and repaired optical equipment for the
fighting fronts . . . What private capitalists failed to do was accomplished
by the creative capacity of the members of the Optical Workers' Union of the
CNT."_ [ **Op. Cit.** , pp. 98-99]

More recently, the positive impact of workers' control has been strikingly
confirmed in studies of the Mondragon co-operatives in Spain, where workers
are democratically involved in production decisions and encouraged to
innovate. As George Bennello notes, _"Mondragon productivity is very high --
higher than in its capitalist counterparts. Efficiency, measured as the ratio
of utilised resources -- capital and labour -- to output, is far higher than
in comparable capitalist factories."_ [ _"The Challenge of Mondragon"_ ,
**Reinventing Anarchy, Again** , p. 216]

The example of Lucas Aerospace, during the 1970s indicates well the creative
potential waiting to be utilised and wasted due to capitalism. Faced with
massive job cuts and restructuring, the workers and their Shop Stewards SSCC
in 1976 proposed an alternative Corporate Plan to Lucas's management. This was
the product of two years planning and debate among Lucas workers. Everyone
from unionised engineers, to technicians to production workers and secretaries
was involved in drawing it up. It was based on detailed information on the
machinery and equipment that all Lucas sites had, as well as the type of
skills that were in the company. The workers designed the products themselves,
using their own experiences of work and life. While its central aim was to
head off Lucas's planned job cuts, it presented a vision of a better world by
arguing that the concentration on military goods and markets was neither the
best use of resources nor in itself desirable. It argued that if Lucas was to
look away from military production it could expand into markets for socially
useful goods (such as medical equipment) where it already had some expertise
and sales. The management were not interested, it was their to "manage" Lucas
and to decide where its resources would be used, including the 18,000 people
working there. Management were more than happy to exclude the workforce from
any say in such fundamental matter as implementing the workers' ideas would
have shown how unnecessary they, the bosses, actually were.

Another example of wasted worker innovation is provided by the US car
industry. In the 1960s, Walter Reuther, president of the United Auto Workers
(UAW) had proposed to the Johnson Whitehouse that the government help the US
car companies to produce small cars, competing with Volkswagen which had
enjoyed phenomenal success in the U.S. market. The project, unsurprisingly,
fell through as the executives of the car companies were uninterested. In the
1970s, higher petrol prices saw US buyers opt for smaller cars and the big US
manufacturers were caught unprepared. This allowed Toyota, Honda and other
Asian car companies to gain a crucial foothold in the American market.
Unsurprisingly, resistance by the union and workforce were blamed for the
industry's problems when, in fact, it was the bosses, not the unions, who were
blind to a potential market niche and the industry's competitive challenges.

Therefore, far from being a threat to innovation, workers' self-management
would increase it and, more importantly, direct it towards improving the
quality of life for all as opposed to increasing the profits of the few (this
aspect an anarchist society will be discussed in more detail in [section
I](secIcon.md)). This should be unsurprising, as vesting a minority with
managerial authority and deciding that the others should be cogs results in a
massive loss of social initiative and drive. In addition, see sections
[J.5.10](secJ5.md#secj510), [J.5.11](secJ5.md#secj511) and
[J.5.12](secJ5.md#secj512) for more on why anarchists support self-
management and why, in spite of its higher efficiency and productivity, the
capitalist market will select against it.

To conclude, capitalist workplace hierarchy actually hinders innovation and
efficiency rather than fosters it. To defend profits by appealing to
innovation is, in such circumstances, deeply ironic. Not only does it end up
simply justifying profits in terms of monopoly power (i.e. hierarchical
decision making rewarding itself), that power also wastes a huge amount of
potential innovation in society -- namely the ideas and experience of the
workforce excluded from the decision making process. Given that power produces
resistance, capitalism ensures that the _"creative faculties [the workers] are
not allowed to exercise **on behalf** of a social order that rejects them (and
which they reject) are now utilised **against** that social order"_ and so
_"work under capitalism"_ is _"a perpetual waste of creative capacity, and a
constant struggle between the worker and his own activity."_ [Castoriadis,
**Op. Cit.** , p. 93 and p. 94]

Therefore, rather than being a defence of capitalist profit taking (and the
inequality it generates) innovation backfires against capitalism. Innovation
flourishes best under freedom and this points towards libertarian socialism
and workers' self-management. Given the chance, workers can manage their own
work and this results in increased innovation and productivity, so showing
that capitalist monopoly of decision making power hinders both. This is
unsurprising, for only equality can maximise liberty and so workers' control
(rather than capitalist power) is the key to innovation. Only those who
confuse freedom with the oppression of wage labour would be surprised by this.

## C.2.9 Do profits reflect a reward for risk?

Another common justification of surplus value is that of "risk taking", namely
the notion that non-labour income is justified because its owners took a risk
in providing money and deserve a reward for so doing.

Before discussing why anarchists reject this argument, it must be noted that
in the mainstream neo-classical model, risk and uncertainty plays no role in
generating profits. According to general equilibrium theory, there is no
uncertainty (the present and future are known) and so there is no role for
risk. As such, the concept of profits being related to risk is more realistic
than the standard model. However, as we will argue, such an argument is
unrealistic in many other ways, particularly in relation to modern-day
corporate capitalism.

It is fair to say that the appeal of risk to explain and justify profits lies
almost entirely in the example of the small investor who gambles their savings
(for example, by opening a bar) and face a major risk if the investment does
not succeed. However, in spite of the emotional appeal of such examples,
anarchists argue that they are hardly typical of investment decisions and
rewards within capitalism. In fact, such examples are used precisely to draw
attention away from the way the system works rather than provide an insight
into it. That is, the higher apparent realism of the argument hides an equally
unreal model of capitalism as the more obviously unrealistic theories which
seek to rationalise non-labour income.

So does "risk" explain or justify non-labour income? No, anarchists argue.
This is for five reasons. Firstly, the returns on property income are utterly
independent on the amount of risk involved. Secondly, all human acts involve
risk of some kind and so why should property owners gain exclusively from it?
Thirdly, risk as such it not rewarded, only **successful** risks are and what
constitutes success is dependent on production, i.e. exploiting labour.
Fourthly, most "risk" related non-labour income today plays **no** part in
aiding production and, indeed, is simply not that risky due to state
intervention. Fifthly, risk in this context is not independent of owning
capital and, consequently, the arguments against "waiting" and innovation
apply equally to this rationale. In other words, "risk" is simply yet another
excuse to reward the rich for being wealthy.

The first objection is the most obvious. It is a joke to suggest that
capitalism rewards in proportion to risk. There is little or no relationship
between income and the risk that person faces. Indeed, it would be fairer to
say that return is **inversely** proportional to the amount of risk a person
faces. The most obvious example is that of a worker who wants to be their own
boss and sets up their own business. That is a genuine risk, as they are
risking their savings and are willing to go into debt. Compare this to a
billionaire investor with millions of shares in hundreds of companies. While
the former struggles to make a living, the latter gets a large regular flow of
income without raising a finger. In terms of risk, the investor is wealthy
enough to have spread their money so far that, in practical terms, there is
none. Who has the larger income?

As such, the risk people face is dependent on their existing wealth and so it
is impossible to determine any relationship between it and the income it is
claimed to generate. Given that risk is inherently subjective, there is no way
of discovering its laws of operation except by begging the question and using
the actual rate of profits to measure the cost of risk-bearing.

The second objection is equally as obvious. The suggestion that risk taking is
the source and justification for profits ignores the fact that virtually all
human activity involves risk. To claim that capitalists should be paid for the
risks associated with investment is to implicitly state that money is more
valuable that human life. After all, workers risk their health and often their
lives in work and often the most dangerous workplaces are those associated
with the lowest pay. Moreover, providing safe working conditions can eat into
profits and by cutting health and safety costs, profits can rise. This means
that to reward capitalist "risk", the risk workers face may actually increase.
In the inverted world of capitalist ethics, it is usually cheaper (or more
"efficient") to replace an individual worker than a capital investment. Unlike
investors, bosses and the corporate elite, workers **do** face risk to life or
limb daily as part of their work. Life is risky and no life is more risky that
that of a worker who may be ruined by the "risky" decisions of management,
capitalists and investors seeking to make their next million. While it is
possible to diversify the risk in holding a stock portfolio that is not
possible with a job. A job cannot be spread across a wide array of companies
diversifying risk.

In other words, workers face much greater risks than their employers and,
moreover, they have no say in what risks will be taken with their lives and
livelihoods. It is workers who pay the lion's share of the costs of failure,
not management and stockholders. When firms are in difficulty, it is the
workers who are asked to pay for the failures of management though pay cuts
and the elimination of health and other benefits. Management rarely get pay
cuts, indeed they often get bonuses and "incentive" schemes to get them to do
the work they were (over) paid to do in the first. When a corporate manager
makes a mistake and their business actually fails, his workers will suffer far
more serious consequences than him. In most cases, the manager will still live
comfortably (indeed, many will receive extremely generous severance packages)
while workers will face the fear, insecurity and hardship of having to find a
new job. Indeed, as we argued in [section C.2.1](secC2.md#secc21), it is the
risk of unemployment that is a key factor in ensuring the exploitation of
labour in the first place.

As production is inherently collective under capitalism, so must be the risk.
As Proudhon put it, it may be argued that the capitalist _"alone runs the risk
of the enterprise"_ but this ignores the fact that capitalist cannot _"alone
work a mine or run a railroad"_ nor _"alone carry on a factory, sail a ship,
play a tragedy, build the Pantheon."_ He asked: _"Can anybody do such things
as these, even if he has all the capital necessary?"_ And so _"association"_
becomes _"absolutely necessary and right"_ as the _"work to be accomplished"_
is _"the common and undivided property of all those who take part therein."_
If not, shareholders would _"plunder the bodies and souls of the wage-
workers"_ and it would be _"an outrage upon human dignity and personality."_ [
**General Idea of the Revolution** , p. 219] In other words, as production is
collective, so is the risk faced and, consequently, risk cannot be used to
justify excluding people from controlling their own working lives or the fruit
of their labour.

This brings us to the third reason, namely how "risk" contributes to
production. The idea that "risk" is a contribution to production is equally
flawed. Obviously, no one argues that **failed** investments should result in
investors being rewarded for the risks they took. This means that
**successful** risks are what counts and this means that the company has
produced a desired good or service. In other words, the argument for risk is
dependent on the investor providing capital which the workers of the company
used productivity to create a commodity. However, as we discussed in [section
C.2.4](secC2.md#secc24) capital is **not** productive and, as a result, an
investor may expect the return of their initial investment but no more. At
best, the investor has allowed others to use their money but, as [section
C.2.3](secC2.md#secc23) indicated, giving permission to use something is not
a productive act.

However, there is another sense in which risk does not, in general, contribute
to production within capitalism, namely finance markets. This bring us to our
fourth objection, namely that most kinds of "risks" within capitalism do
**not** contribute to production and, thanks to state aid, not that risky.

Looking at the typical "risk" associated with capitalism, namely putting money
into the stock market and buying shares, the idea that "risk" contributes to
production is seriously flawed. As David Schweickart points out, _"[i]n the
vast majority of cases, when you buy stock, you give your money not to the
company but to another private individual. You buy your share of stock from
someone who is cashing in his share. Not a nickel of your money goes to the
company itself. The company's profits would have been exactly the same, with
or without your stock purchase."_ [ **After Capitalism** , p. 37] In fact
between 1952 and 1997, about 92% of investment was paid for by firms' own
internal funds and so _"the stock market contributes virtually nothing to the
financing of outside investment."_ Even new stock offerings only accounted for
4% of non-financial corporations capital expenditures. [Doug Henwood, **Wall
Street** , p. 72] _"In spite of the stock market's large symbolic value, it is
notorious that it has relatively little to do with the production of goods and
services,"_ notes David Ellerman, _"The overwhelming bulk of stock
transactions are in second-hand shares so the capital paid for shares usually
goes to other stock traders, not to productive enterprises issuing new
shares."_ [ **The Democratic worker-owned firm** , p. 199]

In other words, most investment is simply the "risk" associated with buying a
potential income stream in an uncertain world. The buyer's action has not
contributed to producing that income stream in any way whatsoever yet it
results in a claim on the labour of others. At best, it could be said that a
previous owner of the shares at some time in the past has _"contributed"_ to
production by providing money but this does not justify non-labour income. As
such, investing in shares may rearrange existing wealth (often to the great
advantage of the rearrangers) but it does produce anything. New wealth flows
from production, the use of labour on existing wealth to create new wealth.

Ironically, the stock market (and the risk it is based on) harms this process.
The notion that dividends represent the return for "risk" may be faulted by
looking at how the markets operate in reality, rather than in theory. Stock
markets react to recent movements in the price of stock markets, causing price
movements to build upon price movements. According to academic finance
economist Bob Haugen, this results in finance markets having endogenous
instability, with such price-driven volatility accounting for over three-
quarters of all volatility in finance markets. This leads to the market
directing investments very badly as some investment is wasted in over-valued
companies and under-valued firms cannot get finance to produce useful goods.
The market's endogenous volatility reduces the overall level of investment as
investors will only fund projects which return a sufficiently high level of
return. This results in a serious drag on economic growth. As such, "risk" has
a large and negative impact on the real economy and it seems ironic to reward
such behaviour. Particularly as the high rate of return is meant to compensate
for the risk of investing in the stock market, but in fact most of this risk
results from the endogenous stability of the market itself. [Steve Keen,
**Debunking Economics** , pp. 249-50]

Appeals to "risk" to justify capitalism are somewhat ironic, given the
dominant organisational form within capitalism -- the corporation. These firms
are based on _"limited liability"_ which was designed explicitly to reduce the
risk faced by investors. As Joel Bakan notes, before this "no matter how much,
or how little, a person had invested in a company, he or she was
**personally** liable, without limit, for the company's debts. Investors'
homes, savings, and other personal assess would be exposed to claims by
creditors if a company failed, meaning that a person risked finance ruin
simply by owning shares in a company. Stockholding could not becomes a truly
attractive option . . . until that risk was removed, which it soon was. By the
middle of the nineteenth century, business leaders and politicians broadly
advocated changing the law to limit the liability of shareholders to the
amounts they had invested in a company. If a person bought $100 worth of
shares, they reasoned, he or she should be immune to liability for anything
beyond that, regardless of what happened to the company." Limited liability's
_"sole purpose . . . is to shield them from legal responsibility for
corporations' actions"_ as well as reducing the risks of investing (unlike for
small businesses). [ **The Corporation** , p. 11 and p. 79]

This means that stock holders (investors) in a corporation hold no liability
for the corporation's debts and obligations. As a result of this state granted
privilege, potential losses cannot exceed the amount which they paid for their
shares. The rationale used to justify this is the argument that without
limited liability, a creditor would not likely allow any share to be sold to a
buyer of at least equivalent creditworthiness as the seller. This means that
limited liability allows corporations to raise funds for riskier enterprises
by reducing risks and costs from the owners and shifting them onto other
members of society (i.e. an externality). It is, in effect, a state granted
privilege to trade with a limited chance of loss but with an unlimited chance
of gain.

This is an interesting double-standard. It suggests that corporations are not,
in fact, owned by shareholders at all since they take on none of the
responsibility of ownership, especially the responsibility to pay back debts.
Why should they have the privilege of getting profit during good times when
they take none of the responsibility during bad times? Corporations are
creatures of government, created with the social privileges of limited
financial liability of shareholders. Since their debts are ultimately public,
why should their profits be private?

Needless to say, this reducing of risk is not limited to within a state, it is
applied internationally as well. Big banks and corporations lend money to
developing nations but _"the people who borrowed the money [i.e. the local
elite] aren't held responsible for it. It's the people . . . who have to pay
[the debts] off . . . The lenders are protected from risk. That's one of the
main functions of the IMF, to provide risk free insurance to people who lend
and invest in risky loans. They earn high yields because there's a lot of
risk, but they don't have to take the risk, because it's socialised. It's
transferred in various ways to Northern taxpayers through the IMP and other
devices . . . The whole system is one in which the borrowers are released from
the responsibility. That's transferred to the impoverished mass of the
population in their own countries. And the lenders are protected from risk."_
[Noam Chomsky, **Propaganda and the Public Mind** , p. 125]

Capitalism, ironically enough, has developed precisely by externalising risk
and placing the burden onto other parties -- suppliers, creditors, workers
and, ultimately, society as a whole. _"Costs and risks are socialised,"_ in
other words, _"and the profit is privatised."_ [Noam Chomsky, **Op. Cit.** ,
p. 185] To then turn round and justify corporate profits in terms of risk
seems to be hypocritical in the extreme, particularly by appealing to examples
of small business people whom usually face the burdens caused by corporate
externalising of risk! Doug Henwood states the obvious when he writes
shareholder _"liabilities are limited by definition to what they paid for the
shares"_ and _"they can always sell their shares in a troubled firm, and if
they have diversified portfolios, they can handle an occasional wipe-out with
hardly a stumble. Employees, and often customers and suppliers, are rarely so
well-insulated."_ Given that the _"signals emitted by the stock market are
either irrelevant or harmful to real economic activity, and that the stock
market itself counts for little or nothing as a source of finance"_ and the
argument for risk as a defence of profits is extremely weak. [ **Op. Cit.** ,
p. 293 and p. 292]

Lastly, the risk theory of profit fails to take into account the different
risk-taking abilities of that derive from the unequal distribution of
society's wealth. As James Meade puts it, while _"property owners can spread
their risks by putting small bits of their property into a large number of
concerns, a worker cannot easily put small bits of his effort into a large
number of different jobs. This presumably is the main reason we find risk-
bearing capital hiring labour"_ and not vice versa. [quoted by David
Schweickart, **Against Capitalism** , pp. 129-130]

It should be noted that until the early nineteenth century, self-employment
was the normal state of affairs and it has declined steadily to reach, at
best, around 10% of the working population in Western countries today. It
would be inaccurate, to say the least, to explain this decline in terms of
increased unwillingness to face potential risks on the part of working people.
Rather, it is a product of increased costs to set up and run businesses which
acts as a very effect **natural** barrier to competition (see [section
C.4](secC4.md)). With limited resources available, most working people
simply **cannot** face the risk as they do not have sufficient funds in the
first place and, moreover, if such funds are found the market is hardly a
level playing field.

This means that going into business for yourself is always a possibility, but
that option is very difficult without sufficient assets. Moreover, even if
sufficient funds are found (either by savings or a loan), the risk is
extremely high due to the inability to diversify investments and the constant
possibility that larger firms will set-up shop in your area (for example, Wal-
Mart driving out small businesses or chain pubs, cafes and bars destroying
local family businesses). So it is true that there is a small flow of workers
into self-employment (sometimes called the petit bourgeoisie) and that, of
these, a small amount become full-scale capitalists. However, these are the
exceptions that prove the rule -- there is a greater return into wage slavery
as enterprises fail.

Simply put, the distribution of wealth (and so ability to take risks) is so
skewed that such possibilities are small and, in spite being highly risky, do
not provide sufficient returns to make most of them a success. That many
people **do** risk their savings and put themselves through stress, insecurity
and hardship in this way is, ironically, hardly a defence of capitalism as it
suggests that wage labour is so bad that many people will chance everything to
escape it. Sadly, this natural desire to be your own boss generally becomes,
if successful, being someone else's boss! Which means, in almost all cases, it
shows that to become rich you need to exploit other people's labour.

So, as with "waiting" (see [section C.2.7](secC2.md#secc27)), taking a risk
is much easier if you are wealthy and so risk is simply another means for
rewarding the wealthy for being wealthy. In other words, risk aversion is the
dependent, not the independent, factor. The distribution of wealth determines
the risks people willing to face and so cannot explain or justify that wealth.
Rather than individual evaluations determining "risk", these evaluations will
be dependent on the class position of the individuals involved. As Schweickart
notes, _"large numbers of people simply do not have any discretionary funds to
invest. They can't play at all . . . among those who can play, some are better
situated than others. Wealth gives access to information, expert advice, and
opportunities for diversification that the small investor often lacks."_ [
**After Capitalism** , p. 34] As such, profits do not reflect the real cost of
risk but rather the scarcity of people with anything to risk (i.e. inequality
of wealth).

Similarly, given that the capitalists (or their hired managers) have a
monopoly of decision making power within a firm, any risks made by a company
reflects that hierarchy. As such, risk and the ability to take risks are
monopolised in a few hands. If profit **is** the product of risk then,
ultimately, it is the product of a hierarchical company structure and,
consequently, capitalists are simply rewarding themselves because they have
power within the workplace. As with "innovation" and "entrepreneurialism" (see
[section C.2.8](secC2.md#secc28)), this rationale for surplus value depends
on ignoring how the workplace is structured. In other words, because managers
monopolise decision making ("risk") they also monopolise the surplus value
produced by workers. However, the former in no way justifies this
appropriation nor does it create it.

As risk is not an independent factor and so cannot be the source of profit.
Indeed other activities can involve far more risk and be rewarded less.
Needless to say, the most serious consequences of "risk" are usually suffered
by working people who can lose their jobs, health and even lives all depending
on how the risks of the wealthy turn out in an uncertain world. As such, it is
one thing to gamble your own income on a risky decision but quite another when
that decision can ruin the lives of others. If quoting Keynes is not too out
of place: _"Speculators may do no harm as bubbles on a steady stream of
enterprise. But the position is serious when enterprise becomes the bubble on
a whirlpool of speculation. When the capital development of a country becomes
a by-product of the activities of a casino, the job is likely to be ill-
done."_ [ **The General Theory of Employment, Interest and Money** , p. 159]

Appeals of risk to justify capitalism simply exposes that system as little
more than a massive casino. In order for such a system to be fair, the
participants must have approximately equal chances of winning. However, with
massive inequality the wealthy face little chance of loosing. For example, if
a millionaire and a pauper both repeatedly bet a pound on the outcome of a
coin toss, the millionaire will always win as the pauper has so little reserve
money that even a minor run of bad luck will bankrupt him.

Ultimately, _"the capitalist investment game (as a whole and usually in its
various parts) is positive sum. In most years more money is made in the
financial markets than is lost. How is this possible? It is possible only
because those who engage in real productive activity receive less than that to
which they would be entitled were they fully compensated for what they
produce. The reward, allegedly for risk, derives from this discrepancy."_
[David Schweickart, **Op. Cit.** , p. 38] In other words, people would not
risk their money unless they could make a profit and the willingness to risk
is dependent on current and expected profit levels and so cannot explain them.
To focus on risk simply obscures the influence that property has upon the
ability to enter a given industry (i.e. to take a risk in the first place) and
so distracts attention away from the essential aspects of how profits are
actually generated (i.e. away from production and its hierarchical
organisation under capitalism).

So risk does not explain how surplus value is generated nor is its origin.
Moreover, as the risk people face and the return they get is dependent on the
wealth they have, it cannot be used to justify this distribution. Quite the
opposite, as return and risk are usually inversely related. If risk was the
source of surplus value or justified it, the riskiest investment and poorest
investor would receive the highest returns and this is not the case. In
summary, the "risk" defence of capitalism does not convince.

[‹ C.1 What is wrong with economics?](secC1.md "Go to previous page")
[up](secCcon.md "Go to parent page") [C.3 What determines the distribution
between labour and capital? ›](secC3.md "Go to next page")

