# C.12 Doesn't Hong Kong show the potentials of "free market" capitalism?

Given the general lack of laissez-faire capitalism in the world, examples to
show its benefits are few and far between. Rather than admit that the ideal is
simply impossible, conservative and right-"libertarian" ideologues scour the
world and history for examples. Rarely do they let facts get in the way of
their searching -- until the example expresses some negative features such as
economic crisis (repression of working class people or rising inequality and
poverty are of little consequence). Once that happens, then all the statist
features of those economies previously ignored or downplayed will be stressed
in order to protect the ideal from reality.

One such example is Hong Kong, which is often pointed to by right-wingers as
an example of the power of capitalism and how a "pure" capitalism will benefit
all. It has regularly been ranked as first in the _"Index of Economic
Freedom"_ produced by the Heritage Foundation, a US-based conservative think
tank ("economic freedom" reflecting what you expect a right-winger would
consider important). Milton Friedman played a leading role in this
idealisation of the former UK colony. In his words:

> _"Take the fifty-year experiment in economic policy provided by Hong Kong
> between the end of World War II and . . . when Hong Kong reverted to China.  
>  _
>
> _"In this experiment, Hong Kong represents the experimental treatment . . .
> I take Britain as one control because Britain, a benevolent dictator,
> imposed different policies on Hong Kong from the ones it pursued at home . .
> ._
>
> _"Nonetheless, there are some statistics, and in 1960, the earliest date for
> which I have been able to get them, the average per capita income in Hong
> Kong was 28 percent of that in Great Britain; by 1996, it had risen to 137
> percent of that in Britain. In short, from 1960 to 1996, Hong Kong's per
> capita income rose from about one-quarter of Britain's to more than a third
> larger than Britain's . . . I believe that the only plausible explanation
> for the different rates of growth is socialism in Britain, free enterprise
> and free markets in Hong Kong. Has anybody got a better explanation? I'd be
> grateful for any suggestions."_ [ **The Hong Kong Experiment** ]

It should be stressed that by "socialism" Friedman meant state spending,
particularly that associated with welfare ( _"Direct government spending is
less than 15 percent of national income in Hong Kong, more than 40 percent in
the United States."_ [ **Op. Cit.** ]). What to make of his claims?

It is undeniable that the figures for Hong Kong's economy are impressive. Per-
capita GDP by end 1996 should reach US$ 25,300, one of the highest in Asia and
higher than many western nations. Enviable tax rates - 16.5% corporate profits
tax, 15% salaries tax. In the first 5 years of the 1990's Hong Kong's economy
grew at a tremendous rate -- nominal per capita income and GDP levels (where
inflation is not factored in) almost doubled. Even accounting for inflation,
growth was brisk. The average annual growth rate in real terms of total GDP in
the 10 years to 1995 was six per cent, growing by 4.6 per cent in 1995.
However, looking more closely, we find a somewhat different picture than that
painted by those claim Hong Kong as an example of the wonders of free market
capitalism. Once these basic (and well known) facts are known, it is hard to
take Friedman's claims seriously. Of course, there are aspects of laissez-
faire to the system (it does not subsidise sunset industries, for example)
however, there is much more to Hong Kong that these features. Ultimately,
laissez-faire capitalism is more than just low taxes.

The most obvious starting place is the fact that the government owns all the
land. To state the obvious, land nationalisation is hardly capitalistic. It is
one of the reasons why its direct taxation levels are so low. As one resident
points out:

> _"The main explanation for low tax rates . . . is not low social spending.
> One important factor is that Hong Kong does not have to support a defence
> industry . . . The most crucial explanation . . . lies in the fact that less
> than half of the government's revenues comes from direct taxation.  
>  _
>
> _"The Hong Kong government actually derives much of its revenue from land
> transactions. The territory's land is technically owned by the government,
> and the government fills its coffers by selling fifty-year leases to
> developers (the fact that there are no absolute private property rights to
> land will come as another surprise t boosters of 'Hong Kong-style'
> libertarianism) . . . The government has an interest in maintaining high
> property values . . . if it is to maintain its policy of low taxation. It
> does this by carefully controlling the amount of land that is released for
> sale . . . It is, of course, those buying new homes and renting from the
> private sector who pay the price for this policy. Many Hong Kongers live in
> third world conditions, and the need to pay astronomical residential
> property prices is widely viewed as an indirect form of taxation."_ [Daniel
> A. Bell, _"Hong Kong's Transition to Capitalism"_ , pp. 15-23, **Dissent** ,
> Winter 1998, pp. 15-6]

The ownership of land and the state's role as landlord partly explains the low
apparent ratio of state spending to GDP. If the cost of the subsidised housing
land were accounted for at market prices in the government budget, the ratio
would be significantly higher. As noted, Hong Kong had no need to pay for
defence as this cost was borne by the UK taxpayer. Include these government-
provided services at their market prices and the famously low share of
government spending in GDP climbs sharply.

Luckily for many inhabitants of Hong Kong, the state provides a range of
social welfare services in housing, education, health care and social
security. The government has a very basic, but comprehensive social welfare
system. This started in the 1950s, when the government launched one of the
largest public housing schemes in history to house the influx of about 2
million people fleeing Communist China. Hong Kong's social welfare system
really started in 1973, when the newly appointed governor _"announced that
public housing, education, medical, and social welfare services would be
treated as the four pillars of a fair and caring society."_ He launched a
public housing program and by 1998, 52 percent of the population _"live in
subsidised housing, most of whom rent flats from the Housing Authority with
rents set at one-fifth the market level (the rest have bought subsidised flats
under various home-ownership schemes, with prices discounted 50 percent from
those in the private sector)."_ Beyond public housing, Hong Kong _"also has
most of the standard features of welfare states in Western Europe. There is an
excellent public health care system: private hospitals are actually going out
of business because clean and efficient public hospitals are well subsidised
(the government pays 97 percent of the costs)."_ Fortunately for the state,
the territory initially had a relatively youthful population compared with
western countries which meant it had less need for spending on pensions and
help for the aged (this advantage is declining as the population ages). In
addition, the _"large majority of primary schools and secondary schools are
either free of heavily subsidised, and the territory's tertiary institutions
all receive most of their funds from the public coffers."_ [Bell, **Op. Cit.**
, pp. 16-7 and p. 17] We can be sure that when conservatives and
right-"libertarians" use Hong Kong as a model, they are **not** referring to
these aspects of the regime.

Given this, Hong Kong has _"deviated from the myth of a laissez-faire economy
with the government limiting itself to the role of the 'night watchman'"_ as
it _"is a welfare state."_ In 1995-6, it spent 47 percent of its public
expenditure on social services ( _"only slightly less than the United
Kingdom"_ ). Between 1992 and 1998, welfare spending increased at a real rate
of at least 10 percent annually. [Bell, **Op. Cit.** , p. 16] _"Without
doubt,"_ two experts note, _"the development of public housing in Hong Kong
has contributed greatly to the social well-being of the Territory."_ Overall,
social welfare _"is the third largest [state] expenditure . . . after
education and health."_ [Simon X. B. Zhao and l. Zhand, _"Economic Growth and
Income Inequality in Hong Kong: Trends and Explanations,"_ pp. 74-103,
**China: An International Journal** , Vol. 3, No. 1, p. 95 and p. 97] Hong
Kong spent 11.6% of its GDP on welfare spending in 2004, for example.

Moreover, this state intervention is not limited to just social welfare
provision. Hong Kong has an affordable public transport system in which the
government has substantial equity in most transport systems and grants
franchises and monopolised routes. So as well as being the monopoly owner of
land and the largest landlord, the state imposes rent controls, operates three
railways and regulates transport services and public utilities as monopoly
franchises. It subsidises education, health care, welfare and charity. It has
also took over the ownership and management of several banks in the 1980s to
prevent a general bank run. Overall, since the 1960s _"the Hong Kong
government's involvement in everyday life has increases steadily and now
reaches into many vital areas of socio-economic development."_ [Ming K Chan,
_"The Legacy of the British Administration of Hong Kong: A View from Hong
Kong,"_ pp. 567-582, **The China Quarterly** , no. 151, p. 575 and p. 574] It
also intervened massively in the stock market during the 1997 Asian crisis.
Strangely, Friedman failed to note any of these developments nor point to the
lack of competition in many areas of the domestic economy and the high returns
given to competition-free utility companies.

The state did not agree to these welfare measures by choice, as they were
originally forced upon it by fears of social unrest, first by waves of
migrants fleeing from China and then by the need to portray itself as
something more than an uncaring colonial regime. However, the other form of
intervention it pursued **was** by choice, namely the collusion between the
state and business elites. As one expert notes, the _"executive-led
'administrative non-party' state was heavily influenced by the business
community"_ with _"the composition of various government advisory boards,
committees and the three councils"_ reflecting this as _"business interests
had an overwhelming voice in the consultation machinery (about 70% of the
total membership)."_ This is accurately described as a _"bureaucratic-cum-
corporatist state"_ with _"the interests of government and the private sector
dominating those of the community."_ Overall, _"the government and private
sector share common interests and have close links."_ [Mae Kam Ng, _"Political
Economy and Urban Planning,"_ **Progress in Planning** , P. Diamond and B. H.
Massan (eds.), vol. 51, Part 1, p. 11 and p. 84] Sizeable fortunes will be
made when there are interlocking arrangements between the local oligarchies
and the state.

Another commentator notes that the myth of Hong Kong's laissez-faire regime
_"has been disproved in academic debates more than a decade ago"_ and points
to _"the hypocrisy of laissez-faire colonialism"_ which is marked by _"a
government which is actively involved, fully engaged and often
interventionist, whether by design or necessity."_ He notes that _"the most
damaging legacy [of colonial rule] was the blatantly pro-business bias in the
government's decision-making."_ There has been _"collusion between the
colonial officialdom and the British economic elites."_ Indeed, _"the colonial
regime has been at fault for its subservience to business interests as
manifested in its unwillingness until very recently, not because of laissez-
faire but from its pro-business bias, to legislate against cartels and
monopolies and to regulate economic activities in the interests of labour,
consumers and the environment . . . In other words, free trade and free
enterprise with an open market . . . did not always mean fair trade and equal
opportunity: the regime intervened to favour British and big business
interests at the expense of both fair play and of a level playing field for
all economic players regardless of class or race."_ [Ming K Chan, _"The Legacy
of the British Administration of Hong Kong: A View from Hong Kong,"_ pp.
567-582, **The China Quarterly** , no. 151, p. 577, p. 576, p. 575 and pp.
575-6] Bell notes that a British corporation _"held the local telephone
monopoly until 1995"_ while another _"holds all the landing rights at Hong
Kong airport."_ [ **Op. Cit.** , p. 21]

Unsurprisingly, as it owns all the land, the government has _"a strong
position in commanding resources to direct spatial development in the
territory."_ There is a _"three-tiered system of land-use plans."_ The top-
level, for example, _"maps out the overall land development strategy to meet
the long-term socio-economic needs of Hong Kong"_ and it is _"prepared and
reviewed by the administration and there is no public input to it."_ This
planning system is, as noted, heavily influenced by the business sector and
its _"committees operate largely behind closed doors and policy formulation
could be likened to a black-box operation."_ _"Traditionally,"_ Ng notes,
_"the closed door and Hong Kong centred urban planning system had served to
maintain economic dynamism in the colony. With democratisation introduced in
the 1980s, the planning system is forced to be more open and to serve not just
economic interests."_ [Mae Kam Ng, **Op. Cit.** , p. 11, p. 39, p. 37 and p.
13] As Chan stresses, _"the colonial government has continuously played a
direct and crucial role as a very significant economic participant. Besides
its control of valuable resources, the regime's command of the relevant legal,
political and social institutions and processes also indirectly shapes
economic behaviour and societal development."_ [ **Op. Cit.** , p. 574]

Overall, as Bell notes, _"one cannot help but notice the large gap between
this reality and the myth of an open and competitive market where only talent
and luck determine the economic winners."_ [ **Op. Cit.** , p. 16] As an
expert in the Asian Tiger economies summarises:

> _"to conclude . . . that Hong Kong is close to a free market economy is
> misleading . . . Not only is the economy managed from outside the formal
> institutions of government by the informal coalition of peak private
> economic organisations, but government itself also has available some
> unusual instruments for influencing industrial activity. It owns all the
> land. . . It controls rents in part of the public housing market and
> supplies subsidised public housing to roughly half the population, thereby
> helping to keep down the cost of labour. And its ability to increase or
> decrease the flow of immigrants from China also gives it a way of affecting
> labour costs."_ [Robert Wade, **Governing the Market** , p. 332]

This means that the Hong Kong system of "laissez-faire" is marked by the state
having close ties with the major banks and trading companies, which, in turn,
are closely linked to the life-time expatriates who largely run the
government. This provides a _"point of concentration"_ to conduct negotiations
in line with an implicit development strategy. Therefore it is pretty clear
that Hong Kong does not really show the benefits of "free market" capitalism.
Wade indicates that we can consider Hong Kong as a _"special case or as a less
successful variant of the authoritarian-capitalist state."_ [ **Op. Cit.** ,
p. 333]

There are other explanations for Hong Kong's high growth rates than simply
"capitalism." Firstly, Hong Kong is a city state and cities have a higher
economic growth rate than regions (which are held back by large rural areas).
This is because the agricultural sector rarely achieves high economic growth
rates and so in its absence a high growth rate is easier to achieve. Secondly,
there is Hong Kong's location and its corresponding role as an entrepôt
economy. Wade notes that _"its economic growth is a function of its service
role in a wider regional economy, as entrepôt trader, regional headquarters
for multinational companies, and refuge for nervous money."_ [ **Op. Cit.** ,
p. 331] Being between China and the rest of the world means its traders could
act as a middleman, earning income from the mark-up they could impose on good
going through the territory. This is why Hong Kong is often referred to as an
entrepôt economy, a place that imports, stores, and re-exports goods. In other
words, Hong Kong made a lot of its money because many Chinese exports and
imports went through it and its traders marked-up the prices. It should be
obvious if most of Western Europe's goods went through, say, Liverpool, that
city would have a very good economic performance regardless of other factors.
This option is hardly available to most cities, never mind countries.

Then there is the issue of state ownership of land. As Mae Kam Ng reports,
monopoly ownership of all land by the state sets the context for super-profits
by government and finance capital generally. [ **Op. Cit.** , p. 13]
Unsurprisingly, most government land _"is sold to just three real-estate
developers"_ who _"sit on huge tracts of land, drop-feeding apartments onto
the market so as to maintain high property prices."_ Between 1992 and 1996,
for example, prices increased fourfold and profits doubled. The heads of two
of the property firms were on the list of the world's ten richest men in 1998.
_"Meanwhile, potential new entrants to the market are restricted by the huge
cost of paying land-conversion premiums that are the bedrock of government
revenues."_ This is a _"cosy arrangement between the government and major
developers."_ [Daniel A. Bell, **Op. Cit.** , p. 16]

The role as headquarters for companies and as a financial centre also plays a
part. It means an essential part of its success is that it gets surplus value
produced elsewhere in the world. Handling other people's money is a sure-fire
way of getting rich and this will have a nice impact on per-capita income
figures (as will selling goods produced in sweat-shops in dictatorships like
China). There has been a gradual shift in economic direction to a more
service-oriented economy which has stamped Hong Kong as one of the world's
foremost financial centres. This highly developed sector is served by some 565
banks and deposit-taking companies from over 40 countries, including 85 of the
world's top 100 in terms of assets. In addition, it is the 8th largest stock
market in the world (in terms of capitalisation) and the 2nd largest in Asia.
By 1995, Hong Kong was the world's 10th largest exporter of services with the
industry embracing everything from accounting and legal services, insurance
and maritime to telecommunications and media. The contribution of the services
sectors as a whole to GDP increased from 60 per cent in 1970 to 83 per cent in
1994.

Meanwhile, manufacturing industry has moved to low wage countries such as
southern China (by the end of the 1970's, Hong Kong's manufacturing base was
less competitive, facing increasing costs in land and labour -- in other
words, workers were starting to benefit from economic growth and so capital
moved elsewhere). The economic reforms introduced by Deng Xiaoping in southern
China in 1978 where important, as this allowed capital access to labour living
under a dictatorship (just as American capitalists invested heavily in Nazi
Germany -- labour rights were null, profits were high). It is estimated about
42,000 enterprises in the province have Hong Kong participation and 4,000,000
workers (nine times larger than the territory's own manufacturing workforce)
are now directly or indirectly employed by Hong Kong companies. In the late
1980's Hong Kong trading and manufacturing companies began to expand further a
field than just southern China. By the mid 1990's they were operating across
Asia, in Eastern Europe and Central America. This shift, incidentally, has
resulted in deindustrialisation and a _"decrease in real income among manual
workers"_ as they moved to the lower end service sector. [Simon X. B. Zhao and
l. Zhand, **Op. Cit.** , p. 88]

Then there is the criteria Friedman uses, namely per-capita GDP. As we have
repeated stressed, averages hide a lot of important and relevant information
when evaluating a society. So it must be stressed that Friedman's criteria of
per capita income is an average and, as such, hides the effect of inequality.
This means that a society with huge numbers of poor people and a handful of
ultra-rich individuals may have a higher average income than a more equal
society. This is the case of, say, America compared to Sweden. Unsurprisingly,
Hong Kong is a very unequal society and this inequality is growing (so his
claim that Hong Kong is capitalist refutes his 1962 assertion that the more
capitalist economies are more equal). _"Behind the impressive GDP figures,"_
indicates Chan, _"is a widening income gap between the super-rich and the
grassroots, with 650,000 people reportedly living below the poverty line."_ [
**Op. Cit.** , p. 576] As Bell points out, 13% lived below the poverty line in
1999, compared to 8% in 1971. This is partly explained by _"the rising
proportion of elderly people and single-parent families."_ However, economic
integration with China has played a role as Hong Kong's manufacturing sector
_"has been almost entirely transferred to the southern province of Guangdong
(where labour is cheaper and workers' rights are practically non-existent),
with the consequence that Hong Kong's industrial workers now find it much
harder to find decent jobs in Hong Kong. Most end up working in low-paying
service jobs without much hope of upward mobility."_ [ **Op. Cit.** , pp.
21-2]

As other experts note, while Hong Kong may have a GDP-per-capita of a
developed nation, its distribution of household income was similar to that of
Guatemala. Looking at the 1960s onwards, income distribution only improved
between 1966 and 1971, after this period the share of the bottom 30% of the
population went down continuously while the top 20% saw an increase in their
share of total income. In fact, from the 1980s, _"the top 20% of households
managed to account for over 50 per cent of the total income."_ In fact, the
bottom 60% of the population saw a decline in their share of income between
1971 and 1996. Overall, _"high-income households increased their wealth
progressively faster than low-income households."_ This polarisation, they
argue, will continue as the economy de-industrialises: _"in the absence of
proper social policies, it will generate a small, extremely wealthy class of
the 'new rich' and simultaneously a large population of the 'working poor.'"_
[Simon X. B. Zhao and L. Zhand, **Op. Cit.** , p. 85, p. 80, p. 82, p. 84 and
p. 102]

Given that everywhere cannot be such a service provider, it does not provide
much of an indication of how "free market" capitalism would work in, say, the
United States. And as there is in fact extensive (if informal) economic
management and that the state owns all the land and subsidies rent and health
care, how can it be even considered an example of "free market" capitalism in
action? Unless, of course, you consider that "economic freedom" best
flourishes under a dictatorship which owns all the land, which has close links
to business interests, provides a comprehensive, if basic, welfare state and
is dependent on another country to provide its defence needs and the head of
its executive. While most American's would be envious of Hong Kong's welfare
state, it is doubtful that many would consider its other features as
desirable. How many would be happy with being under a _"benevolent dictator"_
(perhaps being turned into a colony of Britain again?) whose appointed
government works closely with the local business elite? Having a political
regime in which the wealthy can influence the government without the need for
elections may be considered too a high price to pay just to get subsidised
housing, health care and education. Given a choice between freedom and a high
rate of growth, how many would pick the latter over the former?

It is no coincidence that like most examples of the wonders of the free
market, Hong Kong was not a democracy. It was a relatively liberal colonial
dictatorship run. But political liberty does not rate highly with many
supporters of laissez-faire capitalism (such as right-"libertarians", for
example). However, the two are linked. Which explains why we have spent so
much time debunking the "free market" capitalism claims over Hong Kong. It is
more than simply a concern over basic facts and correcting inaccurate
assertions. Rather it is a concern over the meaning of freedom and the dubious
assumption that freedom can be compartmentalised. While Hong Kong may be a
more appealing example that Pinochet's Chile, it still rests on the assumption
that the masses should be excluded from having a say over their communities
(in their own interests, of course, and **never,** of course, in the interests
of those who do the excluding) and that freedom is simply the ability to
change bosses (or become one yourself). Ultimately, there is a big difference
between "free" and "business-friendly." Hong Kong is the latter simply because
it is not the former. Its success is testament that dictatorships can be more
reliable defenders of class privilege than democracies.

This can be seen from the attitude of Hong Kong's business elite to the
democratic reforms introduced in the 1990s and integration with China.
Significantly, _"the nominally socialist Chinese government consistently
opposed the introduction of further social welfare programs in Hong Kong."_
This is because _"it has chosen to enter into a strategic alliance with Hong
Kong's business class"_ ( _"To earn support of corporate bosses, the Chinese
government organised timely interventions on behalf of Hong Kong companies"_
). Unsurprisingly, the first Beijing-appointed executive was made up of
successful business men and one of its first acts was to suspend pro-labour
laws passed by the out-going legislature. [Bell, **Op. Cit.** , p. 17, p. 18
and pp. 19-20] The Chinese government opposed attempts to extend democracy,
imposing a complex electoral system which, in the words of the **Asian Wall
Street Journal** , was a _"means of reducing public participation in the
political process while stacking the next legislature with people who depend
on favours from the regime in Hong Kong or Beijing and answer to narrow
special interests, particularly the business elite."_ [quoted by Bell, **Op.
Cit.** , pp. 18-9]

This reflects the fact that business tycoons are worried that democracy would
led to increased welfare spending with one, for example, predicting that the
_"under-educated, and those who did not pay tax would elect candidates who
stood for more social spending, which would turn Hong Kong into a 'welfare
state' . . . If we had a 100-per-cent directly elected LegCo, only social
welfare-oriented candidates will be elected. Hong Kong is a business city and
we [sic!] do not want to end up being a social welfare state."_ [ _"Tycoon
warns on protests,"_ **The Standard** , 29 April 2004] Such a government can
ignore public opinion and the electorate more than in an independent democracy
and, of course, can be more influenced by business (as the history of Hong
Kong testifies).

Overall, it is fair to say that Friedman only saw what he wanted to see and
contrasted his idealised vision with Britain and explained the divergent
economic performances of both countries to a conflict between "socialism" and
"capitalism." How he failed to notice that the reality of Hong Kong was one
marked by collusion between big business and the state and that in key areas
the regime was much more "socialist" than its British counterpart is difficult
to understand given his willingness to use it as an example. It seems
intellectually dishonest to fail to mention that the state owned all the land
and was the biggest landlord with at least 50% of the population living in
subsidised housing. Then there are the facts of almost free medical treatment
at government clinics and hospitals and an education system almost entirely
funded by the government. These are all massive interventions in the
marketplace, interventions Friedman spent many decades fighting in the USA. He
did, however, contribute to the myth that the British were benign imperialists
and the "free market" they introduced into Hong Kong was in the interests of
all rather than for those who exercised the dictatorship.

[‹ C.11 Doesn't neo-liberalism in Chile prove that the free market benefits
everyone? ](secC11.md "Go to previous page") [up](secCcon.md "Go to parent
page") [Section D - How do statism and capitalism affect society?
›](secDcon.md "Go to next page")

