#!/bin/bash
##################################################
#       aMuleAdunanzA.app bundle creator.        #
##################################################

# Just a stupid "mod" of original script...

THE_BASE_NAME=aMuleAdunanzA
THE_BASEGUI_NAME=aMuleGUIAdunanzA

THE_VERSION=2012.1

## This file is part of the aMule Project
##
## Copyright (c) 2004-2011 Angel Vidal ( kry@amule.org )
## Copyright (c) 2003-2011 aMule Team     ( http://www.amule-project.net )
##
## This program is free software; you can redistribute it and/or
## modify it under the terms of the GNU General Public License
## as published by the Free Software Foundation; either
## version 2 of the License, or (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301, USA

SRC_FOLDER=$1


if [ -z $SRC_FOLDER ]; then
	SRC_FOLDER=`pwd`
fi

if [ -d ${SRC_FOLDER}/.svn ]; then
	THE_SVNVERSION=`svnversion . | sed -e 's/[0-9][0-9]*:\(.*\)/\1/' -e 's/\([0-9][0-9]*\).*/\1/'`
	THE_VERSION+="-rev${THE_SVNVERSION}"
fi


echo ""
echo -n "Step 1: Cleaning bundles... "
rm -f ${SRC_FOLDER}/${THE_BASE_NAME}.app/Contents/Frameworks/libwx_* ${SRC_FOLDER}/${THE_BASE_NAME}.app/Contents/MacOS/* 1> /dev/null 2> /dev/null
rm -f ${SRC_FOLDER}/${THE_BASE_NAME}.app/Contents/Frameworks/libixml* 1> /dev/null 2> /dev/null
rm -rf ${SRC_FOLDER}/${THE_BASE_NAME}.app/Contents/Resources/webserver 1> /dev/null 2> /dev/null
rm -f ${SRC_FOLDER}/${THE_BASEGUI_NAME}.app/Contents/Frameworks/libwx_* ${SRC_FOLDER}/${THE_BASEGUI_NAME}.app/Contents/MacOS/* 1> /dev/null 2> /dev/null
rm -rf ${SRC_FOLDER}/${THE_BASE_NAME}.app/Contents/SharedSupport 1> /dev/null 2> /dev/null
echo "Done"
echo ""
echo -n "Step 2.1: Copying aMule apps and resources to aMuleAdunanzA app bundle... " 
cp ${SRC_FOLDER}/src/amule ${SRC_FOLDER}/${THE_BASE_NAME}.app/Contents/MacOS/
if [ -f ${SRC_FOLDER}/src/amuled ]; then
	cp ${SRC_FOLDER}/src/amuled ${THE_BASE_NAME}.app/Contents/MacOS/
fi
if [ -f ${SRC_FOLDER}/src/webserver/src/amuleweb ]; then
	cp ${SRC_FOLDER}/src/webserver/src/amuleweb ${SRC_FOLDER}/${THE_BASE_NAME}.app/Contents/MacOS/
fi
if [ -f ${SRC_FOLDER}/src/ed2k ]; then
	cp ${SRC_FOLDER}/src/ed2k ${SRC_FOLDER}/${THE_BASE_NAME}.app/Contents/MacOS/
fi
if [ -f ${SRC_FOLDER}/src/amulecmd ]; then
	cp ${SRC_FOLDER}/src/amulecmd ${SRC_FOLDER}/${THE_BASE_NAME}.app/Contents/MacOS/
fi
cp ${SRC_FOLDER}/amuleadunanza.icns ${SRC_FOLDER}/${THE_BASE_NAME}.app/Contents/Resources/
cp -R ${SRC_FOLDER}/src/webserver ${SRC_FOLDER}/${THE_BASE_NAME}.app/Contents/Resources
find ${SRC_FOLDER}/${THE_BASE_NAME}.app/Contents/Resources/webserver \( -name .svn -o -name "Makefile*" -o -name src \) -print0 | xargs -0 rm -rf
echo "Done"

echo -n "Step 2.2: Copying aMuleGUI apps and resources to aMuleGUIAdunanzA app bundle... "
cp ${SRC_FOLDER}/src/amulegui ${SRC_FOLDER}/${THE_BASEGUI_NAME}.app/Contents/MacOS/
# per ora uso la stessa icona...
cp ${SRC_FOLDER}/amuleadunanza.icns ${SRC_FOLDER}/${THE_BASEGUI_NAME}.app/Contents/Resources/


echo ""
echo -n "Step 3: Installing translations to AdunanzA app bundle... "
orig_dir=`pwd`
pushd ${SRC_FOLDER}/po
make install datadir=$orig_dir/${THE_BASE_NAME}.app/Contents/SharedSupport 1> /dev/null 2> /dev/null
make install datadir=$orig_dir/${THE_BASEGUI_NAME}.app/Contents/SharedSupport 1> /dev/null 2> /dev/null
popd
echo "Done"

echo ""
echo "Step 4: Copying libs to Framework"
echo "    wxWidgets..."
# wxWidgets libs to frameworks
for i in $( otool -L	${SRC_FOLDER}/${THE_BASE_NAME}.app/Contents/MacOS/amule \
						${SRC_FOLDER}/${THE_BASE_NAME}.app/Contents/MacOS/amuled \
						${SRC_FOLDER}/${THE_BASE_NAME}.app/Contents/MacOS/amuleweb \
						${SRC_FOLDER}/${THE_BASE_NAME}.app/Contents/MacOS/ed2k \
						${SRC_FOLDER}/${THE_BASE_NAME}.app/Contents/MacOS/amulecmd \
			| sort -u | grep libwx_ | cut -d " " -f 1 ); do 
	cp $i ${SRC_FOLDER}/${THE_BASE_NAME}.app/Contents/Frameworks; 
done
for i in $( otool -L	${SRC_FOLDER}/${THE_BASEGUI_NAME}.app/Contents/MacOS/amulegui \
			| sort -u | grep libwx_ | cut -d " " -f 1 ); do
	cp $i ${SRC_FOLDER}/${THE_BASEGUI_NAME}.app/Contents/Frameworks;
done

echo "Libs copy done."
echo ""
echo "Step 5: Update libs info"
#then install_name_tool on them to fix the path on the shared lib
pushd ${THE_BASE_NAME}.app/Contents/
for i in $( ls Frameworks | grep -v CVS); do
	echo "    Updating $i"
	#update library id
	install_name_tool -id @executable_path/../Frameworks/$i Frameworks/$i
	#update library links
	for j in $( otool -L Frameworks/$i | grep libwx_ | cut -d " " -f 1 ); do
	        install_name_tool -change \
                $j @executable_path/../Frameworks/`echo $j | rev | cut -d "/" -f 1 | rev` \
		Frameworks/$i 1> /dev/null 2> /dev/null

	done
	echo "    Updating aMuleAdunanzA lib info for $i"
	#update amule executable
	install_name_tool -change \
		`otool -L MacOS/amule | grep $i | cut -d " " -f 1` \
		@executable_path/../Frameworks/$i MacOS/amule 1> /dev/null 2> /dev/null
	install_name_tool -change \
		`otool -L MacOS/amuled | grep $i | cut -d " " -f 1` \
		@executable_path/../Frameworks/$i MacOS/amuled 1> /dev/null 2> /dev/null
	install_name_tool -change \
		`otool -L MacOS/amuleweb | grep $i | cut -d " " -f 1` \
		@executable_path/../Frameworks/$i MacOS/amuleweb 1> /dev/null 2> /dev/null
	install_name_tool -change \
		`otool -L MacOS/ed2k | grep $i | cut -d " " -f 1` \
		@executable_path/../Frameworks/$i MacOS/ed2k 1> /dev/null 2> /dev/null
	install_name_tool -change \
		`otool -L MacOS/amulecmd | grep $i | cut -d " " -f 1` \
		@executable_path/../Frameworks/$i MacOS/amulecmd 1> /dev/null 2> /dev/null
done
popd


pushd ${THE_BASEGUI_NAME}.app/Contents/
for i in $( ls Frameworks | grep -v CVS); do
	echo "    Updating $i"
	#update library id
	install_name_tool -id @executable_path/../Frameworks/$i Frameworks/$i
	#update library links
	for j in $( otool -L Frameworks/$i | grep libwx_ | cut -d " " -f 1 ); do
	        install_name_tool -change \
                $j @executable_path/../Frameworks/`echo $j | rev | cut -d "/" -f 1 | rev` \
		Frameworks/$i 1> /dev/null 2> /dev/null

	done
	echo "    Updating aMuleGUIAdunanzA lib info for $i"
	#update amuleGUI executable
	install_name_tool -change \
		`otool -L MacOS/amulegui | grep $i | cut -d " " -f 1` \
		@executable_path/../Frameworks/$i MacOS/amulegui 1> /dev/null 2> /dev/null
done
popd

echo "Libs info updated, aMuleAdunanzA.app and aMuleGUIAdunanzA.app are ready to package."
echo ""

echo "Preparing aMuleAdunanzA package..."
NAME_OF_ZIP="${THE_BASE_NAME}-${THE_VERSION}"
#if [ -d ${SRC_FOLDER}/.svn ]; then
#	THE_SVNVERSION=`svnversion . | sed -e 's/[0-9][0-9]*:\(.*\)/\1/' -e 's/\([0-9][0-9]*\).*/\1/'`
#	NAME_OF_ZIP+="-rev${THE_SVNVERSION}"
#fi

# vediamo se ho Cocoa
HAS_COCOA=`${SRC_FOLDER}/${THE_BASE_NAME}.app/Contents/MacOS/amule --version | grep "wxOSX Cocoa"`
if [ "x${HAS_COCOA}" != "x" ]; then
	echo "    built with wxOSX Cocoa!"
	NAME_OF_ZIP+="-OSXCocoa"
fi

# vediamo se ho ppc
HAS_PPC=`file ${SRC_FOLDER}/${THE_BASE_NAME}.app/Contents/MacOS/amule | grep -i ppc`
if [ "x${HAS_PPC}" != "x" ]; then
	echo "    built for PPC!"
	NAME_OF_ZIP+="-ppc"
fi


# vediamo se ho i386
HAS_I386=`file ${SRC_FOLDER}/${THE_BASE_NAME}.app/Contents/MacOS/amule | grep i386`
if [ "x${HAS_I386}" != "x" ]; then
	echo "    built for i386!"
	NAME_OF_ZIP+="-i386"
fi

# vediamo se ho x86_64
HAS_X86_64=`file ${SRC_FOLDER}/${THE_BASE_NAME}.app/Contents/MacOS/amule | grep x86_64`
if [ "x${HAS_X86_64}" != "x" ]; then
	echo "    built for x86_64!"
	NAME_OF_ZIP+="-x86_64"
fi


# Backup previous zip, if any
if [ -f ${NAME_OF_ZIP}.zip ]; then
	THE_TIMESTAMP=`/bin/date "+%Y%m%d_%H%M%S"`
	# THE_TIMESTAMP=`/bin/date`
	BACKUPNAME=${NAME_OF_ZIP}_${THE_TIMESTAMP}
	/bin/echo -n "Archiving previous zip as ${BACKUPNAME}.zip... "
	mv -f "${NAME_OF_ZIP}.zip" "${BACKUPNAME}.zip"
	/bin/echo "Done"
fi


echo -n "Creating ${NAME_OF_ZIP}.zip... "
zip -9 -r  ${NAME_OF_ZIP}.zip ${THE_BASE_NAME}.app/ > /dev/null
zip -9 -j ${SRC_FOLDER}/docs/README.Mac.txt ${SRC_FOLDER}/docs/COPYING ${SRC_FOLDER}/Changelog.AdunanzA ${SRC_FOLDER}/LEGGIMI.AdunanzA > /dev/null
echo "Done"

# E ora per la GUI
echo "Preparing aMuleGUIAdunanzA package..."

GUINAME_OF_ZIP="${THE_BASEGUI_NAME}-${THE_VERSION}"
#if [ -d ${SRC_FOLDER}/.svn ]; then
#	GUINAME_OF_ZIP+="-rev${THE_SVNVERSION}"
#fi

# vediamo se ho Cocoa
GUIHAS_COCOA=`${SRC_FOLDER}/${THE_BASEGUI_NAME}.app/Contents/MacOS/amulegui --version | grep "wxOSX Cocoa"`
if [ "x${GUIHAS_COCOA}" != "x" ]; then
	echo "    built with wxOSX Cocoa!"
	GUINAME_OF_ZIP+="-OSXCocoa"
fi

# vediamo se ho ppc
GUIHAS_PPC=`file ${SRC_FOLDER}/${THE_BASEGUI_NAME}.app/Contents/MacOS/amulegui | grep -i ppc`
if [ "x${GUIHAS_PPC}" != "x" ]; then
	echo "    built for PPC!"
	GUINAME_OF_ZIP+="-ppc"
fi


# vediamo se ho i386
GUIHAS_I386=`file ${SRC_FOLDER}/${THE_BASEGUI_NAME}.app/Contents/MacOS/amulegui | grep i386`
if [ "x${GUIHAS_I386}" != "x" ]; then
	echo "    built for i386!"
	GUINAME_OF_ZIP+="-i386"
fi

# vediamo se ho x86_64
GUIHAS_X86_64=`file ${SRC_FOLDER}/${THE_BASEGUI_NAME}.app/Contents/MacOS/amulegui | grep x86_64`
if [ "x${GUIHAS_X86_64}" != "x" ]; then
	echo "    built for x86_64!"
	GUINAME_OF_ZIP+="-x86_64"
fi


# Backup previous zip, if any
if [ -f ${GUINAME_OF_ZIP}.zip ]; then
	# THE_TIMESTAMP=`/bin/date`
	GUIBACKUPNAME=${GUINAME_OF_ZIP}_${THE_TIMESTAMP}
	/bin/echo -n "Archiving previous GUI zip as ${GUIBACKUPNAME}.zip... "
	mv -f "${GUINAME_OF_ZIP}.zip" "${GUIBACKUPNAME}.zip"
	/bin/echo "Done"
fi


echo -n "Creating ${GUINAME_OF_ZIP}.zip... "
zip -9 -r ${GUINAME_OF_ZIP}.zip ${THE_BASEGUI_NAME}.app/ > /dev/null
zip -9 -j ${SRC_FOLDER}/docs/README.Mac.txt ${SRC_FOLDER}/docs/COPYING ${SRC_FOLDER}/Changelog.AdunanzA ${SRC_FOLDER}/LEGGIMI.AdunanzA > /dev/null
echo "Done"
echo ""

