#
# Copyright 2001 by Object Craft P/L, Melbourne, Australia.
#
# LICENCE - see LICENCE file distributed with this software for details.
#
from mod_python import util, apache
from albatross.request import RequestBase
from albatross.common import *


class Request(RequestBase):

    def __init__(self, req):
        self.__req = req
        RequestBase.__init__(self, util.FieldStorage(self.__req))

    def get_uri(self):
        return self.__req.uri

    def get_method(self):
        return self.__req.method

    def get_path_info(self):
        return self.__req.path_info

    def get_servername(self):
        try:
            return self.__req.hostname                          # mod_python 3
        except AttributeError:
            return self.__req.connection.server.server_hostname # mod_python 2

    def get_header(self, name):
        if name in self.__req.headers_in:
            return self.__req.headers_in[name]

    def write_header(self, name, value):
        if name.lower() == 'content-type':
            self.__req.content_type = value
        else:
            self.__req.headers_out.add(name, value)

    def end_headers(self):
        self.__req.send_http_header()

    def redirect(self, loc):
        self.write_header('Location', loc)
        return apache.HTTP_MOVED_PERMANENTLY

    def write_content(self, data):
        self.__req.write(data)

    def set_status(self, status):
        self.__req.status = status
        RequestBase.set_status(self, status)

    def return_code(self):
        return apache.OK
