#ifndef	__SYSCONFIG_H__
#define	__SYSCONFIG_H__

#define SYSCONFIG_MAX_NAME_SIZE		(100)
#define SYSCONFIG_MAX_VALUE_SIZE	(100)
#define SYSCONFIG_MAX_NUM_ENTRY		(10)

typedef enum
{
	SYSCONFIG_SUCCESS = 0,
	SYSCONFIG_FAIL
} SYSCONFIG_RESULT;

typedef struct
{
	char	name[SYSCONFIG_MAX_NAME_SIZE];
	char	value[SYSCONFIG_MAX_VALUE_SIZE];
} SYSCONFIG_CONF_ENTRY, *PSYSCONFIG_CONFIG_ENTRY;

typedef struct _SYSCONFIG
{
	SYSCONFIG_CONF_ENTRY	entry[SYSCONFIG_MAX_NUM_ENTRY];
	int						numEntry;
} SYSCONFIG, *PSYSCONFIG;

SYSCONFIG_RESULT
SysConfigInit(	PSYSCONFIG	pSysConfig,
				char*		confFileName);

void
SysConfigCleanUp(PSYSCONFIG	pSysConfig);

SYSCONFIG_RESULT
SysConfigQuery(	PSYSCONFIG	pSysConfig,
				char*		valueName,
				char*		valueStr);

#endif	/* __SYSCONFIG_H__ */
