/*
 *	filterErrorDialog.cpp - Dialog for displaying error notices computed from filter tree
 *	Copyright (C) 2015, D Haley 

 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation, either version 3 of the License, or
 *	(at your option) any later version.

 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.

 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
// -*- C++ -*- generated by wxGlade 0.6.3 on Sun Jun 24 00:03:00 2012

#include "filterErrorDialog.h"
#include "wx/wxcommon.h"
#include "common/translation.h"
//Art for buttons
#include <wx/artprov.h>
// begin wxGlade: ::extracode
// end wxGlade

using std::string;


FilterErrorDialog::FilterErrorDialog(wxWindow* parent, int id, const wxString& title, const wxPoint& pos, const wxSize& size, long style):
    wxDialog(parent, id, title, pos, size, wxDEFAULT_DIALOG_STYLE|wxRESIZE_BORDER)
{
    // begin wxGlade: FilterErrorDialog::FilterErrorDialog
    textErrorMessage = new wxTextCtrl(this, wxID_ANY, wxEmptyString,wxDefaultPosition,wxDefaultSize,wxTE_MULTILINE|wxTE_READONLY);
    bitmapError = new wxStaticBitmap(this, wxID_ANY, wxArtProvider::GetBitmap(wxART_ERROR));
    labelError = new wxStaticText(this, wxID_ANY, TRANS("Error"));
    bitmapWarning = new wxStaticBitmap(this, wxID_ANY,wxArtProvider::GetBitmap(wxART_WARNING));
    labelWarning = new wxStaticText(this, wxID_ANY, TRANS("Warning"));
    btnOK = new wxButton(this, wxID_OK, wxEmptyString);

    SetTitle(TRANS("Filter Errors"));
    set_properties();
    do_layout();
    // end wxGlade
}


void FilterErrorDialog::set_properties()
{
    // begin wxGlade: FilterErrorDialog::set_properties
    SetTitle(TRANS("Filter Errors"));
    SetSize(wxSize(551, 414));
    // end wxGlade
}

void FilterErrorDialog::SetText(const std::vector<string> &text)
{
	std::string bigMessage;
	for(unsigned int ui=0;ui<text.size();ui++)
	{
		bigMessage+= text[ui];
		if(ui<text.size()-1)
	       	      bigMessage+= "\n-------------------\n\n";
	}

	textErrorMessage->Clear();
	textErrorMessage->AppendText((bigMessage));
}

void FilterErrorDialog::do_layout()
{
    // begin wxGlade: FilterErrorDialog::do_layout
    wxBoxSizer* sizerMain = new wxBoxSizer(wxVERTICAL);
    wxBoxSizer* sizerTop = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizerKey = new wxBoxSizer(wxVERTICAL);
    wxBoxSizer* sizerWarn = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizerError = new wxBoxSizer(wxHORIZONTAL);
    sizerTop->Add(textErrorMessage, 4, wxLEFT|wxRIGHT|wxTOP|wxEXPAND, 6);
    sizerKey->Add(10, 10, 0, 0, 0);
    sizerError->Add(bitmapError, 0, 0, 0);
    sizerError->Add(labelError, 0, wxALIGN_CENTER_VERTICAL, 0);
    sizerKey->Add(sizerError, 0, wxTOP|wxEXPAND, 5);
    sizerWarn->Add(bitmapWarning, 0, 0, 0);
    sizerWarn->Add(labelWarning, 0, wxALIGN_CENTER_VERTICAL, 0);
    sizerKey->Add(sizerWarn, 0, wxTOP|wxEXPAND, 6);
    sizerKey->Add(20, 20, 0, 0, 0);
    sizerTop->Add(sizerKey, 1, wxEXPAND, 0);
    sizerMain->Add(sizerTop, 1, wxEXPAND, 0);
    sizerMain->Add(btnOK, 0, wxALL|wxALIGN_RIGHT, 5);
    SetSizer(sizerMain);
    Layout();
    // end wxGlade
}

