## Introduction

This folder contains the files generated by the glad GL loader for the game.

## Instructions

Download glad v2:
```sh
git clone https://github.com/Dav1dde/glad.git -b glad2
```

Install the python dependencies
```sh
cd glad
pip install -r requirements.txt
```

Build the source files for all four backends with their respective extensions
- GL
    ```sh
    python -m glad --api="gl:core=2.1" --extensions="../extensions/gl.txt"  --out-path="../"
    ```
- GLES2
    ```sh
    python -m glad --api="gles2=2.0" --extensions="../extensions/gles2.txt"  --out-path="../"
    ```
- GLX
    ```sh
    python -m glad --api="glx=1.4" --extensions="../extensions/glx.txt"  --out-path="../"
    ```
- WGL
    ```sh
    python -m glad --api="wgl=1.0" --extensions="../extensions/wgl.txt"  --out-path="../"
    ```
- EGL
    ```sh
    python -m glad --api="egl=1.5" --extensions="../extensions/egl.txt"  --out-path="../"
    ```

Rename all files to .cpp to prevent compilation warnings
