#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2015 Antoine Le Gonidec <vv221@dotslashplay.it>
# SPDX-FileCopyrightText: © 2020 macaron
set -o errexit

###
# Goblins series:
# - Goblins 1
# - Goblins 2
# - Goblins 3
###

script_version=20231105.1

PLAYIT_COMPATIBILITY_LEVEL='2.27'

GAME_ID_GOB1='goblins-1'
GAME_NAME_GOB1='Gobliiins'

GAME_ID_GOB2='goblins-2'
GAME_NAME_GOB2='Gobliins 2: The Prince Buffoon'

GAME_ID_GOB3='goblins-3'
GAME_NAME_GOB3='Goblins 3'

# Archives

## Goblins 1

ARCHIVE_BASE_GOB1_0_NAME='setup_gobliiins_1.02_(20270).exe'
ARCHIVE_BASE_GOB1_0_MD5='dd4fa52b7ed43b964d82f2056c18b681'
ARCHIVE_BASE_GOB1_0_TYPE='innosetup'
ARCHIVE_BASE_GOB1_0_SIZE='99000'
ARCHIVE_BASE_GOB1_0_VERSION='1.02-gog20270'
ARCHIVE_BASE_GOB1_0_URL='https://www.gog.com/game/gobliiins_pack'

## Goblins 2

ARCHIVE_BASE_GOB2_0_NAME='setup_gobliins_2_-_the_prince_buffoon_1.02_(20270).exe'
ARCHIVE_BASE_GOB2_0_MD5='3607f4ab042fea51e3b6544775955701'
ARCHIVE_BASE_GOB2_0_TYPE='innosetup'
ARCHIVE_BASE_GOB2_0_SIZE='110000'
ARCHIVE_BASE_GOB2_0_VERSION='1.02-gog20270'
ARCHIVE_BASE_GOB2_0_URL='https://www.gog.com/game/gobliiins_pack'

## Goblins 3

ARCHIVE_BASE_GOB3_EN_0_NAME='setup_goblins_quest_3_1.02_(20270).exe'
ARCHIVE_BASE_GOB3_EN_0_MD5='9d98b9f643dad9c793416d50bcbd9f17'
ARCHIVE_BASE_GOB3_EN_0_TYPE='innosetup'
ARCHIVE_BASE_GOB3_EN_0_SIZE='210000'
ARCHIVE_BASE_GOB3_EN_0_VERSION='1.02-gog20270'
ARCHIVE_BASE_GOB3_EN_0_URL='https://www.gog.com/game/gobliiins_pack'

ARCHIVE_BASE_GOB3_FR_0_NAME='setup_goblins_quest_3_1.02_(french)_(20270).exe'
ARCHIVE_BASE_GOB3_FR_0_MD5='52649e08b57d8edfdbb4b72bc032e625'
ARCHIVE_BASE_GOB3_FR_0_TYPE='innosetup'
ARCHIVE_BASE_GOB3_FR_0_SIZE='200000'
ARCHIVE_BASE_GOB3_FR_0_VERSION='1.02-gog20270'
ARCHIVE_BASE_GOB3_FR_0_URL='https://www.gog.com/game/gobliiins_pack'


CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_L10N_FILES_GOB3='
??gob3.itk'
CONTENT_GAME_FLOPPY_PATH="${CONTENT_PATH_DEFAULT}/fdd"
CONTENT_GAME_FLOPPY_FILES='
*.stk'
CONTENT_GAME_CDROM_FILES='
*.itk
*.lic
*.stk
*.mp3'
CONTENT_DOC_COMMON_FILES='
*.pdf'

# Applications

## Goblins 1

APP_FLOPPY_SCUMMID_GOB1='gob:gob1'
APP_FLOPPY_ICON_GOB1='goggame-1207662273.ico'

APP_CDROM_SCUMMID_GOB1='gob:gob1cd'
APP_CDROM_ICON_GOB1='goggame-1207662273.ico'

## Goblins 2

APP_FLOPPY_SCUMMID_GOB2='gob:gob2'
APP_FLOPPY_ICON_GOB2='goggame-1207662293.ico'

APP_CDROM_SCUMMID_GOB2='gob:gob2cd'
APP_CDROM_ICON_GOB2='goggame-1207662293.ico'

## Goblins 3

APP_FLOPPY_SCUMMID_GOB3='gob:gob3'
APP_FLOPPY_ICON_GOB3='goggame-1207662313.ico'

APP_CDROM_SCUMMID_GOB3='gob:gob3cd'
APP_CDROM_ICON_GOB3='goggame-1207662313.ico'
## Set game language based on the available localization
APP_CDROM_PRERUN='# Set game language based on the available localization
if [ -e "${PATH_GAME}/frgob3.itk" ]; then
	APP_OPTIONS="${APP_OPTIONS:-} --language=fr"
elif [ -e "${PATH_GAME}/usgob3.itk" ]; then
	APP_OPTIONS="${APP_OPTIONS:-} --language=us"
fi
'

# Packages

## Common

PACKAGES_LIST='
PKG_COMMON
PKG_FLOPPY
PKG_CDROM'

## Goblins 1

PKG_COMMON_ID_GOB1="${GAME_ID_GOB1}-common"

PKG_MAIN_ID_GOB1="$GAME_ID_GOB1"

PKG_FLOPPY_ID_GOB1="${PKG_MAIN_ID_GOB1}-floppy"
PKG_FLOPPY_PROVIDES_GOB1="
$PKG_MAIN_ID_GOB1"
PKG_FLOPPY_DEPS_GOB1="$PKG_COMMON_ID_GOB1"

PKG_CDROM_ID_GOB1="${PKG_MAIN_ID_GOB1}-cdrom"
PKG_CDROM_PROVIDES_GOB1="
$PKG_MAIN_ID_GOB1"
PKG_CDROM_DEPS_GOB1="$PKG_COMMON_ID_GOB1"

## Goblins 2

PKG_COMMON_ID_GOB2="${GAME_ID_GOB2}-common"

PKG_MAIN_ID_GOB2="$GAME_ID_GOB2"

PKG_FLOPPY_ID_GOB2="${PKG_MAIN_ID_GOB2}-floppy"
PKG_FLOPPY_PROVIDES_GOB2="
$PKG_MAIN_ID_GOB2"
PKG_FLOPPY_DEPS_GOB2="$PKG_COMMON_ID_GOB2"

PKG_CDROM_ID_GOB2="${PKG_MAIN_ID_GOB2}-cdrom"
PKG_CDROM_PROVIDES_GOB2="
$PKG_MAIN_ID_GOB2"
PKG_CDROM_DEPS_GOB2="$PKG_COMMON_ID_GOB2"

## Goblins 3

PACKAGES_LIST_GOB3="
PKG_L10N
$PACKAGES_LIST"

PKG_COMMON_ID_GOB3="${GAME_ID_GOB3}-common"

PKG_L10N_ID_GOB3="${GAME_ID_GOB3}-l10n"
PKG_L10N_ID_GOB3_EN="${PKG_L10N_ID_GOB3}-en"
PKG_L10N_ID_GOB3_FR="${PKG_L10N_ID_GOB3}-fr"
PKG_L10N_PROVIDES_GOB3="
$PKG_L10N_ID_GOB3"
PKG_L10N_DESCRIPTION_GOB3_EN='English localization'
PKG_L10N_DESCRIPTION_GOB3_FR='French localization'

PKG_MAIN_ID_GOB3="$GAME_ID_GOB3"

PKG_FLOPPY_ID_GOB3="${PKG_MAIN_ID_GOB3}-floppy"
PKG_FLOPPY_PROVIDES_GOB3="
$PKG_MAIN_ID_GOB3"
PKG_FLOPPY_DEPS_GOB3="$PKG_COMMON_ID_GOB3"

PKG_CDROM_ID_GOB3="${PKG_MAIN_ID_GOB3}-cdrom"
PKG_CDROM_PROVIDES_GOB3="
$PKG_MAIN_ID_GOB3"
PKG_CDROM_DEPS_GOB3="$PKG_COMMON_ID_GOB3 $PKG_L10N_ID_GOB3"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Incude game data

set_current_package 'PKG_COMMON'
icons_inclusion
content_inclusion_default

# Write launchers

set_current_package 'PKG_FLOPPY'
launchers_write 'APP_FLOPPY'
set_current_package 'PKG_CDROM'
launchers_write 'APP_CDROM'

# Build packages

packages_generation
packages_list_floppy='PKG_FLOPPY PKG_COMMON'
packages_list_cdrom='PKG_CDROM PKG_COMMON'
case "$(current_archive)" in
	('ARCHIVE_BASE_GOB3_'*)
		packages_list_cdrom="$packages_list_cdrom PKG_L10N"
	;;
esac
case "${LANG%_*}" in
	('fr')
		version_string='version %s :'
		version_floppy='disquette'
		version_cdrom='CD-ROM'
	;;
	('en'|*)
		version_string='%s version:'
		version_floppy='Floppy'
		version_cdrom='CD-ROM'
	;;
esac
printf '\n'
printf "$version_string" "$version_floppy"
print_instructions $packages_list_floppy
printf "$version_string" "$version_cdrom"
print_instructions $packages_list_cdrom

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
