#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Mopi
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Interrogation: You Will Be Deceived
# send your bug reports to bugs@dotslashplay.it
###

script_version=20240929.1

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID='interrogation'
GAME_NAME='Interrogation: You Will Be Deceived'

ARCHIVE_BASE_0_NAME='interrogation_you_will_be_deceived_1_1_9_a1704342_39945.sh'
ARCHIVE_BASE_0_MD5='6e5c4d0ed24129d10a7781d034665b89'
ARCHIVE_BASE_0_SIZE='630000'
ARCHIVE_BASE_0_VERSION='1.1.9.a1704342-gog39954'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/interrogation_you_will_be_deceived'

CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_LIBS_BIN_FILES='
libfmod.so
libfmodstudio.so'
## The game binary is linked against libGalaxy64.so.
CONTENT_LIBS_BIN_FILES="${CONTENT_LIBS_BIN_FILES:-}
libGalaxy64.so"
CONTENT_GAME_BIN_FILES='
Interrogation.x86_64'
CONTENT_GAME_DATA_FILES='
banks
game.*'
CONTENT_DOC_FILES='
licenses.html'

APP_MAIN_EXE='Interrogation.x86_64'
APP_MAIN_ICON='../support/icon.png'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
## A link to libfmod.so.12 is omitted, the shipped libfmod.so is probably used for it.
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libGL.so.1
libGLU.so.1
libm.so.6
libopenal.so.1
libpthread.so.0
librt.so.1
libstdc++.so.6
libX11.so.6
libXext.so.6
libXi.so.6'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

## The game engine looks for some libraries in a hardcoded path
ln --symbolic "$(path_libraries)/libfmod.so" "$(package_path 'PKG_BIN')$(path_game_data)"
ln --symbolic "$(path_libraries)/libfmodstudio.so" "$(package_path 'PKG_BIN')$(path_game_data)"

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
