#ifndef __MIXSPINLOCK_H
#define __MIXSPINLOCK_H

/*#include <linux/spinlock.h>*/

typedef struct _mspinlock {
	volatile __s32 lock;
} mspinlock_t;

#ifdef CONFIG_SMP 

#if defined(__i386__) || defined(__x86_64__)

static inline void mspin_lock_init (mspinlock_t *lock) {
	lock->lock = 1;
}

static inline void mspin_lock (mspinlock_t *lock) {
	__asm__ __volatile__(
		"1:\n"
		"\tlock; decl %0\n"
		"\tjs 2f\n\n"
		LOCK_SECTION_START("")
		"2:\n"
		"\t\tpause\n"
		"\tcmpl $0,%0\n"
		"\tjle 2b\n"
		"jmp 1b\n"
		LOCK_SECTION_END
		:"=m" (lock->lock) : : "memory"
	);
}

static inline int mspin_trylock (mspinlock_t *lock) {
	__s32 old;

	__asm__ __volatile__(
		"xchgl %0,%1"
		:"=q" (old), "=m" (lock->lock) : "0" (0) : "memory"
	);

	return old > 0;
}

static inline void mspin_unlock (mspinlock_t *lock) {
	__asm__ __volatile__(
		"movl $1, %0"
		:"=m" (lock->lock) : : "memory"
	);
}

static inline int mspin_is_locked (mspinlock_t *lock) {
	return lock->lock <= 0;
}

#endif

#endif /* CONFIG_SMP */

/*
static inline void mspin_lock (mspinlock_t *lock) {
	__asm__ __volatile__(
		"1:\n"
		"\tlock; decl %0\n"
		"\tjs 2f\n\n"
		LOCK_SECTION_START("")
		"2:\n"
		"\t\tpause\n"
		"\tcmpl $0,%0\n"
		"\tjle 2b\n"
		"jmp 1b\n"
		LOCK_SECTION_END
		:"=m" (lock->lock) : : "memory"
	);
}
*/

#endif
