/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.runtime;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class RuntimeUtils {
    public static final String[] PATHS;

    public static File which(String executable) {
        for (String path : PATHS) {
            File file = new File(path, executable);
            if (!file.exists()) continue;
            return file.getAbsoluteFile();
        }
        return null;
    }

    public static List<String> getAbsoluteClassPaths() {
        String[] relativeClassPaths = System.getProperty("java.class.path").split(File.pathSeparator);
        ArrayList<String> absoluteClassPaths = new ArrayList<String>(relativeClassPaths.length);
        for (String classPath : relativeClassPaths) {
            File cp = new File(classPath);
            if (!cp.exists()) continue;
            absoluteClassPaths.add(cp.getAbsolutePath());
        }
        return absoluteClassPaths;
    }

    static {
        String path = System.getenv("PATH");
        if (path == null) {
            path = System.getenv("path");
        }
        PATHS = path == null ? new String[0] : StringUtils.split((String)path, (char)File.pathSeparatorChar);
    }
}

