/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.gvcf;

import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.GenotypeBuilder;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.vcf.VCFFormatHeaderLine;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import htsjdk.variant.vcf.VCFHeaderLineType;
import htsjdk.variant.vcf.VCFStandardHeaderLines;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.broadinstitute.gatk.utils.gvcf.HomRefBlock;
import org.broadinstitute.gatk.utils.variant.GATKVariantContextUtils;

public class GVCFWriter
implements VariantContextWriter {
    protected static final String BLOCK_SIZE_INFO_FIELD = "BLOCK_SIZE";
    protected static final String MIN_DP_FORMAT_FIELD = "MIN_DP";
    protected static final String MIN_GQ_FORMAT_FIELD = "MIN_GQ";
    private final VariantContextWriter underlyingWriter;
    private final List<HomRefBlock> GQPartitions;
    int nextAvailableStart = -1;
    String contigOfNextAvailableStart = null;
    private String sampleName = null;
    private HomRefBlock currentBlock = null;

    protected static List<HomRefBlock> parsePartitions(List<Integer> GQPartitions) {
        if (GQPartitions == null) {
            throw new IllegalArgumentException("GQpartitions cannot be null");
        }
        if (GQPartitions.isEmpty()) {
            throw new IllegalArgumentException("GQpartitions cannot be empty");
        }
        LinkedList<HomRefBlock> result = new LinkedList<HomRefBlock>();
        int lastThreshold = 0;
        for (Integer value : GQPartitions) {
            if (value == null) {
                throw new IllegalArgumentException("GQPartitions contains a null integer");
            }
            if (value < lastThreshold) {
                throw new IllegalArgumentException("GQPartitions is out of order.  Last is " + lastThreshold + " but next is " + value);
            }
            if (value == lastThreshold) {
                throw new IllegalArgumentException("GQPartitions is equal elements: Last is " + lastThreshold + " but next is " + value);
            }
            result.add(new HomRefBlock(lastThreshold, value));
            lastThreshold = value;
        }
        result.add(new HomRefBlock(lastThreshold, Integer.MAX_VALUE));
        return result;
    }

    public GVCFWriter(VariantContextWriter underlyingWriter, List<Integer> GQPartitions) {
        if (underlyingWriter == null) {
            throw new IllegalArgumentException("underlyingWriter cannot be null");
        }
        this.underlyingWriter = underlyingWriter;
        this.GQPartitions = GVCFWriter.parsePartitions(GQPartitions);
    }

    public void writeHeader(VCFHeader header) {
        if (header == null) {
            throw new IllegalArgumentException("header cannot be null");
        }
        header.addMetaDataLine((VCFHeaderLine)VCFStandardHeaderLines.getInfoLine((String)"END"));
        header.addMetaDataLine((VCFHeaderLine)new VCFFormatHeaderLine(MIN_DP_FORMAT_FIELD, 1, VCFHeaderLineType.Integer, "Minimum DP observed within the GVCF block"));
        for (HomRefBlock partition : this.GQPartitions) {
            header.addMetaDataLine(partition.toVCFHeaderLine());
        }
        this.underlyingWriter.writeHeader(header);
    }

    public void close() {
        this.close(true);
    }

    public void close(boolean closeUnderlyingWriter) {
        this.emitCurrentBlock();
        if (closeUnderlyingWriter) {
            this.underlyingWriter.close();
        }
    }

    protected VariantContext addHomRefSite(VariantContext vc, Genotype g) {
        if (this.nextAvailableStart != -1) {
            if (vc.getStart() <= this.nextAvailableStart && vc.getChr().equals(this.contigOfNextAvailableStart)) {
                return null;
            }
            this.nextAvailableStart = -1;
            this.contigOfNextAvailableStart = null;
        }
        if (this.currentBlock == null) {
            this.currentBlock = this.createNewBlock(vc, g);
            return null;
        }
        if (this.currentBlock.withinBounds(g.getGQ())) {
            this.currentBlock.add(vc.getStart(), g);
            return null;
        }
        VariantContext result = this.blockToVCF(this.currentBlock);
        this.currentBlock = this.createNewBlock(vc, g);
        return result;
    }

    private void emitCurrentBlock() {
        if (this.currentBlock != null) {
            this.underlyingWriter.add(this.blockToVCF(this.currentBlock));
            this.currentBlock = null;
        }
    }

    private VariantContext blockToVCF(HomRefBlock block) {
        if (block == null) {
            throw new IllegalArgumentException("block cannot be null");
        }
        VariantContextBuilder vcb = new VariantContextBuilder(block.getStartingVC());
        vcb.attributes(new HashMap(2));
        vcb.stop((long)block.getStop());
        vcb.attribute("END", (Object)block.getStop());
        GenotypeBuilder gb = new GenotypeBuilder(this.sampleName, Collections.nCopies(2, block.getRef()));
        gb.noAD().noPL().noAttributes();
        gb.GQ(block.getMedianGQ());
        gb.DP(block.getMedianDP());
        gb.attribute(MIN_DP_FORMAT_FIELD, (Object)block.getMinDP());
        gb.PL(block.getMinPLs());
        return vcb.genotypes(new Genotype[]{gb.make()}).make();
    }

    private HomRefBlock createNewBlock(VariantContext vc, Genotype g) {
        HomRefBlock partition = null;
        for (HomRefBlock maybePartition : this.GQPartitions) {
            if (!maybePartition.withinBounds(g.getGQ())) continue;
            partition = maybePartition;
            break;
        }
        if (partition == null) {
            throw new IllegalStateException("GQ " + g + " from " + vc + " didn't fit into any partition " + partition);
        }
        HomRefBlock block = new HomRefBlock(vc, partition.getGQLowerBound(), partition.getGQUpperBound());
        block.add(vc.getStart(), g);
        return block;
    }

    public void add(VariantContext vc) {
        Genotype g;
        if (vc == null) {
            throw new IllegalArgumentException("vc cannot be null");
        }
        if (this.sampleName == null) {
            this.sampleName = vc.getGenotype(0).getSampleName();
        }
        if (!vc.hasGenotypes()) {
            throw new IllegalArgumentException("GVCF assumes that the VariantContext has genotypes");
        }
        if (vc.getGenotypes().size() != 1) {
            throw new IllegalArgumentException("GVCF assumes that the VariantContext has exactly one genotype but saw " + vc.getGenotypes().size());
        }
        if (this.currentBlock != null && !this.currentBlock.isContiguous(vc)) {
            this.emitCurrentBlock();
        }
        if ((g = vc.getGenotype(0)).isHomRef() && vc.hasAlternateAllele(GATKVariantContextUtils.NON_REF_SYMBOLIC_ALLELE) && vc.isBiallelic()) {
            VariantContext maybeCompletedBand = this.addHomRefSite(vc, g);
            if (maybeCompletedBand != null) {
                this.underlyingWriter.add(maybeCompletedBand);
            }
        } else {
            this.emitCurrentBlock();
            this.nextAvailableStart = vc.getEnd();
            this.contigOfNextAvailableStart = vc.getChr();
            this.underlyingWriter.add(vc);
        }
    }
}

