/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.codecs.refseq;

import htsjdk.tribble.Feature;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.broadinstitute.gatk.engine.refdata.utils.GATKFeature;
import org.broadinstitute.gatk.engine.refdata.utils.RODRecordList;
import org.broadinstitute.gatk.utils.GenomeLoc;
import org.broadinstitute.gatk.utils.codecs.refseq.Transcript;
import org.broadinstitute.gatk.utils.exceptions.ReviewedGATKException;

public class RefSeqFeature
implements Transcript,
Feature {
    private String transcript_id;
    private int strand;
    private GenomeLoc transcript_interval;
    private GenomeLoc transcript_coding_interval;
    private List<GenomeLoc> exons;
    private String gene_name;
    private List<Integer> exon_frames;
    private String name;
    ArrayList<GenomeLoc> exonInRefOrderCache = null;

    public RefSeqFeature(GenomeLoc genomeLoc) {
        this.transcript_interval = genomeLoc;
    }

    @Override
    public String getTranscriptId() {
        return this.transcript_id;
    }

    @Override
    public int getStrand() {
        return this.strand;
    }

    @Override
    public GenomeLoc getLocation() {
        return this.transcript_interval;
    }

    @Override
    public GenomeLoc getCodingLocation() {
        return this.transcript_coding_interval;
    }

    @Override
    public String getGeneName() {
        return this.gene_name;
    }

    @Override
    public int getNumExons() {
        return this.exons.size();
    }

    @Override
    public GenomeLoc getExonLocation(int n) {
        if (n >= this.exons.size() || n < 0) {
            throw new ReviewedGATKException("Index out-of-bounds. Transcript has " + this.exons.size() + " exons; requested: " + n);
        }
        return this.exons.get(n);
    }

    @Override
    public List<GenomeLoc> getExons() {
        return this.exons;
    }

    public List<GenomeLoc> getExonsInInterval(GenomeLoc interval) {
        ArrayList<GenomeLoc> relevantExons = new ArrayList<GenomeLoc>(this.exons.size());
        for (GenomeLoc exon : this.getExons()) {
            if (!interval.containsP(exon)) continue;
            relevantExons.add(exon);
        }
        return relevantExons;
    }

    public List<Integer> getExonNumbersInInterval(GenomeLoc interval) {
        ArrayList<Integer> numbers = new ArrayList<Integer>();
        int iNo = 0;
        for (GenomeLoc exon : this.getExons()) {
            if (interval.containsP(exon)) {
                numbers.add(iNo);
            }
            ++iNo;
        }
        return numbers;
    }

    public String getTranscriptUniqueGeneName() {
        return String.format("%s(%s)", this.getGeneName(), this.getTranscriptId());
    }

    public String getOverlapString(GenomeLoc position) {
        boolean is_exon = false;
        StringBuilder overlapString = new StringBuilder();
        int exonNo = 1;
        for (GenomeLoc exon : this.exons) {
            if (exon.containsP(position)) {
                overlapString.append(String.format("exon_%d", exonNo));
                is_exon = true;
                break;
            }
            ++exonNo;
        }
        if (!is_exon) {
            if (this.overlapsCodingP(position)) {
                overlapString.append("Intron");
            } else {
                overlapString.append("UTR");
            }
        }
        return overlapString.toString();
    }

    public Integer getSortedOverlapInteger(GenomeLoc position) {
        ArrayList<GenomeLoc> exonsInReferenceOrder;
        int exonNo = -1;
        ArrayList<GenomeLoc> arrayList = exonsInReferenceOrder = this.exonInRefOrderCache != null ? this.exonInRefOrderCache : new ArrayList<GenomeLoc>(this.exons);
        if (this.exonInRefOrderCache == null) {
            Collections.sort(exonsInReferenceOrder);
        }
        this.exonInRefOrderCache = exonsInReferenceOrder;
        for (GenomeLoc exon : exonsInReferenceOrder) {
            if (exon.overlapsP(position)) {
                return ++exonNo;
            }
            ++exonNo;
        }
        return -1;
    }

    public GenomeLoc getSortedExonLoc(int offset) {
        ArrayList<GenomeLoc> exonsInReferenceOrder;
        ArrayList<GenomeLoc> arrayList = exonsInReferenceOrder = this.exonInRefOrderCache != null ? this.exonInRefOrderCache : new ArrayList<GenomeLoc>(this.exons);
        if (this.exonInRefOrderCache == null) {
            Collections.sort(exonsInReferenceOrder);
        }
        this.exonInRefOrderCache = exonsInReferenceOrder;
        return exonsInReferenceOrder.get(offset);
    }

    @Override
    public boolean overlapsP(GenomeLoc that) {
        return this.getLocation().overlapsP(that);
    }

    @Override
    public boolean overlapsCodingP(GenomeLoc that) {
        return this.transcript_coding_interval.overlapsP(that);
    }

    @Override
    public boolean overlapsExonP(GenomeLoc that) {
        for (GenomeLoc e : this.exons) {
            if (!e.overlapsP(that)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder b = new StringBuilder("000\t");
        b.append(this.transcript_id);
        b.append('\t');
        b.append(this.getLocation().getContig());
        b.append('\t');
        b.append(this.strand == 1 ? (char)'+' : '-');
        b.append('\t');
        b.append(this.getLocation().getStart() - 1);
        b.append('\t');
        b.append(this.getLocation().getStop());
        b.append('\t');
        b.append(this.transcript_coding_interval.getStart() - 1);
        b.append('\t');
        b.append(this.transcript_coding_interval.getStop());
        b.append('\t');
        b.append(this.exons.size());
        b.append('\t');
        for (GenomeLoc loc : this.exons) {
            b.append(loc.getStart() - 1);
            b.append(',');
        }
        b.append('\t');
        for (GenomeLoc loc : this.exons) {
            b.append(loc.getStop());
            b.append(',');
        }
        b.append("\t0\t");
        b.append(this.gene_name);
        b.append("\tcmpl\tcmpl\t");
        for (Integer f : this.exon_frames) {
            b.append(f);
            b.append(',');
        }
        return b.toString();
    }

    public static boolean isExon(RODRecordList l) {
        if (l == null) {
            return false;
        }
        GenomeLoc loc = l.getLocation();
        for (GATKFeature t : l) {
            if (!((RefSeqFeature)t.getUnderlyingObject()).overlapsExonP(loc)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCoding(RODRecordList l) {
        if (l == null) {
            return false;
        }
        GenomeLoc loc = l.getLocation();
        for (GATKFeature t : l) {
            if (!((RefSeqFeature)t.getUnderlyingObject()).overlapsCodingP(loc)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCodingExon(RODRecordList l) {
        if (l == null) {
            return false;
        }
        GenomeLoc loc = l.getLocation();
        for (GATKFeature t : l) {
            if (!((RefSeqFeature)t.getUnderlyingObject()).overlapsCodingP(loc) || !((RefSeqFeature)t.getUnderlyingObject()).overlapsExonP(loc)) continue;
            return true;
        }
        return false;
    }

    public void setTranscript_id(String transcript_id) {
        this.transcript_id = transcript_id;
    }

    public void setStrand(int strand) {
        this.strand = strand;
    }

    public void setTranscript_interval(GenomeLoc transcript_interval) {
        this.transcript_interval = transcript_interval;
    }

    public void setTranscript_coding_interval(GenomeLoc transcript_coding_interval) {
        this.transcript_coding_interval = transcript_coding_interval;
    }

    public void setExons(List<GenomeLoc> exons) {
        this.exons = exons;
    }

    public void setGene_name(String gene_name) {
        this.gene_name = gene_name;
    }

    public void setExon_frames(List<Integer> exon_frames) {
        this.exon_frames = exon_frames;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getChr() {
        return this.transcript_interval.getContig();
    }

    public int getStart() {
        return this.transcript_interval.getStart();
    }

    public int getEnd() {
        return this.transcript_interval.getStop();
    }
}

