/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils;

import htsjdk.variant.variantcontext.VariantContext;
import java.util.ArrayList;
import java.util.Arrays;
import org.broadinstitute.gatk.engine.contexts.ReferenceContext;
import org.broadinstitute.gatk.utils.exceptions.ReviewedGATKException;

public class IndelUtils {
    protected static final String[] COLUMN_KEYS = new String[51];
    private static final int START_IND_NOVEL = 4;
    private static final int STOP_IND_NOVEL = 13;
    private static final int START_IND_FOR_REPEAT_EXPANSION_1 = 14;
    private static final int IND_FOR_REPEAT_EXPANSION_A = 14;
    private static final int IND_FOR_REPEAT_EXPANSION_C = 15;
    private static final int IND_FOR_REPEAT_EXPANSION_G = 16;
    private static final int IND_FOR_REPEAT_EXPANSION_T = 17;
    private static final int STOP_IND_FOR_REPEAT_EXPANSION_2 = 29;
    private static final int START_IND_FOR_REPEAT_EXPANSION_COUNTS = 30;
    private static final int STOP_IND_FOR_REPEAT_EXPANSION_COUNTS = 39;
    private static final int START_IND_FOR_NUM_REPETITION_COUNTS = 40;
    private static final int STOP_IND_FOR_NUM_REPETITION_COUNTS = 49;
    private static final int IND_FOR_OTHER_EVENT = 50;
    private static final int START_IND_NOVEL_PER_BASE = 0;
    private static final int STOP_IND_NOVEL_PER_BASE = 3;

    private static String findMinimalEvent(String eventString) {
        String minEvent = eventString;
        for (int k = 1; k < eventString.length(); ++k) {
            if (eventString.length() % k > 0) continue;
            String str = eventString.substring(0, k);
            int numReps = eventString.length() / k;
            String r = "";
            for (int j = 0; j < numReps; ++j) {
                r = r.concat(str);
            }
            if (!r.matches(eventString)) continue;
            minEvent = str;
            break;
        }
        return minEvent;
    }

    public static ArrayList<Integer> findEventClassificationIndex(VariantContext vc, ReferenceContext ref) {
        String refPiece;
        String indelAlleleString;
        boolean done = false;
        ArrayList<Integer> inds = new ArrayList<Integer>();
        if (vc.isSimpleInsertion()) {
            indelAlleleString = vc.getAlternateAllele(0).getDisplayString().substring(1);
        } else if (vc.isSimpleDeletion()) {
            indelAlleleString = vc.getReference().getDisplayString().substring(1);
        } else {
            inds.add(50);
            return inds;
        }
        byte[] refBases = ref.getBases();
        indelAlleleString = IndelUtils.findMinimalEvent(indelAlleleString);
        int eventLength = indelAlleleString.length();
        int indStart = refBases.length / 2 - eventLength + 1;
        int numRepetitions = 0;
        while (!done) {
            if (indStart < 0) {
                done = true;
                continue;
            }
            refPiece = new String(Arrays.copyOfRange(refBases, indStart, indStart + eventLength));
            if (refPiece.matches(indelAlleleString)) {
                ++numRepetitions;
                indStart -= eventLength;
                continue;
            }
            done = true;
        }
        done = false;
        indStart = refBases.length / 2 + 1;
        while (!done && indStart + eventLength < refBases.length) {
            refPiece = new String(Arrays.copyOfRange(refBases, indStart, indStart + eventLength));
            if (refPiece.matches(indelAlleleString)) {
                ++numRepetitions;
                indStart += eventLength;
                continue;
            }
            done = true;
        }
        if (numRepetitions == 0) {
            int ind = 4 + (eventLength - 1);
            if (ind > 13) {
                ind = 13;
            }
            inds.add(ind);
            if (eventLength == 1) {
                int k;
                String keyStr = "Novel_" + indelAlleleString;
                for (k = 0; k <= 3 && !keyStr.matches(COLUMN_KEYS[k]); ++k) {
                }
                inds.add(k);
            }
        } else {
            int ind = 40 + (numRepetitions - 1);
            if (ind > 49) {
                ind = 49;
            }
            inds.add(ind);
            ind = 30 + (eventLength - 1);
            if (ind > 39) {
                ind = 39;
            }
            inds.add(ind);
            if (eventLength <= 2) {
                int k;
                String keyStr = "RepeatExpansion_" + indelAlleleString;
                for (k = 14; k <= 29 && !keyStr.matches(COLUMN_KEYS[k]); ++k) {
                }
                inds.add(k);
            }
        }
        return inds;
    }

    public static String getIndelClassificationName(int k) {
        if (k >= 0 && k < COLUMN_KEYS.length) {
            return COLUMN_KEYS[k];
        }
        throw new ReviewedGATKException("Invalid index when trying to get indel classification name");
    }

    public static boolean isInsideExtendedIndel(VariantContext vc, ReferenceContext ref) {
        return vc.getStart() != ref.getLocus().getStart();
    }

    static {
        IndelUtils.COLUMN_KEYS[0] = "Novel_A";
        IndelUtils.COLUMN_KEYS[1] = "Novel_C";
        IndelUtils.COLUMN_KEYS[2] = "Novel_G";
        IndelUtils.COLUMN_KEYS[3] = "Novel_T";
        IndelUtils.COLUMN_KEYS[4] = "NOVEL_1";
        IndelUtils.COLUMN_KEYS[5] = "NOVEL_2";
        IndelUtils.COLUMN_KEYS[6] = "NOVEL_3";
        IndelUtils.COLUMN_KEYS[7] = "NOVEL_4";
        IndelUtils.COLUMN_KEYS[8] = "NOVEL_5";
        IndelUtils.COLUMN_KEYS[9] = "NOVEL_6";
        IndelUtils.COLUMN_KEYS[10] = "NOVEL_7";
        IndelUtils.COLUMN_KEYS[11] = "NOVEL_8";
        IndelUtils.COLUMN_KEYS[12] = "NOVEL_9";
        IndelUtils.COLUMN_KEYS[13] = "NOVEL_10orMore";
        IndelUtils.COLUMN_KEYS[14] = "RepeatExpansion_A";
        IndelUtils.COLUMN_KEYS[15] = "RepeatExpansion_C";
        IndelUtils.COLUMN_KEYS[16] = "RepeatExpansion_G";
        IndelUtils.COLUMN_KEYS[17] = "RepeatExpansion_T";
        IndelUtils.COLUMN_KEYS[18] = "RepeatExpansion_AC";
        IndelUtils.COLUMN_KEYS[19] = "RepeatExpansion_AG";
        IndelUtils.COLUMN_KEYS[20] = "RepeatExpansion_AT";
        IndelUtils.COLUMN_KEYS[21] = "RepeatExpansion_CA";
        IndelUtils.COLUMN_KEYS[22] = "RepeatExpansion_CG";
        IndelUtils.COLUMN_KEYS[23] = "RepeatExpansion_CT";
        IndelUtils.COLUMN_KEYS[24] = "RepeatExpansion_GA";
        IndelUtils.COLUMN_KEYS[25] = "RepeatExpansion_GC";
        IndelUtils.COLUMN_KEYS[26] = "RepeatExpansion_GT";
        IndelUtils.COLUMN_KEYS[27] = "RepeatExpansion_TA";
        IndelUtils.COLUMN_KEYS[28] = "RepeatExpansion_TC";
        IndelUtils.COLUMN_KEYS[29] = "RepeatExpansion_TG";
        IndelUtils.COLUMN_KEYS[30] = "EventLength_1";
        IndelUtils.COLUMN_KEYS[31] = "EventLength_2";
        IndelUtils.COLUMN_KEYS[32] = "EventLength_3";
        IndelUtils.COLUMN_KEYS[33] = "EventLength_4";
        IndelUtils.COLUMN_KEYS[34] = "EventLength_5";
        IndelUtils.COLUMN_KEYS[35] = "EventLength_6";
        IndelUtils.COLUMN_KEYS[36] = "EventLength_7";
        IndelUtils.COLUMN_KEYS[37] = "EventLength_8";
        IndelUtils.COLUMN_KEYS[38] = "EventLength_9";
        IndelUtils.COLUMN_KEYS[39] = "EventLength_10orMore";
        IndelUtils.COLUMN_KEYS[40] = "NumRepetitions_1";
        IndelUtils.COLUMN_KEYS[41] = "NumRepetitions_2";
        IndelUtils.COLUMN_KEYS[42] = "NumRepetitions_3";
        IndelUtils.COLUMN_KEYS[43] = "NumRepetitions_4";
        IndelUtils.COLUMN_KEYS[44] = "NumRepetitions_5";
        IndelUtils.COLUMN_KEYS[45] = "NumRepetitions_6";
        IndelUtils.COLUMN_KEYS[46] = "NumRepetitions_7";
        IndelUtils.COLUMN_KEYS[47] = "NumRepetitions_8";
        IndelUtils.COLUMN_KEYS[48] = "NumRepetitions_9";
        IndelUtils.COLUMN_KEYS[49] = "NumRepetitions_10orMore";
        IndelUtils.COLUMN_KEYS[50] = "Other";
    }
}

