/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.goby.algorithmic.compression;

import edu.cornell.med.icb.goby.algorithmic.compression.FastArithmeticCoder;
import edu.cornell.med.icb.goby.algorithmic.compression.FastArithmeticCoderI;
import it.unimi.dsi.fastutil.io.FastByteArrayOutputStream;
import it.unimi.dsi.io.OutputBitStream;
import java.io.IOException;

public final class FastArithmeticCoderOrder1
implements FastArithmeticCoderI {
    FastArithmeticCoderI[] delegates;
    private int numSymbols;
    private int previousSymbol;
    private OutputBitStream[] outs;
    private FastByteArrayOutputStream[] arrays;
    private int[] lengths;

    public FastArithmeticCoderOrder1(int numSymbols) {
        this.delegates = new FastArithmeticCoderI[numSymbols];
        this.outs = new OutputBitStream[numSymbols];
        this.arrays = new FastByteArrayOutputStream[numSymbols];
        this.lengths = new int[numSymbols];
        for (int i = 0; i < numSymbols; ++i) {
            this.delegates[i] = new FastArithmeticCoder(numSymbols);
            this.arrays[i] = new FastByteArrayOutputStream();
            this.outs[i] = new OutputBitStream(this.arrays[i]);
        }
        this.numSymbols = numSymbols;
    }

    @Override
    public void reset() {
        this.previousSymbol = 0;
        for (FastArithmeticCoderI delegate : this.delegates) {
            delegate.reset();
        }
    }

    @Override
    public int encode(int x, OutputBitStream obs) throws IOException {
        int n = this.previousSymbol;
        this.lengths[n] = this.lengths[n] + 1;
        int result = this.delegates[this.previousSymbol].encode(x, this.outs[this.previousSymbol]);
        this.previousSymbol = x;
        return result;
    }

    @Override
    public int flush(OutputBitStream obs) throws IOException {
        int bitsWritten = 0;
        int i = 0;
        for (FastArithmeticCoderI delegate : this.delegates) {
            int delegateBitsWritten = 0;
            int bitsFlushed = delegate.flush(this.outs[i]);
            long length = this.outs[i].writtenBits();
            this.outs[i].flush();
            delegateBitsWritten += obs.writeNibble(this.lengths[i]);
            delegateBitsWritten = (int)((long)delegateBitsWritten + obs.write(this.arrays[i].array, length));
            ++i;
            bitsWritten += delegateBitsWritten;
        }
        return bitsWritten;
    }
}

