/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.vcf;

import htsjdk.variant.vcf.VCFLineParser;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class VCF3Parser
implements VCFLineParser {
    VCF3Parser() {
    }

    @Override
    public Map<String, String> parseLine(String valueLine, List<String> expectedTagOrder) {
        LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>();
        StringBuilder builder = new StringBuilder();
        int index = 0;
        int tagIndex = 0;
        boolean inQuote = false;
        for (char c : valueLine.toCharArray()) {
            switch (c) {
                case '\"': {
                    inQuote = !inQuote;
                    break;
                }
                case ',': {
                    if (!inQuote) {
                        ret.put(expectedTagOrder.get(tagIndex++), builder.toString());
                        builder = new StringBuilder();
                        break;
                    }
                }
                default: {
                    builder.append(c);
                }
            }
            ++index;
        }
        ret.put(expectedTagOrder.get(tagIndex++), builder.toString());
        index = 0;
        if (tagIndex != expectedTagOrder.size()) {
            throw new IllegalArgumentException("Unexpected tag count " + tagIndex + ", we expected " + expectedTagOrder.size());
        }
        Object object = ret.keySet().iterator();
        while (object.hasNext()) {
            String str = (String)object.next();
            if (!expectedTagOrder.get(index).equals(str)) {
                throw new IllegalArgumentException("Unexpected tag " + str + " in string " + valueLine);
            }
            ++index;
        }
        return ret;
    }
}

