/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.util.BinaryCodec;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class StringUtil {
    private static final byte UPPER_CASE_OFFSET = -32;
    public static final String EMPTY_STRING = "";

    public static <T> String join(String separator, Collection<T> objs) {
        if (objs.isEmpty()) {
            return EMPTY_STRING;
        }
        boolean notFirst = false;
        StringBuilder ret = new StringBuilder();
        for (T obj : objs) {
            if (notFirst) {
                ret.append(separator);
            }
            ret.append(obj.toString());
            notFirst = true;
        }
        return ret.toString();
    }

    public static <T> String join(String separator, T ... objs) {
        List<T> values = Arrays.asList(objs);
        return StringUtil.join(separator, values);
    }

    public static int split(String aString, String[] tokens, char delim) {
        String trailingString;
        int maxTokens = tokens.length;
        int nTokens = 0;
        int start = 0;
        int end = aString.indexOf(delim);
        if (end < 0) {
            tokens[nTokens++] = aString;
            return nTokens;
        }
        while (end >= 0 && nTokens < maxTokens) {
            tokens[nTokens++] = aString.substring(start, end);
            start = end + 1;
            end = aString.indexOf(delim, start);
        }
        if (nTokens < maxTokens && !(trailingString = aString.substring(start)).isEmpty()) {
            tokens[nTokens++] = trailingString;
        }
        return nTokens;
    }

    public static int splitConcatenateExcessTokens(String aString, String[] tokens, char delim) {
        int maxTokens = tokens.length;
        int nTokens = 0;
        int start = 0;
        int end = aString.indexOf(delim);
        if (end < 0) {
            tokens[nTokens++] = aString;
            return nTokens;
        }
        while (end >= 0 && nTokens < maxTokens - 1) {
            tokens[nTokens++] = aString.substring(start, end);
            start = end + 1;
            end = aString.indexOf(delim, start);
        }
        String trailingString = aString.substring(start);
        if (!trailingString.isEmpty()) {
            tokens[nTokens++] = trailingString;
        }
        return nTokens;
    }

    public static byte toLowerCase(byte b) {
        if (b < 65 || b > 90) {
            return b;
        }
        return (byte)(b - -32);
    }

    public static byte toUpperCase(byte b) {
        if (b < 97 || b > 122) {
            return b;
        }
        return (byte)(b + -32);
    }

    public static void toUpperCase(byte[] bytes) {
        int length = bytes.length;
        for (int i = 0; i < length; ++i) {
            if (bytes[i] < 97 || bytes[i] > 122) continue;
            bytes[i] = (byte)(bytes[i] + -32);
        }
    }

    public static String assertCharactersNotInString(String illegalChars, char ... chars) {
        for (char illegalChar : illegalChars.toCharArray()) {
            for (char ch : chars) {
                if (illegalChar != ch) continue;
                throw new IllegalArgumentException("Supplied String contains illegal character '" + illegalChar + "'.");
            }
        }
        return illegalChars;
    }

    public static String wordWrap(String s, int maxLineLength) {
        String[] lines = s.split("\n");
        StringBuilder sb = new StringBuilder();
        for (String line : lines) {
            if (sb.length() > 0) {
                sb.append('\n');
            }
            sb.append(StringUtil.wordWrapSingleLine(line, maxLineLength));
        }
        if (s.endsWith("\n")) {
            sb.append('\n');
        }
        return sb.toString();
    }

    public static String wordWrapSingleLine(String s, int maxLineLength) {
        if (s.length() <= maxLineLength) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        int startCopyFrom = 0;
        while (startCopyFrom < s.length()) {
            int i;
            int lastSpaceIndex = startCopyFrom;
            for (i = startCopyFrom; i < s.length() && i - startCopyFrom < maxLineLength; ++i) {
                if (!Character.isWhitespace(s.charAt(i))) continue;
                lastSpaceIndex = i;
            }
            if (i - startCopyFrom < maxLineLength) {
                lastSpaceIndex = i;
            }
            while (lastSpaceIndex < s.length() && Character.isWhitespace(s.charAt(lastSpaceIndex))) {
                ++lastSpaceIndex;
            }
            if (sb.length() > 0) {
                sb.append('\n');
            }
            if (lastSpaceIndex == startCopyFrom) {
                lastSpaceIndex = i;
            }
            sb.append(s.substring(startCopyFrom, lastSpaceIndex));
            startCopyFrom = lastSpaceIndex;
        }
        return sb.toString();
    }

    public static String intValuesToString(int[] intVals) {
        StringBuilder sb = new StringBuilder(intVals.length);
        if (intVals.length > 0) {
            sb.append(String.valueOf(intVals[0]));
            for (int i = 1; i < intVals.length; ++i) {
                sb.append(", ");
                sb.append(String.valueOf(intVals[i]));
            }
        }
        return sb.toString();
    }

    public static String intValuesToString(short[] shortVals) {
        StringBuilder sb = new StringBuilder(shortVals.length);
        if (shortVals.length > 0) {
            sb.append(String.valueOf(shortVals[0]));
            for (int i = 1; i < shortVals.length; ++i) {
                sb.append(", ");
                sb.append(String.valueOf(shortVals[i]));
            }
        }
        return sb.toString();
    }

    public static String bytesToString(byte[] data) {
        if (data == null) {
            return null;
        }
        return StringUtil.bytesToString(data, 0, data.length);
    }

    public static String bytesToString(byte[] buffer, int offset, int length) {
        return new String(buffer, 0, offset, length);
    }

    public static byte[] stringToBytes(String s) {
        if (s == null) {
            return null;
        }
        byte[] byteBuffer = new byte[s.length()];
        s.getBytes(0, byteBuffer.length, byteBuffer, 0);
        return byteBuffer;
    }

    public static byte[] stringToBytes(String s, int offset, int length) {
        if (s == null) {
            return null;
        }
        byte[] byteBuffer = new byte[length];
        s.getBytes(offset, offset + length, byteBuffer, 0);
        return byteBuffer;
    }

    public static String readNullTerminatedString(BinaryCodec binaryCodec) {
        StringBuilder ret = new StringBuilder();
        byte b = binaryCodec.readByte();
        while (b != 0) {
            ret.append((char)(b & 0xFF));
            b = binaryCodec.readByte();
        }
        return ret.toString();
    }

    public static void charsToBytes(char[] chars, int charOffset, int length, byte[] bytes, int byteOffset) {
        for (int i = 0; i < length; ++i) {
            bytes[byteOffset + i] = (byte)chars[charOffset + i];
        }
    }

    public static byte charToByte(char c) {
        return (byte)c;
    }

    public static char byteToChar(byte b) {
        return (char)(b & 0xFF);
    }

    public static String bytesToHexString(byte[] data) {
        char[] chars = new char[2 * data.length];
        for (int i = 0; i < data.length; ++i) {
            byte b = data[i];
            chars[2 * i] = StringUtil.toHexDigit(b >> 4 & 0xF);
            chars[2 * i + 1] = StringUtil.toHexDigit(b & 0xF);
        }
        return new String(chars);
    }

    public static byte[] hexStringToBytes(String s) throws NumberFormatException {
        if (s.length() % 2 != 0) {
            throw new NumberFormatException("Hex representation of byte string does not have even number of hex chars: " + s);
        }
        byte[] ret = new byte[s.length() / 2];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (byte)(StringUtil.fromHexDigit(s.charAt(i * 2)) << 4 | StringUtil.fromHexDigit(s.charAt(i * 2 + 1)));
        }
        return ret;
    }

    public static char toHexDigit(int value) {
        return (char)(value < 10 ? 48 + value : 65 + value - 10);
    }

    public static int fromHexDigit(char c) throws NumberFormatException {
        int ret = Character.digit(c, 16);
        if (ret == -1) {
            throw new NumberFormatException("Not a valid hex digit: " + c);
        }
        return ret;
    }

    public static String reverseString(String s) {
        StringBuilder sb = new StringBuilder(s);
        sb.reverse();
        return sb.toString();
    }

    public static boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String repeatCharNTimes(char c, int repeatNumber) {
        char[] output = new char[repeatNumber];
        Arrays.fill(output, c);
        return String.valueOf(output);
    }

    public static String asEmptyIfNull(Object string) {
        return string == null ? EMPTY_STRING : string.toString();
    }

    public static int levenshteinDistance(String string1, String string2, int swap, int substitution, int insertion, int deletion) {
        int i;
        int j;
        int[] row0 = new int[string2.length() + 1];
        int[] row1 = new int[string2.length() + 1];
        int[] row2 = new int[string2.length() + 1];
        byte[] str1 = string1.getBytes();
        byte[] str2 = string2.getBytes();
        for (j = 0; j < str2.length; ++j) {
            row1[j] = j * insertion;
        }
        for (i = 0; i < str1.length; ++i) {
            row2[0] = (i + 1) * deletion;
            for (j = 0; j < str2.length; ++j) {
                row2[j + 1] = row1[j];
                if (str1[i] != str2[j]) {
                    int n = j + 1;
                    row2[n] = row2[n] + substitution;
                }
                if (i > 0 && j > 0 && str1[i - 1] == str2[j] && str1[i] == str2[j - 1] && row2[j + 1] > row0[j - 1] + swap) {
                    row2[j + 1] = row0[j - 1] + swap;
                }
                if (row2[j + 1] > row1[j + 1] + deletion) {
                    row2[j + 1] = row1[j + 1] + deletion;
                }
                if (row2[j + 1] <= row2[j] + insertion) continue;
                row2[j + 1] = row2[j] + insertion;
            }
            int[] dummy = row0;
            row0 = row1;
            row1 = row2;
            row2 = dummy;
        }
        i = row1[str2.length];
        return i;
    }

    public static int hammingDistance(String s1, String s2) {
        if (s1.length() != s2.length()) {
            throw new IllegalArgumentException("Attempted to determine Hamming distance of strings with differing lengths. The first string has length " + s1.length() + " and the second string has length " + s2.length() + ".");
        }
        int measuredDistance = 0;
        for (int i = 0; i < s1.length(); ++i) {
            if (s1.charAt(i) == s2.charAt(i)) continue;
            ++measuredDistance;
        }
        return measuredDistance;
    }

    public static boolean isWithinHammingDistance(String s1, String s2, int maxHammingDistance) {
        if (s1.length() != s2.length()) {
            throw new IllegalArgumentException("Attempted to determine if two strings of different length were within a specified edit distance.");
        }
        int measuredDistance = 0;
        for (int i = 0; i < s1.length(); ++i) {
            if (s1.charAt(i) == s2.charAt(i) || ++measuredDistance <= maxHammingDistance) continue;
            return false;
        }
        return true;
    }
}

