/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.PeekableIterator;
import htsjdk.samtools.util.ReferenceSequenceMask;
import java.util.BitSet;
import java.util.List;

public class IntervalListReferenceSequenceMask
implements ReferenceSequenceMask {
    private final SAMFileHeader header;
    private final BitSet currentBitSet = new BitSet();
    private int currentSequenceIndex = -1;
    private final PeekableIterator<Interval> intervalIterator;
    private final int lastSequenceIndex;
    private final int lastPosition;

    public IntervalListReferenceSequenceMask(IntervalList intervalList) {
        List<Interval> uniqueIntervals;
        this.header = intervalList.getHeader();
        if (intervalList.getHeader().getSortOrder() != SAMFileHeader.SortOrder.coordinate) {
            intervalList.sorted();
        }
        if ((uniqueIntervals = intervalList.uniqued().getIntervals()).isEmpty()) {
            this.lastSequenceIndex = -1;
            this.lastPosition = 0;
        } else {
            Interval lastInterval = uniqueIntervals.get(uniqueIntervals.size() - 1);
            this.lastSequenceIndex = this.header.getSequenceIndex(lastInterval.getContig());
            this.lastPosition = lastInterval.getEnd();
        }
        this.intervalIterator = new PeekableIterator<Interval>(uniqueIntervals.iterator());
    }

    @Override
    public boolean get(int sequenceIndex, int position) {
        this.ensureSequenceLoaded(sequenceIndex);
        return this.currentBitSet.get(position);
    }

    @Override
    public int nextPosition(int sequenceIndex, int position) {
        this.ensureSequenceLoaded(sequenceIndex);
        return this.currentBitSet.nextSetBit(position + 1);
    }

    private void ensureSequenceLoaded(int sequenceIndex) {
        if (sequenceIndex < this.currentSequenceIndex) {
            throw new IllegalArgumentException("Cannot look at an earlier sequence.  Current: " + this.currentSequenceIndex + "; requested: " + sequenceIndex);
        }
        if (sequenceIndex > this.currentSequenceIndex) {
            this.currentBitSet.clear();
            while (this.intervalIterator.hasNext()) {
                Interval interval = this.intervalIterator.peek();
                int nextSequenceIndex = this.header.getSequenceIndex(interval.getContig());
                if (nextSequenceIndex < sequenceIndex) {
                    this.intervalIterator.next();
                    continue;
                }
                if (nextSequenceIndex != sequenceIndex) break;
                this.currentBitSet.set(interval.getStart(), interval.getEnd() + 1);
                this.intervalIterator.next();
            }
            this.currentSequenceIndex = sequenceIndex;
        }
    }

    @Override
    public int getMaxSequenceIndex() {
        return this.lastSequenceIndex;
    }

    @Override
    public int getMaxPosition() {
        return this.lastPosition;
    }

    public SAMFileHeader getHeader() {
        return this.header;
    }
}

