/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.Defaults;
import htsjdk.samtools.util.StringUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public class AsciiWriter
extends Writer {
    private final OutputStream os;
    private final byte[] buffer = new byte[Defaults.NON_ZERO_BUFFER_SIZE];
    private int numBytes;

    public AsciiWriter(OutputStream os) {
        this.os = os;
        this.numBytes = 0;
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.os.close();
    }

    @Override
    public void flush() throws IOException {
        this.os.write(this.buffer, 0, this.numBytes);
        this.numBytes = 0;
        this.os.flush();
    }

    @Override
    public void write(char[] chars, int offset, int length) throws IOException {
        while (length > 0) {
            int charsToConvert = Math.min(length, this.buffer.length - this.numBytes);
            StringUtil.charsToBytes(chars, offset, charsToConvert, this.buffer, this.numBytes);
            this.numBytes += charsToConvert;
            offset += charsToConvert;
            length -= charsToConvert;
            if (this.numBytes != this.buffer.length) continue;
            this.os.write(this.buffer, 0, this.numBytes);
            this.numBytes = 0;
        }
    }
}

