/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.monitor;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.WeakHashMap;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.query.ComponentParentQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WindowEventQueueMapping {
    final Map<EventQueue, Map<Window, Boolean>> queueMap = new WeakHashMap<EventQueue, Map<Window, Boolean>>();

    WindowEventQueueMapping() {
    }

    void addQueueFor(Toolkit toolkit) {
        this.queueMap.put(toolkit.getSystemEventQueue(), new WeakHashMap());
    }

    void addQueueFor(Component component) {
        EventQueue queue = component.getToolkit().getSystemEventQueue();
        Map<Window, Boolean> windowMapping = this.queueMap.get(queue);
        if (windowMapping == null) {
            windowMapping = this.createWindowMapping(queue);
        }
        if (!(component instanceof Window) || ComponentParentQuery.parentOf(component) != null) {
            return;
        }
        windowMapping.put((Window)component, Boolean.TRUE);
    }

    private Map<Window, Boolean> createWindowMapping(EventQueue queue) {
        WeakHashMap<Window, Boolean> windowMapping = new WeakHashMap<Window, Boolean>();
        this.queueMap.put(queue, windowMapping);
        return windowMapping;
    }

    @RunsInCurrentThread
    void removeMappingFor(Component component) {
        EventQueue queue = component.getToolkit().getSystemEventQueue();
        this.removeComponent(component, queue);
        for (EventQueue q : this.queueMap.keySet()) {
            this.removeComponent(component, q);
        }
    }

    private void removeComponent(Component component, EventQueue queue) {
        Map<Window, Boolean> windowMapping = this.queueMap.get(queue);
        if (windowMapping != null) {
            windowMapping.remove(component);
        }
    }

    Collection<Window> windows() {
        HashSet<Window> rootWindows = new HashSet<Window>();
        for (EventQueue queue : this.queueMap.keySet()) {
            rootWindows.addAll(this.queueMap.get(queue).keySet());
        }
        return rootWindows;
    }

    Collection<EventQueue> eventQueues() {
        return this.queueMap.keySet();
    }
}

