/*
 * Decompiled with CFR 0.152.
 */
package picard.sam.markduplicates.util;

import htsjdk.samtools.CoordinateSortedPairInfoMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractMap;
import java.util.Map;
import picard.PicardException;
import picard.sam.markduplicates.util.ReadEndsForMarkDuplicates;
import picard.sam.markduplicates.util.ReadEndsForMarkDuplicatesCodec;
import picard.sam.markduplicates.util.ReadEndsForMarkDuplicatesMap;

public class DiskBasedReadEndsForMarkDuplicatesMap
implements ReadEndsForMarkDuplicatesMap {
    private final CoordinateSortedPairInfoMap<String, ReadEndsForMarkDuplicates> pairInfoMap;

    public DiskBasedReadEndsForMarkDuplicatesMap(int maxOpenFiles) {
        this.pairInfoMap = new CoordinateSortedPairInfoMap(maxOpenFiles, (CoordinateSortedPairInfoMap.Codec)new Codec());
    }

    @Override
    public ReadEndsForMarkDuplicates remove(int mateSequenceIndex, String key) {
        return (ReadEndsForMarkDuplicates)this.pairInfoMap.remove(mateSequenceIndex, (Object)key);
    }

    @Override
    public void put(int mateSequenceIndex, String key, ReadEndsForMarkDuplicates readEnds) {
        this.pairInfoMap.put(mateSequenceIndex, (Object)key, (Object)readEnds);
    }

    @Override
    public int size() {
        return this.pairInfoMap.size();
    }

    @Override
    public int sizeInRam() {
        return this.pairInfoMap.sizeInRam();
    }

    private static class Codec
    implements CoordinateSortedPairInfoMap.Codec<String, ReadEndsForMarkDuplicates> {
        private final ReadEndsForMarkDuplicatesCodec readEndsForMarkDuplicatesCodec = new ReadEndsForMarkDuplicatesCodec();

        private Codec() {
        }

        public void setInputStream(InputStream is) {
            this.readEndsForMarkDuplicatesCodec.setInputStream(is);
        }

        public void setOutputStream(OutputStream os) {
            this.readEndsForMarkDuplicatesCodec.setOutputStream(os);
        }

        public Map.Entry<String, ReadEndsForMarkDuplicates> decode() {
            try {
                String key = this.readEndsForMarkDuplicatesCodec.getInputStream().readUTF();
                ReadEndsForMarkDuplicates record = this.readEndsForMarkDuplicatesCodec.decode();
                return new AbstractMap.SimpleEntry<String, ReadEndsForMarkDuplicates>(key, record);
            }
            catch (IOException e) {
                throw new PicardException("Error loading ReadEndsForMarkDuplicatesMap from disk", e);
            }
        }

        public void encode(String key, ReadEndsForMarkDuplicates readEnds) {
            try {
                this.readEndsForMarkDuplicatesCodec.getOutputStream().writeUTF(key);
                this.readEndsForMarkDuplicatesCodec.encode(readEnds);
            }
            catch (IOException e) {
                throw new PicardException("Error spilling ReadEndsForMarkDuplicatesMap to disk.", e);
            }
        }
    }
}

