/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis;

import htsjdk.samtools.SAMFileReader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import java.io.File;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.Metrics;

@CommandLineProgramProperties(usage="Collects quality yield metrics, a set of metrics that quantify the quality and yield of sequence data from a SAM/BAM input file.", usageShort="Collects a set of metrics that quantify the quality and yield of sequence data from the provided SAM/BAM", programGroup=Metrics.class)
public class CollectQualityYieldMetrics
extends CommandLineProgram {
    @Option(shortName="I", doc="A SAM or BAM file to process.")
    public File INPUT;
    @Option(shortName="O", doc="The metrics file to write with quality yield metrics.")
    public File OUTPUT;
    @Option(shortName="OQ", doc="If available in the OQ tag, use the original quality scores as inputs instead of the quality scores in the QUAL field.")
    public boolean USE_ORIGINAL_QUALITIES = true;

    public static void main(String[] argv) {
        new CollectQualityYieldMetrics().instanceMainWithExit(argv);
    }

    @Override
    protected int doWork() {
        Log log = Log.getInstance(this.getClass());
        ProgressLogger progress = new ProgressLogger(log);
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        log.info(new Object[]{"Reading input file and calculating metrics."});
        SAMFileReader sam = new SAMFileReader(IOUtil.openFileForReading((File)this.INPUT));
        MetricsFile metricsFile = this.getMetricsFile();
        QualityYieldMetrics metrics = new QualityYieldMetrics();
        for (SAMRecord rec : sam) {
            byte[] quals;
            boolean isPfRead;
            ++metrics.TOTAL_READS;
            int length = rec.getReadLength();
            boolean bl = isPfRead = !rec.getReadFailsVendorQualityCheckFlag();
            if (isPfRead) {
                ++metrics.PF_READS;
                metrics.PF_BASES += (long)length;
            }
            metrics.TOTAL_BASES += (long)length;
            if (this.USE_ORIGINAL_QUALITIES) {
                byte[] tmp = rec.getOriginalBaseQualities();
                if (tmp == null) {
                    tmp = rec.getBaseQualities();
                }
                quals = tmp;
            } else {
                quals = rec.getBaseQualities();
            }
            for (int i = 0; i < quals.length; ++i) {
                metrics.Q20_EQUIVALENT_YIELD += (long)quals[i];
                if (quals[i] >= 20) {
                    ++metrics.Q20_BASES;
                }
                if (quals[i] >= 30) {
                    ++metrics.Q30_BASES;
                }
                if (!isPfRead) continue;
                metrics.PF_Q20_EQUIVALENT_YIELD += (long)quals[i];
                if (quals[i] >= 20) {
                    ++metrics.PF_Q20_BASES;
                }
                if (quals[i] < 30) continue;
                ++metrics.PF_Q30_BASES;
            }
            progress.record(rec);
        }
        metrics.READ_LENGTH = metrics.TOTAL_READS == 0 ? 0 : (int)(metrics.TOTAL_BASES / (long)metrics.TOTAL_READS);
        metrics.Q20_EQUIVALENT_YIELD /= 20L;
        metrics.PF_Q20_EQUIVALENT_YIELD /= 20L;
        metricsFile.addMetric((MetricBase)metrics);
        metricsFile.write(this.OUTPUT);
        return 0;
    }

    public static class QualityYieldMetrics
    extends MetricBase {
        public int TOTAL_READS = 0;
        public int PF_READS = 0;
        public int READ_LENGTH = 0;
        public long TOTAL_BASES;
        public long PF_BASES = 0L;
        public long Q20_BASES = 0L;
        public long PF_Q20_BASES = 0L;
        public long Q30_BASES = 0L;
        public long PF_Q30_BASES = 0L;
        public long Q20_EQUIVALENT_YIELD = 0L;
        public long PF_Q20_EQUIVALENT_YIELD = 0L;
    }
}

