/*
 * Decompiled with CFR 0.152.
 */
package org.ibex.nestedvm;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.ibex.nestedvm.ClassFileCompiler;
import org.ibex.nestedvm.Compiler;
import org.ibex.nestedvm.UnixRuntime;
import org.ibex.nestedvm.util.Seekable;

public class RuntimeCompiler {
    public static Class compile(Seekable seekable) throws IOException, Compiler.Exn {
        return RuntimeCompiler.compile(seekable, null);
    }

    public static Class compile(Seekable seekable, String string) throws IOException, Compiler.Exn {
        return RuntimeCompiler.compile(seekable, string, null);
    }

    public static Class compile(Seekable seekable, String string, String string2) throws IOException, Compiler.Exn {
        byte[] byArray;
        String string3 = "nestedvm.runtimecompiled";
        try {
            byArray = RuntimeCompiler.runCompiler(seekable, string3, string, string2, null);
        }
        catch (Compiler.Exn exn) {
            if (exn.getMessage() != null || exn.getMessage().indexOf("constant pool full") != -1) {
                byArray = RuntimeCompiler.runCompiler(seekable, string3, string, string2, "lessconstants");
            }
            throw exn;
        }
        return new SingleClassLoader().fromBytes(string3, byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] runCompiler(Seekable seekable, String string, String string2, String string3, String string4) throws IOException, Compiler.Exn {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ClassFileCompiler classFileCompiler = new ClassFileCompiler(seekable, string, (OutputStream)byteArrayOutputStream);
            classFileCompiler.parseOptions("nosupportcall,maxinsnpermethod=256");
            classFileCompiler.setSource(string3);
            if (string2 != null) {
                classFileCompiler.parseOptions(string2);
            }
            if (string4 != null) {
                classFileCompiler.parseOptions(string4);
            }
            classFileCompiler.go();
        }
        finally {
            seekable.seek(0);
        }
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            System.err.println("Usage: RuntimeCompiler mipsbinary");
            System.exit(1);
        }
        UnixRuntime unixRuntime = (UnixRuntime)RuntimeCompiler.compile(new Seekable.File(stringArray[0]), "unixruntime").newInstance();
        System.err.println("Instansiated: " + unixRuntime);
        System.exit(UnixRuntime.runAndExec(unixRuntime, stringArray));
    }

    private RuntimeCompiler() {
    }

    private static class SingleClassLoader
    extends ClassLoader {
        private SingleClassLoader() {
        }

        public Class loadClass(String string, boolean bl) throws ClassNotFoundException {
            return super.loadClass(string, bl);
        }

        public Class fromBytes(String string, byte[] byArray) {
            return this.fromBytes(string, byArray, 0, byArray.length);
        }

        public Class fromBytes(String string, byte[] byArray, int n, int n2) {
            Class<?> clazz = super.defineClass(string, byArray, n, n2);
            this.resolveClass(clazz);
            return clazz;
        }
    }
}

