/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.OffsetDST;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMEZONETAB;
import oracle.sql.ZONEIDMAP;

public class TIMESTAMPTZ
extends Datum {
    static final long serialVersionUID = 6708361144588335769L;
    static final Calendar CAL_GMT_US = Calendar.getInstance(TimeZone.getTimeZone("GMT"), Locale.US);
    static final TimeZone TIMEZONE_UTC = TimeZone.getTimeZone("UTC");
    private static int HOUR_MILLISECOND = 3600000;
    private static int MINUTE_MILLISECOND = 60000;
    private static int OFFSET_HOUR = 20;
    private static int OFFSET_MINUTE = 60;
    private static byte REGIONIDBIT = (byte)-128;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
    public static final boolean TRACE = false;

    public TIMESTAMPTZ() {
        super(TIMESTAMPTZ.initTimestamptz());
    }

    public TIMESTAMPTZ(byte[] byArray) {
        super(byArray);
    }

    public TIMESTAMPTZ(Connection connection, Date date) throws SQLException {
        super(TIMESTAMPTZ.toBytes(connection, date));
    }

    public TIMESTAMPTZ(Connection connection, Date date, Calendar calendar) throws SQLException {
        super(TIMESTAMPTZ.toBytes(connection, date, calendar));
    }

    public TIMESTAMPTZ(Connection connection, Time time) throws SQLException {
        super(TIMESTAMPTZ.toBytes(connection, time));
    }

    public TIMESTAMPTZ(Connection connection, Time time, Calendar calendar) throws SQLException {
        super(TIMESTAMPTZ.toBytes(connection, time, calendar));
    }

    public TIMESTAMPTZ(Connection connection, Timestamp timestamp) throws SQLException {
        super(TIMESTAMPTZ.toBytes(connection, timestamp));
    }

    public TIMESTAMPTZ(Connection connection, Timestamp timestamp, Calendar calendar) throws SQLException {
        super(TIMESTAMPTZ.toBytes(connection, timestamp, calendar));
    }

    public TIMESTAMPTZ(Connection connection, DATE dATE) throws SQLException {
        super(TIMESTAMPTZ.toBytes(connection, dATE));
    }

    public TIMESTAMPTZ(Connection connection, String string) throws SQLException {
        super(TIMESTAMPTZ.toBytes(connection, string));
    }

    public TIMESTAMPTZ(Connection connection, String string, Calendar calendar) throws SQLException {
        super(TIMESTAMPTZ.toBytes(connection, string, calendar));
    }

    public static Date toDate(Connection connection, byte[] byArray) throws SQLException {
        int n2;
        int[] nArray = new int[13];
        for (n2 = 0; n2 < 13; ++n2) {
            nArray[n2] = byArray[n2] & 0xFF;
        }
        n2 = TIMESTAMP.getJavaYear(nArray[0], nArray[1]);
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, n2);
        calendar.set(2, nArray[2] - 1);
        calendar.set(5, nArray[3]);
        calendar.set(11, nArray[4] - 1);
        calendar.set(12, nArray[5] - 1);
        calendar.set(13, nArray[6] - 1);
        calendar.set(14, 0);
        if ((nArray[11] & REGIONIDBIT) != 0) {
            int n3 = TIMESTAMPTZ.getHighOrderbits(nArray[11]);
            TIMEZONETAB tIMEZONETAB = TIMESTAMPTZ.getTIMEZONETAB(connection);
            if (tIMEZONETAB.checkID(n3 += TIMESTAMPTZ.getLowOrderbits(nArray[12]))) {
                tIMEZONETAB.updateTable(connection, n3);
            }
            int n4 = tIMEZONETAB.getOffset(calendar, n3);
            calendar.add(10, n4 / HOUR_MILLISECOND);
            calendar.add(12, n4 % HOUR_MILLISECOND / MINUTE_MILLISECOND);
        } else {
            calendar.add(10, nArray[11] - OFFSET_HOUR);
            calendar.add(12, nArray[12] - OFFSET_MINUTE);
        }
        long l2 = calendar.getTime().getTime();
        return new Date(l2);
    }

    public static Date toDate2(Connection connection, byte[] byArray) throws SQLException {
        int n2;
        int[] nArray = new int[13];
        for (n2 = 0; n2 < 13; ++n2) {
            nArray[n2] = byArray[n2] & 0xFF;
        }
        n2 = TIMESTAMP.getJavaYear(nArray[0], nArray[1]);
        Calendar calendar = (Calendar)CAL_GMT_US.clone();
        calendar.set(1, n2);
        calendar.set(2, nArray[2] - 1);
        calendar.set(5, nArray[3]);
        calendar.set(11, nArray[4] - 1);
        calendar.set(12, nArray[5] - 1);
        calendar.set(13, nArray[6] - 1);
        calendar.set(14, 0);
        long l2 = calendar.getTime().getTime();
        return new Date(l2);
    }

    public static Time toTime(Connection connection, byte[] byArray) throws SQLException {
        int[] nArray = new int[13];
        for (int i2 = 0; i2 < 13; ++i2) {
            nArray[i2] = byArray[i2] & 0xFF;
        }
        Calendar calendar = (Calendar)CAL_GMT_US.clone();
        int n2 = TIMESTAMP.getJavaYear(nArray[0], nArray[1]);
        calendar.set(1, n2);
        calendar.set(2, nArray[2] - 1);
        calendar.set(5, nArray[3]);
        calendar.set(11, nArray[4] - 1);
        calendar.set(12, nArray[5] - 1);
        calendar.set(13, nArray[6] - 1);
        calendar.set(14, 0);
        return new Time(calendar.getTimeInMillis());
    }

    public static DATE toDATE(Connection connection, byte[] byArray) throws SQLException {
        return new DATE(TIMESTAMPTZ.toTimestampInSessionTimezone(connection, byArray));
    }

    public static TIMESTAMP toTIMESTAMP(Connection connection, byte[] byArray) throws SQLException {
        return new TIMESTAMP(TIMESTAMPTZ.toTimestampInSessionTimezone(connection, byArray));
    }

    public static Timestamp toTimestamp(Connection connection, byte[] byArray) throws SQLException {
        Cloneable cloneable;
        int[] nArray = new int[13];
        for (int i2 = 0; i2 < 13; ++i2) {
            nArray[i2] = byArray[i2] & 0xFF;
        }
        Calendar calendar = Calendar.getInstance();
        Calendar calendar2 = (Calendar)CAL_GMT_US.clone();
        Calendar calendar3 = Calendar.getInstance();
        int n2 = TIMESTAMP.getJavaYear(nArray[0], nArray[1]);
        calendar.set(1, n2);
        calendar.set(2, nArray[2] - 1);
        calendar.set(5, nArray[3]);
        calendar.set(11, nArray[4] - 1);
        calendar.set(12, nArray[5] - 1);
        calendar.set(13, nArray[6] - 1);
        calendar.set(14, 0);
        calendar2.set(1, n2);
        calendar2.set(2, nArray[2] - 1);
        calendar2.set(5, nArray[3]);
        calendar2.set(11, nArray[4] - 1);
        calendar2.set(12, nArray[5] - 1);
        calendar2.set(13, nArray[6] - 1);
        calendar2.set(14, 0);
        long l2 = calendar.getTime().getTime();
        if ((nArray[11] & REGIONIDBIT) != 0) {
            int n3 = TIMESTAMPTZ.getHighOrderbits(nArray[11]);
            TIMEZONETAB tIMEZONETAB = TIMESTAMPTZ.getTIMEZONETAB(connection);
            if (tIMEZONETAB.checkID(n3 += TIMESTAMPTZ.getLowOrderbits(nArray[12]))) {
                tIMEZONETAB.updateTable(connection, n3);
            }
            int n4 = tIMEZONETAB.getOffset(calendar2, n3);
            TimeZone timeZone = calendar.getTimeZone();
            cloneable = calendar3.getTimeZone();
            if (!timeZone.inDaylightTime(calendar.getTime()) && ((TimeZone)cloneable).inDaylightTime(new Timestamp(l2 += (long)n4))) {
                l2 = cloneable instanceof SimpleTimeZone ? (l2 -= (long)((SimpleTimeZone)cloneable).getDSTSavings()) : (l2 -= (long)HOUR_MILLISECOND);
            }
            if (timeZone.inDaylightTime(calendar.getTime()) && !((TimeZone)cloneable).inDaylightTime(new Timestamp(l2))) {
                l2 = cloneable instanceof SimpleTimeZone ? (l2 += (long)((SimpleTimeZone)timeZone).getDSTSavings()) : (l2 += (long)HOUR_MILLISECOND);
            }
        } else {
            calendar.add(10, nArray[11] - OFFSET_HOUR);
            calendar.add(12, nArray[12] - OFFSET_MINUTE);
            l2 = calendar.getTime().getTime();
        }
        Timestamp timestamp = new Timestamp(l2);
        long l3 = calendar2.getTime().getTime();
        cloneable = Calendar.getInstance();
        ((Calendar)cloneable).setTimeInMillis(l3);
        Calendar calendar4 = Calendar.getInstance();
        calendar4.setTime(timestamp);
        boolean bl = ((Calendar)cloneable).getTimeZone().inDaylightTime(((Calendar)cloneable).getTime());
        boolean bl2 = calendar4.getTimeZone().inDaylightTime(calendar4.getTime());
        if (bl && !bl2) {
            timestamp = new Timestamp(l2 - (long)((Calendar)cloneable).getTimeZone().getDSTSavings());
        } else if (!bl && bl2) {
            timestamp = new Timestamp(l2 + (long)calendar4.getTimeZone().getDSTSavings());
        }
        int n5 = TIMESTAMP.getNanos(byArray, 7);
        timestamp.setNanos(n5);
        return timestamp;
    }

    public static Timestamp toTimestamp2(Connection connection, byte[] byArray) throws SQLException {
        int n2;
        int[] nArray = new int[13];
        for (n2 = 0; n2 < 13; ++n2) {
            nArray[n2] = byArray[n2] & 0xFF;
        }
        n2 = TIMESTAMP.getJavaYear(nArray[0], nArray[1]);
        Calendar calendar = (Calendar)CAL_GMT_US.clone();
        calendar.clear();
        calendar.set(1, n2);
        calendar.set(2, nArray[2] - 1);
        calendar.set(5, nArray[3]);
        calendar.set(11, nArray[4] - 1);
        calendar.set(12, nArray[5] - 1);
        calendar.set(13, nArray[6] - 1);
        calendar.set(14, 0);
        long l2 = calendar.getTime().getTime();
        Timestamp timestamp = new Timestamp(l2);
        int n3 = TIMESTAMP.getNanos(byArray, 7);
        timestamp.setNanos(n3);
        return timestamp;
    }

    static Timestamp toTimestampInSessionTimezone(Connection connection, byte[] byArray) throws SQLException {
        int n2;
        int[] nArray = new int[13];
        for (n2 = 0; n2 < 13; ++n2) {
            nArray[n2] = byArray[n2] & 0xFF;
        }
        n2 = TIMESTAMP.getJavaYear(nArray[0], nArray[1]);
        Calendar calendar = (Calendar)CAL_GMT_US.clone();
        calendar.clear();
        calendar.set(1, n2);
        calendar.set(2, nArray[2] - 1);
        calendar.set(5, nArray[3]);
        calendar.set(11, nArray[4] - 1);
        calendar.set(12, nArray[5] - 1);
        calendar.set(13, nArray[6] - 1);
        calendar.set(14, 0);
        Calendar calendar2 = TIMESTAMPLTZ.getSessCalendar(connection);
        TIMESTAMPLTZ.TimeZoneAdjust(connection, calendar, calendar2);
        long l2 = calendar2.getTime().getTime();
        Timestamp timestamp = new Timestamp(l2);
        int n3 = TIMESTAMP.getNanos(byArray, 7);
        timestamp.setNanos(n3);
        return timestamp;
    }

    public static String toString(Connection connection, byte[] byArray) throws SQLException {
        String string;
        String string2;
        int n2;
        if ((byArray[11] & REGIONIDBIT) != 0) {
            n2 = TIMESTAMPTZ.getHighOrderbits(byArray[11]);
            string = string2 = ZONEIDMAP.getRegion(n2 += TIMESTAMPTZ.getLowOrderbits(byArray[12]));
        } else {
            n2 = byArray[11] - OFFSET_HOUR;
            int n3 = byArray[12] - OFFSET_MINUTE;
            string2 = n2 + ":";
            string2 = n3 == 0 ? string2 + "00" : string2 + "" + n3;
            string = "GMT" + (n2 >= 0 ? "+" : "") + string2;
        }
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone(string));
        Timestamp timestamp = TIMESTAMPTZ.toTimestamp2(connection, byArray);
        calendar.setTimeInMillis(timestamp.getTime());
        int n4 = calendar.get(1);
        if (calendar.get(0) == 0) {
            n4 = -(n4 - 1);
        }
        int n5 = calendar.get(2) + 1;
        int n6 = calendar.get(5);
        int n7 = calendar.get(11);
        int n8 = calendar.get(12);
        int n9 = calendar.get(13);
        int n10 = 0;
        n10 = (byArray[7] & 0xFF) << 24;
        n10 |= (byArray[8] & 0xFF) << 16;
        n10 |= (byArray[9] & 0xFF) << 8;
        return TIMESTAMPTZ.toString(n4, n5, n6, n7, n8, n9, n10 |= byArray[10] & 0xFF & 0xFF, string2);
    }

    public static final String toString(int n2, int n3, int n4, int n5, int n6, int n7, int n8, String string) {
        String string2 = "" + n2 + "-" + TIMESTAMPTZ.toStr(n3) + "-" + TIMESTAMPTZ.toStr(n4) + " " + TIMESTAMPTZ.toStr(n5) + ":" + TIMESTAMPTZ.toStr(n6) + ":" + TIMESTAMPTZ.toStr(n7);
        if (n8 >= 0) {
            int n9;
            String string3 = String.format("%09d", n8);
            char[] cArray = string3.toCharArray();
            for (n9 = cArray.length; n9 > 1 && cArray[n9 - 1] == '0'; --n9) {
            }
            string3 = string3.substring(0, n9);
            string2 = string2 + "." + string3;
        }
        if (string != null) {
            string2 = string2 + " " + string;
        }
        return string2;
    }

    private static final String toStr(int n2) {
        return n2 < 10 ? "0" + n2 : Integer.toString(n2);
    }

    public Timestamp timestampValue(Connection connection) throws SQLException {
        if (((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin().getTimestamptzInGmt()) {
            return TIMESTAMPTZ.toTimestamp2(connection, this.getBytes());
        }
        return TIMESTAMPTZ.toTimestamp(connection, this.getBytes());
    }

    public byte[] toBytes() {
        return this.getBytes();
    }

    public static byte[] toBytes(Connection connection, Date date) throws SQLException {
        return TIMESTAMPTZ.toBytes(connection, date, null);
    }

    public static byte[] toBytes(Connection connection, Date date, Calendar calendar) throws SQLException {
        if (date == null) {
            return null;
        }
        byte[] byArray = new byte[13];
        Calendar calendar2 = TIMESTAMPTZ.getWorkCal(connection, calendar);
        calendar2.setTime(date);
        Calendar calendar3 = TIMESTAMPTZ.doCalWork(connection, calendar2, byArray);
        int n2 = TIMESTAMP.getOracleYear(calendar3);
        byArray[0] = (byte)(n2 / 100 + 100);
        byArray[1] = (byte)(n2 % 100 + 100);
        byArray[2] = (byte)(calendar3.get(2) + 1);
        byArray[3] = (byte)calendar3.get(5);
        byArray[4] = (byte)(calendar3.get(11) + 1);
        byArray[5] = (byte)(calendar3.get(12) + 1);
        byArray[6] = (byte)(calendar3.get(13) + 1);
        byArray[7] = 0;
        byArray[8] = 0;
        byArray[9] = 0;
        byArray[10] = 0;
        return byArray;
    }

    public static byte[] toBytes(Connection connection, Time time) throws SQLException {
        return TIMESTAMPTZ.toBytes(connection, time, null);
    }

    public static byte[] toBytes(Connection connection, Time time, Calendar calendar) throws SQLException {
        if (time == null) {
            return null;
        }
        byte[] byArray = new byte[13];
        Calendar calendar2 = TIMESTAMPTZ.getWorkCal(connection, calendar);
        calendar2.setTime(time);
        int n2 = ((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin().getUse1900AsYearForTime() ? 1900 : 1970;
        calendar2.set(1, n2);
        calendar2.set(2, 0);
        calendar2.set(5, 1);
        Calendar calendar3 = TIMESTAMPTZ.doCalWork(connection, calendar2, byArray);
        int n3 = TIMESTAMP.getOracleYear(calendar3);
        byArray[0] = (byte)(n3 / 100 + 100);
        byArray[1] = (byte)(n3 % 100 + 100);
        byArray[2] = (byte)(calendar3.get(2) + 1);
        byArray[3] = (byte)calendar3.get(5);
        byArray[4] = (byte)(calendar3.get(11) + 1);
        byArray[5] = (byte)(calendar3.get(12) + 1);
        byArray[6] = (byte)(calendar3.get(13) + 1);
        byArray[7] = 0;
        byArray[8] = 0;
        byArray[9] = 0;
        byArray[10] = 0;
        return byArray;
    }

    public static byte[] toBytes(Connection connection, Timestamp timestamp) throws SQLException {
        return TIMESTAMPTZ.toBytes(connection, timestamp, null);
    }

    public static byte[] toBytes(Connection connection, Timestamp timestamp, Calendar calendar) throws SQLException {
        if (timestamp == null) {
            return null;
        }
        byte[] byArray = new byte[13];
        Calendar calendar2 = TIMESTAMPTZ.getWorkCal(connection, calendar);
        calendar2.setTime(timestamp);
        Calendar calendar3 = TIMESTAMPTZ.doCalWork(connection, calendar2, byArray);
        int n2 = TIMESTAMP.getOracleYear(calendar3);
        byArray[0] = (byte)(n2 / 100 + 100);
        byArray[1] = (byte)(n2 % 100 + 100);
        byArray[2] = (byte)(calendar3.get(2) + 1);
        byArray[3] = (byte)calendar3.get(5);
        byArray[4] = (byte)(calendar3.get(11) + 1);
        byArray[5] = (byte)(calendar3.get(12) + 1);
        byArray[6] = (byte)(calendar3.get(13) + 1);
        byArray[7] = (byte)(timestamp.getNanos() >> 24);
        byArray[8] = (byte)(timestamp.getNanos() >> 16 & 0xFF);
        byArray[9] = (byte)(timestamp.getNanos() >> 8 & 0xFF);
        byArray[10] = (byte)(timestamp.getNanos() & 0xFF);
        return byArray;
    }

    public static byte[] toBytes(Connection connection, DATE dATE) throws SQLException {
        if (dATE == null) {
            return null;
        }
        byte[] byArray = new byte[13];
        Calendar calendar = TIMESTAMPTZ.getWorkCal(connection, null);
        calendar.setTime(DATE.toDate(dATE.toBytes()));
        Calendar calendar2 = TIMESTAMPTZ.doCalWork(connection, calendar, byArray);
        int n2 = TIMESTAMP.getOracleYear(calendar2);
        byArray[0] = (byte)(n2 / 100 + 100);
        byArray[1] = (byte)(n2 % 100 + 100);
        byArray[2] = (byte)(calendar2.get(2) + 1);
        byArray[3] = (byte)calendar2.get(5);
        byArray[4] = (byte)(calendar2.get(11) + 1);
        byArray[5] = (byte)(calendar2.get(12) + 1);
        byArray[6] = (byte)(calendar2.get(13) + 1);
        byArray[7] = 0;
        byArray[8] = 0;
        byArray[9] = 0;
        byArray[10] = 0;
        return byArray;
    }

    public static byte[] toBytes(Connection connection, String string) throws SQLException {
        return TIMESTAMPTZ.toBytes(connection, Timestamp.valueOf(string));
    }

    public static byte[] toBytes(Connection connection, String string, Calendar calendar) throws SQLException {
        Calendar calendar2 = (Calendar)CAL_GMT_US.clone();
        Timestamp timestamp = TIMESTAMPTZ.parseTime(string);
        calendar2.setTime(timestamp);
        Calendar calendar3 = calendar == null ? Calendar.getInstance() : Calendar.getInstance(calendar.getTimeZone());
        calendar3.set(1, calendar2.get(1));
        calendar3.set(2, calendar2.get(2));
        calendar3.set(5, calendar2.get(5));
        calendar3.set(11, calendar2.get(11));
        calendar3.set(12, calendar2.get(12));
        calendar3.set(13, calendar2.get(13));
        calendar3.set(14, calendar2.get(14));
        int n2 = timestamp.getNanos();
        timestamp = new Timestamp(calendar3.getTime().getTime());
        timestamp.setNanos(n2);
        return TIMESTAMPTZ.toBytes(connection, timestamp, calendar);
    }

    @Override
    public String stringValue(Connection connection) throws SQLException {
        return TIMESTAMPTZ.toString(connection, this.getBytes());
    }

    public Date dateValue(Connection connection) throws SQLException {
        if (((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin().getTimestamptzInGmt()) {
            return TIMESTAMPTZ.toDate2(connection, this.getBytes());
        }
        return TIMESTAMPTZ.toDate(connection, this.getBytes());
    }

    public Time timeValue(Connection connection) throws SQLException {
        return TIMESTAMPTZ.toTime(connection, this.getBytes());
    }

    private static Calendar getWorkCal(Connection connection, Calendar calendar) {
        String string;
        Calendar calendar2 = calendar == null ? ((string = ((oracle.jdbc.OracleConnection)connection).getSessionTimeZone()) == null ? Calendar.getInstance() : Calendar.getInstance(TimeZone.getTimeZone(string))) : Calendar.getInstance(calendar.getTimeZone());
        return calendar2;
    }

    private static Calendar doCalWork(Connection connection, Calendar calendar, byte[] byArray) throws SQLException {
        Object object;
        int n2;
        boolean bl = calendar.getTimeZone().inDaylightTime(calendar.getTime());
        if (calendar.getTimeZone().getID() == "Custom") {
            n2 = calendar.getTimeZone().getRawOffset();
            byArray[11] = (byte)(n2 / HOUR_MILLISECOND + OFFSET_HOUR);
            byArray[12] = (byte)(n2 % HOUR_MILLISECOND / MINUTE_MILLISECOND + OFFSET_MINUTE);
        } else {
            object = calendar.getTimeZone().getID();
            int n3 = ZONEIDMAP.getID((String)object);
            if (!ZONEIDMAP.isValidID(n3)) {
                if (calendar.getTimeZone().useDaylightTime()) {
                    throw new SQLException("Timezone not supported");
                }
                n2 = calendar.getTimeZone().getRawOffset();
                byArray[11] = (byte)(n2 / HOUR_MILLISECOND + OFFSET_HOUR);
                byArray[12] = (byte)(n2 % HOUR_MILLISECOND / MINUTE_MILLISECOND + OFFSET_MINUTE);
            } else {
                TIMEZONETAB tIMEZONETAB = TIMESTAMPTZ.getTIMEZONETAB(connection);
                if (tIMEZONETAB.checkID(n3)) {
                    tIMEZONETAB.updateTable(connection, n3);
                }
                OffsetDST offsetDST = new OffsetDST();
                byte by = tIMEZONETAB.getLocalOffset(calendar, n3, offsetDST);
                n2 = offsetDST.getOFFSET();
                if (bl && by == 1) {
                    if (offsetDST.getDSTFLAG() == 0) {
                        n2 += HOUR_MILLISECOND;
                    } else {
                        throw new SQLException();
                    }
                }
                int n4 = ZONEIDMAP.getID((String)object);
                byArray[11] = (byte)TIMESTAMPTZ.setHighOrderbits(n4);
                byArray[11] = (byte)(byArray[11] | REGIONIDBIT);
                byArray[12] = (byte)TIMESTAMPTZ.setLowOrderbits(n4);
            }
        }
        object = (Calendar)CAL_GMT_US.clone();
        ((Calendar)object).set(0, calendar.get(0));
        ((Calendar)object).set(1, calendar.get(1));
        ((Calendar)object).set(2, calendar.get(2));
        ((Calendar)object).set(5, calendar.get(5));
        ((Calendar)object).set(11, calendar.get(11));
        ((Calendar)object).set(12, calendar.get(12));
        ((Calendar)object).set(13, calendar.get(13));
        ((Calendar)object).add(14, -1 * n2);
        return object;
    }

    private static byte[] initTimestamptz() {
        byte[] byArray = new byte[13];
        Calendar calendar = Calendar.getInstance();
        byArray[0] = 119;
        byArray[1] = -86;
        byArray[2] = 1;
        byArray[3] = 1;
        byArray[4] = 1;
        byArray[5] = 1;
        byArray[6] = 1;
        byArray[7] = 0;
        byArray[8] = 0;
        byArray[9] = 0;
        byArray[10] = 0;
        String string = calendar.getTimeZone().getID();
        byArray[11] = (byte)TIMESTAMPTZ.setHighOrderbits(ZONEIDMAP.getID(string));
        byArray[11] = (byte)(byArray[11] | REGIONIDBIT);
        byArray[12] = (byte)TIMESTAMPTZ.setLowOrderbits(ZONEIDMAP.getID(string));
        return byArray;
    }

    @Override
    public Object toJdbc() throws SQLException {
        return null;
    }

    @Override
    public Object makeJdbcArray(int n2) {
        Timestamp[] timestampArray = new Timestamp[n2];
        return timestampArray;
    }

    @Override
    public boolean isConvertibleTo(Class clazz) {
        return clazz.getName().compareTo("java.sql.Date") == 0 || clazz.getName().compareTo("java.sql.Time") == 0 || clazz.getName().compareTo("java.sql.Timestamp") == 0 || clazz.getName().compareTo("java.lang.String") == 0;
    }

    private static Timestamp parseTime(String string) throws SQLException {
        Object object;
        Object object2;
        int n2;
        String string2;
        if (string == null) {
            SQLException sQLException = DatabaseError.createSqlException(null, 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        String string3 = string.trim();
        int n3 = string3.indexOf(32);
        if (n3 == 0) {
            SQLException sQLException = DatabaseError.createSqlException(null, 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        String string4 = string3.substring(0, n3);
        if (string4 == null | (string2 = string3.substring(n3 + 1)) == null) {
            SQLException sQLException = DatabaseError.createSqlException(null, 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        int n4 = string4.indexOf(45);
        int n5 = string4.indexOf(45, n4 + 1);
        if (n4 < 1 || n5 < 1 || n5 == string4.length()) {
            SQLException sQLException = DatabaseError.createSqlException(null, 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        String string5 = string4.substring(0, n4);
        String string6 = string4.substring(n4 + 1, n5);
        String string7 = string4.substring(n5 + 1);
        if (string5.length() != 4 || string6.length() != 2 || string7.length() != 2) {
            SQLException sQLException = DatabaseError.createSqlException(null, 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        int n6 = Integer.parseInt(string5);
        int n7 = Integer.parseInt(string6) - 1;
        int n8 = Integer.parseInt(string7);
        int n9 = string2.indexOf(58);
        int n10 = string2.indexOf(58, n9 + 1);
        if (n9 < 1 || n10 < 1 || n10 == string2.length()) {
            SQLException sQLException = DatabaseError.createSqlException(null, 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        String string8 = string2.substring(0, n9);
        String string9 = string2.substring(n9 + 1, n10);
        if (string8.length() != 2 || string9.length() != 2) {
            SQLException sQLException = DatabaseError.createSqlException(null, 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        int n11 = Integer.parseInt(string8);
        int n12 = Integer.parseInt(string9);
        int n13 = 0;
        int n14 = string2.indexOf(46, n10 + 1);
        if (n14 == -1) {
            n2 = Integer.parseInt(string2.substring(n10 + 1));
        } else if (n14 > 0 && n14 < string2.length() - 1) {
            n2 = Integer.parseInt(string2.substring(n10 + 1, n14));
            object2 = string2.substring(n14 + 1);
            object = "000000000";
            if (((String)object2).length() > ((String)object).length() || !Character.isDigit(((String)object2).charAt(0))) {
                SQLException sQLException = DatabaseError.createSqlException(null, 68);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            object2 = (String)object2 + ((String)object).substring(0, ((String)object).length() - ((String)object2).length());
            n13 = Integer.parseInt((String)object2);
        } else {
            SQLException sQLException = DatabaseError.createSqlException(null, 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        object2 = (Calendar)CAL_GMT_US.clone();
        ((Calendar)object2).set(1, n6);
        ((Calendar)object2).set(2, n7);
        ((Calendar)object2).set(5, n8);
        ((Calendar)object2).set(11, n11);
        ((Calendar)object2).set(12, n12);
        ((Calendar)object2).set(13, n2);
        ((Calendar)object2).set(14, 0);
        object = new Timestamp(((Calendar)object2).getTime().getTime());
        ((Timestamp)object).setNanos(n13);
        return object;
    }

    private static int setHighOrderbits(int n2) {
        return (n2 & 0x1FC0) >> 6;
    }

    private static int setLowOrderbits(int n2) {
        return (n2 & 0x3F) << 2;
    }

    private static int getHighOrderbits(int n2) {
        return (n2 & 0x7F) << 6;
    }

    private static int getLowOrderbits(int n2) {
        return (n2 & 0xFC) >> 2;
    }

    static TIMEZONETAB getTIMEZONETAB(Connection connection) throws SQLException {
        OracleConnection oracleConnection = ((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin();
        return oracleConnection.getTIMEZONETAB();
    }
}

