/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.FieldrefConstant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.evaluation.BasicInvocationUnit;
import proguard.evaluation.TracedStack;
import proguard.evaluation.value.BasicValueFactory;
import proguard.evaluation.value.InstructionOffsetValue;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.TracedReferenceValue;
import proguard.evaluation.value.Value;
import proguard.optimize.evaluation.ParameterTracingInvocationUnit;
import proguard.optimize.evaluation.PartialEvaluator;
import proguard.optimize.evaluation.ReferenceTracingValueFactory;
import proguard.optimize.info.ParameterEscapeMarker;
import proguard.util.ArrayUtil;

public class ReferenceEscapeChecker
extends SimplifiedVisitor
implements AttributeVisitor,
InstructionVisitor,
ConstantVisitor {
    private static final boolean DEBUG = false;
    private boolean[] instanceEscaping = new boolean[8096];
    private boolean[] instanceReturned = new boolean[8096];
    private boolean[] instanceModified = new boolean[8096];
    private boolean[] externalInstance = new boolean[8096];
    private final PartialEvaluator partialEvaluator;
    private final boolean runPartialEvaluator;
    private Method referencingMethod;
    private int referencingOffset;
    private int referencingPopCount;

    public ReferenceEscapeChecker() {
        this(new ReferenceTracingValueFactory(new BasicValueFactory()));
    }

    private ReferenceEscapeChecker(ReferenceTracingValueFactory referenceTracingValueFactory) {
        this(new PartialEvaluator(referenceTracingValueFactory, new ParameterTracingInvocationUnit(new BasicInvocationUnit(referenceTracingValueFactory)), true, referenceTracingValueFactory), true);
    }

    public ReferenceEscapeChecker(PartialEvaluator partialEvaluator, boolean bl) {
        this.partialEvaluator = partialEvaluator;
        this.runPartialEvaluator = bl;
    }

    public boolean isInstanceEscaping(int n) {
        return this.instanceEscaping[n];
    }

    public boolean isInstanceReturned(int n) {
        return this.instanceReturned[n];
    }

    public boolean isInstanceModified(int n) {
        return this.instanceModified[n];
    }

    public boolean isInstanceExternal(int n) {
        return this.externalInstance[n];
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        if (this.runPartialEvaluator) {
            this.partialEvaluator.visitCodeAttribute(clazz, method, codeAttribute);
        }
        int n = codeAttribute.u4codeLength;
        this.instanceEscaping = ArrayUtil.ensureArraySize(this.instanceEscaping, n, false);
        this.instanceReturned = ArrayUtil.ensureArraySize(this.instanceReturned, n, false);
        this.instanceModified = ArrayUtil.ensureArraySize(this.instanceModified, n, false);
        this.externalInstance = ArrayUtil.ensureArraySize(this.externalInstance, n, false);
        codeAttribute.instructionsAccept(clazz, method, this.partialEvaluator.tracedInstructionFilter(this));
    }

    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
    }

    @Override
    public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SimpleInstruction simpleInstruction) {
        switch (simpleInstruction.opcode) {
            case 83: {
                this.markModifiedReferenceValues(n, simpleInstruction.stackPopCount(clazz) - 1);
                this.markEscapingReferenceValues(n, 0);
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 84: 
            case 85: 
            case 86: {
                this.markModifiedReferenceValues(n, simpleInstruction.stackPopCount(clazz) - 1);
                break;
            }
            case -80: {
                this.markReturnedReferenceValues(n, 0);
                break;
            }
            case -65: {
                this.markEscapingReferenceValues(n, 0);
            }
        }
    }

    @Override
    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ConstantInstruction constantInstruction) {
        switch (constantInstruction.opcode) {
            case -78: 
            case -76: {
                this.markExternalReferenceValue(n);
                break;
            }
            case -77: {
                this.markEscapingReferenceValues(n, 0);
                break;
            }
            case -75: {
                this.markModifiedReferenceValues(n, constantInstruction.stackPopCount(clazz) - 1);
                this.markEscapingReferenceValues(n, 0);
                break;
            }
            case -74: 
            case -73: 
            case -72: 
            case -71: {
                this.referencingMethod = method;
                this.referencingOffset = n;
                this.referencingPopCount = constantInstruction.stackPopCount(clazz);
                clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
            }
        }
    }

    @Override
    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    @Override
    public void visitFieldrefConstant(Clazz clazz, FieldrefConstant fieldrefConstant) {
        clazz.constantPoolEntryAccept(fieldrefConstant.u2classIndex, this);
    }

    @Override
    public void visitAnyMethodrefConstant(Clazz clazz, RefConstant refConstant) {
        Method method = (Method)refConstant.referencedMember;
        for (int i = 0; i < this.referencingPopCount; ++i) {
            int n = this.referencingPopCount - i - 1;
            TracedStack tracedStack = this.partialEvaluator.getStackBefore(this.referencingOffset);
            Value value = tracedStack.getTop(n);
            if (value.computationalType() != 5) continue;
            if (method == null || ParameterEscapeMarker.isParameterEscaping(method, i)) {
                this.markEscapingReferenceValues(this.referencingOffset, n);
            }
            if (method != null && !ParameterEscapeMarker.isParameterModified(method, i)) continue;
            this.markModifiedReferenceValues(this.referencingOffset, n);
        }
        String string = ClassUtil.internalMethodReturnType(refConstant.getType(clazz));
        if (method == null || (ClassUtil.isInternalClassType(string) || ClassUtil.isInternalArrayType(string)) && ParameterEscapeMarker.returnsExternalValues(method)) {
            this.markExternalReferenceValue(this.referencingOffset);
        }
    }

    private void markEscapingReferenceValues(int n, int n2) {
        ReferenceValue referenceValue;
        TracedStack tracedStack = this.partialEvaluator.getStackBefore(n);
        Value value = tracedStack.getTop(n2);
        if (value.computationalType() == 5 && (referenceValue = value.referenceValue()).isNull() != 1) {
            this.markEscapingReferenceValues(referenceValue);
        }
    }

    private void markEscapingReferenceValues(ReferenceValue referenceValue) {
        TracedReferenceValue tracedReferenceValue = (TracedReferenceValue)referenceValue;
        InstructionOffsetValue instructionOffsetValue = tracedReferenceValue.getTraceValue().instructionOffsetValue();
        int n = instructionOffsetValue.instructionOffsetCount();
        for (int i = 0; i < n; ++i) {
            if (instructionOffsetValue.isMethodParameter(i)) continue;
            this.instanceEscaping[instructionOffsetValue.instructionOffset((int)i)] = true;
        }
    }

    private void markReturnedReferenceValues(int n, int n2) {
        TracedStack tracedStack = this.partialEvaluator.getStackBefore(n);
        ReferenceValue referenceValue = tracedStack.getTop(n2).referenceValue();
        if (referenceValue.isNull() != 1) {
            this.markReturnedReferenceValues(referenceValue);
        }
    }

    private void markReturnedReferenceValues(ReferenceValue referenceValue) {
        TracedReferenceValue tracedReferenceValue = (TracedReferenceValue)referenceValue;
        InstructionOffsetValue instructionOffsetValue = tracedReferenceValue.getTraceValue().instructionOffsetValue();
        int n = instructionOffsetValue.instructionOffsetCount();
        for (int i = 0; i < n; ++i) {
            if (instructionOffsetValue.isMethodParameter(i)) continue;
            this.instanceReturned[instructionOffsetValue.instructionOffset((int)i)] = true;
        }
    }

    private void markModifiedReferenceValues(int n, int n2) {
        TracedStack tracedStack = this.partialEvaluator.getStackBefore(n);
        ReferenceValue referenceValue = tracedStack.getTop(n2).referenceValue();
        if (referenceValue.isNull() != 1) {
            this.markModifiedReferenceValues(referenceValue);
        }
    }

    private void markModifiedReferenceValues(ReferenceValue referenceValue) {
        TracedReferenceValue tracedReferenceValue = (TracedReferenceValue)referenceValue;
        InstructionOffsetValue instructionOffsetValue = tracedReferenceValue.getTraceValue().instructionOffsetValue();
        int n = instructionOffsetValue.instructionOffsetCount();
        for (int i = 0; i < n; ++i) {
            if (instructionOffsetValue.isMethodParameter(i)) continue;
            this.instanceModified[instructionOffsetValue.instructionOffset((int)i)] = true;
        }
    }

    private void markExternalReferenceValue(int n) {
        this.externalInstance[n] = true;
    }
}

