/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import org.fest.assertions.Description;
import org.fest.assertions.ErrorMessages;
import org.fest.assertions.NumberAssert;
import org.fest.assertions.PrimitiveAssert;

public class ShortAssert
extends PrimitiveAssert
implements NumberAssert {
    private static final short ZERO = 0;
    private final short actual;

    protected ShortAssert(short actual) {
        this.actual = actual;
    }

    public ShortAssert as(String description) {
        this.description(description);
        return this;
    }

    public ShortAssert describedAs(String description) {
        return this.as(description);
    }

    public ShortAssert as(Description description) {
        this.description(description);
        return this;
    }

    public ShortAssert describedAs(Description description) {
        return this.as(description);
    }

    public ShortAssert isEqualTo(short expected) {
        if (this.actual == expected) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedNotEqual(this.actual, expected));
    }

    public ShortAssert isNotEqualTo(short other) {
        if (this.actual != other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedEqual(this.actual, other));
    }

    public ShortAssert isGreaterThan(short other) {
        if (this.actual > other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedLessThanOrEqualTo(this.actual, other));
    }

    public ShortAssert isLessThan(short other) {
        if (this.actual < other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedGreaterThanOrEqualTo(this.actual, other));
    }

    public ShortAssert isGreaterThanOrEqualTo(short other) {
        if (this.actual >= other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedLessThan(this.actual, other));
    }

    public ShortAssert isLessThanOrEqualTo(short other) {
        if (this.actual <= other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedGreaterThan(this.actual, other));
    }

    public ShortAssert isZero() {
        return this.isEqualTo((short)0);
    }

    public ShortAssert isPositive() {
        return this.isGreaterThan((short)0);
    }

    public ShortAssert isNegative() {
        return this.isLessThan((short)0);
    }

    public ShortAssert overridingErrorMessage(String message) {
        this.replaceDefaultErrorMessagesWith(message);
        return this;
    }
}

