/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.ArrayList;
import java.util.List;
import org.fest.assertions.ArrayInspection;
import org.fest.assertions.Formatting;
import org.fest.assertions.GroupAssert;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ArrayAssert<T>
extends GroupAssert<T> {
    protected ArrayAssert(T actual) {
        super(actual);
    }

    @Override
    protected final int actualGroupSize() {
        this.isNotNull();
        return ArrayInspection.sizeOf(this.actual);
    }

    protected final void assertContains(List<Object> values) {
        List<Object> notFound = this.notFoundInActual(values);
        if (notFound.isEmpty()) {
            return;
        }
        this.failIfCustomMessageIsSet();
        this.failureIfExpectedElementsNotFound(notFound.toArray());
    }

    private List<Object> notFoundInActual(List<Object> values) {
        List<Object> copy = ArrayInspection.copy(this.actual);
        ArrayList<Object> notFound = new ArrayList<Object>();
        for (Object value : values) {
            if (copy.contains(value)) continue;
            notFound.add(value);
        }
        return notFound;
    }

    protected final void assertContainsOnly(List<Object> values) {
        List<Object> copy = ArrayInspection.copy(this.actual);
        List<Object> notFound = this.notFoundInCopy(copy, values);
        if (!notFound.isEmpty()) {
            this.failureIfExpectedElementsNotFound(notFound.toArray());
        }
        if (copy.isEmpty()) {
            return;
        }
        throw this.failureIfUnexpectedElementsFound(copy.toArray());
    }

    private List<Object> notFoundInCopy(List<Object> copy, List<Object> values) {
        ArrayList<Object> notFound = new ArrayList<Object>();
        for (Object value : values) {
            if (!copy.contains(value)) {
                notFound.add(value);
                continue;
            }
            copy.remove(value);
        }
        return notFound;
    }

    private void failureIfExpectedElementsNotFound(Object[] notFound) {
        this.failIfCustomMessageIsSet();
        this.fail(Strings.concat((Object[])new Object[]{"array:", this.actualInBrackets(), " does not contain element(s):", Formatting.inBrackets(notFound)}));
    }

    private AssertionError failureIfUnexpectedElementsFound(Object[] unexpected) {
        this.failIfCustomMessageIsSet();
        return this.failure(Strings.concat((Object[])new Object[]{"unexpected element(s):", Formatting.inBrackets(unexpected), " in array:", this.actualInBrackets()}));
    }

    protected final void assertExcludes(List<Object> values) {
        List<Object> copyOfActual = ArrayInspection.copy(this.actual);
        ArrayList<Object> found = new ArrayList<Object>();
        for (Object value : values) {
            if (!copyOfActual.contains(value)) continue;
            found.add(value);
        }
        if (found.isEmpty()) {
            return;
        }
        this.failIfCustomMessageIsSet();
        this.fail(Strings.concat((Object[])new Object[]{"array:", this.actualInBrackets(), " does not exclude element(s):", Formatting.inBrackets(found.toArray())}));
    }

    protected final String actualInBrackets() {
        return Formatting.inBrackets(this.actual);
    }

    protected final void assertThatActualIsNotNull() {
        if (this.actual != null) {
            return;
        }
        this.failIfCustomMessageIsSet();
        this.fail("expecting a non-null array, but it was null");
    }

    @Override
    public final void isEmpty() {
        if (this.actualGroupSize() == 0) {
            return;
        }
        this.failIfCustomMessageIsSet();
        this.fail(Strings.concat((Object[])new Object[]{"expecting empty array, but was:", this.actualInBrackets()}));
    }

    @Override
    public final void isNullOrEmpty() {
        if (this.actual == null || this.actualGroupSize() == 0) {
            return;
        }
        this.failIfCustomMessageIsSet();
        this.fail(Strings.concat((Object[])new Object[]{"expecting a null or empty array, but was:", this.actualInBrackets()}));
    }

    protected final void assertThatActualIsNotEmpty() {
        if (this.actualGroupSize() > 0) {
            return;
        }
        this.failIfCustomMessageIsSet();
        this.fail("expecting a non-empty array, but it was empty");
    }

    protected final void assertThatActualHasSize(int expected) {
        int actualSize = this.actualGroupSize();
        if (actualSize == expected) {
            return;
        }
        this.failIfCustomMessageIsSet();
        this.fail(Strings.concat((Object[])new Object[]{"expected size:", Formatting.inBrackets(expected), " but was:", Formatting.inBrackets(actualSize), " for array:", this.actualInBrackets()}));
    }
}

