/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.jdbc.OracleArray;
import oracle.jdbc.OracleBfile;
import oracle.jdbc.OracleBlob;
import oracle.jdbc.OracleClob;
import oracle.jdbc.OracleData;
import oracle.jdbc.OracleOpaque;
import oracle.jdbc.OracleRef;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleConnection;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.DATE;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

abstract class Redirector<T> {
    private final Class<T> type;
    private static final HashMap<Class, Redirector> CLASS_TO_REDIRECTOR = new HashMap();
    private static final HashMap<Class, Redirector> CLASS_TO_ERROR;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_;
    public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
    public static final boolean TRACE = false;

    private Redirector(Class<T> clazz) {
        this.type = clazz;
    }

    abstract T redirect(Accessor var1, int var2) throws SQLException;

    final Class<T> getTarget() {
        return this.type;
    }

    public String toString() {
        return super.toString() + "[" + this.type.getName() + "]";
    }

    static <V> Redirector<V> createObjectRedirector(Class<V> clazz) {
        return new Redirector<V>((Class)clazz){

            @Override
            final V redirect(Accessor accessor, int n2) throws SQLException {
                try {
                    Object object = accessor.getObject(n2);
                    Class clazz = this.getTarget();
                    if (object != null && !clazz.isInstance(object)) {
                        SQLException sQLException = DatabaseError.createSqlException(null, 49, clazz.getName());
                        sQLException.fillInStackTrace();
                        throw sQLException;
                    }
                    return object;
                }
                catch (ClassCastException classCastException) {
                    SQLException sQLException = DatabaseError.createSqlException(null, 4);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
            }
        };
    }

    static <V> Redirector<V> createValueOfRedirector(Class<V> clazz, List<Class> list) {
        if (Modifier.isPublic(clazz.getModifiers())) {
            Method[] methodArray = clazz.getDeclaredMethods();
            int n2 = Integer.MAX_VALUE;
            Method method = null;
            Class clazz2 = null;
            for (Method method2 : methodArray) {
                if (Modifier.isStatic(method2.getModifiers()) && Modifier.isPublic(method2.getModifiers()) && method2.getName().equals("valueOf") && method2.getParameterTypes().length == 1 && clazz.isAssignableFrom(method2.getReturnType())) {
                    int n3 = 0;
                    for (Class clazz3 : list) {
                        if (method2.getParameterTypes()[0].isAssignableFrom(clazz3)) {
                            if (n3 >= n2) break;
                            n2 = n3;
                            method = method2;
                            clazz2 = clazz3;
                            break;
                        }
                        ++n3;
                    }
                }
                if (n2 == 0) break;
            }
            if (method != null) {
                return Redirector.createValueOfRedirector(method, clazz2);
            }
        }
        return new Redirector<V>((Class)clazz){

            @Override
            final V redirect(Accessor accessor, int n2) throws SQLException {
                SQLException sQLException = DatabaseError.createSqlException(null, 4);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        };
    }

    private static <V> Redirector<V> createValueOfRedirector(final Method method, Class clazz) {
        final Redirector redirector = CLASS_TO_REDIRECTOR.get(clazz);
        return new Redirector<V>(clazz){

            @Override
            public final V redirect(Accessor accessor, int n2) throws SQLException {
                try {
                    if (accessor.isNull(n2)) {
                        return null;
                    }
                    return method.invoke(null, redirector.redirect(accessor, n2));
                }
                catch (IllegalAccessException illegalAccessException) {
                    SQLException sQLException = DatabaseError.createSqlException(null, 1, illegalAccessException.getMessage());
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    SQLException sQLException = DatabaseError.createSqlException(null, 1, illegalArgumentException.getMessage());
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                catch (InvocationTargetException invocationTargetException) {
                    if (invocationTargetException.getTargetException() instanceof SQLException) {
                        throw (SQLException)invocationTargetException.getTargetException();
                    }
                    SQLException sQLException = DatabaseError.createSqlException(null, 1, "Got something other than a SQLException: " + invocationTargetException.getTargetException());
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
            }
        };
    }

    static Map<Class, Redirector> createRedirectorMap(Collection<Class> collection) {
        Map map = (Map)CLASS_TO_ERROR.clone();
        for (Class clazz : collection) {
            assert (CLASS_TO_REDIRECTOR.get(clazz) != null) : clazz;
            map.put(clazz, CLASS_TO_REDIRECTOR.get(clazz));
        }
        return map;
    }

    static OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    static {
        CLASS_TO_REDIRECTOR.put(Array.class, new Redirector<Array>(Array.class){

            @Override
            final Array redirect(Accessor accessor, int n2) throws SQLException {
                return accessor.getARRAY(n2);
            }
        });
        CLASS_TO_REDIRECTOR.put(BigDecimal.class, new Redirector<BigDecimal>(BigDecimal.class){

            @Override
            final BigDecimal redirect(Accessor accessor, int n2) throws SQLException {
                return accessor.getBigDecimal(n2);
            }
        });
        CLASS_TO_REDIRECTOR.put(Blob.class, new Redirector<Blob>(Blob.class){

            @Override
            final Blob redirect(Accessor accessor, int n2) throws SQLException {
                return accessor.getBLOB(n2);
            }
        });
        CLASS_TO_REDIRECTOR.put(Boolean.class, new Redirector<Boolean>(Boolean.class){

            @Override
            final Boolean redirect(Accessor accessor, int n2) throws SQLException {
                return accessor.getBoolean(n2);
            }
        });
        CLASS_TO_REDIRECTOR.put(Byte.class, new Redirector<Byte>(Byte.class){

            @Override
            final Byte redirect(Accessor accessor, int n2) throws SQLException {
                return accessor.getByte(n2);
            }
        });
        CLASS_TO_REDIRECTOR.put(byte[].class, new Redirector<byte[]>(byte[].class){

            @Override
            final byte[] redirect(Accessor accessor, int n2) throws SQLException {
                return accessor.getBytes(n2);
            }
        });
        CLASS_TO_REDIRECTOR.put(Clob.class, new Redirector<Clob>(Clob.class){

            @Override
            final Clob redirect(Accessor accessor, int n2) throws SQLException {
                return accessor.getCLOB(n2);
            }
        });
        CLASS_TO_REDIRECTOR.put(Date.class, new Redirector<Date>(Date.class){

            @Override
            final Date redirect(Accessor accessor, int n2) throws SQLException {
                return accessor.getDate(n2);
            }
        });
        CLASS_TO_REDIRECTOR.put(Double.class, new Redirector<Double>(Double.class){

            @Override
            final Double redirect(Accessor accessor, int n2) throws SQLException {
                return accessor.getDouble(n2);
            }
        });
        CLASS_TO_REDIRECTOR.put(Float.class, new Redirector<Float>(Float.class){

            @Override
            final Float redirect(Accessor accessor, int n2) throws SQLException {
                return Float.valueOf(accessor.getFloat(n2));
            }
        });
        CLASS_TO_REDIRECTOR.put(Integer.class, new Redirector<Integer>(Integer.class){

            @Override
            final Integer redirect(Accessor accessor, int n2) throws SQLException {
                return accessor.getInt(n2);
            }
        });
        CLASS_TO_REDIRECTOR.put(Long.class, new Redirector<Long>(Long.class){

            @Override
            final Long redirect(Accessor accessor, int n2) throws SQLException {
                return accessor.getLong(n2);
            }
        });
        CLASS_TO_REDIRECTOR.put(NClob.class, new Redirector<NClob>(NClob.class){

            @Override
            final NClob redirect(Accessor accessor, int n2) throws SQLException {
                return accessor.getNClob(n2);
            }
        });
        CLASS_TO_REDIRECTOR.put(Ref.class, new Redirector<Ref>(Ref.class){

            @Override
            final Ref redirect(Accessor accessor, int n2) throws SQLException {
                return accessor.getREF(n2);
            }
        });
        CLASS_TO_REDIRECTOR.put(RowId.class, new Redirector<RowId>(RowId.class){

            @Override
            final RowId redirect(Accessor accessor, int n2) throws SQLException {
                return accessor.getROWID(n2);
            }
        });
        CLASS_TO_REDIRECTOR.put(Short.class, new Redirector<Short>(Short.class){

            @Override
            final Short redirect(Accessor accessor, int n2) throws SQLException {
                return accessor.getShort(n2);
            }
        });
        CLASS_TO_REDIRECTOR.put(SQLXML.class, new Redirector<SQLXML>(SQLXML.class){

            @Override
            final SQLXML redirect(Accessor accessor, int n2) throws SQLException {
                return accessor.getSQLXML(n2);
            }
        });
        CLASS_TO_REDIRECTOR.put(String.class, new Redirector<String>(String.class){

            @Override
            final String redirect(Accessor accessor, int n2) throws SQLException {
                return accessor.getString(n2);
            }
        });
        CLASS_TO_REDIRECTOR.put(Struct.class, new Redirector<Struct>(Struct.class){

            @Override
            final Struct redirect(Accessor accessor, int n2) throws SQLException {
                return accessor.getStruct(n2);
            }
        });
        CLASS_TO_REDIRECTOR.put(Time.class, new Redirector<Time>(Time.class){

            @Override
            final Time redirect(Accessor accessor, int n2) throws SQLException {
                return accessor.getTime(n2);
            }
        });
        CLASS_TO_REDIRECTOR.put(Timestamp.class, new Redirector<Timestamp>(Timestamp.class){

            @Override
            final Timestamp redirect(Accessor accessor, int n2) throws SQLException {
                return accessor.getTimestamp(n2);
            }
        });
        CLASS_TO_REDIRECTOR.put(URL.class, new Redirector<URL>(URL.class){

            @Override
            final URL redirect(Accessor accessor, int n2) throws SQLException {
                return accessor.getURL(n2);
            }
        });
        CLASS_TO_REDIRECTOR.put(BigInteger.class, new Redirector<BigInteger>(BigInteger.class){

            @Override
            final BigInteger redirect(Accessor accessor, int n2) throws SQLException {
                return accessor.getBigInteger(n2);
            }
        });
        CLASS_TO_REDIRECTOR.put(java.util.Date.class, new Redirector<java.util.Date>(java.util.Date.class){

            @Override
            final java.util.Date redirect(Accessor accessor, int n2) throws SQLException {
                return accessor.getJavaUtilDate(n2);
            }
        });
        CLASS_TO_REDIRECTOR.put(Calendar.class, new Redirector<Calendar>(Calendar.class){

            @Override
            final Calendar redirect(Accessor accessor, int n2) throws SQLException {
                return accessor.getCalendar(n2);
            }
        });
        CLASS_TO_REDIRECTOR.put(ARRAY.class, new Redirector<ARRAY>(ARRAY.class){

            @Override
            final ARRAY redirect(Accessor accessor, int n2) throws SQLException {
                return accessor.getARRAY(n2);
            }
        });
        CLASS_TO_REDIRECTOR.put(BFILE.class, new Redirector<BFILE>(BFILE.class){

            @Override
            final BFILE redirect(Accessor accessor, int n2) throws SQLException {
                return accessor.getBFILE(n2);
            }
        });
        CLASS_TO_REDIRECTOR.put(BINARY_FLOAT.class, new Redirector<BINARY_FLOAT>(BINARY_FLOAT.class){

            @Override
            final BINARY_FLOAT redirect(Accessor accessor, int n2) throws SQLException {
                return accessor.getBINARY_FLOAT(n2);
            }
        });
        CLASS_TO_REDIRECTOR.put(BINARY_DOUBLE.class, new Redirector<BINARY_DOUBLE>(BINARY_DOUBLE.class){

            @Override
            final BINARY_DOUBLE redirect(Accessor accessor, int n2) throws SQLException {
                return accessor.getBINARY_DOUBLE(n2);
            }
        });
        CLASS_TO_REDIRECTOR.put(BLOB.class, new Redirector<BLOB>(BLOB.class){

            @Override
            final BLOB redirect(Accessor accessor, int n2) throws SQLException {
                return accessor.getBLOB(n2);
            }
        });
        CLASS_TO_REDIRECTOR.put(CHAR.class, new Redirector<CHAR>(CHAR.class){

            @Override
            final CHAR redirect(Accessor accessor, int n2) throws SQLException {
                return accessor.getCHAR(n2);
            }
        });
        CLASS_TO_REDIRECTOR.put(CLOB.class, new Redirector<CLOB>(CLOB.class){

            @Override
            final CLOB redirect(Accessor accessor, int n2) throws SQLException {
                return accessor.getCLOB(n2);
            }
        });
        CLASS_TO_REDIRECTOR.put(ResultSet.class, new Redirector<ResultSet>(ResultSet.class){

            @Override
            final ResultSet redirect(Accessor accessor, int n2) throws SQLException {
                return accessor.getCursor(n2);
            }
        });
        CLASS_TO_REDIRECTOR.put(DATE.class, new Redirector<DATE>(DATE.class){

            @Override
            final DATE redirect(Accessor accessor, int n2) throws SQLException {
                return accessor.getDATE(n2);
            }
        });
        CLASS_TO_REDIRECTOR.put(INTERVALDS.class, new Redirector<INTERVALDS>(INTERVALDS.class){

            @Override
            final INTERVALDS redirect(Accessor accessor, int n2) throws SQLException {
                return accessor.getINTERVALDS(n2);
            }
        });
        CLASS_TO_REDIRECTOR.put(INTERVALYM.class, new Redirector<INTERVALYM>(INTERVALYM.class){

            @Override
            final INTERVALYM redirect(Accessor accessor, int n2) throws SQLException {
                return accessor.getINTERVALYM(n2);
            }
        });
        CLASS_TO_REDIRECTOR.put(NUMBER.class, new Redirector<NUMBER>(NUMBER.class){

            @Override
            final NUMBER redirect(Accessor accessor, int n2) throws SQLException {
                return accessor.getNUMBER(n2);
            }
        });
        CLASS_TO_REDIRECTOR.put(OPAQUE.class, new Redirector<OPAQUE>(OPAQUE.class){

            @Override
            final OPAQUE redirect(Accessor accessor, int n2) throws SQLException {
                return accessor.getOPAQUE(n2);
            }
        });
        CLASS_TO_REDIRECTOR.put(ORAData.class, new Redirector<ORAData>(ORAData.class){

            @Override
            final ORAData redirect(Accessor accessor, int n2) throws SQLException {
                return accessor.getORAData(n2);
            }
        });
        CLASS_TO_REDIRECTOR.put(OracleData.class, new Redirector<OracleData>(OracleData.class){

            @Override
            final OracleData redirect(Accessor accessor, int n2) throws SQLException {
                return accessor.getOracleData(n2);
            }
        });
        CLASS_TO_REDIRECTOR.put(RAW.class, new Redirector<RAW>(RAW.class){

            @Override
            final RAW redirect(Accessor accessor, int n2) throws SQLException {
                return accessor.getRAW(n2);
            }
        });
        CLASS_TO_REDIRECTOR.put(REF.class, new Redirector<REF>(REF.class){

            @Override
            final REF redirect(Accessor accessor, int n2) throws SQLException {
                return accessor.getREF(n2);
            }
        });
        CLASS_TO_REDIRECTOR.put(ROWID.class, new Redirector<ROWID>(ROWID.class){

            @Override
            final ROWID redirect(Accessor accessor, int n2) throws SQLException {
                return accessor.getROWID(n2);
            }
        });
        CLASS_TO_REDIRECTOR.put(STRUCT.class, new Redirector<STRUCT>(STRUCT.class){

            @Override
            final STRUCT redirect(Accessor accessor, int n2) throws SQLException {
                return accessor.getSTRUCT(n2);
            }
        });
        CLASS_TO_REDIRECTOR.put(TIMESTAMPLTZ.class, new Redirector<TIMESTAMPLTZ>(TIMESTAMPLTZ.class){

            @Override
            final TIMESTAMPLTZ redirect(Accessor accessor, int n2) throws SQLException {
                return accessor.getTIMESTAMPLTZ(n2);
            }
        });
        CLASS_TO_REDIRECTOR.put(TIMESTAMPTZ.class, new Redirector<TIMESTAMPTZ>(TIMESTAMPTZ.class){

            @Override
            final TIMESTAMPTZ redirect(Accessor accessor, int n2) throws SQLException {
                return accessor.getTIMESTAMPTZ(n2);
            }
        });
        CLASS_TO_REDIRECTOR.put(TIMESTAMP.class, new Redirector<TIMESTAMP>(TIMESTAMP.class){

            @Override
            final TIMESTAMP redirect(Accessor accessor, int n2) throws SQLException {
                return accessor.getTIMESTAMP(n2);
            }
        });
        CLASS_TO_REDIRECTOR.put(OracleArray.class, new Redirector<OracleArray>(OracleArray.class){

            @Override
            final OracleArray redirect(Accessor accessor, int n2) throws SQLException {
                return accessor.getARRAY(n2);
            }
        });
        CLASS_TO_REDIRECTOR.put(OracleBlob.class, new Redirector<OracleBlob>(OracleBlob.class){

            @Override
            final OracleBlob redirect(Accessor accessor, int n2) throws SQLException {
                return accessor.getBLOB(n2);
            }
        });
        CLASS_TO_REDIRECTOR.put(OracleClob.class, new Redirector<OracleClob>(OracleClob.class){

            @Override
            final OracleClob redirect(Accessor accessor, int n2) throws SQLException {
                return accessor.getCLOB(n2);
            }
        });
        CLASS_TO_REDIRECTOR.put(OracleBfile.class, new Redirector<OracleBfile>(OracleBfile.class){

            @Override
            final OracleBfile redirect(Accessor accessor, int n2) throws SQLException {
                return accessor.getBFILE(n2);
            }
        });
        CLASS_TO_REDIRECTOR.put(OracleRef.class, new Redirector<OracleRef>(OracleRef.class){

            @Override
            final OracleRef redirect(Accessor accessor, int n2) throws SQLException {
                return accessor.getREF(n2);
            }
        });
        CLASS_TO_REDIRECTOR.put(OracleOpaque.class, new Redirector<OracleOpaque>(OracleOpaque.class){

            @Override
            final OracleOpaque redirect(Accessor accessor, int n2) throws SQLException {
                return accessor.getOPAQUE(n2);
            }
        });
        CLASS_TO_REDIRECTOR.put(InputStream.class, new Redirector<InputStream>(InputStream.class){

            @Override
            final InputStream redirect(Accessor accessor, int n2) throws SQLException {
                return accessor.getBinaryStream(n2);
            }
        });
        CLASS_TO_REDIRECTOR.put(Reader.class, new Redirector<Reader>(Reader.class){

            @Override
            final Reader redirect(Accessor accessor, int n2) throws SQLException {
                return accessor.getCharacterStream(n2);
            }
        });
        CLASS_TO_ERROR = new HashMap();
        CLASS_TO_ERROR.put(Array.class, new Redirector<Array>(Array.class){

            @Override
            final Array redirect(Accessor accessor, int n2) throws SQLException {
                SQLException sQLException = DatabaseError.createSqlException(null, 4);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        });
        CLASS_TO_ERROR.put(BigDecimal.class, new Redirector<BigDecimal>(BigDecimal.class){

            @Override
            final BigDecimal redirect(Accessor accessor, int n2) throws SQLException {
                SQLException sQLException = DatabaseError.createSqlException(null, 4);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        });
        CLASS_TO_ERROR.put(Blob.class, new Redirector<Blob>(Blob.class){

            @Override
            final Blob redirect(Accessor accessor, int n2) throws SQLException {
                SQLException sQLException = DatabaseError.createSqlException(null, 4);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        });
        CLASS_TO_ERROR.put(Boolean.class, new Redirector<Boolean>(Boolean.class){

            @Override
            final Boolean redirect(Accessor accessor, int n2) throws SQLException {
                SQLException sQLException = DatabaseError.createSqlException(null, 4);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        });
        CLASS_TO_ERROR.put(Byte.class, new Redirector<Byte>(Byte.class){

            @Override
            final Byte redirect(Accessor accessor, int n2) throws SQLException {
                SQLException sQLException = DatabaseError.createSqlException(null, 4);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        });
        CLASS_TO_ERROR.put(byte[].class, new Redirector<byte[]>(byte[].class){

            @Override
            final byte[] redirect(Accessor accessor, int n2) throws SQLException {
                SQLException sQLException = DatabaseError.createSqlException(null, 4);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        });
        CLASS_TO_ERROR.put(Clob.class, new Redirector<Clob>(Clob.class){

            @Override
            final Clob redirect(Accessor accessor, int n2) throws SQLException {
                SQLException sQLException = DatabaseError.createSqlException(null, 4);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        });
        CLASS_TO_ERROR.put(Date.class, new Redirector<Date>(Date.class){

            @Override
            final Date redirect(Accessor accessor, int n2) throws SQLException {
                SQLException sQLException = DatabaseError.createSqlException(null, 4);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        });
        CLASS_TO_ERROR.put(Double.class, new Redirector<Double>(Double.class){

            @Override
            final Double redirect(Accessor accessor, int n2) throws SQLException {
                SQLException sQLException = DatabaseError.createSqlException(null, 4);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        });
        CLASS_TO_ERROR.put(Float.class, new Redirector<Float>(Float.class){

            @Override
            final Float redirect(Accessor accessor, int n2) throws SQLException {
                SQLException sQLException = DatabaseError.createSqlException(null, 4);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        });
        CLASS_TO_ERROR.put(Integer.class, new Redirector<Integer>(Integer.class){

            @Override
            final Integer redirect(Accessor accessor, int n2) throws SQLException {
                SQLException sQLException = DatabaseError.createSqlException(null, 4);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        });
        CLASS_TO_ERROR.put(Long.class, new Redirector<Long>(Long.class){

            @Override
            final Long redirect(Accessor accessor, int n2) throws SQLException {
                SQLException sQLException = DatabaseError.createSqlException(null, 4);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        });
        CLASS_TO_ERROR.put(NClob.class, new Redirector<NClob>(NClob.class){

            @Override
            final NClob redirect(Accessor accessor, int n2) throws SQLException {
                SQLException sQLException = DatabaseError.createSqlException(null, 4);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        });
        CLASS_TO_ERROR.put(Ref.class, new Redirector<Ref>(Ref.class){

            @Override
            final Ref redirect(Accessor accessor, int n2) throws SQLException {
                SQLException sQLException = DatabaseError.createSqlException(null, 4);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        });
        CLASS_TO_ERROR.put(RowId.class, new Redirector<RowId>(RowId.class){

            @Override
            final RowId redirect(Accessor accessor, int n2) throws SQLException {
                SQLException sQLException = DatabaseError.createSqlException(null, 4);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        });
        CLASS_TO_ERROR.put(Short.class, new Redirector<Short>(Short.class){

            @Override
            final Short redirect(Accessor accessor, int n2) throws SQLException {
                SQLException sQLException = DatabaseError.createSqlException(null, 4);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        });
        CLASS_TO_ERROR.put(SQLXML.class, new Redirector<SQLXML>(SQLXML.class){

            @Override
            final SQLXML redirect(Accessor accessor, int n2) throws SQLException {
                SQLException sQLException = DatabaseError.createSqlException(null, 4);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        });
        CLASS_TO_ERROR.put(String.class, new Redirector<String>(String.class){

            @Override
            final String redirect(Accessor accessor, int n2) throws SQLException {
                SQLException sQLException = DatabaseError.createSqlException(null, 4);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        });
        CLASS_TO_ERROR.put(Struct.class, new Redirector<Struct>(Struct.class){

            @Override
            final Struct redirect(Accessor accessor, int n2) throws SQLException {
                SQLException sQLException = DatabaseError.createSqlException(null, 4);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        });
        CLASS_TO_ERROR.put(Time.class, new Redirector<Time>(Time.class){

            @Override
            final Time redirect(Accessor accessor, int n2) throws SQLException {
                SQLException sQLException = DatabaseError.createSqlException(null, 4);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        });
        CLASS_TO_ERROR.put(Timestamp.class, new Redirector<Timestamp>(Timestamp.class){

            @Override
            final Timestamp redirect(Accessor accessor, int n2) throws SQLException {
                SQLException sQLException = DatabaseError.createSqlException(null, 4);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        });
        CLASS_TO_ERROR.put(URL.class, new Redirector<URL>(URL.class){

            @Override
            final URL redirect(Accessor accessor, int n2) throws SQLException {
                SQLException sQLException = DatabaseError.createSqlException(null, 4);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        });
        CLASS_TO_ERROR.put(BigInteger.class, new Redirector<BigInteger>(BigInteger.class){

            @Override
            final BigInteger redirect(Accessor accessor, int n2) throws SQLException {
                SQLException sQLException = DatabaseError.createSqlException(null, 4);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        });
        CLASS_TO_ERROR.put(java.util.Date.class, new Redirector<java.util.Date>(java.util.Date.class){

            @Override
            final java.util.Date redirect(Accessor accessor, int n2) throws SQLException {
                SQLException sQLException = DatabaseError.createSqlException(null, 4);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        });
        CLASS_TO_ERROR.put(Calendar.class, new Redirector<Calendar>(Calendar.class){

            @Override
            final Calendar redirect(Accessor accessor, int n2) throws SQLException {
                SQLException sQLException = DatabaseError.createSqlException(null, 4);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        });
        CLASS_TO_ERROR.put(ARRAY.class, new Redirector<ARRAY>(ARRAY.class){

            @Override
            final ARRAY redirect(Accessor accessor, int n2) throws SQLException {
                SQLException sQLException = DatabaseError.createSqlException(null, 4);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        });
        CLASS_TO_ERROR.put(BFILE.class, new Redirector<BFILE>(BFILE.class){

            @Override
            final BFILE redirect(Accessor accessor, int n2) throws SQLException {
                SQLException sQLException = DatabaseError.createSqlException(null, 4);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        });
        CLASS_TO_ERROR.put(BINARY_FLOAT.class, new Redirector<BINARY_FLOAT>(BINARY_FLOAT.class){

            @Override
            final BINARY_FLOAT redirect(Accessor accessor, int n2) throws SQLException {
                SQLException sQLException = DatabaseError.createSqlException(null, 4);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        });
        CLASS_TO_ERROR.put(BINARY_DOUBLE.class, new Redirector<BINARY_DOUBLE>(BINARY_DOUBLE.class){

            @Override
            final BINARY_DOUBLE redirect(Accessor accessor, int n2) throws SQLException {
                SQLException sQLException = DatabaseError.createSqlException(null, 4);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        });
        CLASS_TO_ERROR.put(BLOB.class, new Redirector<BLOB>(BLOB.class){

            @Override
            final BLOB redirect(Accessor accessor, int n2) throws SQLException {
                SQLException sQLException = DatabaseError.createSqlException(null, 4);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        });
        CLASS_TO_ERROR.put(CHAR.class, new Redirector<CHAR>(CHAR.class){

            @Override
            final CHAR redirect(Accessor accessor, int n2) throws SQLException {
                SQLException sQLException = DatabaseError.createSqlException(null, 4);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        });
        CLASS_TO_ERROR.put(CLOB.class, new Redirector<CLOB>(CLOB.class){

            @Override
            final CLOB redirect(Accessor accessor, int n2) throws SQLException {
                SQLException sQLException = DatabaseError.createSqlException(null, 4);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        });
        CLASS_TO_ERROR.put(ResultSet.class, new Redirector<ResultSet>(ResultSet.class){

            @Override
            final ResultSet redirect(Accessor accessor, int n2) throws SQLException {
                SQLException sQLException = DatabaseError.createSqlException(null, 4);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        });
        CLASS_TO_ERROR.put(DATE.class, new Redirector<DATE>(DATE.class){

            @Override
            final DATE redirect(Accessor accessor, int n2) throws SQLException {
                SQLException sQLException = DatabaseError.createSqlException(null, 4);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        });
        CLASS_TO_ERROR.put(INTERVALDS.class, new Redirector<INTERVALDS>(INTERVALDS.class){

            @Override
            final INTERVALDS redirect(Accessor accessor, int n2) throws SQLException {
                SQLException sQLException = DatabaseError.createSqlException(null, 4);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        });
        CLASS_TO_ERROR.put(INTERVALYM.class, new Redirector<INTERVALYM>(INTERVALYM.class){

            @Override
            final INTERVALYM redirect(Accessor accessor, int n2) throws SQLException {
                SQLException sQLException = DatabaseError.createSqlException(null, 4);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        });
        CLASS_TO_ERROR.put(NUMBER.class, new Redirector<NUMBER>(NUMBER.class){

            @Override
            final NUMBER redirect(Accessor accessor, int n2) throws SQLException {
                SQLException sQLException = DatabaseError.createSqlException(null, 4);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        });
        CLASS_TO_ERROR.put(OPAQUE.class, new Redirector<OPAQUE>(OPAQUE.class){

            @Override
            final OPAQUE redirect(Accessor accessor, int n2) throws SQLException {
                SQLException sQLException = DatabaseError.createSqlException(null, 4);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        });
        CLASS_TO_ERROR.put(ORAData.class, new Redirector<ORAData>(ORAData.class){

            @Override
            final ORAData redirect(Accessor accessor, int n2) throws SQLException {
                SQLException sQLException = DatabaseError.createSqlException(null, 4);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        });
        CLASS_TO_ERROR.put(OracleData.class, new Redirector<OracleData>(OracleData.class){

            @Override
            final OracleData redirect(Accessor accessor, int n2) throws SQLException {
                SQLException sQLException = DatabaseError.createSqlException(null, 4);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        });
        CLASS_TO_ERROR.put(RAW.class, new Redirector<RAW>(RAW.class){

            @Override
            final RAW redirect(Accessor accessor, int n2) throws SQLException {
                SQLException sQLException = DatabaseError.createSqlException(null, 4);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        });
        CLASS_TO_ERROR.put(REF.class, new Redirector<REF>(REF.class){

            @Override
            final REF redirect(Accessor accessor, int n2) throws SQLException {
                SQLException sQLException = DatabaseError.createSqlException(null, 4);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        });
        CLASS_TO_ERROR.put(ROWID.class, new Redirector<ROWID>(ROWID.class){

            @Override
            final ROWID redirect(Accessor accessor, int n2) throws SQLException {
                SQLException sQLException = DatabaseError.createSqlException(null, 4);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        });
        CLASS_TO_ERROR.put(STRUCT.class, new Redirector<STRUCT>(STRUCT.class){

            @Override
            final STRUCT redirect(Accessor accessor, int n2) throws SQLException {
                SQLException sQLException = DatabaseError.createSqlException(null, 4);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        });
        CLASS_TO_ERROR.put(TIMESTAMPLTZ.class, new Redirector<TIMESTAMPLTZ>(TIMESTAMPLTZ.class){

            @Override
            final TIMESTAMPLTZ redirect(Accessor accessor, int n2) throws SQLException {
                SQLException sQLException = DatabaseError.createSqlException(null, 4);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        });
        CLASS_TO_ERROR.put(TIMESTAMPTZ.class, new Redirector<TIMESTAMPTZ>(TIMESTAMPTZ.class){

            @Override
            final TIMESTAMPTZ redirect(Accessor accessor, int n2) throws SQLException {
                SQLException sQLException = DatabaseError.createSqlException(null, 4);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        });
        CLASS_TO_ERROR.put(TIMESTAMP.class, new Redirector<TIMESTAMP>(TIMESTAMP.class){

            @Override
            final TIMESTAMP redirect(Accessor accessor, int n2) throws SQLException {
                SQLException sQLException = DatabaseError.createSqlException(null, 4);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        });
        CLASS_TO_ERROR.put(OracleArray.class, new Redirector<OracleArray>(OracleArray.class){

            @Override
            final OracleArray redirect(Accessor accessor, int n2) throws SQLException {
                SQLException sQLException = DatabaseError.createSqlException(null, 4);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        });
        CLASS_TO_ERROR.put(OracleBlob.class, new Redirector<OracleBlob>(OracleBlob.class){

            @Override
            final OracleBlob redirect(Accessor accessor, int n2) throws SQLException {
                SQLException sQLException = DatabaseError.createSqlException(null, 4);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        });
        CLASS_TO_ERROR.put(OracleClob.class, new Redirector<OracleClob>(OracleClob.class){

            @Override
            final OracleClob redirect(Accessor accessor, int n2) throws SQLException {
                SQLException sQLException = DatabaseError.createSqlException(null, 4);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        });
        CLASS_TO_ERROR.put(OracleBfile.class, new Redirector<OracleBfile>(OracleBfile.class){

            @Override
            final OracleBfile redirect(Accessor accessor, int n2) throws SQLException {
                SQLException sQLException = DatabaseError.createSqlException(null, 4);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        });
        CLASS_TO_ERROR.put(OracleRef.class, new Redirector<OracleRef>(OracleRef.class){

            @Override
            final OracleRef redirect(Accessor accessor, int n2) throws SQLException {
                SQLException sQLException = DatabaseError.createSqlException(null, 4);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        });
        CLASS_TO_ERROR.put(OracleOpaque.class, new Redirector<OracleOpaque>(OracleOpaque.class){

            @Override
            final OracleOpaque redirect(Accessor accessor, int n2) throws SQLException {
                SQLException sQLException = DatabaseError.createSqlException(null, 4);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        });
        CLASS_TO_ERROR.put(InputStream.class, new Redirector<InputStream>(InputStream.class){

            @Override
            final InputStream redirect(Accessor accessor, int n2) throws SQLException {
                SQLException sQLException = DatabaseError.createSqlException(null, 4);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        });
        CLASS_TO_ERROR.put(Reader.class, new Redirector<Reader>(Reader.class){

            @Override
            final Reader redirect(Accessor accessor, int n2) throws SQLException {
                SQLException sQLException = DatabaseError.createSqlException(null, 4);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        });
        _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    }
}

