/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.file;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.file.FileSystemInabilityToLockException;

public class FSLockWithShared {
    private static final Logger logger = Logger.getLogger(FSLockWithShared.class);
    private final File file;
    private FileLock lock = null;
    private FileChannel channel = null;
    private boolean throwExceptionOnUnknownFailure = false;

    public FSLockWithShared(File baseFile) {
        this.file = baseFile;
    }

    public FSLockWithShared(File baseFile, boolean throwExceptionOnUnknownFailure) {
        this(baseFile);
        this.throwExceptionOnUnknownFailure = throwExceptionOnUnknownFailure;
    }

    public boolean sharedLock() throws FileSystemInabilityToLockException {
        try {
            this.channel = new RandomAccessFile(this.file, "r").getChannel();
        }
        catch (IOException e) {
            logger.warn((Object)String.format("WARNING: Unable to lock file %s (could not open read only file channel)", this.file.getAbsolutePath()));
            return false;
        }
        try {
            this.lock = this.channel.tryLock(0L, Long.MAX_VALUE, true);
            if (this.lock == null) {
                logger.warn((Object)String.format("WARNING: Unable to lock file %s because there is already a lock active.", this.file.getAbsolutePath()));
                return false;
            }
        }
        catch (ClosedChannelException e) {
            logger.warn((Object)String.format("WARNING: Unable to lock file %s because the file channel is closed.", this.file.getAbsolutePath()));
            return false;
        }
        catch (OverlappingFileLockException e) {
            logger.warn((Object)String.format("WARNING: Unable to lock file %s because you already have a lock on this file.", this.file.getAbsolutePath()));
            return false;
        }
        catch (IOException e) {
            logger.warn((Object)String.format("WARNING: Unable to lock file %s: %s.", this.file.getAbsolutePath(), e.getMessage()));
            if (this.throwExceptionOnUnknownFailure) {
                throw new FileSystemInabilityToLockException(e.getMessage(), e);
            }
            return false;
        }
        return true;
    }

    public boolean exclusiveLock() throws FileSystemInabilityToLockException {
        try {
            this.channel = new RandomAccessFile(this.file, "rw").getChannel();
        }
        catch (Exception e) {
            logger.warn((Object)String.format("WARNING: Unable to lock file %s (could not open read/write file channel)", this.file.getAbsolutePath()));
            return false;
        }
        try {
            this.lock = this.channel.tryLock(0L, Long.MAX_VALUE, false);
            if (this.lock == null) {
                logger.warn((Object)String.format("WARNING: Unable to lock file %s because there is already a lock active.", this.file.getAbsolutePath()));
                return false;
            }
            return true;
        }
        catch (ClosedChannelException e) {
            logger.warn((Object)String.format("WARNING: Unable to lock file %s because the file channel is closed.", this.file.getAbsolutePath()));
            return false;
        }
        catch (OverlappingFileLockException e) {
            logger.warn((Object)String.format("WARNING: Unable to lock file %s because you already have a lock on this file.", this.file.getAbsolutePath()));
            return false;
        }
        catch (IOException e) {
            logger.warn((Object)String.format("WARNING: Unable to lock file %s: %s.", this.file.getAbsolutePath(), e.getMessage()));
            if (this.throwExceptionOnUnknownFailure) {
                throw new FileSystemInabilityToLockException(e.getMessage(), e);
            }
            return false;
        }
    }

    public void unlock() {
        try {
            if (this.lock != null) {
                this.lock.release();
            }
            if (this.channel != null) {
                this.channel.close();
            }
        }
        catch (Exception e) {
            throw new ReviewedStingException("An error occurred while unlocking file", e);
        }
    }
}

