/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.commandline;

import java.lang.reflect.Type;
import org.broadinstitute.sting.commandline.ArgumentMatches;
import org.broadinstitute.sting.commandline.ArgumentSource;
import org.broadinstitute.sting.commandline.ArgumentTypeDescriptor;
import org.broadinstitute.sting.commandline.ParsingEngine;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.commandline.Tags;
import org.broadinstitute.sting.utils.classloader.JVMUtils;

class RodBindingArgumentTypeDescriptor
extends ArgumentTypeDescriptor {
    RodBindingArgumentTypeDescriptor() {
    }

    @Override
    public boolean supports(Class type) {
        return RodBindingArgumentTypeDescriptor.isRodBinding(type);
    }

    public static boolean isRodBinding(Class type) {
        return RodBinding.class.isAssignableFrom(type);
    }

    @Override
    public boolean createsTypeDefault(ArgumentSource source) {
        return !source.isRequired();
    }

    @Override
    public Object createTypeDefault(ParsingEngine parsingEngine, ArgumentSource source, Type type) {
        Class parameterType = JVMUtils.getParameterizedTypeClass(type);
        return RodBinding.makeUnbound(parameterType);
    }

    @Override
    public String typeDefaultDocString(ArgumentSource source) {
        return "none";
    }

    @Override
    public Object parse(ParsingEngine parsingEngine, ArgumentSource source, Type type, ArgumentMatches matches) {
        Tags tags = this.getArgumentTags(matches);
        RodBinding rbind = (RodBinding)this.parseBinding(source, type, matches, tags);
        parsingEngine.addTags(rbind, tags);
        parsingEngine.addRodBinding(rbind);
        return rbind;
    }
}

