/* SourceInterfaces.c generated by valac 0.40.4, the Vala compiler
 * generated from SourceInterfaces.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */
/* See the note in MediaInterfaces.vala for some thoughts on the theory of expanding Shotwell's*/
/* features via interfaces rather than class hierarchies.*/
/* Indexable DataSources provide raw strings that may be searched against (and, in the future,*/
/* indexed) for free-text search queries.  DataSources implementing Indexable must prepare and*/
/* store (i.e. cache) these strings using prepare_indexable_string(s), as preparing the strings*/
/* for each call is expensive.*/
/**/
/* When the indexable string has changed, the object should fire an alteration of*/
/* "indexable:keywords".  The prepare methods will not do this.*/


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_INDEXABLE (indexable_get_type ())
#define INDEXABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_INDEXABLE, Indexable))
#define IS_INDEXABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_INDEXABLE))
#define INDEXABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_INDEXABLE, IndexableIface))

typedef struct _Indexable Indexable;
typedef struct _IndexableIface IndexableIface;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _IndexableIface {
	GTypeInterface parent_iface;
	const gchar* (*get_indexable_keywords) (Indexable* self);
};



GType data_object_get_type (void) G_GNUC_CONST;
GType data_source_get_type (void) G_GNUC_CONST;
GType indexable_get_type (void) G_GNUC_CONST;
const gchar* indexable_get_indexable_keywords (Indexable* self);
gchar* indexable_prepare_indexable_string (const gchar* str);
gboolean is_string_empty (const gchar* s);
gchar* string_remove_diacritics (const gchar* istring);
gchar* indexable_prepare_indexable_strings (gchar** strs,
                                            int strs_length1);


const gchar*
indexable_get_indexable_keywords (Indexable* self)
{
#line 19 "/home/jens/Source/shotwell/src/core/SourceInterfaces.vala"
	g_return_val_if_fail (IS_INDEXABLE (self), NULL);
#line 19 "/home/jens/Source/shotwell/src/core/SourceInterfaces.vala"
	return INDEXABLE_GET_INTERFACE (self)->get_indexable_keywords (self);
#line 82 "SourceInterfaces.c"
}


gchar*
indexable_prepare_indexable_string (const gchar* str)
{
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
#line 22 "/home/jens/Source/shotwell/src/core/SourceInterfaces.vala"
	if (is_string_empty (str)) {
#line 23 "/home/jens/Source/shotwell/src/core/SourceInterfaces.vala"
		result = NULL;
#line 23 "/home/jens/Source/shotwell/src/core/SourceInterfaces.vala"
		return result;
#line 100 "SourceInterfaces.c"
	}
#line 24 "/home/jens/Source/shotwell/src/core/SourceInterfaces.vala"
	_tmp0_ = g_utf8_strdown (str, (gssize) -1);
#line 24 "/home/jens/Source/shotwell/src/core/SourceInterfaces.vala"
	_tmp1_ = _tmp0_;
#line 24 "/home/jens/Source/shotwell/src/core/SourceInterfaces.vala"
	_tmp2_ = string_remove_diacritics (_tmp1_);
#line 24 "/home/jens/Source/shotwell/src/core/SourceInterfaces.vala"
	_tmp3_ = _tmp2_;
#line 24 "/home/jens/Source/shotwell/src/core/SourceInterfaces.vala"
	_g_free0 (_tmp1_);
#line 24 "/home/jens/Source/shotwell/src/core/SourceInterfaces.vala"
	result = _tmp3_;
#line 24 "/home/jens/Source/shotwell/src/core/SourceInterfaces.vala"
	return result;
#line 116 "SourceInterfaces.c"
}


gchar*
indexable_prepare_indexable_strings (gchar** strs,
                                     int strs_length1)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	GString* builder = NULL;
	GString* _tmp1_;
	gint ctr = 0;
	const gchar* _tmp14_ = NULL;
	GString* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp19_;
#line 28 "/home/jens/Source/shotwell/src/core/SourceInterfaces.vala"
	if (strs == NULL) {
#line 28 "/home/jens/Source/shotwell/src/core/SourceInterfaces.vala"
		_tmp0_ = TRUE;
#line 137 "SourceInterfaces.c"
	} else {
#line 28 "/home/jens/Source/shotwell/src/core/SourceInterfaces.vala"
		_tmp0_ = strs_length1 == 0;
#line 141 "SourceInterfaces.c"
	}
#line 28 "/home/jens/Source/shotwell/src/core/SourceInterfaces.vala"
	if (_tmp0_) {
#line 29 "/home/jens/Source/shotwell/src/core/SourceInterfaces.vala"
		result = NULL;
#line 29 "/home/jens/Source/shotwell/src/core/SourceInterfaces.vala"
		return result;
#line 149 "SourceInterfaces.c"
	}
#line 31 "/home/jens/Source/shotwell/src/core/SourceInterfaces.vala"
	_tmp1_ = g_string_new ("");
#line 31 "/home/jens/Source/shotwell/src/core/SourceInterfaces.vala"
	builder = _tmp1_;
#line 32 "/home/jens/Source/shotwell/src/core/SourceInterfaces.vala"
	ctr = 0;
#line 157 "SourceInterfaces.c"
	{
		gboolean _tmp2_ = FALSE;
#line 33 "/home/jens/Source/shotwell/src/core/SourceInterfaces.vala"
		_tmp2_ = TRUE;
#line 33 "/home/jens/Source/shotwell/src/core/SourceInterfaces.vala"
		while (TRUE) {
#line 164 "SourceInterfaces.c"
			gint _tmp5_;
			const gchar* _tmp6_;
#line 33 "/home/jens/Source/shotwell/src/core/SourceInterfaces.vala"
			if (!_tmp2_) {
#line 169 "SourceInterfaces.c"
				gint _tmp3_;
				gint _tmp4_;
#line 39 "/home/jens/Source/shotwell/src/core/SourceInterfaces.vala"
				_tmp3_ = ctr;
#line 39 "/home/jens/Source/shotwell/src/core/SourceInterfaces.vala"
				ctr = _tmp3_ + 1;
#line 39 "/home/jens/Source/shotwell/src/core/SourceInterfaces.vala"
				_tmp4_ = ctr;
#line 39 "/home/jens/Source/shotwell/src/core/SourceInterfaces.vala"
				if (!(_tmp4_ < strs_length1)) {
#line 39 "/home/jens/Source/shotwell/src/core/SourceInterfaces.vala"
					break;
#line 182 "SourceInterfaces.c"
				}
			}
#line 33 "/home/jens/Source/shotwell/src/core/SourceInterfaces.vala"
			_tmp2_ = FALSE;
#line 34 "/home/jens/Source/shotwell/src/core/SourceInterfaces.vala"
			_tmp5_ = ctr;
#line 34 "/home/jens/Source/shotwell/src/core/SourceInterfaces.vala"
			_tmp6_ = strs[_tmp5_];
#line 34 "/home/jens/Source/shotwell/src/core/SourceInterfaces.vala"
			if (!is_string_empty (_tmp6_)) {
#line 193 "SourceInterfaces.c"
				GString* _tmp7_;
				gint _tmp8_;
				const gchar* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				gint _tmp12_;
#line 35 "/home/jens/Source/shotwell/src/core/SourceInterfaces.vala"
				_tmp7_ = builder;
#line 35 "/home/jens/Source/shotwell/src/core/SourceInterfaces.vala"
				_tmp8_ = ctr;
#line 35 "/home/jens/Source/shotwell/src/core/SourceInterfaces.vala"
				_tmp9_ = strs[_tmp8_];
#line 35 "/home/jens/Source/shotwell/src/core/SourceInterfaces.vala"
				_tmp10_ = g_utf8_strdown (_tmp9_, (gssize) -1);
#line 35 "/home/jens/Source/shotwell/src/core/SourceInterfaces.vala"
				_tmp11_ = _tmp10_;
#line 35 "/home/jens/Source/shotwell/src/core/SourceInterfaces.vala"
				g_string_append (_tmp7_, _tmp11_);
#line 35 "/home/jens/Source/shotwell/src/core/SourceInterfaces.vala"
				_g_free0 (_tmp11_);
#line 36 "/home/jens/Source/shotwell/src/core/SourceInterfaces.vala"
				_tmp12_ = ctr;
#line 36 "/home/jens/Source/shotwell/src/core/SourceInterfaces.vala"
				if (_tmp12_ < (strs_length1 - 1)) {
#line 218 "SourceInterfaces.c"
					GString* _tmp13_;
#line 37 "/home/jens/Source/shotwell/src/core/SourceInterfaces.vala"
					_tmp13_ = builder;
#line 37 "/home/jens/Source/shotwell/src/core/SourceInterfaces.vala"
					g_string_append_c (_tmp13_, ' ');
#line 224 "SourceInterfaces.c"
				}
			}
		}
	}
#line 41 "/home/jens/Source/shotwell/src/core/SourceInterfaces.vala"
	_tmp15_ = builder;
#line 41 "/home/jens/Source/shotwell/src/core/SourceInterfaces.vala"
	_tmp16_ = _tmp15_->str;
#line 41 "/home/jens/Source/shotwell/src/core/SourceInterfaces.vala"
	if (!is_string_empty (_tmp16_)) {
#line 235 "SourceInterfaces.c"
		GString* _tmp17_;
		const gchar* _tmp18_;
#line 41 "/home/jens/Source/shotwell/src/core/SourceInterfaces.vala"
		_tmp17_ = builder;
#line 41 "/home/jens/Source/shotwell/src/core/SourceInterfaces.vala"
		_tmp18_ = _tmp17_->str;
#line 41 "/home/jens/Source/shotwell/src/core/SourceInterfaces.vala"
		_tmp14_ = _tmp18_;
#line 244 "SourceInterfaces.c"
	} else {
#line 41 "/home/jens/Source/shotwell/src/core/SourceInterfaces.vala"
		_tmp14_ = NULL;
#line 248 "SourceInterfaces.c"
	}
#line 41 "/home/jens/Source/shotwell/src/core/SourceInterfaces.vala"
	_tmp19_ = g_strdup (_tmp14_);
#line 41 "/home/jens/Source/shotwell/src/core/SourceInterfaces.vala"
	result = _tmp19_;
#line 41 "/home/jens/Source/shotwell/src/core/SourceInterfaces.vala"
	_g_string_free0 (builder);
#line 41 "/home/jens/Source/shotwell/src/core/SourceInterfaces.vala"
	return result;
#line 258 "SourceInterfaces.c"
}


static void
indexable_base_init (IndexableIface * iface)
{
#line 18 "/home/jens/Source/shotwell/src/core/SourceInterfaces.vala"
	static gboolean initialized = FALSE;
#line 18 "/home/jens/Source/shotwell/src/core/SourceInterfaces.vala"
	if (!initialized) {
#line 18 "/home/jens/Source/shotwell/src/core/SourceInterfaces.vala"
		initialized = TRUE;
#line 271 "SourceInterfaces.c"
	}
}


GType
indexable_get_type (void)
{
	static volatile gsize indexable_type_id__volatile = 0;
	if (g_once_init_enter (&indexable_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (IndexableIface), (GBaseInitFunc) indexable_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType indexable_type_id;
		indexable_type_id = g_type_register_static (G_TYPE_INTERFACE, "Indexable", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (indexable_type_id, TYPE_DATA_SOURCE);
		g_once_init_leave (&indexable_type_id__volatile, indexable_type_id);
	}
	return indexable_type_id__volatile;
}



