/* doxygen.h */

/*
 * Copyright (C) 2006 - 2012
 *     Andrew Beekhof <andrew@beekhof.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef DOXYGEN__H
#  define DOXYGEN__H

/**
 * \file
 * \brief Fake header file that contains doxygen documentation.
 * \author Andrew Beekhof <andrew@beekhof.net>
 *
 * The purpose of this file is to provide a file that can be used to create
 * doxygen pages.  It should contain _only_ comment blocks.
 *
 *
 * \defgroup core Core API
 * \defgroup date ISO-8601 Date/Time API
 * \defgroup cib Configuration API
 * \defgroup lrmd Local Resource Manager API
 * \defgroup pengine Policy Engine API
 * \defgroup fencing Fencing API
 */

/**
 * \mainpage
 * Welcome to the developer documentation for The Pacemaker Project!  For more
 * information about Pacemaker, please visit the
 * <a href="http://clusterlabs.org/">project web site</a>.
 *
 * Here are some pointers on where to go from here.
 *
 * Using Pacemaker APIs:
 *  - \ref core
 *  - \ref date
 *  - \ref cib
 *  - \ref lrmd
 *  - \ref pengine
 *  - \ref fencing
 *
 * Contributing to the Pacemaker Project:
 * - <a href="http://clusterlabs.org/doc/en-US/Pacemaker/1.1-pcs/html-single/Pacemaker_Development/">Pacemaker Development</a>
 */

#endif                          /* DOXYGEN__H */
