/* SPDX-License-Identifier: GPL-2.0
 *
 * MediaTek 8365 audio driver reg definition
 *
 * Copyright (c) 2024 MediaTek Inc.
 * Authors: Jia Zeng <jia.zeng@mediatek.com>
 *          Alexandre Mergnat <amergnat@baylibre.com>
 */

#ifndef _MT8365_REG_H_
#define _MT8365_REG_H_

#include <linux/bitfield.h>

#define AUDIO_TOP_CON0			(0x0000)
#define AUDIO_TOP_CON1			(0x0004)
#define AUDIO_TOP_CON2			(0x0008)
#define AUDIO_TOP_CON3			(0x000c)

#define AFE_DAC_CON0			(0x0010)
#define AFE_DAC_CON1			(0x0014)
#define AFE_I2S_CON			(0x0018)
#define AFE_CONN0			(0x0020)
#define AFE_CONN1			(0x0024)
#define AFE_CONN2			(0x0028)
#define AFE_CONN3			(0x002c)
#define AFE_CONN4			(0x0030)
#define AFE_I2S_CON1			(0x0034)
#define AFE_I2S_CON2			(0x0038)
#define AFE_MRGIF_CON			(0x003c)
#define AFE_DL1_BASE			(0x0040)
#define AFE_DL1_CUR			(0x0044)
#define AFE_DL1_END			(0x0048)
#define AFE_I2S_CON3			(0x004c)
#define AFE_DL2_BASE			(0x0050)
#define AFE_DL2_CUR			(0x0054)
#define AFE_DL2_END			(0x0058)
#define AFE_CONN5			(0x005c)
#define AFE_AWB_BASE			(0x0070)
#define AFE_AWB_END			(0x0078)
#define AFE_AWB_CUR			(0x007c)
#define AFE_VUL_BASE			(0x0080)
#define AFE_VUL_END			(0x0088)
#define AFE_VUL_CUR			(0x008c)
#define AFE_CONN6			(0x00bc)
#define AFE_MEMIF_MSB			(0x00cc)
#define AFE_MEMIF_MON0			(0x00d0)
#define AFE_MEMIF_MON1			(0x00d4)
#define AFE_MEMIF_MON2			(0x00d8)
#define AFE_MEMIF_MON3			(0x00dc)
#define AFE_MEMIF_MON4			(0x00e0)
#define AFE_MEMIF_MON5			(0x00e4)
#define AFE_MEMIF_MON6			(0x00e8)
#define AFE_MEMIF_MON7			(0x00ec)
#define AFE_MEMIF_MON8			(0x00f0)
#define AFE_MEMIF_MON9			(0x00f4)
#define AFE_MEMIF_MON10			(0x00f8)
#define AFE_MEMIF_MON11			(0x00fc)
#define AFE_ADDA_DL_SRC2_CON0		(0x0108)
#define AFE_ADDA_DL_SRC2_CON1		(0x010c)
#define AFE_ADDA_UL_SRC_CON0		(0x0114)
#define AFE_ADDA_UL_SRC_CON1		(0x0118)
#define AFE_ADDA_TOP_CON0		(0x0120)
#define AFE_ADDA_UL_DL_CON0		(0x0124)
#define AFE_ADDA_SRC_DEBUG		(0x012c)
#define AFE_ADDA_SRC_DEBUG_MON0		(0x0130)
#define AFE_ADDA_SRC_DEBUG_MON1		(0x0134)
#define AFE_ADDA_UL_SRC_MON0		(0x0148)
#define AFE_ADDA_UL_SRC_MON1		(0x014c)
#define AFE_SRAM_BOUND			(0x0170)
#define AFE_SECURE_CON			(0x0174)
#define AFE_SECURE_CONN0		(0x0178)
#define AFE_SIDETONE_DEBUG		(0x01d0)
#define AFE_SIDETONE_MON		(0x01d4)
#define AFE_SIDETONE_CON0		(0x01e0)
#define AFE_SIDETONE_COEFF		(0x01e4)
#define AFE_SIDETONE_CON1		(0x01e8)
#define AFE_SIDETONE_GAIN		(0x01ec)
#define AFE_SGEN_CON0			(0x01f0)
#define AFE_SINEGEN_CON_TDM		(0x01f8)
#define AFE_SINEGEN_CON_TDM_IN		(0x01fc)
#define AFE_TOP_CON0			(0x0200)
#define AFE_BUS_CFG			(0x0240)
#define AFE_BUS_MON0			(0x0244)
#define AFE_ADDA_PREDIS_CON0		(0x0260)
#define AFE_ADDA_PREDIS_CON1		(0x0264)
#define AFE_CONN_MON0			(0x0280)
#define AFE_CONN_MON1			(0x0284)
#define AFE_CONN_MON2			(0x0288)
#define AFE_CONN_MON3			(0x028c)
#define AFE_ADDA_IIR_COEF_02_01		(0x0290)
#define AFE_ADDA_IIR_COEF_04_03		(0x0294)
#define AFE_ADDA_IIR_COEF_06_05		(0x0298)
#define AFE_ADDA_IIR_COEF_08_07		(0x029c)
#define AFE_ADDA_IIR_COEF_10_09		(0x02a0)
#define AFE_VUL_D2_BASE			(0x0350)
#define AFE_VUL_D2_END			(0x0358)
#define AFE_VUL_D2_CUR			(0x035c)
#define AFE_HDMI_OUT_CON0		(0x0370)
#define AFE_HDMI_OUT_BASE		(0x0374)
#define AFE_HDMI_OUT_CUR		(0x0378)
#define AFE_HDMI_OUT_END		(0x037c)
#define AFE_SPDIF_OUT_CON0		(0x0380)
#define AFE_SPDIF_OUT_BASE		(0x0384)
#define AFE_SPDIF_OUT_CUR		(0x0388)
#define AFE_SPDIF_OUT_END		(0x038c)
#define AFE_HDMI_CONN0			(0x0390)
#define AFE_HDMI_CONN1			(0x0398)
#define AFE_CONN_TDMIN_CON		(0x039c)
#define AFE_IRQ_MCU_CON			(0x03a0)
#define AFE_IRQ_MCU_STATUS		(0x03a4)
#define AFE_IRQ_MCU_CLR			(0x03a8)
#define AFE_IRQ_MCU_CNT1		(0x03ac)
#define AFE_IRQ_MCU_CNT2		(0x03b0)
#define AFE_IRQ_MCU_EN			(0x03b4)
#define AFE_IRQ_MCU_MON2		(0x03b8)
#define AFE_IRQ_MCU_CNT5		(0x03bc)
#define AFE_IRQ1_MCU_CNT_MON		(0x03c0)
#define AFE_IRQ2_MCU_CNT_MON		(0x03c4)
#define AFE_IRQ1_MCU_EN_CNT_MON		(0x03c8)
#define AFE_IRQ5_MCU_CNT_MON		(0x03cc)
#define AFE_MEMIF_MINLEN		(0x03d0)
#define AFE_MEMIF_MAXLEN		(0x03d4)
#define AFE_MEMIF_PBUF_SIZE		(0x03d8)
#define AFE_IRQ_MCU_CNT7		(0x03dc)
#define AFE_IRQ7_MCU_CNT_MON		(0x03e0)
#define AFE_MEMIF_PBUF2_SIZE		(0x03ec)
#define AFE_APLL_TUNER_CFG		(0x03f0)
#define AFE_APLL_TUNER_CFG1		(0x03f4)
#define AFE_IRQ_MCU_CON2		(0x03f8)
#define IRQ13_MCU_CNT			(0x0408)
#define IRQ13_MCU_CNT_MON		(0x040c)
#define AFE_GAIN1_CON0			(0x0410)
#define AFE_GAIN1_CON1			(0x0414)
#define AFE_GAIN1_CON2			(0x0418)
#define AFE_GAIN1_CON3			(0x041c)
#define AFE_GAIN2_CON0			(0x0428)
#define AFE_GAIN2_CON1			(0x042c)
#define AFE_GAIN2_CON2			(0x0430)
#define AFE_GAIN2_CON3			(0x0434)
#define AFE_GAIN2_CUR			(0x043c)
#define AFE_CONN11			(0x0448)
#define AFE_CONN12			(0x044c)
#define AFE_CONN13			(0x0450)
#define AFE_CONN14			(0x0454)
#define AFE_CONN15			(0x0458)
#define AFE_CONN16			(0x045c)
#define AFE_CONN7			(0x0460)
#define AFE_CONN8			(0x0464)
#define AFE_CONN9			(0x0468)
#define AFE_CONN10			(0x046c)
#define AFE_CONN21			(0x0470)
#define AFE_CONN22			(0x0474)
#define AFE_CONN23			(0x0478)
#define AFE_CONN24			(0x047c)
#define AFE_IEC_CFG			(0x0480)
#define AFE_IEC_NSNUM			(0x0484)
#define AFE_IEC_BURST_INFO		(0x0488)
#define AFE_IEC_BURST_LEN		(0x048c)
#define AFE_IEC_NSADR			(0x0490)
#define AFE_CONN_RS			(0x0494)
#define AFE_CONN_DI			(0x0498)
#define AFE_IEC_CHL_STAT0		(0x04a0)
#define AFE_IEC_CHL_STAT1		(0x04a4)
#define AFE_IEC_CHR_STAT0		(0x04a8)
#define AFE_IEC_CHR_STAT1		(0x04ac)
#define AFE_CONN25			(0x04b0)
#define AFE_CONN26			(0x04b4)
#define FPGA_CFG2			(0x04b8)
#define FPGA_CFG3			(0x04bc)
#define FPGA_CFG0			(0x04c0)
#define FPGA_CFG1			(0x04c4)
#define AFE_SRAM_DELSEL_CON0		(0x04f0)
#define AFE_SRAM_DELSEL_CON1		(0x04f4)
#define AFE_SRAM_DELSEL_CON2		(0x04f8)
#define FPGA_CFG4			(0x04fc)
#define AFE_TDM_GASRC4_ASRC_2CH_CON0	(0x0500)
#define AFE_TDM_GASRC4_ASRC_2CH_CON1	(0x0504)
#define AFE_TDM_GASRC4_ASRC_2CH_CON2	(0x0508)
#define AFE_TDM_GASRC4_ASRC_2CH_CON3	(0x050c)
#define AFE_TDM_GASRC4_ASRC_2CH_CON4	(0x0510)
#define AFE_TDM_GASRC4_ASRC_2CH_CON5	(0x0514)
#define AFE_TDM_GASRC4_ASRC_2CH_CON6	(0x0518)
#define AFE_TDM_GASRC4_ASRC_2CH_CON7	(0x051c)
#define AFE_TDM_GASRC4_ASRC_2CH_CON8	(0x0520)
#define AFE_TDM_GASRC4_ASRC_2CH_CON9	(0x0524)
#define AFE_TDM_GASRC4_ASRC_2CH_CON10	(0x0528)
#define AFE_TDM_GASRC4_ASRC_2CH_CON12	(0x0530)
#define AFE_TDM_GASRC4_ASRC_2CH_CON13	(0x0534)
#define PCM_INTF_CON2			(0x0538)
#define PCM2_INTF_CON			(0x053c)
#define AFE_APB_MON			(0x0540)
#define AFE_CONN34			(0x0544)
#define AFE_TDM_CON1			(0x0548)
#define AFE_TDM_CON2			(0x054c)
#define PCM_INTF_CON1			(0x0550)
#define AFE_SECURE_MASK_CONN47_1	(0x0554)
#define AFE_SECURE_MASK_CONN48_1	(0x0558)
#define AFE_SECURE_MASK_CONN49_1	(0x055c)
#define AFE_SECURE_MASK_CONN50_1	(0x0560)
#define AFE_SECURE_MASK_CONN51_1	(0x0564)
#define AFE_SECURE_MASK_CONN52_1	(0x0568)
#define AFE_SECURE_MASK_CONN53_1	(0x056c)
#define AFE_SE_SECURE_CON		(0x0570)
#define AFE_TDM_IN_CON1			(0x0588)
#define AFE_TDM_IN_CON2			(0x058c)
#define AFE_TDM_IN_MON1			(0x0590)
#define AFE_TDM_IN_MON2			(0x0594)
#define AFE_TDM_IN_MON3			(0x0598)
#define AFE_DMIC0_UL_SRC_CON0		(0x05b4)
#define AFE_DMIC0_UL_SRC_CON1		(0x05b8)
#define AFE_DMIC0_SRC_DEBUG		(0x05bc)
#define AFE_DMIC0_SRC_DEBUG_MON0	(0x05c0)
#define AFE_DMIC0_UL_SRC_MON0		(0x05c8)
#define AFE_DMIC0_UL_SRC_MON1		(0x05cc)
#define AFE_DMIC0_IIR_COEF_02_01	(0x05d0)
#define AFE_DMIC0_IIR_COEF_04_03	(0x05d4)
#define AFE_DMIC0_IIR_COEF_06_05	(0x05d8)
#define AFE_DMIC0_IIR_COEF_08_07	(0x05dc)
#define AFE_DMIC0_IIR_COEF_10_09	(0x05e0)
#define AFE_DMIC1_UL_SRC_CON0		(0x0620)
#define AFE_DMIC1_UL_SRC_CON1		(0x0624)
#define AFE_DMIC1_SRC_DEBUG		(0x0628)
#define AFE_DMIC1_SRC_DEBUG_MON0	(0x062c)
#define AFE_DMIC1_UL_SRC_MON0		(0x0634)
#define AFE_DMIC1_UL_SRC_MON1		(0x0638)
#define AFE_DMIC1_IIR_COEF_02_01	(0x063c)
#define AFE_DMIC1_IIR_COEF_04_03	(0x0640)
#define AFE_DMIC1_IIR_COEF_06_05	(0x0644)
#define AFE_DMIC1_IIR_COEF_08_07	(0x0648)
#define AFE_DMIC1_IIR_COEF_10_09	(0x064c)
#define AFE_SECURE_MASK_CONN39_1	(0x068c)
#define AFE_SECURE_MASK_CONN40_1	(0x0690)
#define AFE_SECURE_MASK_CONN41_1	(0x0694)
#define AFE_SECURE_MASK_CONN42_1	(0x0698)
#define AFE_SECURE_MASK_CONN43_1	(0x069c)
#define AFE_SECURE_MASK_CONN44_1	(0x06a0)
#define AFE_SECURE_MASK_CONN45_1	(0x06a4)
#define AFE_SECURE_MASK_CONN46_1	(0x06a8)
#define AFE_TDM_GASRC1_ASRC_2CH_CON0	(0x06c0)
#define AFE_TDM_GASRC1_ASRC_2CH_CON1	(0x06c4)
#define AFE_TDM_GASRC1_ASRC_2CH_CON2	(0x06c8)
#define AFE_TDM_GASRC1_ASRC_2CH_CON3	(0x06cc)
#define AFE_TDM_GASRC1_ASRC_2CH_CON4	(0x06d0)
#define AFE_TDM_GASRC1_ASRC_2CH_CON5	(0x06d4)
#define AFE_TDM_GASRC1_ASRC_2CH_CON6	(0x06d8)
#define AFE_TDM_GASRC1_ASRC_2CH_CON7	(0x06dc)
#define AFE_TDM_GASRC1_ASRC_2CH_CON8	(0x06e0)
#define AFE_TDM_GASRC1_ASRC_2CH_CON9	(0x06e4)
#define AFE_TDM_GASRC1_ASRC_2CH_CON10	(0x06e8)
#define AFE_TDM_GASRC1_ASRC_2CH_CON12	(0x06f0)
#define AFE_TDM_GASRC1_ASRC_2CH_CON13	(0x06f4)
#define AFE_TDM_ASRC_CON0		(0x06f8)
#define AFE_TDM_GASRC2_ASRC_2CH_CON0	(0x0700)
#define AFE_TDM_GASRC2_ASRC_2CH_CON1	(0x0704)
#define AFE_TDM_GASRC2_ASRC_2CH_CON2	(0x0708)
#define AFE_TDM_GASRC2_ASRC_2CH_CON3	(0x070c)
#define AFE_TDM_GASRC2_ASRC_2CH_CON4	(0x0710)
#define AFE_TDM_GASRC2_ASRC_2CH_CON5	(0x0714)
#define AFE_TDM_GASRC2_ASRC_2CH_CON6	(0x0718)
#define AFE_TDM_GASRC2_ASRC_2CH_CON7	(0x071c)
#define AFE_TDM_GASRC2_ASRC_2CH_CON8	(0x0720)
#define AFE_TDM_GASRC2_ASRC_2CH_CON9	(0x0724)
#define AFE_TDM_GASRC2_ASRC_2CH_CON10	(0x0728)
#define AFE_TDM_GASRC2_ASRC_2CH_CON12	(0x0730)
#define AFE_TDM_GASRC2_ASRC_2CH_CON13	(0x0734)
#define AFE_TDM_GASRC3_ASRC_2CH_CON0	(0x0740)
#define AFE_TDM_GASRC3_ASRC_2CH_CON1	(0x0744)
#define AFE_TDM_GASRC3_ASRC_2CH_CON2	(0x0748)
#define AFE_TDM_GASRC3_ASRC_2CH_CON3	(0x074c)
#define AFE_TDM_GASRC3_ASRC_2CH_CON4	(0x0750)
#define AFE_TDM_GASRC3_ASRC_2CH_CON5	(0x0754)
#define AFE_TDM_GASRC3_ASRC_2CH_CON6	(0x0758)
#define AFE_TDM_GASRC3_ASRC_2CH_CON7	(0x075c)
#define AFE_TDM_GASRC3_ASRC_2CH_CON8	(0x0760)
#define AFE_TDM_GASRC3_ASRC_2CH_CON9	(0x0764)
#define AFE_TDM_GASRC3_ASRC_2CH_CON10	(0x0768)
#define AFE_TDM_GASRC3_ASRC_2CH_CON12	(0x0770)
#define AFE_TDM_GASRC3_ASRC_2CH_CON13	(0x0774)
#define AFE_DMIC2_UL_SRC_CON0		(0x0780)
#define AFE_DMIC2_UL_SRC_CON1		(0x0784)
#define AFE_DMIC2_SRC_DEBUG		(0x0788)
#define AFE_DMIC2_SRC_DEBUG_MON0	(0x078c)
#define AFE_DMIC2_UL_SRC_MON0		(0x0794)
#define AFE_DMIC2_UL_SRC_MON1		(0x0798)
#define AFE_DMIC2_IIR_COEF_02_01	(0x079c)
#define AFE_DMIC2_IIR_COEF_04_03	(0x07a0)
#define AFE_DMIC2_IIR_COEF_06_05	(0x07a4)
#define AFE_DMIC2_IIR_COEF_08_07	(0x07a8)
#define AFE_DMIC2_IIR_COEF_10_09	(0x07ac)
#define AFE_DMIC3_UL_SRC_CON0		(0x07ec)
#define AFE_DMIC3_UL_SRC_CON1		(0x07f0)
#define AFE_DMIC3_SRC_DEBUG		(0x07f4)
#define AFE_DMIC3_SRC_DEBUG_MON0	(0x07f8)
#define AFE_DMIC3_UL_SRC_MON0		(0x0800)
#define AFE_DMIC3_UL_SRC_MON1		(0x0804)
#define AFE_DMIC3_IIR_COEF_02_01	(0x0808)
#define AFE_DMIC3_IIR_COEF_04_03	(0x080c)
#define AFE_DMIC3_IIR_COEF_06_05	(0x0810)
#define AFE_DMIC3_IIR_COEF_08_07	(0x0814)
#define AFE_DMIC3_IIR_COEF_10_09	(0x0818)
#define AFE_SECURE_MASK_CONN25_1	(0x0858)
#define AFE_SECURE_MASK_CONN26_1	(0x085c)
#define AFE_SECURE_MASK_CONN27_1	(0x0860)
#define AFE_SECURE_MASK_CONN28_1	(0x0864)
#define AFE_SECURE_MASK_CONN29_1	(0x0868)
#define AFE_SECURE_MASK_CONN30_1	(0x086c)
#define AFE_SECURE_MASK_CONN31_1	(0x0870)
#define AFE_SECURE_MASK_CONN32_1	(0x0874)
#define AFE_SECURE_MASK_CONN33_1	(0x0878)
#define AFE_SECURE_MASK_CONN34_1	(0x087c)
#define AFE_SECURE_MASK_CONN35_1	(0x0880)
#define AFE_SECURE_MASK_CONN36_1	(0x0884)
#define AFE_SECURE_MASK_CONN37_1	(0x0888)
#define AFE_SECURE_MASK_CONN38_1	(0x088c)
#define AFE_IRQ_MCU_SCP_EN		(0x0890)
#define AFE_IRQ_MCU_DSP_EN		(0x0894)
#define AFE_IRQ3_MCU_CNT_MON		(0x0898)
#define AFE_IRQ4_MCU_CNT_MON		(0x089c)
#define AFE_IRQ8_MCU_CNT_MON		(0x08a0)
#define AFE_IRQ_MCU_CNT3		(0x08a4)
#define AFE_IRQ_MCU_CNT4		(0x08a8)
#define AFE_IRQ_MCU_CNT8		(0x08ac)
#define AFE_IRQ_MCU_CNT11		(0x08b0)
#define AFE_IRQ_MCU_CNT12		(0x08b4)
#define AFE_IRQ11_MCU_CNT_MON		(0x08b8)
#define AFE_IRQ12_MCU_CNT_MON		(0x08bc)
#define AFE_VUL3_BASE			(0x08c0)
#define AFE_VUL3_CUR			(0x08c4)
#define AFE_VUL3_END			(0x08c8)
#define AFE_VUL3_BASE_MSB		(0x08d0)
#define AFE_VUL3_END_MSB		(0x08d4)
#define AFE_IRQ10_MCU_CNT_MON		(0x08d8)
#define AFE_IRQ_MCU_CNT10		(0x08dc)
#define AFE_IRQ_ACC1_CNT		(0x08e0)
#define AFE_IRQ_ACC2_CNT		(0x08e4)
#define AFE_IRQ_ACC1_CNT_MON1		(0x08e8)
#define AFE_IRQ_ACC2_CNT_MON		(0x08ec)
#define AFE_TSF_CON			(0x08f0)
#define AFE_TSF_MON			(0x08f4)
#define AFE_IRQ_ACC1_CNT_MON2		(0x08f8)
#define AFE_SPDIFIN_CFG0		(0x0900)
#define AFE_SPDIFIN_CFG1		(0x0904)
#define AFE_SPDIFIN_CHSTS1		(0x0908)
#define AFE_SPDIFIN_CHSTS2		(0x090c)
#define AFE_SPDIFIN_CHSTS3		(0x0910)
#define AFE_SPDIFIN_CHSTS4		(0x0914)
#define AFE_SPDIFIN_CHSTS5		(0x0918)
#define AFE_SPDIFIN_CHSTS6		(0x091c)
#define AFE_SPDIFIN_DEBUG1		(0x0920)
#define AFE_SPDIFIN_DEBUG2		(0x0924)
#define AFE_SPDIFIN_DEBUG3		(0x0928)
#define AFE_SPDIFIN_DEBUG4		(0x092c)
#define AFE_SPDIFIN_EC			(0x0930)
#define AFE_SPDIFIN_CKLOCK_CFG		(0x0934)
#define AFE_SPDIFIN_BR			(0x093c)
#define AFE_SPDIFIN_BR_DBG1		(0x0940)
#define AFE_SPDIFIN_INT_EXT		(0x0948)
#define AFE_SPDIFIN_INT_EXT2		(0x094c)
#define SPDIFIN_FREQ_INFO		(0x0950)
#define SPDIFIN_FREQ_INFO_2		(0x0954)
#define SPDIFIN_FREQ_INFO_3		(0x0958)
#define SPDIFIN_FREQ_STATUS		(0x095c)
#define SPDIFIN_USERCODE1		(0x0960)
#define SPDIFIN_USERCODE2		(0x0964)
#define SPDIFIN_USERCODE3		(0x0968)
#define SPDIFIN_USERCODE4		(0x096c)
#define SPDIFIN_USERCODE5		(0x0970)
#define SPDIFIN_USERCODE6		(0x0974)
#define SPDIFIN_USERCODE7		(0x0978)
#define SPDIFIN_USERCODE8		(0x097c)
#define SPDIFIN_USERCODE9		(0x0980)
#define SPDIFIN_USERCODE10		(0x0984)
#define SPDIFIN_USERCODE11		(0x0988)
#define SPDIFIN_USERCODE12		(0x098c)
#define SPDIFIN_MEMIF_CON0		(0x0990)
#define SPDIFIN_BASE_ADR		(0x0994)
#define SPDIFIN_END_ADR			(0x0998)
#define SPDIFIN_APLL_TUNER_CFG		(0x09a0)
#define SPDIFIN_APLL_TUNER_CFG1		(0x09a4)
#define SPDIFIN_APLL2_TUNER_CFG		(0x09a8)
#define SPDIFIN_APLL2_TUNER_CFG1	(0x09ac)
#define SPDIFIN_TYPE_DET		(0x09b0)
#define MPHONE_MULTI_CON0		(0x09b4)
#define SPDIFIN_CUR_ADR			(0x09b8)
#define AFE_SINEGEN_CON_SPDIFIN		(0x09bc)
#define AFE_HDMI_IN_2CH_CON0		(0x09c0)
#define AFE_HDMI_IN_2CH_BASE		(0x09c4)
#define AFE_HDMI_IN_2CH_END		(0x09c8)
#define AFE_HDMI_IN_2CH_CUR		(0x09cc)
#define AFE_MEMIF_BUF_MON0		(0x09d0)
#define AFE_MEMIF_BUF_MON1		(0x09d4)
#define AFE_MEMIF_BUF_MON2		(0x09d8)
#define AFE_MEMIF_BUF_MON3		(0x09dc)
#define AFE_MEMIF_BUF_MON6		(0x09e8)
#define AFE_MEMIF_BUF_MON7		(0x09ec)
#define AFE_MEMIF_BUF_MON8		(0x09f0)
#define AFE_MEMIF_BUF_MON10		(0x09f8)
#define AFE_MEMIF_BUF_MON11		(0x09fc)
#define SYSTOP_STC_CONFIG		(0x0a00)
#define AUDIO_STC_STATUS		(0x0a04)
#define SYSTOP_W_STC_H			(0x0a08)
#define SYSTOP_W_STC_L			(0x0a0c)
#define SYSTOP_R_STC_H			(0x0a10)
#define SYSTOP_R_STC_L			(0x0a14)
#define AUDIO_W_STC_H			(0x0a18)
#define AUDIO_W_STC_L			(0x0a1c)
#define AUDIO_R_STC_H			(0x0a20)
#define AUDIO_R_STC_L			(0x0a24)
#define SYSTOP_W_STC2_H			(0x0a28)
#define SYSTOP_W_STC2_L			(0x0a2c)
#define SYSTOP_R_STC2_H			(0x0a30)
#define SYSTOP_R_STC2_L			(0x0a34)
#define AUDIO_W_STC2_H			(0x0a38)
#define AUDIO_W_STC2_L			(0x0a3c)
#define AUDIO_R_STC2_H			(0x0a40)
#define AUDIO_R_STC2_L			(0x0a44)

#define AFE_CONN17			(0x0a48)
#define AFE_CONN18			(0x0a4c)
#define AFE_CONN19			(0x0a50)
#define AFE_CONN20			(0x0a54)
#define AFE_CONN27			(0x0a58)
#define AFE_CONN28			(0x0a5c)
#define AFE_CONN29			(0x0a60)
#define AFE_CONN30			(0x0a64)
#define AFE_CONN31			(0x0a68)
#define AFE_CONN32			(0x0a6c)
#define AFE_CONN33			(0x0a70)
#define AFE_CONN35			(0x0a74)
#define AFE_CONN36			(0x0a78)
#define AFE_CONN37			(0x0a7c)
#define AFE_CONN38			(0x0a80)
#define AFE_CONN39			(0x0a84)
#define AFE_CONN40			(0x0a88)
#define AFE_CONN41			(0x0a8c)
#define AFE_CONN42			(0x0a90)
#define AFE_CONN44			(0x0a94)
#define AFE_CONN45			(0x0a98)
#define AFE_CONN46			(0x0a9c)
#define AFE_CONN47			(0x0aa0)
#define AFE_CONN_24BIT			(0x0aa4)
#define AFE_CONN0_1			(0x0aa8)
#define AFE_CONN1_1			(0x0aac)
#define AFE_CONN2_1			(0x0ab0)
#define AFE_CONN3_1			(0x0ab4)
#define AFE_CONN4_1			(0x0ab8)
#define AFE_CONN5_1			(0x0abc)
#define AFE_CONN6_1			(0x0ac0)
#define AFE_CONN7_1			(0x0ac4)
#define AFE_CONN8_1			(0x0ac8)
#define AFE_CONN9_1			(0x0acc)
#define AFE_CONN10_1			(0x0ad0)
#define AFE_CONN11_1			(0x0ad4)
#define AFE_CONN12_1			(0x0ad8)
#define AFE_CONN13_1			(0x0adc)
#define AFE_CONN14_1			(0x0ae0)
#define AFE_CONN15_1			(0x0ae4)
#define AFE_CONN16_1			(0x0ae8)
#define AFE_CONN17_1			(0x0aec)
#define AFE_CONN18_1			(0x0af0)
#define AFE_CONN19_1			(0x0af4)
#define AFE_CONN43			(0x0af8)
#define AFE_CONN43_1			(0x0afc)
#define AFE_CONN21_1			(0x0b00)
#define AFE_CONN22_1			(0x0b04)
#define AFE_CONN23_1			(0x0b08)
#define AFE_CONN24_1			(0x0b0c)
#define AFE_CONN25_1			(0x0b10)
#define AFE_CONN26_1			(0x0b14)
#define AFE_CONN27_1			(0x0b18)
#define AFE_CONN28_1			(0x0b1c)
#define AFE_CONN29_1			(0x0b20)
#define AFE_CONN30_1			(0x0b24)
#define AFE_CONN31_1			(0x0b28)
#define AFE_CONN32_1			(0x0b2c)
#define AFE_CONN33_1			(0x0b30)
#define AFE_CONN34_1			(0x0b34)
#define AFE_CONN35_1			(0x0b38)
#define AFE_CONN36_1			(0x0b3c)
#define AFE_CONN37_1			(0x0b40)
#define AFE_CONN38_1			(0x0b44)
#define AFE_CONN39_1			(0x0b48)
#define AFE_CONN40_1			(0x0b4c)
#define AFE_CONN41_1			(0x0b50)
#define AFE_CONN42_1			(0x0b54)
#define AFE_CONN44_1			(0x0b58)
#define AFE_CONN45_1			(0x0b5c)
#define AFE_CONN46_1			(0x0b60)
#define AFE_CONN47_1			(0x0b64)
#define AFE_CONN_RS_1			(0x0b68)
#define AFE_CONN_DI_1			(0x0b6c)
#define AFE_CONN_24BIT_1		(0x0b70)
#define AFE_GAIN1_CUR			(0x0b78)
#define AFE_CONN20_1			(0x0b7c)
#define AFE_DL1_BASE_MSB		(0x0b80)
#define AFE_DL1_END_MSB			(0x0b84)
#define AFE_DL2_BASE_MSB		(0x0b88)
#define AFE_DL2_END_MSB			(0x0b8c)
#define AFE_AWB_BASE_MSB		(0x0b90)
#define AFE_AWB_END_MSB			(0x0b94)
#define AFE_VUL_BASE_MSB		(0x0ba0)
#define AFE_VUL_END_MSB			(0x0ba4)
#define AFE_VUL_D2_BASE_MSB		(0x0ba8)
#define AFE_VUL_D2_END_MSB		(0x0bac)
#define AFE_HDMI_OUT_BASE_MSB		(0x0bb8)
#define AFE_HDMI_OUT_END_MSB		(0x0bbc)
#define AFE_HDMI_IN_2CH_BASE_MSB	(0x0bc0)
#define AFE_HDMI_IN_2CH_END_MSB		(0x0bc4)
#define AFE_SPDIF_OUT_BASE_MSB		(0x0bc8)
#define AFE_SPDIF_OUT_END_MSB		(0x0bcc)
#define SPDIFIN_BASE_MSB		(0x0bd0)
#define SPDIFIN_END_MSB			(0x0bd4)
#define AFE_DL1_CUR_MSB			(0x0bd8)
#define AFE_DL2_CUR_MSB			(0x0bdc)
#define AFE_AWB_CUR_MSB			(0x0be8)
#define AFE_VUL_CUR_MSB			(0x0bf8)
#define AFE_VUL_D2_CUR_MSB		(0x0c04)
#define AFE_HDMI_OUT_CUR_MSB		(0x0c0c)
#define AFE_HDMI_IN_2CH_CUR_MSB		(0x0c10)
#define AFE_SPDIF_OUT_CUR_MSB		(0x0c14)
#define SPDIFIN_CUR_MSB			(0x0c18)
#define AFE_CONN_REG			(0x0c20)
#define AFE_SECURE_MASK_CONN14_1	(0x0c24)
#define AFE_SECURE_MASK_CONN15_1	(0x0c28)
#define AFE_SECURE_MASK_CONN16_1	(0x0c2c)
#define AFE_SECURE_MASK_CONN17_1	(0x0c30)
#define AFE_SECURE_MASK_CONN18_1	(0x0c34)
#define AFE_SECURE_MASK_CONN19_1	(0x0c38)
#define AFE_SECURE_MASK_CONN20_1	(0x0c3c)
#define AFE_SECURE_MASK_CONN21_1	(0x0c40)
#define AFE_SECURE_MASK_CONN22_1	(0x0c44)
#define AFE_SECURE_MASK_CONN23_1	(0x0c48)
#define AFE_SECURE_MASK_CONN24_1	(0x0c4c)
#define AFE_ADDA_DL_SDM_DCCOMP_CON	(0x0c50)
#define AFE_ADDA_DL_SDM_TEST		(0x0c54)
#define AFE_ADDA_DL_DC_COMP_CFG0	(0x0c58)
#define AFE_ADDA_DL_DC_COMP_CFG1	(0x0c5c)
#define AFE_ADDA_DL_SDM_FIFO_MON	(0x0c60)
#define AFE_ADDA_DL_SRC_LCH_MON		(0x0c64)
#define AFE_ADDA_DL_SRC_RCH_MON		(0x0c68)
#define AFE_ADDA_DL_SDM_OUT_MON		(0x0c6c)
#define AFE_ADDA_DL_SDM_DITHER_CON	(0x0c70)

#define AFE_VUL3_CUR_MSB		(0x0c78)
#define AFE_ASRC_2CH_CON0		(0x0c80)
#define AFE_ASRC_2CH_CON1		(0x0c84)
#define AFE_ASRC_2CH_CON2		(0x0c88)
#define AFE_ASRC_2CH_CON3		(0x0c8c)
#define AFE_ASRC_2CH_CON4		(0x0c90)
#define AFE_ASRC_2CH_CON5		(0x0c94)
#define AFE_ASRC_2CH_CON6		(0x0c98)
#define AFE_ASRC_2CH_CON7		(0x0c9c)
#define AFE_ASRC_2CH_CON8		(0x0ca0)
#define AFE_ASRC_2CH_CON9		(0x0ca4)
#define AFE_ASRC_2CH_CON10		(0x0ca8)
#define AFE_ASRC_2CH_CON12		(0x0cb0)
#define AFE_ASRC_2CH_CON13		(0x0cb4)

#define AFE_PCM_TX_ASRC_2CH_CON0	(0x0cc0)
#define AFE_PCM_TX_ASRC_2CH_CON1	(0x0cc4)
#define AFE_PCM_TX_ASRC_2CH_CON2	(0x0cc8)
#define AFE_PCM_TX_ASRC_2CH_CON3	(0x0ccc)
#define AFE_PCM_TX_ASRC_2CH_CON4	(0x0cd0)
#define AFE_PCM_TX_ASRC_2CH_CON5	(0x0cd4)
#define AFE_PCM_TX_ASRC_2CH_CON6	(0x0cd8)
#define AFE_PCM_TX_ASRC_2CH_CON7	(0x0cdc)
#define AFE_PCM_TX_ASRC_2CH_CON8	(0x0ce0)
#define AFE_PCM_TX_ASRC_2CH_CON9	(0x0ce4)
#define AFE_PCM_TX_ASRC_2CH_CON10	(0x0ce8)
#define AFE_PCM_TX_ASRC_2CH_CON12	(0x0cf0)
#define AFE_PCM_TX_ASRC_2CH_CON13	(0x0cf4)
#define AFE_PCM_RX_ASRC_2CH_CON0	(0x0d00)
#define AFE_PCM_RX_ASRC_2CH_CON1	(0x0d04)
#define AFE_PCM_RX_ASRC_2CH_CON2	(0x0d08)
#define AFE_PCM_RX_ASRC_2CH_CON3	(0x0d0c)
#define AFE_PCM_RX_ASRC_2CH_CON4	(0x0d10)
#define AFE_PCM_RX_ASRC_2CH_CON5	(0x0d14)
#define AFE_PCM_RX_ASRC_2CH_CON6	(0x0d18)
#define AFE_PCM_RX_ASRC_2CH_CON7	(0x0d1c)
#define AFE_PCM_RX_ASRC_2CH_CON8	(0x0d20)
#define AFE_PCM_RX_ASRC_2CH_CON9	(0x0d24)
#define AFE_PCM_RX_ASRC_2CH_CON10	(0x0d28)
#define AFE_PCM_RX_ASRC_2CH_CON12	(0x0d30)
#define AFE_PCM_RX_ASRC_2CH_CON13	(0x0d34)

#define AFE_ADDA_PREDIS_CON2		(0x0d40)
#define AFE_ADDA_PREDIS_CON3		(0x0d44)
#define AFE_SECURE_MASK_CONN4_1		(0x0d48)
#define AFE_SECURE_MASK_CONN5_1		(0x0d4c)
#define AFE_SECURE_MASK_CONN6_1		(0x0d50)
#define AFE_SECURE_MASK_CONN7_1		(0x0d54)
#define AFE_SECURE_MASK_CONN8_1		(0x0d58)
#define AFE_SECURE_MASK_CONN9_1		(0x0d5c)
#define AFE_SECURE_MASK_CONN10_1	(0x0d60)
#define AFE_SECURE_MASK_CONN11_1	(0x0d64)
#define AFE_SECURE_MASK_CONN12_1	(0x0d68)
#define AFE_SECURE_MASK_CONN13_1	(0x0d6c)
#define AFE_MEMIF_MON12			(0x0d70)
#define AFE_MEMIF_MON13			(0x0d74)
#define AFE_MEMIF_MON14			(0x0d78)
#define AFE_MEMIF_MON15			(0x0d7c)
#define AFE_SECURE_MASK_CONN42		(0x0dbc)
#define AFE_SECURE_MASK_CONN43		(0x0dc0)
#define AFE_SECURE_MASK_CONN44		(0x0dc4)
#define AFE_SECURE_MASK_CONN45		(0x0dc8)
#define AFE_SECURE_MASK_CONN46		(0x0dcc)
#define AFE_HD_ENGEN_ENABLE		(0x0dd0)
#define AFE_SECURE_MASK_CONN47		(0x0dd4)
#define AFE_SECURE_MASK_CONN48		(0x0dd8)
#define AFE_SECURE_MASK_CONN49		(0x0ddc)
#define AFE_SECURE_MASK_CONN50		(0x0de0)
#define AFE_SECURE_MASK_CONN51		(0x0de4)
#define AFE_SECURE_MASK_CONN52		(0x0de8)
#define AFE_SECURE_MASK_CONN53		(0x0dec)
#define AFE_SECURE_MASK_CONN0_1		(0x0df0)
#define AFE_SECURE_MASK_CONN1_1		(0x0df4)
#define AFE_SECURE_MASK_CONN2_1		(0x0df8)
#define AFE_SECURE_MASK_CONN3_1		(0x0dfc)

#define AFE_ADDA_MTKAIF_CFG0		(0x0e00)
#define AFE_ADDA_MTKAIF_SYNCWORD_CFG	(0x0e14)
#define AFE_ADDA_MTKAIF_RX_CFG0		(0x0e20)
#define AFE_ADDA_MTKAIF_RX_CFG1		(0x0e24)
#define AFE_ADDA_MTKAIF_RX_CFG2		(0x0e28)
#define AFE_ADDA_MTKAIF_MON0		(0x0e34)
#define AFE_ADDA_MTKAIF_MON1		(0x0e38)
#define AFE_AUD_PAD_TOP			(0x0e40)

#define AFE_CM1_CON4			(0x0e48)
#define AFE_CM2_CON4			(0x0e4c)
#define AFE_CM1_CON0			(0x0e50)
#define AFE_CM1_CON1			(0x0e54)
#define AFE_CM1_CON2			(0x0e58)
#define AFE_CM1_CON3			(0x0e5c)
#define AFE_CM2_CON0			(0x0e60)
#define AFE_CM2_CON1			(0x0e64)
#define AFE_CM2_CON2			(0x0e68)
#define AFE_CM2_CON3			(0x0e6c)
#define AFE_CM2_CONN0			(0x0e70)
#define AFE_CM2_CONN1			(0x0e74)
#define AFE_CM2_CONN2			(0x0e78)

#define AFE_GENERAL1_ASRC_2CH_CON0	(0x0e80)
#define AFE_GENERAL1_ASRC_2CH_CON1	(0x0e84)
#define AFE_GENERAL1_ASRC_2CH_CON2	(0x0e88)
#define AFE_GENERAL1_ASRC_2CH_CON3	(0x0e8c)
#define AFE_GENERAL1_ASRC_2CH_CON4	(0x0e90)
#define AFE_GENERAL1_ASRC_2CH_CON5	(0x0e94)
#define AFE_GENERAL1_ASRC_2CH_CON6	(0x0e98)
#define AFE_GENERAL1_ASRC_2CH_CON7	(0x0e9c)
#define AFE_GENERAL1_ASRC_2CH_CON8	(0x0ea0)
#define AFE_GENERAL1_ASRC_2CH_CON9	(0x0ea4)
#define AFE_GENERAL1_ASRC_2CH_CON10	(0x0ea8)
#define AFE_GENERAL1_ASRC_2CH_CON12	(0x0eb0)
#define AFE_GENERAL1_ASRC_2CH_CON13	(0x0eb4)
#define GENERAL_ASRC_MODE		(0x0eb8)
#define GENERAL_ASRC_EN_ON		(0x0ebc)

#define AFE_CONN48			(0x0ec0)
#define AFE_CONN49			(0x0ec4)
#define AFE_CONN50			(0x0ec8)
#define AFE_CONN51			(0x0ecc)
#define AFE_CONN52			(0x0ed0)
#define AFE_CONN53			(0x0ed4)
#define AFE_CONN48_1			(0x0ee0)
#define AFE_CONN49_1			(0x0ee4)
#define AFE_CONN50_1			(0x0ee8)
#define AFE_CONN51_1			(0x0eec)
#define AFE_CONN52_1			(0x0ef0)
#define AFE_CONN53_1			(0x0ef4)

#define AFE_GENERAL2_ASRC_2CH_CON0	(0x0f00)
#define AFE_GENERAL2_ASRC_2CH_CON1	(0x0f04)
#define AFE_GENERAL2_ASRC_2CH_CON2	(0x0f08)
#define AFE_GENERAL2_ASRC_2CH_CON3	(0x0f0c)
#define AFE_GENERAL2_ASRC_2CH_CON4	(0x0f10)
#define AFE_GENERAL2_ASRC_2CH_CON5	(0x0f14)
#define AFE_GENERAL2_ASRC_2CH_CON6	(0x0f18)
#define AFE_GENERAL2_ASRC_2CH_CON7	(0x0f1c)
#define AFE_GENERAL2_ASRC_2CH_CON8	(0x0f20)
#define AFE_GENERAL2_ASRC_2CH_CON9	(0x0f24)
#define AFE_GENERAL2_ASRC_2CH_CON10	(0x0f28)
#define AFE_GENERAL2_ASRC_2CH_CON12	(0x0f30)
#define AFE_GENERAL2_ASRC_2CH_CON13	(0x0f34)

#define AFE_SECURE_MASK_CONN28		(0x0f48)
#define AFE_SECURE_MASK_CONN29		(0x0f4c)
#define AFE_SECURE_MASK_CONN30		(0x0f50)
#define AFE_SECURE_MASK_CONN31		(0x0f54)
#define AFE_SECURE_MASK_CONN32		(0x0f58)
#define AFE_SECURE_MASK_CONN33		(0x0f5c)
#define AFE_SECURE_MASK_CONN34		(0x0f60)
#define AFE_SECURE_MASK_CONN35		(0x0f64)
#define AFE_SECURE_MASK_CONN36		(0x0f68)
#define AFE_SECURE_MASK_CONN37		(0x0f6c)
#define AFE_SECURE_MASK_CONN38		(0x0f70)
#define AFE_SECURE_MASK_CONN39		(0x0f74)
#define AFE_SECURE_MASK_CONN40		(0x0f78)
#define AFE_SECURE_MASK_CONN41		(0x0f7c)
#define AFE_SIDEBAND0			(0x0f80)
#define AFE_SIDEBAND1			(0x0f84)
#define AFE_SECURE_SIDEBAND0		(0x0f88)
#define AFE_SECURE_SIDEBAND1		(0x0f8c)
#define AFE_SECURE_MASK_CONN0		(0x0f90)
#define AFE_SECURE_MASK_CONN1		(0x0f94)
#define AFE_SECURE_MASK_CONN2		(0x0f98)
#define AFE_SECURE_MASK_CONN3		(0x0f9c)
#define AFE_SECURE_MASK_CONN4		(0x0fa0)
#define AFE_SECURE_MASK_CONN5		(0x0fa4)
#define AFE_SECURE_MASK_CONN6		(0x0fa8)
#define AFE_SECURE_MASK_CONN7		(0x0fac)
#define AFE_SECURE_MASK_CONN8		(0x0fb0)
#define AFE_SECURE_MASK_CONN9		(0x0fb4)
#define AFE_SECURE_MASK_CONN10		(0x0fb8)
#define AFE_SECURE_MASK_CONN11		(0x0fbc)
#define AFE_SECURE_MASK_CONN12		(0x0fc0)
#define AFE_SECURE_MASK_CONN13		(0x0fc4)
#define AFE_SECURE_MASK_CONN14		(0x0fc8)
#define AFE_SECURE_MASK_CONN15		(0x0fcc)
#define AFE_SECURE_MASK_CONN16		(0x0fd0)
#define AFE_SECURE_MASK_CONN17		(0x0fd4)
#define AFE_SECURE_MASK_CONN18		(0x0fd8)
#define AFE_SECURE_MASK_CONN19		(0x0fdc)
#define AFE_SECURE_MASK_CONN20		(0x0fe0)
#define AFE_SECURE_MASK_CONN21		(0x0fe4)
#define AFE_SECURE_MASK_CONN22		(0x0fe8)
#define AFE_SECURE_MASK_CONN23		(0x0fec)
#define AFE_SECURE_MASK_CONN24		(0x0ff0)
#define AFE_SECURE_MASK_CONN25		(0x0ff4)
#define AFE_SECURE_MASK_CONN26		(0x0ff8)
#define AFE_SECURE_MASK_CONN27		(0x0ffc)

#define MAX_REGISTER			AFE_SECURE_MASK_CONN27

#define AFE_IRQ_STATUS_BITS		0x3ff

/* AUDIO_TOP_CON0 (0x0000) */
#define AUD_TCON0_PDN_TML		(1U << 27)
#define AUD_TCON0_PDN_DAC_PREDIS	(1U << 26)
#define AUD_TCON0_PDN_DAC		(1U << 25)
#define AUD_TCON0_PDN_ADC		(1U << 24)
#define AUD_TCON0_PDN_TDM_IN		(1U << 23)
#define AUD_TCON0_PDN_TDM_OUT		(1U << 22)
#define AUD_TCON0_PDN_SPDIF		(1U << 21)
#define AUD_TCON0_PDN_APLL_TUNER	(1U << 19)
#define AUD_TCON0_PDN_APLL2_TUNER	(1U << 18)
#define AUD_TCON0_PDN_INTDIR		(1U << 15)
#define AUD_TCON0_PDN_24M		(1U << 9)
#define AUD_TCON0_PDN_22M		(1U << 8)
#define AUD_TCON0_PDN_I2S_IN		(1U << 6)
#define AUD_TCON0_PDN_AFE		(1U << 2)

/* AUDIO_TOP_CON1 (0x0004) */
#define AUD_TCON1_PDN_TDM_ASRC		(1U << 15)
#define AUD_TCON1_PDN_GENERAL2_ASRC	(1U << 14)
#define AUD_TCON1_PDN_GENERAL1_ASRC	(1U << 13)
#define AUD_TCON1_PDN_CONNSYS_I2S_ASRC	(1U << 12)
#define AUD_TCON1_PDN_DMIC3_ADC		(1U << 11)
#define AUD_TCON1_PDN_DMIC2_ADC		(1U << 10)
#define AUD_TCON1_PDN_DMIC1_ADC		(1U << 9)
#define AUD_TCON1_PDN_DMIC0_ADC		(1U << 8)
#define AUD_TCON1_PDN_I2S4_BCLK		(1U << 7)
#define AUD_TCON1_PDN_I2S3_BCLK		(1U << 6)
#define AUD_TCON1_PDN_I2S2_BCLK		(1U << 5)
#define AUD_TCON1_PDN_I2S1_BCLK		(1U << 4)

/* AUDIO_TOP_CON3 (0x000C) */
#define AUD_TCON3_HDMI_BCK_INV		(1U << 3)

/* AFE_I2S_CON (0x0018) */
#define AFE_I2S_CON_PHASE_SHIFT_FIX	(1U << 31)
#define AFE_I2S_CON_FROM_IO_MUX		(1U << 28)
#define AFE_I2S_CON_LOW_JITTER_CLK	(1U << 12)
#define AFE_I2S_CON_RATE_MASK		GENMASK(11, 8)
#define AFE_I2S_CON_FORMAT_I2S		(1U << 3)
#define AFE_I2S_CON_SRC_SLAVE		(1U << 2)

/* AFE_ASRC_2CH_CON0 */
#define ONE_HEART	(1U << 31)
#define CHSET_STR_CLR	(1U << 4)
#define COEFF_SRAM_CTRL	(1U << 1)
#define ASM_ON		(1U << 0)

/* CON2 */
#define O16BIT		(1U << 19)
#define CLR_IIR_HISTORY	(1U << 17)
#define IS_MONO		(1U << 16)
#define IIR_EN		(1U << 11)
#define IIR_STAGE_MASK	GENMASK(10, 8)

/* CON5 */
#define CALI_CYCLE_MASK	GENMASK(31, 16)
#define CALI_64_CYCLE	FIELD_PREP(CALI_CYCLE_MASK, 0x3F)
#define CALI_96_CYCLE	FIELD_PREP(CALI_CYCLE_MASK, 0x5F)
#define CALI_441_CYCLE	FIELD_PREP(CALI_CYCLE_MASK, 0x1B8)

#define CALI_AUTORST	(1U << 15)
#define AUTO_TUNE_FREQ5	(1U << 12)
#define COMP_FREQ_RES	(1U << 11)

#define CALI_SEL_MASK	GENMASK(9, 8)
#define CALI_SEL_00	FIELD_PREP(CALI_SEL_MASK, 0)
#define CALI_SEL_01	FIELD_PREP(CALI_SEL_MASK, 1)

#define CALI_BP_DGL		(1U << 7) /* Bypass the deglitch circuit */
#define AUTO_TUNE_FREQ4		(1U << 3)
#define CALI_AUTO_RESTART	(1U << 2)
#define CALI_USE_FREQ_OUT	(1U << 1)
#define CALI_ON			(1U << 0)

#define AFE_I2S_CON_WLEN_32BIT		(1U << 1)
#define AFE_I2S_CON_EN			(1U << 0)

#define AFE_CONN3_I03_O03_S		(1U << 3)
#define AFE_CONN4_I04_O04_S		(1U << 4)
#define AFE_CONN4_I03_O04_S		(1U << 3)

/* AFE_I2S_CON1 (0x0034) */
#define AFE_I2S_CON1_I2S2_TO_PAD	(1U << 18)
#define AFE_I2S_CON1_TDMOUT_TO_PAD	(0 << 18)
#define AFE_I2S_CON1_RATE		GENMASK(11, 8)
#define AFE_I2S_CON1_FORMAT_I2S		(1U << 3)
#define AFE_I2S_CON1_WLEN_32BIT		(1U << 1)
#define AFE_I2S_CON1_EN			(1U << 0)

/* AFE_I2S_CON2 (0x0038) */
#define AFE_I2S_CON2_LOW_JITTER_CLK	(1U << 12)
#define AFE_I2S_CON2_RATE		GENMASK(11, 8)
#define AFE_I2S_CON2_FORMAT_I2S		(1U << 3)
#define AFE_I2S_CON2_WLEN_32BIT		(1U << 1)
#define AFE_I2S_CON2_EN			(1U << 0)

/* AFE_I2S_CON3 (0x004C) */
#define AFE_I2S_CON3_LOW_JITTER_CLK	(1U << 12)
#define AFE_I2S_CON3_RATE		GENMASK(11, 8)
#define AFE_I2S_CON3_FORMAT_I2S		(1U << 3)
#define AFE_I2S_CON3_WLEN_32BIT		(1U << 1)
#define AFE_I2S_CON3_EN			(1U << 0)

/* AFE_ADDA_DL_SRC2_CON0 (0x0108) */
#define AFE_ADDA_DL_SAMPLING_RATE	GENMASK(31, 28)
#define AFE_ADDA_DL_8X_UPSAMPLE		GENMASK(25, 24)
#define AFE_ADDA_DL_MUTE_OFF_CH1	(1U << 12)
#define AFE_ADDA_DL_MUTE_OFF_CH2	(1U << 11)
#define AFE_ADDA_DL_VOICE_DATA		(1U << 5)
#define AFE_ADDA_DL_DEGRADE_GAIN	(1U << 1)

/* AFE_ADDA_UL_SRC_CON0 (0x0114) */
#define AFE_ADDA_UL_SAMPLING_RATE	GENMASK(19, 17)

/* AFE_ADDA_UL_DL_CON0 */
#define AFE_ADDA_UL_DL_ADDA_AFE_ON	(1U << 0)
#define AFE_ADDA_UL_DL_DMIC_CLKDIV_ON	(1U << 1)

/* AFE_APLL_TUNER_CFG (0x03f0) */
#define AFE_APLL_TUNER_CFG_MASK		GENMASK(15, 1)
#define AFE_APLL_TUNER_CFG_EN_MASK	(1U << 0)

/* AFE_APLL_TUNER_CFG1 (0x03f4) */
#define AFE_APLL_TUNER_CFG1_MASK	GENMASK(15, 1)
#define AFE_APLL_TUNER_CFG1_EN_MASK	(1U << 0)

/* PCM_INTF_CON1 (0x0550) */
#define PCM_INTF_CON1_EXT_MODEM		(1U << 17)
#define PCM_INTF_CON1_16BIT		(0 << 16)
#define PCM_INTF_CON1_24BIT		(1U << 16)
#define PCM_INTF_CON1_32BCK		(0 << 14)
#define PCM_INTF_CON1_64BCK		(1U << 14)
#define PCM_INTF_CON1_MASTER_MODE	(0 << 5)
#define PCM_INTF_CON1_SLAVE_MODE	(1U << 5)
#define PCM_INTF_CON1_FS_MASK		GENMASK(4, 3)
#define PCM_INTF_CON1_FS_8K		FIELD_PREP(PCM_INTF_CON1_FS_MASK, 0)
#define PCM_INTF_CON1_FS_16K		FIELD_PREP(PCM_INTF_CON1_FS_MASK, 1)
#define PCM_INTF_CON1_FS_32K		FIELD_PREP(PCM_INTF_CON1_FS_MASK, 2)
#define PCM_INTF_CON1_FS_48K		FIELD_PREP(PCM_INTF_CON1_FS_MASK, 3)
#define PCM_INTF_CON1_SYNC_LEN_MASK	GENMASK(13, 9)
#define PCM_INTF_CON1_SYNC_LEN(x)	FIELD_PREP(PCM_INTF_CON1_SYNC_LEN_MASK, ((x) - 1))
#define PCM_INTF_CON1_FORMAT_MASK	GENMASK(2, 1)
#define PCM_INTF_CON1_SYNC_OUT_INV	(1U << 23)
#define PCM_INTF_CON1_BCLK_OUT_INV	(1U << 22)
#define PCM_INTF_CON1_SYNC_IN_INV	(1U << 21)
#define PCM_INTF_CON1_BCLK_IN_INV	(1U << 20)
#define PCM_INTF_CON1_BYPASS_ASRC	(1U << 6)
#define PCM_INTF_CON1_EN		(1U << 0)
#define PCM_INTF_CON1_CONFIG_MASK	(0xf3fffe)

/* AFE_DMIC0_UL_SRC_CON0 (0x05b4)
 * AFE_DMIC1_UL_SRC_CON0 (0x0620)
 * AFE_DMIC2_UL_SRC_CON0 (0x0780)
 * AFE_DMIC3_UL_SRC_CON0 (0x07ec)
 */
#define DMIC_TOP_CON_CK_PHASE_SEL_CH1		GENMASK(29, 27)
#define DMIC_TOP_CON_CK_PHASE_SEL_CH2		GENMASK(26, 24)
#define DMIC_TOP_CON_TWO_WIRE_MODE		(1U << 23)
#define DMIC_TOP_CON_CH2_ON			(1U << 22)
#define DMIC_TOP_CON_CH1_ON			(1U << 21)
#define DMIC_TOP_CON_VOICE_MODE_MASK		GENMASK(19, 17)
#define DMIC_TOP_CON_VOICE_MODE_8K		FIELD_PREP(DMIC_TOP_CON_VOICE_MODE_MASK, 0)
#define DMIC_TOP_CON_VOICE_MODE_16K		FIELD_PREP(DMIC_TOP_CON_VOICE_MODE_MASK, 1)
#define DMIC_TOP_CON_VOICE_MODE_32K		FIELD_PREP(DMIC_TOP_CON_VOICE_MODE_MASK, 2)
#define DMIC_TOP_CON_VOICE_MODE_48K		FIELD_PREP(DMIC_TOP_CON_VOICE_MODE_MASK, 3)
#define DMIC_TOP_CON_LOW_POWER_MODE_MASK	GENMASK(15, 14)
#define DMIC_TOP_CON_LOW_POWER_MODE(x)		FIELD_PREP(DMIC_TOP_CON_LOW_POWER_MODE_MASK, (x))
#define DMIC_TOP_CON_IIR_ON			(1U << 10)
#define DMIC_TOP_CON_IIR_MODE			GENMASK(9, 7)
#define DMIC_TOP_CON_INPUT_MODE			(1U << 5)
#define DMIC_TOP_CON_SDM3_LEVEL_MODE		(1U << 1)
#define DMIC_TOP_CON_SRC_ON			(1U << 0)
#define DMIC_TOP_CON_SDM3_DE_SELECT		(0 << 1)
#define DMIC_TOP_CON_CONFIG_MASK		(0x3f8ed7a6)

/* AFE_CONN_24BIT (0x0AA4) */
#define AFE_CONN_24BIT_O10		(1U << 10)
#define AFE_CONN_24BIT_O09		(1U << 9)
#define AFE_CONN_24BIT_O06		(1U << 6)
#define AFE_CONN_24BIT_O05		(1U << 5)
#define AFE_CONN_24BIT_O04		(1U << 4)
#define AFE_CONN_24BIT_O03		(1U << 3)
#define AFE_CONN_24BIT_O02		(1U << 2)
#define AFE_CONN_24BIT_O01		(1U << 1)
#define AFE_CONN_24BIT_O00		(1U << 0)

/* AFE_HD_ENGEN_ENABLE */
#define AFE_22M_PLL_EN		(1U << 0)
#define AFE_24M_PLL_EN		(1U << 1)

/* AFE_GAIN1_CON0 (0x0410) */
#define AFE_GAIN1_CON0_EN_MASK			GENMASK(0, 0)
#define AFE_GAIN1_CON0_MODE_MASK		GENMASK(7, 4)
#define AFE_GAIN1_CON0_SAMPLE_PER_STEP_MASK	GENMASK(15, 8)

/* AFE_GAIN1_CON1 (0x0414) */
#define AFE_GAIN1_CON1_MASK		GENMASK(19, 0)

/* AFE_GAIN1_CUR (0x0B78) */
#define AFE_GAIN1_CUR_MASK		GENMASK(19, 0)

/* AFE_CM1_CON0 (0x0e50) */
/* AFE_CM2_CON0 (0x0e60) */
#define CM_AFE_CM_CH_NUM_MASK		GENMASK(3, 0)
#define CM_AFE_CM_CH_NUM(x)		FIELD_PREP(CM_AFE_CM_CH_NUM_MASK, ((x) - 1))
#define CM_AFE_CM_ON			(1U << 4)
#define CM_AFE_CM_START_DATA_MASK	GENMASK(11, 8)

#define CM_AFE_CM1_VUL_SEL		(1U << 12)
#define CM_AFE_CM1_IN_MODE_MASK		GENMASK(19, 16)
#define CM_AFE_CM2_TDM_SEL		(1U << 12)
#define CM_AFE_CM2_CLK_SEL		(1U << 13)
#define CM_AFE_CM2_GASRC1_OUT_SEL	(1U << 17)
#define CM_AFE_CM2_GASRC2_OUT_SEL	(1U << 16)

/* AFE_CM2_CONN* */
#define CM2_AFE_CM2_CONN_CFG1(x)	FIELD_PREP(CM2_AFE_CM2_CONN_CFG1_MASK, (x))
#define CM2_AFE_CM2_CONN_CFG1_MASK	GENMASK(4, 0)
#define CM2_AFE_CM2_CONN_CFG2(x)	FIELD_PREP(CM2_AFE_CM2_CONN_CFG2_MASK, (x))
#define CM2_AFE_CM2_CONN_CFG2_MASK	GENMASK(9, 5)
#define CM2_AFE_CM2_CONN_CFG3(x)	FIELD_PREP(CM2_AFE_CM2_CONN_CFG3_MASK, (x))
#define CM2_AFE_CM2_CONN_CFG3_MASK	GENMASK(14, 10)
#define CM2_AFE_CM2_CONN_CFG4(x)	FIELD_PREP(CM2_AFE_CM2_CONN_CFG4_MASK, (x))
#define CM2_AFE_CM2_CONN_CFG4_MASK	GENMASK(19, 15)
#define CM2_AFE_CM2_CONN_CFG5(x)	FIELD_PREP(CM2_AFE_CM2_CONN_CFG5_MASK, (x))
#define CM2_AFE_CM2_CONN_CFG5_MASK	GENMASK(24, 20)
#define CM2_AFE_CM2_CONN_CFG6(x)	FIELD_PREP(CM2_AFE_CM2_CONN_CFG6_MASK, (x))
#define CM2_AFE_CM2_CONN_CFG6_MASK	GENMASK(29, 25)
#define CM2_AFE_CM2_CONN_CFG7(x)	FIELD_PREP(CM2_AFE_CM2_CONN_CFG7_MASK, (x))
#define CM2_AFE_CM2_CONN_CFG7_MASK	GENMASK(4, 0)
#define CM2_AFE_CM2_CONN_CFG8(x)	FIELD_PREP(CM2_AFE_CM2_CONN_CFG8_MASK, (x))
#define CM2_AFE_CM2_CONN_CFG8_MASK	GENMASK(9, 5)
#define CM2_AFE_CM2_CONN_CFG9(x)	FIELD_PREP(CM2_AFE_CM2_CONN_CFG9_MASK, (x))
#define CM2_AFE_CM2_CONN_CFG9_MASK	GENMASK(14, 10)
#define CM2_AFE_CM2_CONN_CFG10(x)	FIELD_PREP(CM2_AFE_CM2_CONN_CFG10_MASK, (x))
#define CM2_AFE_CM2_CONN_CFG10_MASK	GENMASK(19, 15)
#define CM2_AFE_CM2_CONN_CFG11(x)	FIELD_PREP(CM2_AFE_CM2_CONN_CFG11_MASK, (x))
#define CM2_AFE_CM2_CONN_CFG11_MASK	GENMASK(24, 20)
#define CM2_AFE_CM2_CONN_CFG12(x)	FIELD_PREP(CM2_AFE_CM2_CONN_CFG12_MASK, (x))
#define CM2_AFE_CM2_CONN_CFG12_MASK	GENMASK(29, 25)
#define CM2_AFE_CM2_CONN_CFG13(x)	FIELD_PREP(CM2_AFE_CM2_CONN_CFG13_MASK, (x))
#define CM2_AFE_CM2_CONN_CFG13_MASK	GENMASK(4, 0)
#define CM2_AFE_CM2_CONN_CFG14(x)	FIELD_PREP(CM2_AFE_CM2_CONN_CFG14_MASK, (x))
#define CM2_AFE_CM2_CONN_CFG14_MASK	GENMASK(9, 5)
#define CM2_AFE_CM2_CONN_CFG15(x)	FIELD_PREP(CM2_AFE_CM2_CONN_CFG15_MASK, (x))
#define CM2_AFE_CM2_CONN_CFG15_MASK	GENMASK(14, 10)
#define CM2_AFE_CM2_CONN_CFG16(x)	FIELD_PREP(CM2_AFE_CM2_CONN_CFG16_MASK, (x))
#define CM2_AFE_CM2_CONN_CFG16_MASK	GENMASK(19, 15)

/* AFE_CM1_CON* */
#define CM_AFE_CM_UPDATE_CNT1_MASK	GENMASK(15, 0)
#define CM_AFE_CM_UPDATE_CNT1(x)	FIELD_PREP(CM_AFE_CM_UPDATE_CNT1_MASK, (x))
#define CM_AFE_CM_UPDATE_CNT2_MASK	GENMASK(31, 16)
#define CM_AFE_CM_UPDATE_CNT2(x)	FIELD_PREP(CM_AFE_CM_UPDATE_CNT2_MASK, (x))

#endif
