/* sudoku-board.c generated by valac 0.39.92.14-46f76, the Vala compiler
 * generated from sudoku-board.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * Copyright © 2014 Parin Porecha
 * Copyright © 2014 Michael Catanzaro
 *
 * This file is part of GNOME Sudoku.
 *
 * GNOME Sudoku is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME Sudoku is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME Sudoku. If not, see <http://www.gnu.org/licenses/>.
 */


#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <float.h>
#include <math.h>
#include "qqwing-wrapper.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>


#define TYPE_SUDOKU_BOARD (sudoku_board_get_type ())
#define SUDOKU_BOARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_BOARD, SudokuBoard))
#define SUDOKU_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_BOARD, SudokuBoardClass))
#define IS_SUDOKU_BOARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_BOARD))
#define IS_SUDOKU_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_BOARD))
#define SUDOKU_BOARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_BOARD, SudokuBoardClass))

typedef struct _SudokuBoard SudokuBoard;
typedef struct _SudokuBoardClass SudokuBoardClass;
typedef struct _SudokuBoardPrivate SudokuBoardPrivate;

#define TYPE_COORD (coord_get_type ())
typedef struct _Coord Coord;

#define TYPE_DIFFICULTY_CATEGORY (difficulty_category_get_type ())
enum  {
	SUDOKU_BOARD_0_PROPERTY,
	SUDOKU_BOARD_PREVIOUS_PLAYED_TIME_PROPERTY,
	SUDOKU_BOARD_DIFFICULTY_CATEGORY_PROPERTY,
	SUDOKU_BOARD_BLOCK_ROWS_PROPERTY,
	SUDOKU_BOARD_BLOCK_COLS_PROPERTY,
	SUDOKU_BOARD_ROWS_PROPERTY,
	SUDOKU_BOARD_COLS_PROPERTY,
	SUDOKU_BOARD_MAX_VAL_PROPERTY,
	SUDOKU_BOARD_BROKEN_PROPERTY,
	SUDOKU_BOARD_FILLED_PROPERTY,
	SUDOKU_BOARD_FIXED_PROPERTY,
	SUDOKU_BOARD_SIZE_PROPERTY,
	SUDOKU_BOARD_COMPLETE_PROPERTY,
	SUDOKU_BOARD_NUM_PROPERTIES
};
static GParamSpec* sudoku_board_properties[SUDOKU_BOARD_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _coord_free0(var) ((var == NULL) ? NULL : (var = (coord_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	SUDOKU_BOARD_COMPLETED_SIGNAL,
	SUDOKU_BOARD_NUM_SIGNALS
};
static guint sudoku_board_signals[SUDOKU_BOARD_NUM_SIGNALS] = {0};

#define TYPE_HOUSE (house_get_type ())

#define TYPE_CELL (cell_get_type ())
typedef struct _Cell Cell;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Coord {
	gint row;
	gint col;
};

struct _SudokuBoard {
	GObject parent_instance;
	SudokuBoardPrivate * priv;
	gint* cells;
	gint cells_length1;
	gint cells_length2;
	gboolean* is_fixed;
	gint is_fixed_length1;
	gint is_fixed_length2;
	GeeSet* broken_coords;
	GeeList* coords_for_col;
	GeeList* coords_for_row;
	GeeMap* coords_for_block;
};

struct _SudokuBoardClass {
	GObjectClass parent_class;
};

typedef enum  {
	DIFFICULTY_CATEGORY_UNKNOWN,
	DIFFICULTY_CATEGORY_EASY,
	DIFFICULTY_CATEGORY_MEDIUM,
	DIFFICULTY_CATEGORY_HARD,
	DIFFICULTY_CATEGORY_VERY_HARD,
	DIFFICULTY_CATEGORY_CUSTOM
} DifficultyCategory;

struct _SudokuBoardPrivate {
	gboolean* possible_in_row;
	gint possible_in_row_length1;
	gint possible_in_row_length2;
	gboolean* possible_in_col;
	gint possible_in_col_length1;
	gint possible_in_col_length2;
	gboolean* possible_in_block;
	gint possible_in_block_length1;
	gint possible_in_block_length2;
	gint possible_in_block_length3;
	gboolean* earmarks;
	gint earmarks_length1;
	gint earmarks_length2;
	gint earmarks_length3;
	gint n_earmarks;
	gdouble _previous_played_time;
	DifficultyCategory _difficulty_category;
	gint _block_rows;
	gint _block_cols;
	gint _rows;
	gint _cols;
	gint _filled;
	gint _fixed;
};

typedef enum  {
	HOUSE_ROW,
	HOUSE_COLUMN,
	HOUSE_BLOCK
} House;

struct _Cell {
	Coord coord;
	gint val;
};


static gpointer sudoku_board_parent_class = NULL;

GType sudoku_board_get_type (void) G_GNUC_CONST;
GType coord_get_type (void) G_GNUC_CONST;
Coord* coord_dup (const Coord* self);
void coord_free (Coord* self);
GType difficulty_category_get_type (void) G_GNUC_CONST;
#define SUDOKU_BOARD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SUDOKU_BOARD, SudokuBoardPrivate))
gboolean sudoku_board_is_empty (SudokuBoard* self);
gint sudoku_board_get_filled (SudokuBoard* self);
gint sudoku_board_get_fixed (SudokuBoard* self);
gboolean sudoku_board_is_fully_filled (SudokuBoard* self);
gint sudoku_board_get_cols (SudokuBoard* self);
gint sudoku_board_get_rows (SudokuBoard* self);
SudokuBoard* sudoku_board_new (gint block_rows,
                               gint block_cols);
SudokuBoard* sudoku_board_construct (GType object_type,
                                     gint block_rows,
                                     gint block_cols);
static void sudoku_board_set_cols (SudokuBoard* self,
                            gint value);
static void sudoku_board_set_rows (SudokuBoard* self,
                            gint value);
static void sudoku_board_set_block_rows (SudokuBoard* self,
                                  gint value);
static void sudoku_board_set_block_cols (SudokuBoard* self,
                                  gint value);
gint sudoku_board_get_max_val (SudokuBoard* self);
gint coord_hash (Coord* coord);
gboolean coord_equal (Coord* a,
                      Coord* b);
void coord_init (Coord *self,
                 gint row,
                 gint col);
SudokuBoard* sudoku_board_clone (SudokuBoard* self);
gint sudoku_board_get_block_rows (SudokuBoard* self);
gint sudoku_board_get_block_cols (SudokuBoard* self);
static gint* _vala_array_dup1 (gint* self,
                        int length);
static gboolean* _vala_array_dup2 (gboolean* self,
                            int length);
static gboolean* _vala_array_dup3 (gboolean* self,
                            int length);
static gboolean* _vala_array_dup4 (gboolean* self,
                            int length);
static gboolean* _vala_array_dup5 (gboolean* self,
                            int length);
static void sudoku_board_set_filled (SudokuBoard* self,
                              gint value);
static void sudoku_board_set_fixed (SudokuBoard* self,
                             gint value);
static gboolean* _vala_array_dup6 (gboolean* self,
                            int length);
DifficultyCategory sudoku_board_get_difficulty_category (SudokuBoard* self);
void sudoku_board_set_difficulty_category (SudokuBoard* self,
                                           DifficultyCategory value);
void sudoku_board_enable_earmark (SudokuBoard* self,
                                  gint row,
                                  gint column,
                                  gint digit);
void sudoku_board_disable_earmark (SudokuBoard* self,
                                   gint row,
                                   gint column,
                                   gint digit);
void sudoku_board_disable_all_earmarks (SudokuBoard* self,
                                        gint row,
                                        gint column);
gboolean sudoku_board_is_earmark_enabled (SudokuBoard* self,
                                          gint row,
                                          gint column,
                                          gint digit);
gboolean sudoku_board_is_possible (SudokuBoard* self,
                                   gint row,
                                   gint col,
                                   gint val);
gint sudoku_board_count_possibilities (SudokuBoard* self,
                                       gint row,
                                       gint col);
gint* sudoku_board_get_possibilities (SudokuBoard* self,
                                      gint row,
                                      gint col,
                                      int* result_length1);
static gint* _vala_array_dup7 (gint* self,
                        int length);
gboolean* sudoku_board_get_possibilities_as_bool_array (SudokuBoard* self,
                                                        gint row,
                                                        gint col,
                                                        int* result_length1);
void sudoku_board_get_block_for (SudokuBoard* self,
                                 gint row,
                                 gint col,
                                 Coord* result);
void sudoku_board_insert (SudokuBoard* self,
                          gint row,
                          gint col,
                          gint val,
                          gboolean is_fixed);
void sudoku_board_remove (SudokuBoard* self,
                          gint row,
                          gint col,
                          gboolean is_fixed);
static void sudoku_board_mark_breakages_for (SudokuBoard* self,
                                      GeeList* coords,
                                      gint val);
gboolean sudoku_board_get_complete (SudokuBoard* self);
void sudoku_board_set (SudokuBoard* self,
                       gint row,
                       gint col,
                       gint val);
gint sudoku_board_get (SudokuBoard* self,
                       gint row,
                       gint col);
static void sudoku_board_remove_breakages_for (SudokuBoard* self,
                                        GeeList* coords,
                                        gint val);
GeeSet* sudoku_board_get_occurances (SudokuBoard* self,
                                     GeeList* coords,
                                     gint val);
gint sudoku_board_count_solutions_limited (SudokuBoard* self);
gboolean sudoku_board_row_contains (SudokuBoard* self,
                                    gint row,
                                    gint val);
gboolean sudoku_board_col_contains (SudokuBoard* self,
                                    gint col,
                                    gint val);
gboolean sudoku_board_block_contains (SudokuBoard* self,
                                      Coord* block,
                                      gint val);
void sudoku_board_to_initial_state (SudokuBoard* self);
void sudoku_board_print (SudokuBoard* self,
                         gint indent);
void sudoku_board_get_string (SudokuBoard* self);
gchar* sudoku_board_to_string (SudokuBoard* self,
                               gboolean get_original_state);
gint* sudoku_board_get_cells (SudokuBoard* self,
                              int* result_length1,
                              int* result_length2);
static gint* _vala_array_dup8 (gint* self,
                        int length);
GeeHashMap* sudoku_board_calculate_open_squares (SudokuBoard* self);
gboolean sudoku_board_is_finished (SudokuBoard* self);
const gchar* sudoku_saver_get_finishgame_dir (void);
gchar* sudoku_board_get_earmarks_string (SudokuBoard* self,
                                         gint row,
                                         gint col);
gdouble sudoku_board_get_previous_played_time (SudokuBoard* self);
void sudoku_board_set_previous_played_time (SudokuBoard* self,
                                            gdouble value);
gboolean sudoku_board_get_broken (SudokuBoard* self);
gint sudoku_board_get_size (SudokuBoard* self);
static void sudoku_board_finalize (GObject * obj);
static void _vala_sudoku_board_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_sudoku_board_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);
GType house_get_type (void) G_GNUC_CONST;
GType cell_get_type (void) G_GNUC_CONST;
Cell* cell_dup (const Cell* self);
void cell_free (Cell* self);
void cell_init (Cell *self,
                Coord* coord,
                gint val);
gint cell_hash (Cell* cell);
gboolean cell_equal (Cell* a,
                     Cell* b);
gchar* difficulty_category_to_string (DifficultyCategory self);
gchar* difficulty_category_to_untranslated_string (DifficultyCategory self);
DifficultyCategory difficulty_category_from_string (const gchar* input);


gboolean
sudoku_board_is_empty (SudokuBoard* self)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->_filled;
	_tmp2_ = self->priv->_fixed;
	if (_tmp1_ == _tmp2_) {
		gint _tmp3_;
		_tmp3_ = self->priv->n_earmarks;
		_tmp0_ = _tmp3_ == 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


gboolean
sudoku_board_is_fully_filled (SudokuBoard* self)
{
	gboolean result = FALSE;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_filled;
	_tmp1_ = self->priv->_cols;
	_tmp2_ = self->priv->_rows;
	result = _tmp0_ == (_tmp1_ * _tmp2_);
	return result;
}


SudokuBoard*
sudoku_board_construct (GType object_type,
                        gint block_rows,
                        gint block_cols)
{
	SudokuBoard * self = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gint* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gboolean* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gboolean* _tmp11_;
	gboolean* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gboolean* _tmp17_;
	GeeHashSet* _tmp58_;
	GeeArrayList* _tmp59_;
	GeeList* _tmp87_;
	GeeList* _tmp88_;
	GeeList* _tmp89_;
	GeeArrayList* _tmp90_;
	GeeList* _tmp118_;
	GeeList* _tmp119_;
	GeeList* _tmp120_;
	GeeHashMap* _tmp121_;
	GeeMap* _tmp170_;
	GeeMap* _tmp171_;
	GeeMap* _tmp172_;
	self = (SudokuBoard*) g_object_new (object_type, NULL);
	sudoku_board_set_cols (self, block_rows * block_cols);
	sudoku_board_set_rows (self, block_rows * block_cols);
	sudoku_board_set_block_rows (self, block_rows);
	sudoku_board_set_block_cols (self, block_cols);
	_tmp0_ = self->priv->_rows;
	_tmp1_ = self->priv->_cols;
	_tmp2_ = g_new0 (gint, _tmp0_ * _tmp1_);
	self->cells = (g_free (self->cells), NULL);
	self->cells = _tmp2_;
	self->cells_length1 = _tmp0_;
	self->cells_length2 = _tmp1_;
	_tmp3_ = self->priv->_rows;
	_tmp4_ = self->priv->_cols;
	_tmp5_ = g_new0 (gboolean, _tmp3_ * _tmp4_);
	self->is_fixed = (g_free (self->is_fixed), NULL);
	self->is_fixed = _tmp5_;
	self->is_fixed_length1 = _tmp3_;
	self->is_fixed_length2 = _tmp4_;
	_tmp6_ = self->priv->_rows;
	_tmp7_ = self->priv->_cols;
	_tmp8_ = g_new0 (gboolean, _tmp6_ * _tmp7_);
	self->priv->possible_in_row = (g_free (self->priv->possible_in_row), NULL);
	self->priv->possible_in_row = _tmp8_;
	self->priv->possible_in_row_length1 = _tmp6_;
	self->priv->possible_in_row_length2 = _tmp7_;
	_tmp9_ = self->priv->_cols;
	_tmp10_ = self->priv->_rows;
	_tmp11_ = g_new0 (gboolean, _tmp9_ * _tmp10_);
	self->priv->possible_in_col = (g_free (self->priv->possible_in_col), NULL);
	self->priv->possible_in_col = _tmp11_;
	self->priv->possible_in_col_length1 = _tmp9_;
	self->priv->possible_in_col_length2 = _tmp10_;
	_tmp12_ = g_new0 (gboolean, (block_rows * block_cols) * (block_rows * block_cols));
	self->priv->possible_in_block = (g_free (self->priv->possible_in_block), NULL);
	self->priv->possible_in_block = _tmp12_;
	self->priv->possible_in_block_length1 = block_rows;
	self->priv->possible_in_block_length2 = block_cols;
	self->priv->possible_in_block_length3 = block_rows * block_cols;
	_tmp13_ = self->priv->_rows;
	_tmp14_ = self->priv->_cols;
	_tmp15_ = sudoku_board_get_max_val (self);
	_tmp16_ = _tmp15_;
	_tmp17_ = g_new0 (gboolean, (_tmp13_ * _tmp14_) * _tmp16_);
	self->priv->earmarks = (g_free (self->priv->earmarks), NULL);
	self->priv->earmarks = _tmp17_;
	self->priv->earmarks_length1 = _tmp13_;
	self->priv->earmarks_length2 = _tmp14_;
	self->priv->earmarks_length3 = _tmp16_;
	{
		gint l1 = 0;
		l1 = 0;
		{
			gboolean _tmp18_ = FALSE;
			_tmp18_ = TRUE;
			while (TRUE) {
				gint _tmp20_;
				gint _tmp21_;
				if (!_tmp18_) {
					gint _tmp19_;
					_tmp19_ = l1;
					l1 = _tmp19_ + 1;
				}
				_tmp18_ = FALSE;
				_tmp20_ = l1;
				_tmp21_ = self->priv->_rows;
				if (!(_tmp20_ < _tmp21_)) {
					break;
				}
				{
					gint l2 = 0;
					l2 = 0;
					{
						gboolean _tmp22_ = FALSE;
						_tmp22_ = TRUE;
						while (TRUE) {
							gint _tmp24_;
							gint _tmp25_;
							gint* _tmp26_;
							gint _tmp26__length1;
							gint _tmp26__length2;
							gint _tmp27_;
							gint _tmp28_;
							gint _tmp29_;
							gboolean* _tmp30_;
							gint _tmp30__length1;
							gint _tmp30__length2;
							gint _tmp31_;
							gint _tmp32_;
							gboolean _tmp33_;
							gboolean* _tmp34_;
							gint _tmp34__length1;
							gint _tmp34__length2;
							gint _tmp35_;
							gint _tmp36_;
							gboolean _tmp37_;
							gboolean* _tmp38_;
							gint _tmp38__length1;
							gint _tmp38__length2;
							gint _tmp39_;
							gint _tmp40_;
							gboolean _tmp41_;
							if (!_tmp22_) {
								gint _tmp23_;
								_tmp23_ = l2;
								l2 = _tmp23_ + 1;
							}
							_tmp22_ = FALSE;
							_tmp24_ = l2;
							_tmp25_ = self->priv->_cols;
							if (!(_tmp24_ < _tmp25_)) {
								break;
							}
							_tmp26_ = self->cells;
							_tmp26__length1 = self->cells_length1;
							_tmp26__length2 = self->cells_length2;
							_tmp27_ = l1;
							_tmp28_ = l2;
							_tmp26_[(_tmp27_ * _tmp26__length2) + _tmp28_] = 0;
							_tmp29_ = _tmp26_[(_tmp27_ * _tmp26__length2) + _tmp28_];
							_tmp30_ = self->is_fixed;
							_tmp30__length1 = self->is_fixed_length1;
							_tmp30__length2 = self->is_fixed_length2;
							_tmp31_ = l1;
							_tmp32_ = l2;
							_tmp30_[(_tmp31_ * _tmp30__length2) + _tmp32_] = FALSE;
							_tmp33_ = _tmp30_[(_tmp31_ * _tmp30__length2) + _tmp32_];
							_tmp34_ = self->priv->possible_in_row;
							_tmp34__length1 = self->priv->possible_in_row_length1;
							_tmp34__length2 = self->priv->possible_in_row_length2;
							_tmp35_ = l1;
							_tmp36_ = l2;
							_tmp34_[(_tmp35_ * _tmp34__length2) + _tmp36_] = TRUE;
							_tmp37_ = _tmp34_[(_tmp35_ * _tmp34__length2) + _tmp36_];
							_tmp38_ = self->priv->possible_in_col;
							_tmp38__length1 = self->priv->possible_in_col_length1;
							_tmp38__length2 = self->priv->possible_in_col_length2;
							_tmp39_ = l2;
							_tmp40_ = l1;
							_tmp38_[(_tmp39_ * _tmp38__length2) + _tmp40_] = TRUE;
							_tmp41_ = _tmp38_[(_tmp39_ * _tmp38__length2) + _tmp40_];
						}
					}
				}
			}
		}
	}
	{
		gint l1 = 0;
		l1 = 0;
		{
			gboolean _tmp42_ = FALSE;
			_tmp42_ = TRUE;
			while (TRUE) {
				gint _tmp44_;
				if (!_tmp42_) {
					gint _tmp43_;
					_tmp43_ = l1;
					l1 = _tmp43_ + 1;
				}
				_tmp42_ = FALSE;
				_tmp44_ = l1;
				if (!(_tmp44_ < block_rows)) {
					break;
				}
				{
					gint l2 = 0;
					l2 = 0;
					{
						gboolean _tmp45_ = FALSE;
						_tmp45_ = TRUE;
						while (TRUE) {
							gint _tmp47_;
							if (!_tmp45_) {
								gint _tmp46_;
								_tmp46_ = l2;
								l2 = _tmp46_ + 1;
							}
							_tmp45_ = FALSE;
							_tmp47_ = l2;
							if (!(_tmp47_ < block_cols)) {
								break;
							}
							{
								gint l3 = 0;
								l3 = 0;
								{
									gboolean _tmp48_ = FALSE;
									_tmp48_ = TRUE;
									while (TRUE) {
										gint _tmp50_;
										gint _tmp51_;
										gint _tmp52_;
										gboolean* _tmp53_;
										gint _tmp53__length1;
										gint _tmp53__length2;
										gint _tmp53__length3;
										gint _tmp54_;
										gint _tmp55_;
										gint _tmp56_;
										gboolean _tmp57_;
										if (!_tmp48_) {
											gint _tmp49_;
											_tmp49_ = l3;
											l3 = _tmp49_ + 1;
										}
										_tmp48_ = FALSE;
										_tmp50_ = l3;
										_tmp51_ = sudoku_board_get_max_val (self);
										_tmp52_ = _tmp51_;
										if (!(_tmp50_ < _tmp52_)) {
											break;
										}
										_tmp53_ = self->priv->possible_in_block;
										_tmp53__length1 = self->priv->possible_in_block_length1;
										_tmp53__length2 = self->priv->possible_in_block_length2;
										_tmp53__length3 = self->priv->possible_in_block_length3;
										_tmp54_ = l1;
										_tmp55_ = l2;
										_tmp56_ = l3;
										_tmp53_[(((_tmp54_ * _tmp53__length2) + _tmp55_) * _tmp53__length3) + _tmp56_] = TRUE;
										_tmp57_ = _tmp53_[(((_tmp54_ * _tmp53__length2) + _tmp55_) * _tmp53__length3) + _tmp56_];
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp58_ = gee_hash_set_new (TYPE_COORD, (GBoxedCopyFunc) coord_dup, (GDestroyNotify) coord_free, (GeeHashDataFunc) coord_hash, NULL, NULL, (GeeEqualDataFunc) coord_equal, NULL, NULL);
	_g_object_unref0 (self->broken_coords);
	self->broken_coords = (GeeSet*) _tmp58_;
	_tmp59_ = gee_array_list_new (GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->coords_for_col);
	self->coords_for_col = (GeeList*) _tmp59_;
	{
		gint col = 0;
		col = 0;
		{
			gboolean _tmp60_ = FALSE;
			_tmp60_ = TRUE;
			while (TRUE) {
				gint _tmp62_;
				gint _tmp63_;
				GeeList* _tmp64_;
				GeeArrayList* _tmp65_;
				GeeArrayList* _tmp66_;
				GeeList* _tmp78_;
				gint _tmp79_;
				GeeList* _tmp80_;
				gint _tmp81_;
				gpointer _tmp82_;
				GeeList* _tmp83_;
				GeeList* _tmp84_;
				GeeList* _tmp85_;
				GeeList* _tmp86_;
				if (!_tmp60_) {
					gint _tmp61_;
					_tmp61_ = col;
					col = _tmp61_ + 1;
				}
				_tmp60_ = FALSE;
				_tmp62_ = col;
				_tmp63_ = self->priv->_cols;
				if (!(_tmp62_ < _tmp63_)) {
					break;
				}
				_tmp64_ = self->coords_for_col;
				_tmp65_ = gee_array_list_new (TYPE_COORD, (GBoxedCopyFunc) coord_dup, (GDestroyNotify) coord_free, (GeeEqualDataFunc) coord_equal, NULL, NULL);
				_tmp66_ = _tmp65_;
				gee_collection_add ((GeeCollection*) _tmp64_, (GeeList*) _tmp66_);
				_g_object_unref0 (_tmp66_);
				{
					gint row = 0;
					row = 0;
					{
						gboolean _tmp67_ = FALSE;
						_tmp67_ = TRUE;
						while (TRUE) {
							gint _tmp69_;
							gint _tmp70_;
							GeeList* _tmp71_;
							gint _tmp72_;
							gpointer _tmp73_;
							GeeList* _tmp74_;
							gint _tmp75_;
							gint _tmp76_;
							Coord _tmp77_ = {0};
							if (!_tmp67_) {
								gint _tmp68_;
								_tmp68_ = row;
								row = _tmp68_ + 1;
							}
							_tmp67_ = FALSE;
							_tmp69_ = row;
							_tmp70_ = self->priv->_rows;
							if (!(_tmp69_ < _tmp70_)) {
								break;
							}
							_tmp71_ = self->coords_for_col;
							_tmp72_ = col;
							_tmp73_ = gee_list_get (_tmp71_, _tmp72_);
							_tmp74_ = (GeeList*) _tmp73_;
							_tmp75_ = row;
							_tmp76_ = col;
							coord_init (&_tmp77_, _tmp75_, _tmp76_);
							gee_collection_add ((GeeCollection*) _tmp74_, &_tmp77_);
							_g_object_unref0 (_tmp74_);
						}
					}
				}
				_tmp78_ = self->coords_for_col;
				_tmp79_ = col;
				_tmp80_ = self->coords_for_col;
				_tmp81_ = col;
				_tmp82_ = gee_list_get (_tmp80_, _tmp81_);
				_tmp83_ = (GeeList*) _tmp82_;
				_tmp84_ = gee_list_get_read_only_view (_tmp83_);
				_tmp85_ = _tmp84_;
				_tmp86_ = _tmp85_;
				gee_list_set (_tmp78_, _tmp79_, _tmp86_);
				_g_object_unref0 (_tmp86_);
				_g_object_unref0 (_tmp83_);
			}
		}
	}
	_tmp87_ = self->coords_for_col;
	_tmp88_ = gee_list_get_read_only_view (_tmp87_);
	_tmp89_ = _tmp88_;
	_g_object_unref0 (self->coords_for_col);
	self->coords_for_col = _tmp89_;
	_tmp90_ = gee_array_list_new (GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->coords_for_row);
	self->coords_for_row = (GeeList*) _tmp90_;
	{
		gint row = 0;
		row = 0;
		{
			gboolean _tmp91_ = FALSE;
			_tmp91_ = TRUE;
			while (TRUE) {
				gint _tmp93_;
				gint _tmp94_;
				GeeList* _tmp95_;
				GeeArrayList* _tmp96_;
				GeeArrayList* _tmp97_;
				GeeList* _tmp109_;
				gint _tmp110_;
				GeeList* _tmp111_;
				gint _tmp112_;
				gpointer _tmp113_;
				GeeList* _tmp114_;
				GeeList* _tmp115_;
				GeeList* _tmp116_;
				GeeList* _tmp117_;
				if (!_tmp91_) {
					gint _tmp92_;
					_tmp92_ = row;
					row = _tmp92_ + 1;
				}
				_tmp91_ = FALSE;
				_tmp93_ = row;
				_tmp94_ = self->priv->_rows;
				if (!(_tmp93_ < _tmp94_)) {
					break;
				}
				_tmp95_ = self->coords_for_row;
				_tmp96_ = gee_array_list_new (TYPE_COORD, (GBoxedCopyFunc) coord_dup, (GDestroyNotify) coord_free, (GeeEqualDataFunc) coord_equal, NULL, NULL);
				_tmp97_ = _tmp96_;
				gee_collection_add ((GeeCollection*) _tmp95_, (GeeList*) _tmp97_);
				_g_object_unref0 (_tmp97_);
				{
					gint col = 0;
					col = 0;
					{
						gboolean _tmp98_ = FALSE;
						_tmp98_ = TRUE;
						while (TRUE) {
							gint _tmp100_;
							gint _tmp101_;
							GeeList* _tmp102_;
							gint _tmp103_;
							gpointer _tmp104_;
							GeeList* _tmp105_;
							gint _tmp106_;
							gint _tmp107_;
							Coord _tmp108_ = {0};
							if (!_tmp98_) {
								gint _tmp99_;
								_tmp99_ = col;
								col = _tmp99_ + 1;
							}
							_tmp98_ = FALSE;
							_tmp100_ = col;
							_tmp101_ = self->priv->_cols;
							if (!(_tmp100_ < _tmp101_)) {
								break;
							}
							_tmp102_ = self->coords_for_row;
							_tmp103_ = row;
							_tmp104_ = gee_list_get (_tmp102_, _tmp103_);
							_tmp105_ = (GeeList*) _tmp104_;
							_tmp106_ = row;
							_tmp107_ = col;
							coord_init (&_tmp108_, _tmp106_, _tmp107_);
							gee_collection_add ((GeeCollection*) _tmp105_, &_tmp108_);
							_g_object_unref0 (_tmp105_);
						}
					}
				}
				_tmp109_ = self->coords_for_row;
				_tmp110_ = row;
				_tmp111_ = self->coords_for_row;
				_tmp112_ = row;
				_tmp113_ = gee_list_get (_tmp111_, _tmp112_);
				_tmp114_ = (GeeList*) _tmp113_;
				_tmp115_ = gee_list_get_read_only_view (_tmp114_);
				_tmp116_ = _tmp115_;
				_tmp117_ = _tmp116_;
				gee_list_set (_tmp109_, _tmp110_, _tmp117_);
				_g_object_unref0 (_tmp117_);
				_g_object_unref0 (_tmp114_);
			}
		}
	}
	_tmp118_ = self->coords_for_row;
	_tmp119_ = gee_list_get_read_only_view (_tmp118_);
	_tmp120_ = _tmp119_;
	_g_object_unref0 (self->coords_for_row);
	self->coords_for_row = _tmp120_;
	_tmp121_ = gee_hash_map_new (TYPE_COORD, (GBoxedCopyFunc) coord_dup, (GDestroyNotify) coord_free, GEE_TYPE_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, (GeeHashDataFunc) coord_hash, NULL, NULL, (GeeEqualDataFunc) coord_equal, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->coords_for_block);
	self->coords_for_block = (GeeMap*) _tmp121_;
	{
		gint col = 0;
		col = 0;
		{
			gboolean _tmp122_ = FALSE;
			_tmp122_ = TRUE;
			while (TRUE) {
				gint _tmp124_;
				if (!_tmp122_) {
					gint _tmp123_;
					_tmp123_ = col;
					col = _tmp123_ + 1;
				}
				_tmp122_ = FALSE;
				_tmp124_ = col;
				if (!(_tmp124_ < block_cols)) {
					break;
				}
				{
					gint row = 0;
					row = 0;
					{
						gboolean _tmp125_ = FALSE;
						_tmp125_ = TRUE;
						while (TRUE) {
							gint _tmp127_;
							GeeMap* _tmp128_;
							gint _tmp129_;
							gint _tmp130_;
							Coord _tmp131_ = {0};
							GeeArrayList* _tmp132_;
							GeeArrayList* _tmp133_;
							if (!_tmp125_) {
								gint _tmp126_;
								_tmp126_ = row;
								row = _tmp126_ + 1;
							}
							_tmp125_ = FALSE;
							_tmp127_ = row;
							if (!(_tmp127_ < block_rows)) {
								break;
							}
							_tmp128_ = self->coords_for_block;
							_tmp129_ = row;
							_tmp130_ = col;
							coord_init (&_tmp131_, _tmp129_, _tmp130_);
							_tmp132_ = gee_array_list_new (TYPE_COORD, (GBoxedCopyFunc) coord_dup, (GDestroyNotify) coord_free, (GeeEqualDataFunc) coord_equal, NULL, NULL);
							_tmp133_ = _tmp132_;
							gee_map_set (_tmp128_, &_tmp131_, (GeeList*) _tmp133_);
							_g_object_unref0 (_tmp133_);
						}
					}
				}
			}
		}
	}
	{
		gint col = 0;
		col = 0;
		{
			gboolean _tmp134_ = FALSE;
			_tmp134_ = TRUE;
			while (TRUE) {
				gint _tmp136_;
				gint _tmp137_;
				if (!_tmp134_) {
					gint _tmp135_;
					_tmp135_ = col;
					col = _tmp135_ + 1;
				}
				_tmp134_ = FALSE;
				_tmp136_ = col;
				_tmp137_ = self->priv->_cols;
				if (!(_tmp136_ < _tmp137_)) {
					break;
				}
				{
					gint row = 0;
					row = 0;
					{
						gboolean _tmp138_ = FALSE;
						_tmp138_ = TRUE;
						while (TRUE) {
							gint _tmp140_;
							gint _tmp141_;
							GeeMap* _tmp142_;
							gint _tmp143_;
							gint _tmp144_;
							Coord _tmp145_ = {0};
							gpointer _tmp146_;
							GeeList* _tmp147_;
							gint _tmp148_;
							gint _tmp149_;
							Coord _tmp150_ = {0};
							if (!_tmp138_) {
								gint _tmp139_;
								_tmp139_ = row;
								row = _tmp139_ + 1;
							}
							_tmp138_ = FALSE;
							_tmp140_ = row;
							_tmp141_ = self->priv->_rows;
							if (!(_tmp140_ < _tmp141_)) {
								break;
							}
							_tmp142_ = self->coords_for_block;
							_tmp143_ = row;
							_tmp144_ = col;
							coord_init (&_tmp145_, _tmp143_ / block_rows, _tmp144_ / block_cols);
							_tmp146_ = gee_map_get (_tmp142_, &_tmp145_);
							_tmp147_ = (GeeList*) _tmp146_;
							_tmp148_ = row;
							_tmp149_ = col;
							coord_init (&_tmp150_, _tmp148_, _tmp149_);
							gee_collection_add ((GeeCollection*) _tmp147_, &_tmp150_);
							_g_object_unref0 (_tmp147_);
						}
					}
				}
			}
		}
	}
	{
		gint col = 0;
		col = 0;
		{
			gboolean _tmp151_ = FALSE;
			_tmp151_ = TRUE;
			while (TRUE) {
				gint _tmp153_;
				if (!_tmp151_) {
					gint _tmp152_;
					_tmp152_ = col;
					col = _tmp152_ + 1;
				}
				_tmp151_ = FALSE;
				_tmp153_ = col;
				if (!(_tmp153_ < block_cols)) {
					break;
				}
				{
					gint row = 0;
					row = 0;
					{
						gboolean _tmp154_ = FALSE;
						_tmp154_ = TRUE;
						while (TRUE) {
							gint _tmp156_;
							GeeMap* _tmp157_;
							gint _tmp158_;
							gint _tmp159_;
							Coord _tmp160_ = {0};
							GeeMap* _tmp161_;
							gint _tmp162_;
							gint _tmp163_;
							Coord _tmp164_ = {0};
							gpointer _tmp165_;
							GeeList* _tmp166_;
							GeeList* _tmp167_;
							GeeList* _tmp168_;
							GeeList* _tmp169_;
							if (!_tmp154_) {
								gint _tmp155_;
								_tmp155_ = row;
								row = _tmp155_ + 1;
							}
							_tmp154_ = FALSE;
							_tmp156_ = row;
							if (!(_tmp156_ < block_rows)) {
								break;
							}
							_tmp157_ = self->coords_for_block;
							_tmp158_ = row;
							_tmp159_ = col;
							coord_init (&_tmp160_, _tmp158_, _tmp159_);
							_tmp161_ = self->coords_for_block;
							_tmp162_ = row;
							_tmp163_ = col;
							coord_init (&_tmp164_, _tmp162_, _tmp163_);
							_tmp165_ = gee_map_get (_tmp161_, &_tmp164_);
							_tmp166_ = (GeeList*) _tmp165_;
							_tmp167_ = gee_list_get_read_only_view (_tmp166_);
							_tmp168_ = _tmp167_;
							_tmp169_ = _tmp168_;
							gee_map_set (_tmp157_, &_tmp160_, _tmp169_);
							_g_object_unref0 (_tmp169_);
							_g_object_unref0 (_tmp166_);
						}
					}
				}
			}
		}
	}
	_tmp170_ = self->coords_for_block;
	_tmp171_ = gee_map_get_read_only_view (_tmp170_);
	_tmp172_ = _tmp171_;
	_g_object_unref0 (self->coords_for_block);
	self->coords_for_block = _tmp172_;
	return self;
}


SudokuBoard*
sudoku_board_new (gint block_rows,
                  gint block_cols)
{
	return sudoku_board_construct (TYPE_SUDOKU_BOARD, block_rows, block_cols);
}


static gint*
_vala_array_dup1 (gint* self,
                  int length)
{
	return g_memdup (self, length * sizeof (gint));
}


static gboolean*
_vala_array_dup2 (gboolean* self,
                  int length)
{
	return g_memdup (self, length * sizeof (gboolean));
}


static gboolean*
_vala_array_dup3 (gboolean* self,
                  int length)
{
	return g_memdup (self, length * sizeof (gboolean));
}


static gboolean*
_vala_array_dup4 (gboolean* self,
                  int length)
{
	return g_memdup (self, length * sizeof (gboolean));
}


static gboolean*
_vala_array_dup5 (gboolean* self,
                  int length)
{
	return g_memdup (self, length * sizeof (gboolean));
}


static gboolean*
_vala_array_dup6 (gboolean* self,
                  int length)
{
	return g_memdup (self, length * sizeof (gboolean));
}


SudokuBoard*
sudoku_board_clone (SudokuBoard* self)
{
	SudokuBoard* result = NULL;
	SudokuBoard* board = NULL;
	gint _tmp0_;
	gint _tmp1_;
	SudokuBoard* _tmp2_;
	gint* _tmp3_;
	gint _tmp3__length1;
	gint _tmp3__length2;
	gint* _tmp4_;
	gint _tmp4__length1;
	gint _tmp4__length2;
	gboolean* _tmp5_;
	gint _tmp5__length1;
	gint _tmp5__length2;
	gboolean* _tmp6_;
	gint _tmp6__length1;
	gint _tmp6__length2;
	gboolean* _tmp7_;
	gint _tmp7__length1;
	gint _tmp7__length2;
	gboolean* _tmp8_;
	gint _tmp8__length1;
	gint _tmp8__length2;
	gboolean* _tmp9_;
	gint _tmp9__length1;
	gint _tmp9__length2;
	gboolean* _tmp10_;
	gint _tmp10__length1;
	gint _tmp10__length2;
	gboolean* _tmp11_;
	gint _tmp11__length1;
	gint _tmp11__length2;
	gint _tmp11__length3;
	gboolean* _tmp12_;
	gint _tmp12__length1;
	gint _tmp12__length2;
	gint _tmp12__length3;
	gint _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	GeeSet* _tmp16_;
	GeeSet* _tmp17_;
	gboolean* _tmp18_;
	gint _tmp18__length1;
	gint _tmp18__length2;
	gint _tmp18__length3;
	gboolean* _tmp19_;
	gint _tmp19__length1;
	gint _tmp19__length2;
	gint _tmp19__length3;
	DifficultyCategory _tmp20_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_block_rows;
	_tmp1_ = self->priv->_block_cols;
	_tmp2_ = sudoku_board_new (_tmp0_, _tmp1_);
	board = _tmp2_;
	_tmp3_ = self->cells;
	_tmp3__length1 = self->cells_length1;
	_tmp3__length2 = self->cells_length2;
	_tmp4_ = (_tmp3_ != NULL) ? _vala_array_dup1 (_tmp3_, _tmp3__length1 * _tmp3__length2) : ((gpointer) _tmp3_);
	_tmp4__length1 = _tmp3__length1;
	_tmp4__length2 = _tmp3__length2;
	board->cells = (g_free (board->cells), NULL);
	board->cells = _tmp4_;
	board->cells_length1 = _tmp4__length1;
	board->cells_length2 = _tmp4__length2;
	_tmp5_ = self->is_fixed;
	_tmp5__length1 = self->is_fixed_length1;
	_tmp5__length2 = self->is_fixed_length2;
	_tmp6_ = (_tmp5_ != NULL) ? _vala_array_dup2 (_tmp5_, _tmp5__length1 * _tmp5__length2) : ((gpointer) _tmp5_);
	_tmp6__length1 = _tmp5__length1;
	_tmp6__length2 = _tmp5__length2;
	board->is_fixed = (g_free (board->is_fixed), NULL);
	board->is_fixed = _tmp6_;
	board->is_fixed_length1 = _tmp6__length1;
	board->is_fixed_length2 = _tmp6__length2;
	_tmp7_ = self->priv->possible_in_row;
	_tmp7__length1 = self->priv->possible_in_row_length1;
	_tmp7__length2 = self->priv->possible_in_row_length2;
	_tmp8_ = (_tmp7_ != NULL) ? _vala_array_dup3 (_tmp7_, _tmp7__length1 * _tmp7__length2) : ((gpointer) _tmp7_);
	_tmp8__length1 = _tmp7__length1;
	_tmp8__length2 = _tmp7__length2;
	board->priv->possible_in_row = (g_free (board->priv->possible_in_row), NULL);
	board->priv->possible_in_row = _tmp8_;
	board->priv->possible_in_row_length1 = _tmp8__length1;
	board->priv->possible_in_row_length2 = _tmp8__length2;
	_tmp9_ = self->priv->possible_in_col;
	_tmp9__length1 = self->priv->possible_in_col_length1;
	_tmp9__length2 = self->priv->possible_in_col_length2;
	_tmp10_ = (_tmp9_ != NULL) ? _vala_array_dup4 (_tmp9_, _tmp9__length1 * _tmp9__length2) : ((gpointer) _tmp9_);
	_tmp10__length1 = _tmp9__length1;
	_tmp10__length2 = _tmp9__length2;
	board->priv->possible_in_col = (g_free (board->priv->possible_in_col), NULL);
	board->priv->possible_in_col = _tmp10_;
	board->priv->possible_in_col_length1 = _tmp10__length1;
	board->priv->possible_in_col_length2 = _tmp10__length2;
	_tmp11_ = self->priv->possible_in_block;
	_tmp11__length1 = self->priv->possible_in_block_length1;
	_tmp11__length2 = self->priv->possible_in_block_length2;
	_tmp11__length3 = self->priv->possible_in_block_length3;
	_tmp12_ = (_tmp11_ != NULL) ? _vala_array_dup5 (_tmp11_, (_tmp11__length1 * _tmp11__length2) * _tmp11__length3) : ((gpointer) _tmp11_);
	_tmp12__length1 = _tmp11__length1;
	_tmp12__length2 = _tmp11__length2;
	_tmp12__length3 = _tmp11__length3;
	board->priv->possible_in_block = (g_free (board->priv->possible_in_block), NULL);
	board->priv->possible_in_block = _tmp12_;
	board->priv->possible_in_block_length1 = _tmp12__length1;
	board->priv->possible_in_block_length2 = _tmp12__length2;
	board->priv->possible_in_block_length3 = _tmp12__length3;
	_tmp13_ = self->priv->_filled;
	sudoku_board_set_filled (board, _tmp13_);
	_tmp14_ = self->priv->_fixed;
	sudoku_board_set_fixed (board, _tmp14_);
	_tmp15_ = self->priv->n_earmarks;
	board->priv->n_earmarks = _tmp15_;
	_tmp16_ = board->broken_coords;
	_tmp17_ = self->broken_coords;
	gee_collection_add_all ((GeeCollection*) _tmp16_, (GeeCollection*) _tmp17_);
	_tmp18_ = self->priv->earmarks;
	_tmp18__length1 = self->priv->earmarks_length1;
	_tmp18__length2 = self->priv->earmarks_length2;
	_tmp18__length3 = self->priv->earmarks_length3;
	_tmp19_ = (_tmp18_ != NULL) ? _vala_array_dup6 (_tmp18_, (_tmp18__length1 * _tmp18__length2) * _tmp18__length3) : ((gpointer) _tmp18_);
	_tmp19__length1 = _tmp18__length1;
	_tmp19__length2 = _tmp18__length2;
	_tmp19__length3 = _tmp18__length3;
	board->priv->earmarks = (g_free (board->priv->earmarks), NULL);
	board->priv->earmarks = _tmp19_;
	board->priv->earmarks_length1 = _tmp19__length1;
	board->priv->earmarks_length2 = _tmp19__length2;
	board->priv->earmarks_length3 = _tmp19__length3;
	_tmp20_ = self->priv->_difficulty_category;
	sudoku_board_set_difficulty_category (board, _tmp20_);
	result = board;
	return result;
}


void
sudoku_board_enable_earmark (SudokuBoard* self,
                             gint row,
                             gint column,
                             gint digit)
{
	gboolean* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	gint _tmp0__length3;
	gboolean _tmp1_;
	gint _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->earmarks;
	_tmp0__length1 = self->priv->earmarks_length1;
	_tmp0__length2 = self->priv->earmarks_length2;
	_tmp0__length3 = self->priv->earmarks_length3;
	_tmp1_ = _tmp0_[(((row * _tmp0__length2) + column) * _tmp0__length3) + (digit - 1)];
	if (!_tmp1_) {
		gboolean* _tmp2_;
		gint _tmp2__length1;
		gint _tmp2__length2;
		gint _tmp2__length3;
		gboolean _tmp3_;
		gint _tmp4_;
		_tmp2_ = self->priv->earmarks;
		_tmp2__length1 = self->priv->earmarks_length1;
		_tmp2__length2 = self->priv->earmarks_length2;
		_tmp2__length3 = self->priv->earmarks_length3;
		_tmp2_[(((row * _tmp2__length2) + column) * _tmp2__length3) + (digit - 1)] = TRUE;
		_tmp3_ = _tmp2_[(((row * _tmp2__length2) + column) * _tmp2__length3) + (digit - 1)];
		_tmp4_ = self->priv->n_earmarks;
		self->priv->n_earmarks = _tmp4_ + 1;
	}
	_tmp5_ = self->priv->n_earmarks;
	_vala_warn_if_fail (_tmp5_ > 0, "n_earmarks > 0");
}


void
sudoku_board_disable_earmark (SudokuBoard* self,
                              gint row,
                              gint column,
                              gint digit)
{
	gboolean* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	gint _tmp0__length3;
	gboolean _tmp1_;
	gint _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->earmarks;
	_tmp0__length1 = self->priv->earmarks_length1;
	_tmp0__length2 = self->priv->earmarks_length2;
	_tmp0__length3 = self->priv->earmarks_length3;
	_tmp1_ = _tmp0_[(((row * _tmp0__length2) + column) * _tmp0__length3) + (digit - 1)];
	if (_tmp1_) {
		gboolean* _tmp2_;
		gint _tmp2__length1;
		gint _tmp2__length2;
		gint _tmp2__length3;
		gboolean _tmp3_;
		gint _tmp4_;
		_tmp2_ = self->priv->earmarks;
		_tmp2__length1 = self->priv->earmarks_length1;
		_tmp2__length2 = self->priv->earmarks_length2;
		_tmp2__length3 = self->priv->earmarks_length3;
		_tmp2_[(((row * _tmp2__length2) + column) * _tmp2__length3) + (digit - 1)] = FALSE;
		_tmp3_ = _tmp2_[(((row * _tmp2__length2) + column) * _tmp2__length3) + (digit - 1)];
		_tmp4_ = self->priv->n_earmarks;
		self->priv->n_earmarks = _tmp4_ - 1;
	}
	_tmp5_ = self->priv->n_earmarks;
	_vala_warn_if_fail (_tmp5_ >= 0, "n_earmarks >= 0");
}


void
sudoku_board_disable_all_earmarks (SudokuBoard* self,
                                   gint row,
                                   gint column)
{
	gint _tmp9_;
	g_return_if_fail (self != NULL);
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				gboolean* _tmp5_;
				gint _tmp5__length1;
				gint _tmp5__length2;
				gint _tmp5__length3;
				gint _tmp6_;
				gboolean _tmp7_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = sudoku_board_get_max_val (self);
				_tmp4_ = _tmp3_;
				if (!(_tmp2_ <= _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->earmarks;
				_tmp5__length1 = self->priv->earmarks_length1;
				_tmp5__length2 = self->priv->earmarks_length2;
				_tmp5__length3 = self->priv->earmarks_length3;
				_tmp6_ = i;
				_tmp7_ = _tmp5_[(((row * _tmp5__length2) + column) * _tmp5__length3) + (_tmp6_ - 1)];
				if (_tmp7_) {
					gint _tmp8_;
					_tmp8_ = i;
					sudoku_board_disable_earmark (self, row, column, _tmp8_);
				}
			}
		}
	}
	_tmp9_ = self->priv->n_earmarks;
	_vala_warn_if_fail (_tmp9_ >= 0, "n_earmarks >= 0");
}


gboolean
sudoku_board_is_earmark_enabled (SudokuBoard* self,
                                 gint row,
                                 gint column,
                                 gint digit)
{
	gboolean result = FALSE;
	gboolean* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	gint _tmp0__length3;
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->earmarks;
	_tmp0__length1 = self->priv->earmarks_length1;
	_tmp0__length2 = self->priv->earmarks_length2;
	_tmp0__length3 = self->priv->earmarks_length3;
	_tmp1_ = _tmp0_[(((row * _tmp0__length2) + column) * _tmp0__length3) + (digit - 1)];
	result = _tmp1_;
	return result;
}


gboolean
sudoku_board_is_possible (SudokuBoard* self,
                          gint row,
                          gint col,
                          gint val)
{
	gboolean result = FALSE;
	gint _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean* _tmp3_;
	gint _tmp3__length1;
	gint _tmp3__length2;
	gboolean _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = val;
	val = _tmp0_ - 1;
	_tmp3_ = self->priv->possible_in_row;
	_tmp3__length1 = self->priv->possible_in_row_length1;
	_tmp3__length2 = self->priv->possible_in_row_length2;
	_tmp4_ = _tmp3_[(row * _tmp3__length2) + val];
	if (_tmp4_) {
		gboolean* _tmp5_;
		gint _tmp5__length1;
		gint _tmp5__length2;
		gboolean _tmp6_;
		_tmp5_ = self->priv->possible_in_col;
		_tmp5__length1 = self->priv->possible_in_col_length1;
		_tmp5__length2 = self->priv->possible_in_col_length2;
		_tmp6_ = _tmp5_[(col * _tmp5__length2) + val];
		_tmp2_ = _tmp6_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gboolean* _tmp7_;
		gint _tmp7__length1;
		gint _tmp7__length2;
		gint _tmp7__length3;
		gint _tmp8_;
		gint _tmp9_;
		gboolean _tmp10_;
		_tmp7_ = self->priv->possible_in_block;
		_tmp7__length1 = self->priv->possible_in_block_length1;
		_tmp7__length2 = self->priv->possible_in_block_length2;
		_tmp7__length3 = self->priv->possible_in_block_length3;
		_tmp8_ = self->priv->_block_cols;
		_tmp9_ = self->priv->_block_rows;
		_tmp10_ = _tmp7_[((((row / _tmp8_) * _tmp7__length2) + (col / _tmp9_)) * _tmp7__length3) + val];
		_tmp1_ = _tmp10_;
	} else {
		_tmp1_ = FALSE;
	}
	result = _tmp1_;
	return result;
}


gint
sudoku_board_count_possibilities (SudokuBoard* self,
                                  gint row,
                                  gint col)
{
	gint result = 0;
	gint _tmp0_;
	gint* _tmp1_;
	gint* _tmp2_;
	gint _tmp2__length1;
	gint _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp1_ = sudoku_board_get_possibilities (self, row, col, &_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp0_;
	_tmp3_ = _tmp0_;
	_tmp2_ = (g_free (_tmp2_), NULL);
	result = _tmp3_;
	return result;
}


static gint*
_vala_array_dup7 (gint* self,
                  int length)
{
	return g_memdup (self, length * sizeof (gint));
}


gint*
sudoku_board_get_possibilities (SudokuBoard* self,
                                gint row,
                                gint col,
                                int* result_length1)
{
	gint* result = NULL;
	gint* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	gint _tmp1_;
	gint* possibilities = NULL;
	gint* _tmp4_;
	gint possibilities_length1;
	gint _possibilities_size_;
	gint count = 0;
	gint* _tmp16_;
	gint _tmp16__length1;
	gint _tmp17_;
	gint* _tmp18_;
	gint _tmp18__length1;
	gint* _tmp19_;
	gint _tmp19__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->cells;
	_tmp0__length1 = self->cells_length1;
	_tmp0__length2 = self->cells_length2;
	_tmp1_ = _tmp0_[(row * _tmp0__length2) + col];
	if (_tmp1_ != 0) {
		gint* _tmp2_;
		gint* _tmp3_;
		gint _tmp3__length1;
		_tmp2_ = g_new0 (gint, 0);
		_tmp3_ = _tmp2_;
		_tmp3__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp3__length1;
		}
		result = _tmp3_;
		return result;
	}
	_tmp4_ = g_new0 (gint, 9);
	possibilities = _tmp4_;
	possibilities_length1 = 9;
	_possibilities_size_ = possibilities_length1;
	count = 0;
	{
		gint l = 0;
		l = 1;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				gint _tmp7_;
				gint _tmp8_;
				gint _tmp9_;
				gint _tmp10_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = l;
					l = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = l;
				_tmp8_ = sudoku_board_get_max_val (self);
				_tmp9_ = _tmp8_;
				if (!(_tmp7_ <= _tmp9_)) {
					break;
				}
				_tmp10_ = l;
				if (sudoku_board_is_possible (self, row, col, _tmp10_)) {
					gint* _tmp11_;
					gint _tmp11__length1;
					gint _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					gint _tmp15_;
					_tmp11_ = possibilities;
					_tmp11__length1 = possibilities_length1;
					_tmp12_ = count;
					_tmp13_ = l;
					_tmp11_[_tmp12_] = _tmp13_;
					_tmp14_ = _tmp11_[_tmp12_];
					_tmp15_ = count;
					count = _tmp15_ + 1;
				}
			}
		}
	}
	_tmp16_ = possibilities;
	_tmp16__length1 = possibilities_length1;
	_tmp17_ = count;
	_tmp18_ = ((_tmp16_ + 0) != NULL) ? _vala_array_dup7 (_tmp16_ + 0, _tmp17_ - 0) : ((gpointer) (_tmp16_ + 0));
	_tmp18__length1 = _tmp17_ - 0;
	_tmp19_ = _tmp18_;
	_tmp19__length1 = _tmp18__length1;
	if (result_length1) {
		*result_length1 = _tmp19__length1;
	}
	result = _tmp19_;
	possibilities = (g_free (possibilities), NULL);
	return result;
}


gboolean*
sudoku_board_get_possibilities_as_bool_array (SudokuBoard* self,
                                              gint row,
                                              gint col,
                                              int* result_length1)
{
	gboolean* result = NULL;
	gboolean* possibilities = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gboolean* _tmp2_;
	gint possibilities_length1;
	gint _possibilities_size_;
	gboolean* _tmp12_;
	gint _tmp12__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = sudoku_board_get_max_val (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_new0 (gboolean, _tmp1_);
	possibilities = _tmp2_;
	possibilities_length1 = _tmp1_;
	_possibilities_size_ = possibilities_length1;
	{
		gint l = 0;
		l = 1;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
				gboolean* _tmp8_;
				gint _tmp8__length1;
				gint _tmp9_;
				gint _tmp10_;
				gboolean _tmp11_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = l;
					l = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = l;
				_tmp6_ = sudoku_board_get_max_val (self);
				_tmp7_ = _tmp6_;
				if (!(_tmp5_ <= _tmp7_)) {
					break;
				}
				_tmp8_ = possibilities;
				_tmp8__length1 = possibilities_length1;
				_tmp9_ = l;
				_tmp10_ = l;
				_tmp8_[_tmp9_ - 1] = sudoku_board_is_possible (self, row, col, _tmp10_);
				_tmp11_ = _tmp8_[_tmp9_ - 1];
			}
		}
	}
	_tmp12_ = possibilities;
	_tmp12__length1 = possibilities_length1;
	if (result_length1) {
		*result_length1 = _tmp12__length1;
	}
	result = _tmp12_;
	return result;
}


void
sudoku_board_get_block_for (SudokuBoard* self,
                            gint row,
                            gint col,
                            Coord* result)
{
	gint _tmp0_;
	gint _tmp1_;
	Coord _tmp2_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_block_rows;
	_tmp1_ = self->priv->_block_cols;
	coord_init (&_tmp2_, row / _tmp0_, col / _tmp1_);
	*result = _tmp2_;
	return;
}


void
sudoku_board_insert (SudokuBoard* self,
                     gint row,
                     gint col,
                     gint val,
                     gboolean is_fixed)
{
	gint _tmp0_;
	gint _tmp1_;
	gint* _tmp4_;
	gint _tmp4__length1;
	gint _tmp4__length2;
	gint _tmp5_;
	gint* _tmp6_;
	gint _tmp6__length1;
	gint _tmp6__length2;
	gint _tmp7_;
	gboolean* _tmp8_;
	gint _tmp8__length1;
	gint _tmp8__length2;
	gboolean _tmp9_;
	gint _tmp10_;
	gboolean* _tmp12_;
	gint _tmp12__length1;
	gint _tmp12__length2;
	gboolean _tmp13_;
	gboolean* _tmp17_;
	gint _tmp17__length1;
	gint _tmp17__length2;
	gboolean _tmp18_;
	gboolean* _tmp22_;
	gint _tmp22__length1;
	gint _tmp22__length2;
	gint _tmp22__length3;
	gint _tmp23_;
	gint _tmp24_;
	gboolean _tmp25_;
	gint _tmp32_;
	gboolean* _tmp33_;
	gint _tmp33__length1;
	gint _tmp33__length2;
	gboolean _tmp34_;
	gboolean* _tmp35_;
	gint _tmp35__length1;
	gint _tmp35__length2;
	gboolean _tmp36_;
	gboolean* _tmp37_;
	gint _tmp37__length1;
	gint _tmp37__length2;
	gint _tmp37__length3;
	gint _tmp38_;
	gint _tmp39_;
	gboolean _tmp40_;
	gboolean _tmp41_;
	gboolean _tmp42_;
	g_return_if_fail (self != NULL);
	_vala_assert (val > 0, "val > 0");
	_tmp0_ = sudoku_board_get_max_val (self);
	_tmp1_ = _tmp0_;
	_vala_assert (val <= _tmp1_, "val <= max_val");
	if (!is_fixed) {
		gboolean* _tmp2_;
		gint _tmp2__length1;
		gint _tmp2__length2;
		gboolean _tmp3_;
		_tmp2_ = self->is_fixed;
		_tmp2__length1 = self->is_fixed_length1;
		_tmp2__length2 = self->is_fixed_length2;
		_tmp3_ = _tmp2_[(row * _tmp2__length2) + col];
		_vala_assert (!_tmp3_, "!this.is_fixed[row, col]");
	}
	_tmp4_ = self->cells;
	_tmp4__length1 = self->cells_length1;
	_tmp4__length2 = self->cells_length2;
	_tmp5_ = _tmp4_[(row * _tmp4__length2) + col];
	if (_tmp5_ != 0) {
		sudoku_board_remove (self, row, col, is_fixed);
	}
	_tmp6_ = self->cells;
	_tmp6__length1 = self->cells_length1;
	_tmp6__length2 = self->cells_length2;
	_tmp6_[(row * _tmp6__length2) + col] = val;
	_tmp7_ = _tmp6_[(row * _tmp6__length2) + col];
	_tmp8_ = self->is_fixed;
	_tmp8__length1 = self->is_fixed_length1;
	_tmp8__length2 = self->is_fixed_length2;
	_tmp8_[(row * _tmp8__length2) + col] = is_fixed;
	_tmp9_ = _tmp8_[(row * _tmp8__length2) + col];
	_tmp10_ = self->priv->_filled;
	sudoku_board_set_filled (self, _tmp10_ + 1);
	if (is_fixed) {
		gint _tmp11_;
		_tmp11_ = self->priv->_fixed;
		sudoku_board_set_fixed (self, _tmp11_ + 1);
	}
	_tmp12_ = self->priv->possible_in_row;
	_tmp12__length1 = self->priv->possible_in_row_length1;
	_tmp12__length2 = self->priv->possible_in_row_length2;
	_tmp13_ = _tmp12_[(row * _tmp12__length2) + (val - 1)];
	if (!_tmp13_) {
		GeeList* _tmp14_;
		gpointer _tmp15_;
		GeeList* _tmp16_;
		_tmp14_ = self->coords_for_row;
		_tmp15_ = gee_list_get (_tmp14_, row);
		_tmp16_ = (GeeList*) _tmp15_;
		sudoku_board_mark_breakages_for (self, _tmp16_, val);
		_g_object_unref0 (_tmp16_);
	}
	_tmp17_ = self->priv->possible_in_col;
	_tmp17__length1 = self->priv->possible_in_col_length1;
	_tmp17__length2 = self->priv->possible_in_col_length2;
	_tmp18_ = _tmp17_[(col * _tmp17__length2) + (val - 1)];
	if (!_tmp18_) {
		GeeList* _tmp19_;
		gpointer _tmp20_;
		GeeList* _tmp21_;
		_tmp19_ = self->coords_for_col;
		_tmp20_ = gee_list_get (_tmp19_, col);
		_tmp21_ = (GeeList*) _tmp20_;
		sudoku_board_mark_breakages_for (self, _tmp21_, val);
		_g_object_unref0 (_tmp21_);
	}
	_tmp22_ = self->priv->possible_in_block;
	_tmp22__length1 = self->priv->possible_in_block_length1;
	_tmp22__length2 = self->priv->possible_in_block_length2;
	_tmp22__length3 = self->priv->possible_in_block_length3;
	_tmp23_ = self->priv->_block_cols;
	_tmp24_ = self->priv->_block_rows;
	_tmp25_ = _tmp22_[((((row / _tmp23_) * _tmp22__length2) + (col / _tmp24_)) * _tmp22__length3) + (val - 1)];
	if (!_tmp25_) {
		GeeMap* _tmp26_;
		gint _tmp27_;
		gint _tmp28_;
		Coord _tmp29_ = {0};
		gpointer _tmp30_;
		GeeList* _tmp31_;
		_tmp26_ = self->coords_for_block;
		_tmp27_ = self->priv->_block_cols;
		_tmp28_ = self->priv->_block_rows;
		coord_init (&_tmp29_, row / _tmp27_, col / _tmp28_);
		_tmp30_ = gee_map_get (_tmp26_, &_tmp29_);
		_tmp31_ = (GeeList*) _tmp30_;
		sudoku_board_mark_breakages_for (self, _tmp31_, val);
		_g_object_unref0 (_tmp31_);
	}
	_tmp32_ = val;
	val = _tmp32_ - 1;
	_tmp33_ = self->priv->possible_in_row;
	_tmp33__length1 = self->priv->possible_in_row_length1;
	_tmp33__length2 = self->priv->possible_in_row_length2;
	_tmp33_[(row * _tmp33__length2) + val] = FALSE;
	_tmp34_ = _tmp33_[(row * _tmp33__length2) + val];
	_tmp35_ = self->priv->possible_in_col;
	_tmp35__length1 = self->priv->possible_in_col_length1;
	_tmp35__length2 = self->priv->possible_in_col_length2;
	_tmp35_[(col * _tmp35__length2) + val] = FALSE;
	_tmp36_ = _tmp35_[(col * _tmp35__length2) + val];
	_tmp37_ = self->priv->possible_in_block;
	_tmp37__length1 = self->priv->possible_in_block_length1;
	_tmp37__length2 = self->priv->possible_in_block_length2;
	_tmp37__length3 = self->priv->possible_in_block_length3;
	_tmp38_ = self->priv->_block_cols;
	_tmp39_ = self->priv->_block_rows;
	_tmp37_[((((row / _tmp38_) * _tmp37__length2) + (col / _tmp39_)) * _tmp37__length3) + val] = FALSE;
	_tmp40_ = _tmp37_[((((row / _tmp38_) * _tmp37__length2) + (col / _tmp39_)) * _tmp37__length3) + val];
	_tmp41_ = sudoku_board_get_complete (self);
	_tmp42_ = _tmp41_;
	if (_tmp42_) {
		g_signal_emit (self, sudoku_board_signals[SUDOKU_BOARD_COMPLETED_SIGNAL], 0);
	}
}


void
sudoku_board_set (SudokuBoard* self,
                  gint row,
                  gint col,
                  gint val)
{
	g_return_if_fail (self != NULL);
	if (val == 0) {
		sudoku_board_remove (self, row, col, FALSE);
	} else {
		gboolean _tmp0_ = FALSE;
		if (val > 0) {
			gint _tmp1_;
			gint _tmp2_;
			_tmp1_ = sudoku_board_get_max_val (self);
			_tmp2_ = _tmp1_;
			_tmp0_ = val <= _tmp2_;
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			sudoku_board_insert (self, row, col, val, FALSE);
		} else {
			g_assert_not_reached ();
		}
	}
}


gint
sudoku_board_get (SudokuBoard* self,
                  gint row,
                  gint col)
{
	gint result = 0;
	gint* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	gint _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->cells;
	_tmp0__length1 = self->cells_length1;
	_tmp0__length2 = self->cells_length2;
	_tmp1_ = _tmp0_[(row * _tmp0__length2) + col];
	result = _tmp1_;
	return result;
}


void
sudoku_board_remove (SudokuBoard* self,
                     gint row,
                     gint col,
                     gboolean is_fixed)
{
	gint* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	gint _tmp1_;
	gint previous_val = 0;
	gint* _tmp4_;
	gint _tmp4__length1;
	gint _tmp4__length2;
	gint _tmp5_;
	gint* _tmp6_;
	gint _tmp6__length1;
	gint _tmp6__length2;
	gint _tmp7_;
	GeeSet* _tmp8_;
	Coord _tmp9_ = {0};
	gint _tmp92_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->cells;
	_tmp0__length1 = self->cells_length1;
	_tmp0__length2 = self->cells_length2;
	_tmp1_ = _tmp0_[(row * _tmp0__length2) + col];
	if (_tmp1_ == 0) {
		return;
	}
	if (!is_fixed) {
		gboolean* _tmp2_;
		gint _tmp2__length1;
		gint _tmp2__length2;
		gboolean _tmp3_;
		_tmp2_ = self->is_fixed;
		_tmp2__length1 = self->is_fixed_length1;
		_tmp2__length2 = self->is_fixed_length2;
		_tmp3_ = _tmp2_[(row * _tmp2__length2) + col];
		_vala_assert (!_tmp3_, "!this.is_fixed[row, col]");
	}
	_tmp4_ = self->cells;
	_tmp4__length1 = self->cells_length1;
	_tmp4__length2 = self->cells_length2;
	_tmp5_ = _tmp4_[(row * _tmp4__length2) + col];
	previous_val = _tmp5_;
	_tmp6_ = self->cells;
	_tmp6__length1 = self->cells_length1;
	_tmp6__length2 = self->cells_length2;
	_tmp6_[(row * _tmp6__length2) + col] = 0;
	_tmp7_ = _tmp6_[(row * _tmp6__length2) + col];
	_tmp8_ = self->broken_coords;
	coord_init (&_tmp9_, row, col);
	if (gee_collection_contains ((GeeCollection*) _tmp8_, &_tmp9_)) {
		GeeList* _tmp10_;
		gpointer _tmp11_;
		GeeList* _tmp12_;
		gint _tmp13_;
		GeeList* _tmp14_;
		gpointer _tmp15_;
		GeeList* _tmp16_;
		gint _tmp17_;
		GeeMap* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		Coord _tmp21_ = {0};
		gpointer _tmp22_;
		GeeList* _tmp23_;
		gint _tmp24_;
		GeeSet* _tmp25_;
		Coord _tmp26_ = {0};
		GeeList* _tmp27_;
		gpointer _tmp28_;
		GeeList* _tmp29_;
		gint _tmp30_;
		GeeList* _tmp31_;
		gpointer _tmp32_;
		GeeList* _tmp33_;
		gint _tmp34_;
		GeeMap* _tmp35_;
		gint _tmp36_;
		gint _tmp37_;
		Coord _tmp38_ = {0};
		gpointer _tmp39_;
		GeeList* _tmp40_;
		gint _tmp41_;
		gboolean* _tmp42_;
		gint _tmp42__length1;
		gint _tmp42__length2;
		gint _tmp43_;
		GeeList* _tmp44_;
		gpointer _tmp45_;
		GeeList* _tmp46_;
		gint _tmp47_;
		GeeSet* _tmp48_;
		GeeSet* _tmp49_;
		gint _tmp50_;
		gint _tmp51_;
		gboolean _tmp52_;
		gboolean* _tmp53_;
		gint _tmp53__length1;
		gint _tmp53__length2;
		gint _tmp54_;
		GeeList* _tmp55_;
		gpointer _tmp56_;
		GeeList* _tmp57_;
		gint _tmp58_;
		GeeSet* _tmp59_;
		GeeSet* _tmp60_;
		gint _tmp61_;
		gint _tmp62_;
		gboolean _tmp63_;
		gboolean* _tmp64_;
		gint _tmp64__length1;
		gint _tmp64__length2;
		gint _tmp64__length3;
		gint _tmp65_;
		gint _tmp66_;
		gint _tmp67_;
		GeeMap* _tmp68_;
		gint _tmp69_;
		gint _tmp70_;
		Coord _tmp71_ = {0};
		gpointer _tmp72_;
		GeeList* _tmp73_;
		gint _tmp74_;
		GeeSet* _tmp75_;
		GeeSet* _tmp76_;
		gint _tmp77_;
		gint _tmp78_;
		gboolean _tmp79_;
		_tmp10_ = self->coords_for_row;
		_tmp11_ = gee_list_get (_tmp10_, row);
		_tmp12_ = (GeeList*) _tmp11_;
		_tmp13_ = previous_val;
		sudoku_board_remove_breakages_for (self, _tmp12_, _tmp13_);
		_g_object_unref0 (_tmp12_);
		_tmp14_ = self->coords_for_col;
		_tmp15_ = gee_list_get (_tmp14_, col);
		_tmp16_ = (GeeList*) _tmp15_;
		_tmp17_ = previous_val;
		sudoku_board_remove_breakages_for (self, _tmp16_, _tmp17_);
		_g_object_unref0 (_tmp16_);
		_tmp18_ = self->coords_for_block;
		_tmp19_ = self->priv->_block_rows;
		_tmp20_ = self->priv->_block_cols;
		coord_init (&_tmp21_, row / _tmp19_, col / _tmp20_);
		_tmp22_ = gee_map_get (_tmp18_, &_tmp21_);
		_tmp23_ = (GeeList*) _tmp22_;
		_tmp24_ = previous_val;
		sudoku_board_remove_breakages_for (self, _tmp23_, _tmp24_);
		_g_object_unref0 (_tmp23_);
		_tmp25_ = self->broken_coords;
		coord_init (&_tmp26_, row, col);
		gee_collection_remove ((GeeCollection*) _tmp25_, &_tmp26_);
		_tmp27_ = self->coords_for_row;
		_tmp28_ = gee_list_get (_tmp27_, row);
		_tmp29_ = (GeeList*) _tmp28_;
		_tmp30_ = previous_val;
		sudoku_board_mark_breakages_for (self, _tmp29_, _tmp30_);
		_g_object_unref0 (_tmp29_);
		_tmp31_ = self->coords_for_col;
		_tmp32_ = gee_list_get (_tmp31_, col);
		_tmp33_ = (GeeList*) _tmp32_;
		_tmp34_ = previous_val;
		sudoku_board_mark_breakages_for (self, _tmp33_, _tmp34_);
		_g_object_unref0 (_tmp33_);
		_tmp35_ = self->coords_for_block;
		_tmp36_ = self->priv->_block_rows;
		_tmp37_ = self->priv->_block_cols;
		coord_init (&_tmp38_, row / _tmp36_, col / _tmp37_);
		_tmp39_ = gee_map_get (_tmp35_, &_tmp38_);
		_tmp40_ = (GeeList*) _tmp39_;
		_tmp41_ = previous_val;
		sudoku_board_mark_breakages_for (self, _tmp40_, _tmp41_);
		_g_object_unref0 (_tmp40_);
		_tmp42_ = self->priv->possible_in_row;
		_tmp42__length1 = self->priv->possible_in_row_length1;
		_tmp42__length2 = self->priv->possible_in_row_length2;
		_tmp43_ = previous_val;
		_tmp44_ = self->coords_for_row;
		_tmp45_ = gee_list_get (_tmp44_, row);
		_tmp46_ = (GeeList*) _tmp45_;
		_tmp47_ = previous_val;
		_tmp48_ = sudoku_board_get_occurances (self, _tmp46_, _tmp47_);
		_tmp49_ = _tmp48_;
		_tmp50_ = gee_collection_get_size ((GeeCollection*) _tmp49_);
		_tmp51_ = _tmp50_;
		_tmp42_[(row * _tmp42__length2) + (_tmp43_ - 1)] = _tmp51_ == 0;
		_tmp52_ = _tmp42_[(row * _tmp42__length2) + (_tmp43_ - 1)];
		_g_object_unref0 (_tmp49_);
		_g_object_unref0 (_tmp46_);
		_tmp53_ = self->priv->possible_in_col;
		_tmp53__length1 = self->priv->possible_in_col_length1;
		_tmp53__length2 = self->priv->possible_in_col_length2;
		_tmp54_ = previous_val;
		_tmp55_ = self->coords_for_col;
		_tmp56_ = gee_list_get (_tmp55_, col);
		_tmp57_ = (GeeList*) _tmp56_;
		_tmp58_ = previous_val;
		_tmp59_ = sudoku_board_get_occurances (self, _tmp57_, _tmp58_);
		_tmp60_ = _tmp59_;
		_tmp61_ = gee_collection_get_size ((GeeCollection*) _tmp60_);
		_tmp62_ = _tmp61_;
		_tmp53_[(col * _tmp53__length2) + (_tmp54_ - 1)] = _tmp62_ == 0;
		_tmp63_ = _tmp53_[(col * _tmp53__length2) + (_tmp54_ - 1)];
		_g_object_unref0 (_tmp60_);
		_g_object_unref0 (_tmp57_);
		_tmp64_ = self->priv->possible_in_block;
		_tmp64__length1 = self->priv->possible_in_block_length1;
		_tmp64__length2 = self->priv->possible_in_block_length2;
		_tmp64__length3 = self->priv->possible_in_block_length3;
		_tmp65_ = self->priv->_block_cols;
		_tmp66_ = self->priv->_block_rows;
		_tmp67_ = previous_val;
		_tmp68_ = self->coords_for_block;
		_tmp69_ = self->priv->_block_rows;
		_tmp70_ = self->priv->_block_cols;
		coord_init (&_tmp71_, row / _tmp69_, col / _tmp70_);
		_tmp72_ = gee_map_get (_tmp68_, &_tmp71_);
		_tmp73_ = (GeeList*) _tmp72_;
		_tmp74_ = previous_val;
		_tmp75_ = sudoku_board_get_occurances (self, _tmp73_, _tmp74_);
		_tmp76_ = _tmp75_;
		_tmp77_ = gee_collection_get_size ((GeeCollection*) _tmp76_);
		_tmp78_ = _tmp77_;
		_tmp64_[((((row / _tmp65_) * _tmp64__length2) + (col / _tmp66_)) * _tmp64__length3) + (_tmp67_ - 1)] = _tmp78_ == 0;
		_tmp79_ = _tmp64_[((((row / _tmp65_) * _tmp64__length2) + (col / _tmp66_)) * _tmp64__length3) + (_tmp67_ - 1)];
		_g_object_unref0 (_tmp76_);
		_g_object_unref0 (_tmp73_);
	} else {
		gint _tmp80_;
		gboolean* _tmp81_;
		gint _tmp81__length1;
		gint _tmp81__length2;
		gint _tmp82_;
		gboolean _tmp83_;
		gboolean* _tmp84_;
		gint _tmp84__length1;
		gint _tmp84__length2;
		gint _tmp85_;
		gboolean _tmp86_;
		gboolean* _tmp87_;
		gint _tmp87__length1;
		gint _tmp87__length2;
		gint _tmp87__length3;
		gint _tmp88_;
		gint _tmp89_;
		gint _tmp90_;
		gboolean _tmp91_;
		_tmp80_ = previous_val;
		previous_val = _tmp80_ - 1;
		_tmp81_ = self->priv->possible_in_row;
		_tmp81__length1 = self->priv->possible_in_row_length1;
		_tmp81__length2 = self->priv->possible_in_row_length2;
		_tmp82_ = previous_val;
		_tmp81_[(row * _tmp81__length2) + _tmp82_] = TRUE;
		_tmp83_ = _tmp81_[(row * _tmp81__length2) + _tmp82_];
		_tmp84_ = self->priv->possible_in_col;
		_tmp84__length1 = self->priv->possible_in_col_length1;
		_tmp84__length2 = self->priv->possible_in_col_length2;
		_tmp85_ = previous_val;
		_tmp84_[(col * _tmp84__length2) + _tmp85_] = TRUE;
		_tmp86_ = _tmp84_[(col * _tmp84__length2) + _tmp85_];
		_tmp87_ = self->priv->possible_in_block;
		_tmp87__length1 = self->priv->possible_in_block_length1;
		_tmp87__length2 = self->priv->possible_in_block_length2;
		_tmp87__length3 = self->priv->possible_in_block_length3;
		_tmp88_ = self->priv->_block_cols;
		_tmp89_ = self->priv->_block_rows;
		_tmp90_ = previous_val;
		_tmp87_[((((row / _tmp88_) * _tmp87__length2) + (col / _tmp89_)) * _tmp87__length3) + _tmp90_] = TRUE;
		_tmp91_ = _tmp87_[((((row / _tmp88_) * _tmp87__length2) + (col / _tmp89_)) * _tmp87__length3) + _tmp90_];
	}
	_tmp92_ = self->priv->_filled;
	sudoku_board_set_filled (self, _tmp92_ - 1);
	if (is_fixed) {
		gint _tmp93_;
		_tmp93_ = self->priv->_fixed;
		sudoku_board_set_fixed (self, _tmp93_ - 1);
	}
}


gint
sudoku_board_count_solutions_limited (SudokuBoard* self)
{
	gint result = 0;
	gint* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->cells;
	_tmp0__length1 = self->cells_length1;
	_tmp0__length2 = self->cells_length2;
	result = qqwing_count_solutions_limited ((gint*) _tmp0_);
	return result;
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


GeeSet*
sudoku_board_get_occurances (SudokuBoard* self,
                             GeeList* coords,
                             gint val)
{
	GeeSet* result = NULL;
	GeeSet* occurances = NULL;
	GeeHashSet* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (coords != NULL, NULL);
	_tmp0_ = gee_hash_set_new (TYPE_COORD, (GBoxedCopyFunc) coord_dup, (GDestroyNotify) coord_free, (GeeHashDataFunc) coord_hash, NULL, NULL, (GeeEqualDataFunc) coord_equal, NULL, NULL);
	occurances = (GeeSet*) _tmp0_;
	{
		GeeList* _coord_list = NULL;
		GeeList* _tmp1_;
		gint _coord_size = 0;
		GeeList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _coord_index = 0;
		_tmp1_ = _g_object_ref0 (coords);
		_coord_list = _tmp1_;
		_tmp2_ = _coord_list;
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_coord_size = _tmp4_;
		_coord_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			Coord coord = {0};
			GeeList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			Coord* _tmp11_;
			Coord _tmp12_;
			gint* _tmp13_;
			gint _tmp13__length1;
			gint _tmp13__length2;
			Coord _tmp14_;
			gint _tmp15_;
			Coord _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			_tmp5_ = _coord_index;
			_coord_index = _tmp5_ + 1;
			_tmp6_ = _coord_index;
			_tmp7_ = _coord_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _coord_list;
			_tmp9_ = _coord_index;
			_tmp10_ = gee_list_get (_tmp8_, _tmp9_);
			_tmp11_ = (Coord*) _tmp10_;
			_tmp12_ = *_tmp11_;
			_coord_free0 (_tmp11_);
			coord = _tmp12_;
			_tmp13_ = self->cells;
			_tmp13__length1 = self->cells_length1;
			_tmp13__length2 = self->cells_length2;
			_tmp14_ = coord;
			_tmp15_ = _tmp14_.row;
			_tmp16_ = coord;
			_tmp17_ = _tmp16_.col;
			_tmp18_ = _tmp13_[(_tmp15_ * _tmp13__length2) + _tmp17_];
			if (_tmp18_ == val) {
				GeeSet* _tmp19_;
				Coord _tmp20_;
				_tmp19_ = occurances;
				_tmp20_ = coord;
				gee_collection_add ((GeeCollection*) _tmp19_, &_tmp20_);
			}
		}
		_g_object_unref0 (_coord_list);
	}
	result = occurances;
	return result;
}


gboolean
sudoku_board_row_contains (SudokuBoard* self,
                           gint row,
                           gint val)
{
	gboolean result = FALSE;
	GeeList* _tmp0_;
	gpointer _tmp1_;
	GeeList* _tmp2_;
	GeeSet* _tmp3_;
	GeeSet* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gboolean _tmp7_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->coords_for_row;
	_tmp1_ = gee_list_get (_tmp0_, row);
	_tmp2_ = (GeeList*) _tmp1_;
	_tmp3_ = sudoku_board_get_occurances (self, _tmp2_, val);
	_tmp4_ = _tmp3_;
	_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_ != 0;
	_g_object_unref0 (_tmp4_);
	_g_object_unref0 (_tmp2_);
	result = _tmp7_;
	return result;
}


gboolean
sudoku_board_col_contains (SudokuBoard* self,
                           gint col,
                           gint val)
{
	gboolean result = FALSE;
	GeeList* _tmp0_;
	gpointer _tmp1_;
	GeeList* _tmp2_;
	GeeSet* _tmp3_;
	GeeSet* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gboolean _tmp7_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->coords_for_col;
	_tmp1_ = gee_list_get (_tmp0_, col);
	_tmp2_ = (GeeList*) _tmp1_;
	_tmp3_ = sudoku_board_get_occurances (self, _tmp2_, val);
	_tmp4_ = _tmp3_;
	_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_ != 0;
	_g_object_unref0 (_tmp4_);
	_g_object_unref0 (_tmp2_);
	result = _tmp7_;
	return result;
}


gboolean
sudoku_board_block_contains (SudokuBoard* self,
                             Coord* block,
                             gint val)
{
	gboolean result = FALSE;
	GeeMap* _tmp0_;
	Coord _tmp1_;
	gpointer _tmp2_;
	GeeList* _tmp3_;
	GeeSet* _tmp4_;
	GeeSet* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gboolean _tmp8_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (block != NULL, FALSE);
	_tmp0_ = self->coords_for_block;
	_tmp1_ = *block;
	_tmp2_ = gee_map_get (_tmp0_, &_tmp1_);
	_tmp3_ = (GeeList*) _tmp2_;
	_tmp4_ = sudoku_board_get_occurances (self, _tmp3_, val);
	_tmp5_ = _tmp4_;
	_tmp6_ = gee_collection_get_size ((GeeCollection*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_ != 0;
	_g_object_unref0 (_tmp5_);
	_g_object_unref0 (_tmp3_);
	result = _tmp8_;
	return result;
}


static void
sudoku_board_remove_breakages_for (SudokuBoard* self,
                                   GeeList* coords,
                                   gint val)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (coords != NULL);
	{
		GeeList* _coord_list = NULL;
		GeeList* _tmp0_;
		gint _coord_size = 0;
		GeeList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _coord_index = 0;
		_tmp0_ = _g_object_ref0 (coords);
		_coord_list = _tmp0_;
		_tmp1_ = _coord_list;
		_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_coord_size = _tmp3_;
		_coord_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			Coord coord = {0};
			GeeList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			Coord* _tmp10_;
			Coord _tmp11_;
			gboolean _tmp12_ = FALSE;
			gint* _tmp13_;
			gint _tmp13__length1;
			gint _tmp13__length2;
			Coord _tmp14_;
			gint _tmp15_;
			Coord _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			_tmp4_ = _coord_index;
			_coord_index = _tmp4_ + 1;
			_tmp5_ = _coord_index;
			_tmp6_ = _coord_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _coord_list;
			_tmp8_ = _coord_index;
			_tmp9_ = gee_list_get (_tmp7_, _tmp8_);
			_tmp10_ = (Coord*) _tmp9_;
			_tmp11_ = *_tmp10_;
			_coord_free0 (_tmp10_);
			coord = _tmp11_;
			_tmp13_ = self->cells;
			_tmp13__length1 = self->cells_length1;
			_tmp13__length2 = self->cells_length2;
			_tmp14_ = coord;
			_tmp15_ = _tmp14_.row;
			_tmp16_ = coord;
			_tmp17_ = _tmp16_.col;
			_tmp18_ = _tmp13_[(_tmp15_ * _tmp13__length2) + _tmp17_];
			if (_tmp18_ == val) {
				GeeSet* _tmp19_;
				Coord _tmp20_;
				_tmp19_ = self->broken_coords;
				_tmp20_ = coord;
				_tmp12_ = gee_collection_contains ((GeeCollection*) _tmp19_, &_tmp20_);
			} else {
				_tmp12_ = FALSE;
			}
			if (_tmp12_) {
				GeeSet* _tmp21_;
				Coord _tmp22_;
				_tmp21_ = self->broken_coords;
				_tmp22_ = coord;
				gee_collection_remove ((GeeCollection*) _tmp21_, &_tmp22_);
			}
		}
		_g_object_unref0 (_coord_list);
	}
}


static void
sudoku_board_mark_breakages_for (SudokuBoard* self,
                                 GeeList* coords,
                                 gint val)
{
	GeeSet* occurances = NULL;
	GeeSet* _tmp0_;
	GeeSet* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (coords != NULL);
	_tmp0_ = sudoku_board_get_occurances (self, coords, val);
	occurances = _tmp0_;
	_tmp1_ = occurances;
	_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != 1) {
		GeeSet* _tmp4_;
		GeeSet* _tmp5_;
		_tmp4_ = self->broken_coords;
		_tmp5_ = occurances;
		gee_collection_add_all ((GeeCollection*) _tmp4_, (GeeCollection*) _tmp5_);
	}
	_g_object_unref0 (occurances);
}


void
sudoku_board_to_initial_state (SudokuBoard* self)
{
	g_return_if_fail (self != NULL);
	{
		gint l1 = 0;
		l1 = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				gint _tmp3_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = l1;
					l1 = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = l1;
				_tmp3_ = self->priv->_rows;
				if (!(_tmp2_ < _tmp3_)) {
					break;
				}
				{
					gint l2 = 0;
					l2 = 0;
					{
						gboolean _tmp4_ = FALSE;
						_tmp4_ = TRUE;
						while (TRUE) {
							gint _tmp6_;
							gint _tmp7_;
							gboolean* _tmp8_;
							gint _tmp8__length1;
							gint _tmp8__length2;
							gint _tmp9_;
							gint _tmp10_;
							gboolean _tmp11_;
							if (!_tmp4_) {
								gint _tmp5_;
								_tmp5_ = l2;
								l2 = _tmp5_ + 1;
							}
							_tmp4_ = FALSE;
							_tmp6_ = l2;
							_tmp7_ = self->priv->_cols;
							if (!(_tmp6_ < _tmp7_)) {
								break;
							}
							_tmp8_ = self->is_fixed;
							_tmp8__length1 = self->is_fixed_length1;
							_tmp8__length2 = self->is_fixed_length2;
							_tmp9_ = l1;
							_tmp10_ = l2;
							_tmp11_ = _tmp8_[(_tmp9_ * _tmp8__length2) + _tmp10_];
							if (!_tmp11_) {
								gint _tmp12_;
								gint _tmp13_;
								_tmp12_ = l1;
								_tmp13_ = l2;
								sudoku_board_remove (self, _tmp12_, _tmp13_, FALSE);
							}
						}
					}
				}
			}
		}
	}
}


void
sudoku_board_print (SudokuBoard* self,
                    gint indent)
{
	FILE* _tmp21_;
	g_return_if_fail (self != NULL);
	{
		gint l1 = 0;
		l1 = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				FILE* _tmp20_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = l1;
					l1 = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = l1;
				if (!(_tmp2_ < 9)) {
					break;
				}
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							gint _tmp5_;
							FILE* _tmp6_;
							if (!_tmp3_) {
								gint _tmp4_;
								_tmp4_ = i;
								i = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							_tmp5_ = i;
							if (!(_tmp5_ < indent)) {
								break;
							}
							_tmp6_ = stdout;
							fprintf (_tmp6_, " ");
						}
					}
				}
				{
					gint l2 = 0;
					l2 = 0;
					{
						gboolean _tmp7_ = FALSE;
						_tmp7_ = TRUE;
						while (TRUE) {
							gint _tmp9_;
							gint* _tmp10_;
							gint _tmp10__length1;
							gint _tmp10__length2;
							gint _tmp11_;
							gint _tmp12_;
							gint _tmp13_;
							if (!_tmp7_) {
								gint _tmp8_;
								_tmp8_ = l2;
								l2 = _tmp8_ + 1;
							}
							_tmp7_ = FALSE;
							_tmp9_ = l2;
							if (!(_tmp9_ < 9)) {
								break;
							}
							_tmp10_ = self->cells;
							_tmp10__length1 = self->cells_length1;
							_tmp10__length2 = self->cells_length2;
							_tmp11_ = l1;
							_tmp12_ = l2;
							_tmp13_ = _tmp10_[(_tmp11_ * _tmp10__length2) + _tmp12_];
							if (_tmp13_ != 0) {
								FILE* _tmp14_;
								gint* _tmp15_;
								gint _tmp15__length1;
								gint _tmp15__length2;
								gint _tmp16_;
								gint _tmp17_;
								gint _tmp18_;
								_tmp14_ = stdout;
								_tmp15_ = self->cells;
								_tmp15__length1 = self->cells_length1;
								_tmp15__length2 = self->cells_length2;
								_tmp16_ = l1;
								_tmp17_ = l2;
								_tmp18_ = _tmp15_[(_tmp16_ * _tmp15__length2) + _tmp17_];
								fprintf (_tmp14_, "%d ", _tmp18_);
							} else {
								FILE* _tmp19_;
								_tmp19_ = stdout;
								fprintf (_tmp19_, "  ");
							}
						}
					}
				}
				_tmp20_ = stdout;
				fprintf (_tmp20_, "\n");
			}
		}
	}
	_tmp21_ = stdout;
	fflush (_tmp21_);
}


void
sudoku_board_get_string (SudokuBoard* self)
{
	FILE* _tmp0_;
	FILE* _tmp18_;
	g_return_if_fail (self != NULL);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "[ ");
	{
		gint l1 = 0;
		l1 = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_;
				FILE* _tmp4_;
				FILE* _tmp15_;
				gint _tmp16_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = l1;
					l1 = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = l1;
				if (!(_tmp3_ < 9)) {
					break;
				}
				_tmp4_ = stdout;
				fprintf (_tmp4_, "[ ");
				{
					gint l2 = 0;
					l2 = 0;
					{
						gboolean _tmp5_ = FALSE;
						_tmp5_ = TRUE;
						while (TRUE) {
							gint _tmp7_;
							FILE* _tmp8_;
							gint* _tmp9_;
							gint _tmp9__length1;
							gint _tmp9__length2;
							gint _tmp10_;
							gint _tmp11_;
							gint _tmp12_;
							gint _tmp13_;
							if (!_tmp5_) {
								gint _tmp6_;
								_tmp6_ = l2;
								l2 = _tmp6_ + 1;
							}
							_tmp5_ = FALSE;
							_tmp7_ = l2;
							if (!(_tmp7_ < 9)) {
								break;
							}
							_tmp8_ = stdout;
							_tmp9_ = self->cells;
							_tmp9__length1 = self->cells_length1;
							_tmp9__length2 = self->cells_length2;
							_tmp10_ = l1;
							_tmp11_ = l2;
							_tmp12_ = _tmp9_[(_tmp10_ * _tmp9__length2) + _tmp11_];
							fprintf (_tmp8_, "%d", _tmp12_);
							_tmp13_ = l2;
							if (_tmp13_ != 8) {
								FILE* _tmp14_;
								_tmp14_ = stdout;
								fprintf (_tmp14_, ",");
							}
						}
					}
				}
				_tmp15_ = stdout;
				fprintf (_tmp15_, " ]");
				_tmp16_ = l1;
				if (_tmp16_ != 8) {
					FILE* _tmp17_;
					_tmp17_ = stdout;
					fprintf (_tmp17_, ",");
				}
			}
		}
	}
	_tmp18_ = stdout;
	fprintf (_tmp18_, " ]");
}


gchar*
sudoku_board_to_string (SudokuBoard* self,
                        gboolean get_original_state)
{
	gchar* result = NULL;
	gchar* board_string = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("");
	board_string = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_;
				gint _tmp4_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = self->priv->_rows;
				if (!(_tmp3_ < _tmp4_)) {
					break;
				}
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp5_ = FALSE;
						_tmp5_ = TRUE;
						while (TRUE) {
							gint _tmp7_;
							gint _tmp8_;
							gboolean* _tmp9_;
							gint _tmp9__length1;
							gint _tmp9__length2;
							gint _tmp10_;
							gint _tmp11_;
							gboolean _tmp12_;
							if (!_tmp5_) {
								gint _tmp6_;
								_tmp6_ = j;
								j = _tmp6_ + 1;
							}
							_tmp5_ = FALSE;
							_tmp7_ = j;
							_tmp8_ = self->priv->_cols;
							if (!(_tmp7_ < _tmp8_)) {
								break;
							}
							_tmp9_ = self->is_fixed;
							_tmp9__length1 = self->is_fixed_length1;
							_tmp9__length2 = self->is_fixed_length2;
							_tmp10_ = i;
							_tmp11_ = j;
							_tmp12_ = _tmp9_[(_tmp10_ * _tmp9__length2) + _tmp11_];
							if (_tmp12_) {
								const gchar* _tmp13_;
								gint* _tmp14_;
								gint _tmp14__length1;
								gint _tmp14__length2;
								gint _tmp15_;
								gint _tmp16_;
								gint _tmp17_;
								gchar* _tmp18_;
								gchar* _tmp19_;
								gchar* _tmp20_;
								_tmp13_ = board_string;
								_tmp14_ = self->cells;
								_tmp14__length1 = self->cells_length1;
								_tmp14__length2 = self->cells_length2;
								_tmp15_ = i;
								_tmp16_ = j;
								_tmp17_ = _tmp14_[(_tmp15_ * _tmp14__length2) + _tmp16_];
								_tmp18_ = g_strdup_printf ("%i", _tmp17_);
								_tmp19_ = _tmp18_;
								_tmp20_ = g_strconcat (_tmp13_, _tmp19_, NULL);
								_g_free0 (board_string);
								board_string = _tmp20_;
								_g_free0 (_tmp19_);
							} else {
								gchar* _tmp21_ = NULL;
								const gchar* _tmp28_;
								gchar* _tmp29_;
								if (get_original_state) {
									gchar* _tmp22_;
									_tmp22_ = g_strdup ("0");
									_g_free0 (_tmp21_);
									_tmp21_ = _tmp22_;
								} else {
									gint* _tmp23_;
									gint _tmp23__length1;
									gint _tmp23__length2;
									gint _tmp24_;
									gint _tmp25_;
									gint _tmp26_;
									gchar* _tmp27_;
									_tmp23_ = self->cells;
									_tmp23__length1 = self->cells_length1;
									_tmp23__length2 = self->cells_length2;
									_tmp24_ = i;
									_tmp25_ = j;
									_tmp26_ = _tmp23_[(_tmp24_ * _tmp23__length2) + _tmp25_];
									_tmp27_ = g_strdup_printf ("%i", _tmp26_);
									_g_free0 (_tmp21_);
									_tmp21_ = _tmp27_;
								}
								_tmp28_ = board_string;
								_tmp29_ = g_strconcat (_tmp28_, _tmp21_, NULL);
								_g_free0 (board_string);
								board_string = _tmp29_;
								_g_free0 (_tmp21_);
							}
						}
					}
				}
			}
		}
	}
	result = board_string;
	return result;
}


static gint*
_vala_array_dup8 (gint* self,
                  int length)
{
	return g_memdup (self, length * sizeof (gint));
}


gint*
sudoku_board_get_cells (SudokuBoard* self,
                        int* result_length1,
                        int* result_length2)
{
	gint* result = NULL;
	gint* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	gint* _tmp1_;
	gint _tmp1__length1;
	gint _tmp1__length2;
	gint* _tmp2_;
	gint _tmp2__length1;
	gint _tmp2__length2;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->cells;
	_tmp0__length1 = self->cells_length1;
	_tmp0__length2 = self->cells_length2;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup8 (_tmp0_, _tmp0__length1 * _tmp0__length2) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	_tmp1__length2 = _tmp0__length2;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	_tmp2__length2 = _tmp1__length2;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	if (result_length2) {
		*result_length2 = _tmp2__length2;
	}
	result = _tmp2_;
	return result;
}


GeeHashMap*
sudoku_board_calculate_open_squares (SudokuBoard* self)
{
	GeeHashMap* result = NULL;
	GeeHashMap* possibilities = NULL;
	GeeHashMap* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_hash_map_new (TYPE_COORD, (GBoxedCopyFunc) coord_dup, (GDestroyNotify) coord_free, GEE_TYPE_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, (GeeHashDataFunc) coord_hash, NULL, NULL, (GeeEqualDataFunc) coord_equal, NULL, NULL, NULL, NULL, NULL);
	possibilities = _tmp0_;
	{
		gint l1 = 0;
		l1 = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_;
				gint _tmp4_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = l1;
					l1 = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = l1;
				_tmp4_ = self->priv->_rows;
				if (!(_tmp3_ < _tmp4_)) {
					break;
				}
				{
					gint l2 = 0;
					l2 = 0;
					{
						gboolean _tmp5_ = FALSE;
						_tmp5_ = TRUE;
						while (TRUE) {
							gint _tmp7_;
							gint _tmp8_;
							gint* _tmp9_;
							gint _tmp9__length1;
							gint _tmp9__length2;
							gint _tmp10_;
							gint _tmp11_;
							gint _tmp12_;
							if (!_tmp5_) {
								gint _tmp6_;
								_tmp6_ = l2;
								l2 = _tmp6_ + 1;
							}
							_tmp5_ = FALSE;
							_tmp7_ = l2;
							_tmp8_ = self->priv->_cols;
							if (!(_tmp7_ < _tmp8_)) {
								break;
							}
							_tmp9_ = self->cells;
							_tmp9__length1 = self->cells_length1;
							_tmp9__length2 = self->cells_length2;
							_tmp10_ = l1;
							_tmp11_ = l2;
							_tmp12_ = _tmp9_[(_tmp10_ * _tmp9__length2) + _tmp11_];
							if (_tmp12_ == 0) {
								GeeList* possArrayList = NULL;
								GeeArrayList* _tmp13_;
								gint* possArray = NULL;
								gint _tmp14_;
								gint _tmp15_;
								gint _tmp16_;
								gint* _tmp17_;
								gint possArray_length1;
								gint _possArray_size_;
								gint* _tmp18_;
								gint _tmp18__length1;
								GeeHashMap* _tmp21_;
								gint _tmp22_;
								gint _tmp23_;
								Coord _tmp24_ = {0};
								GeeList* _tmp25_;
								_tmp13_ = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL, NULL, NULL);
								possArrayList = (GeeList*) _tmp13_;
								_tmp14_ = l1;
								_tmp15_ = l2;
								_tmp17_ = sudoku_board_get_possibilities (self, _tmp14_, _tmp15_, &_tmp16_);
								possArray = _tmp17_;
								possArray_length1 = _tmp16_;
								_possArray_size_ = possArray_length1;
								_tmp18_ = possArray;
								_tmp18__length1 = possArray_length1;
								{
									gint* i_collection = NULL;
									gint i_collection_length1 = 0;
									gint _i_collection_size_ = 0;
									gint i_it = 0;
									i_collection = _tmp18_;
									i_collection_length1 = _tmp18__length1;
									for (i_it = 0; i_it < _tmp18__length1; i_it = i_it + 1) {
										gint i = 0;
										i = i_collection[i_it];
										{
											GeeList* _tmp19_;
											gint _tmp20_;
											_tmp19_ = possArrayList;
											_tmp20_ = i;
											gee_collection_add ((GeeCollection*) _tmp19_, (gpointer) ((gintptr) _tmp20_));
										}
									}
								}
								_tmp21_ = possibilities;
								_tmp22_ = l1;
								_tmp23_ = l2;
								coord_init (&_tmp24_, _tmp22_, _tmp23_);
								_tmp25_ = possArrayList;
								gee_abstract_map_set ((GeeAbstractMap*) _tmp21_, &_tmp24_, _tmp25_);
								possArray = (g_free (possArray), NULL);
								_g_object_unref0 (possArrayList);
							}
						}
					}
				}
			}
		}
	}
	result = possibilities;
	return result;
}


gboolean
sudoku_board_is_finished (SudokuBoard* self)
{
	gboolean result = FALSE;
	gchar* board_string = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* finishgame_file = NULL;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	GFile* file = NULL;
	GFile* _tmp7_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = sudoku_board_to_string (self, TRUE);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, ".save", NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	board_string = _tmp3_;
	_tmp4_ = sudoku_saver_get_finishgame_dir ();
	_tmp5_ = _tmp4_;
	_tmp6_ = g_build_path (G_DIR_SEPARATOR_S, _tmp5_, board_string, NULL);
	finishgame_file = _tmp6_;
	_tmp7_ = g_file_new_for_path (finishgame_file);
	file = _tmp7_;
	result = g_file_query_exists (file, NULL);
	_g_object_unref0 (file);
	_g_free0 (finishgame_file);
	_g_free0 (board_string);
	return result;
}


gchar*
sudoku_board_get_earmarks_string (SudokuBoard* self,
                                  gint row,
                                  gint col)
{
	gchar* result = NULL;
	gchar* s = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("");
	s = _tmp0_;
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				gboolean* _tmp6_;
				gint _tmp6__length1;
				gint _tmp6__length2;
				gint _tmp6__length3;
				gint _tmp7_;
				gboolean _tmp8_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = sudoku_board_get_max_val (self);
				_tmp5_ = _tmp4_;
				if (!(_tmp3_ <= _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->earmarks;
				_tmp6__length1 = self->priv->earmarks_length1;
				_tmp6__length2 = self->priv->earmarks_length2;
				_tmp6__length3 = self->priv->earmarks_length3;
				_tmp7_ = i;
				_tmp8_ = _tmp6_[(((row * _tmp6__length2) + col) * _tmp6__length3) + (_tmp7_ - 1)];
				if (_tmp8_) {
					const gchar* _tmp9_;
					gint _tmp10_;
					gchar* _tmp11_;
					gchar* _tmp12_;
					gchar* _tmp13_;
					_tmp9_ = s;
					_tmp10_ = i;
					_tmp11_ = g_strdup_printf ("%i", _tmp10_);
					_tmp12_ = _tmp11_;
					_tmp13_ = g_strconcat (_tmp9_, _tmp12_, NULL);
					_g_free0 (s);
					s = _tmp13_;
					_g_free0 (_tmp12_);
				}
			}
		}
	}
	result = s;
	return result;
}


gdouble
sudoku_board_get_previous_played_time (SudokuBoard* self)
{
	gdouble result;
	gdouble _tmp0_;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->priv->_previous_played_time;
	result = _tmp0_;
	return result;
}


void
sudoku_board_set_previous_played_time (SudokuBoard* self,
                                       gdouble value)
{
	g_return_if_fail (self != NULL);
	if (sudoku_board_get_previous_played_time (self) != value) {
		self->priv->_previous_played_time = value;
		g_object_notify_by_pspec ((GObject *) self, sudoku_board_properties[SUDOKU_BOARD_PREVIOUS_PLAYED_TIME_PROPERTY]);
	}
}


DifficultyCategory
sudoku_board_get_difficulty_category (SudokuBoard* self)
{
	DifficultyCategory result;
	DifficultyCategory _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_difficulty_category;
	result = _tmp0_;
	return result;
}


void
sudoku_board_set_difficulty_category (SudokuBoard* self,
                                      DifficultyCategory value)
{
	g_return_if_fail (self != NULL);
	if (sudoku_board_get_difficulty_category (self) != value) {
		self->priv->_difficulty_category = value;
		g_object_notify_by_pspec ((GObject *) self, sudoku_board_properties[SUDOKU_BOARD_DIFFICULTY_CATEGORY_PROPERTY]);
	}
}


gint
sudoku_board_get_block_rows (SudokuBoard* self)
{
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_block_rows;
	result = _tmp0_;
	return result;
}


static void
sudoku_board_set_block_rows (SudokuBoard* self,
                             gint value)
{
	g_return_if_fail (self != NULL);
	if (sudoku_board_get_block_rows (self) != value) {
		self->priv->_block_rows = value;
		g_object_notify_by_pspec ((GObject *) self, sudoku_board_properties[SUDOKU_BOARD_BLOCK_ROWS_PROPERTY]);
	}
}


gint
sudoku_board_get_block_cols (SudokuBoard* self)
{
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_block_cols;
	result = _tmp0_;
	return result;
}


static void
sudoku_board_set_block_cols (SudokuBoard* self,
                             gint value)
{
	g_return_if_fail (self != NULL);
	if (sudoku_board_get_block_cols (self) != value) {
		self->priv->_block_cols = value;
		g_object_notify_by_pspec ((GObject *) self, sudoku_board_properties[SUDOKU_BOARD_BLOCK_COLS_PROPERTY]);
	}
}


gint
sudoku_board_get_rows (SudokuBoard* self)
{
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_rows;
	result = _tmp0_;
	return result;
}


static void
sudoku_board_set_rows (SudokuBoard* self,
                       gint value)
{
	g_return_if_fail (self != NULL);
	if (sudoku_board_get_rows (self) != value) {
		self->priv->_rows = value;
		g_object_notify_by_pspec ((GObject *) self, sudoku_board_properties[SUDOKU_BOARD_ROWS_PROPERTY]);
	}
}


gint
sudoku_board_get_cols (SudokuBoard* self)
{
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_cols;
	result = _tmp0_;
	return result;
}


static void
sudoku_board_set_cols (SudokuBoard* self,
                       gint value)
{
	g_return_if_fail (self != NULL);
	if (sudoku_board_get_cols (self) != value) {
		self->priv->_cols = value;
		g_object_notify_by_pspec ((GObject *) self, sudoku_board_properties[SUDOKU_BOARD_COLS_PROPERTY]);
	}
}


gint
sudoku_board_get_max_val (SudokuBoard* self)
{
	gint result;
	gint _tmp0_;
	gint _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_block_rows;
	_tmp1_ = self->priv->_block_cols;
	result = _tmp0_ * _tmp1_;
	return result;
}


gboolean
sudoku_board_get_broken (SudokuBoard* self)
{
	gboolean result;
	GeeSet* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->broken_coords;
	_tmp1_ = gee_collection_get_size ((GeeCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_ != 0;
	return result;
}


gint
sudoku_board_get_filled (SudokuBoard* self)
{
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_filled;
	result = _tmp0_;
	return result;
}


static void
sudoku_board_set_filled (SudokuBoard* self,
                         gint value)
{
	g_return_if_fail (self != NULL);
	if (sudoku_board_get_filled (self) != value) {
		self->priv->_filled = value;
		g_object_notify_by_pspec ((GObject *) self, sudoku_board_properties[SUDOKU_BOARD_FILLED_PROPERTY]);
	}
}


gint
sudoku_board_get_fixed (SudokuBoard* self)
{
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_fixed;
	result = _tmp0_;
	return result;
}


static void
sudoku_board_set_fixed (SudokuBoard* self,
                        gint value)
{
	g_return_if_fail (self != NULL);
	if (sudoku_board_get_fixed (self) != value) {
		self->priv->_fixed = value;
		g_object_notify_by_pspec ((GObject *) self, sudoku_board_properties[SUDOKU_BOARD_FIXED_PROPERTY]);
	}
}


gint
sudoku_board_get_size (SudokuBoard* self)
{
	gint result;
	gint _tmp0_;
	gint _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_rows;
	_tmp1_ = self->priv->_cols;
	result = _tmp0_ * _tmp1_;
	return result;
}


gboolean
sudoku_board_get_complete (SudokuBoard* self)
{
	gboolean result;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->_filled;
	_tmp2_ = self->priv->_cols;
	_tmp3_ = self->priv->_rows;
	if (_tmp1_ == (_tmp2_ * _tmp3_)) {
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp4_ = sudoku_board_get_broken (self);
		_tmp5_ = _tmp4_;
		_tmp0_ = !_tmp5_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static void
sudoku_board_class_init (SudokuBoardClass * klass)
{
	sudoku_board_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SudokuBoardPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_sudoku_board_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sudoku_board_set_property;
	G_OBJECT_CLASS (klass)->finalize = sudoku_board_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_PREVIOUS_PLAYED_TIME_PROPERTY, sudoku_board_properties[SUDOKU_BOARD_PREVIOUS_PLAYED_TIME_PROPERTY] = g_param_spec_double ("previous-played-time", "previous-played-time", "previous-played-time", -G_MAXDOUBLE, G_MAXDOUBLE, (gdouble) 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_DIFFICULTY_CATEGORY_PROPERTY, sudoku_board_properties[SUDOKU_BOARD_DIFFICULTY_CATEGORY_PROPERTY] = g_param_spec_enum ("difficulty-category", "difficulty-category", "difficulty-category", TYPE_DIFFICULTY_CATEGORY, DIFFICULTY_CATEGORY_UNKNOWN, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_BLOCK_ROWS_PROPERTY, sudoku_board_properties[SUDOKU_BOARD_BLOCK_ROWS_PROPERTY] = g_param_spec_int ("block-rows", "block-rows", "block-rows", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_BLOCK_COLS_PROPERTY, sudoku_board_properties[SUDOKU_BOARD_BLOCK_COLS_PROPERTY] = g_param_spec_int ("block-cols", "block-cols", "block-cols", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_ROWS_PROPERTY, sudoku_board_properties[SUDOKU_BOARD_ROWS_PROPERTY] = g_param_spec_int ("rows", "rows", "rows", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_COLS_PROPERTY, sudoku_board_properties[SUDOKU_BOARD_COLS_PROPERTY] = g_param_spec_int ("cols", "cols", "cols", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_MAX_VAL_PROPERTY, sudoku_board_properties[SUDOKU_BOARD_MAX_VAL_PROPERTY] = g_param_spec_int ("max-val", "max-val", "max-val", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_BROKEN_PROPERTY, sudoku_board_properties[SUDOKU_BOARD_BROKEN_PROPERTY] = g_param_spec_boolean ("broken", "broken", "broken", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_FILLED_PROPERTY, sudoku_board_properties[SUDOKU_BOARD_FILLED_PROPERTY] = g_param_spec_int ("filled", "filled", "filled", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_FIXED_PROPERTY, sudoku_board_properties[SUDOKU_BOARD_FIXED_PROPERTY] = g_param_spec_int ("fixed", "fixed", "fixed", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_SIZE_PROPERTY, sudoku_board_properties[SUDOKU_BOARD_SIZE_PROPERTY] = g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_COMPLETE_PROPERTY, sudoku_board_properties[SUDOKU_BOARD_COMPLETE_PROPERTY] = g_param_spec_boolean ("complete", "complete", "complete", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	sudoku_board_signals[SUDOKU_BOARD_COMPLETED_SIGNAL] = g_signal_new ("completed", TYPE_SUDOKU_BOARD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void
sudoku_board_instance_init (SudokuBoard * self)
{
	self->priv = SUDOKU_BOARD_GET_PRIVATE (self);
	self->priv->_previous_played_time = (gdouble) 0;
	self->priv->_difficulty_category = DIFFICULTY_CATEGORY_UNKNOWN;
}


static void
sudoku_board_finalize (GObject * obj)
{
	SudokuBoard * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU_BOARD, SudokuBoard);
	self->cells = (g_free (self->cells), NULL);
	self->is_fixed = (g_free (self->is_fixed), NULL);
	self->priv->possible_in_row = (g_free (self->priv->possible_in_row), NULL);
	self->priv->possible_in_col = (g_free (self->priv->possible_in_col), NULL);
	self->priv->possible_in_block = (g_free (self->priv->possible_in_block), NULL);
	self->priv->earmarks = (g_free (self->priv->earmarks), NULL);
	_g_object_unref0 (self->broken_coords);
	_g_object_unref0 (self->coords_for_col);
	_g_object_unref0 (self->coords_for_row);
	_g_object_unref0 (self->coords_for_block);
	G_OBJECT_CLASS (sudoku_board_parent_class)->finalize (obj);
}


GType
sudoku_board_get_type (void)
{
	static volatile gsize sudoku_board_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_board_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SudokuBoardClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_board_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuBoard), 0, (GInstanceInitFunc) sudoku_board_instance_init, NULL };
		GType sudoku_board_type_id;
		sudoku_board_type_id = g_type_register_static (G_TYPE_OBJECT, "SudokuBoard", &g_define_type_info, 0);
		g_once_init_leave (&sudoku_board_type_id__volatile, sudoku_board_type_id);
	}
	return sudoku_board_type_id__volatile;
}


static void
_vala_sudoku_board_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	SudokuBoard * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_BOARD, SudokuBoard);
	switch (property_id) {
		case SUDOKU_BOARD_PREVIOUS_PLAYED_TIME_PROPERTY:
		g_value_set_double (value, sudoku_board_get_previous_played_time (self));
		break;
		case SUDOKU_BOARD_DIFFICULTY_CATEGORY_PROPERTY:
		g_value_set_enum (value, sudoku_board_get_difficulty_category (self));
		break;
		case SUDOKU_BOARD_BLOCK_ROWS_PROPERTY:
		g_value_set_int (value, sudoku_board_get_block_rows (self));
		break;
		case SUDOKU_BOARD_BLOCK_COLS_PROPERTY:
		g_value_set_int (value, sudoku_board_get_block_cols (self));
		break;
		case SUDOKU_BOARD_ROWS_PROPERTY:
		g_value_set_int (value, sudoku_board_get_rows (self));
		break;
		case SUDOKU_BOARD_COLS_PROPERTY:
		g_value_set_int (value, sudoku_board_get_cols (self));
		break;
		case SUDOKU_BOARD_MAX_VAL_PROPERTY:
		g_value_set_int (value, sudoku_board_get_max_val (self));
		break;
		case SUDOKU_BOARD_BROKEN_PROPERTY:
		g_value_set_boolean (value, sudoku_board_get_broken (self));
		break;
		case SUDOKU_BOARD_FILLED_PROPERTY:
		g_value_set_int (value, sudoku_board_get_filled (self));
		break;
		case SUDOKU_BOARD_FIXED_PROPERTY:
		g_value_set_int (value, sudoku_board_get_fixed (self));
		break;
		case SUDOKU_BOARD_SIZE_PROPERTY:
		g_value_set_int (value, sudoku_board_get_size (self));
		break;
		case SUDOKU_BOARD_COMPLETE_PROPERTY:
		g_value_set_boolean (value, sudoku_board_get_complete (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_sudoku_board_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	SudokuBoard * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_BOARD, SudokuBoard);
	switch (property_id) {
		case SUDOKU_BOARD_PREVIOUS_PLAYED_TIME_PROPERTY:
		sudoku_board_set_previous_played_time (self, g_value_get_double (value));
		break;
		case SUDOKU_BOARD_DIFFICULTY_CATEGORY_PROPERTY:
		sudoku_board_set_difficulty_category (self, g_value_get_enum (value));
		break;
		case SUDOKU_BOARD_BLOCK_ROWS_PROPERTY:
		sudoku_board_set_block_rows (self, g_value_get_int (value));
		break;
		case SUDOKU_BOARD_BLOCK_COLS_PROPERTY:
		sudoku_board_set_block_cols (self, g_value_get_int (value));
		break;
		case SUDOKU_BOARD_ROWS_PROPERTY:
		sudoku_board_set_rows (self, g_value_get_int (value));
		break;
		case SUDOKU_BOARD_COLS_PROPERTY:
		sudoku_board_set_cols (self, g_value_get_int (value));
		break;
		case SUDOKU_BOARD_FILLED_PROPERTY:
		sudoku_board_set_filled (self, g_value_get_int (value));
		break;
		case SUDOKU_BOARD_FIXED_PROPERTY:
		sudoku_board_set_fixed (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


GType
house_get_type (void)
{
	static volatile gsize house_type_id__volatile = 0;
	if (g_once_init_enter (&house_type_id__volatile)) {
		static const GEnumValue values[] = {{HOUSE_ROW, "HOUSE_ROW", "row"}, {HOUSE_COLUMN, "HOUSE_COLUMN", "column"}, {HOUSE_BLOCK, "HOUSE_BLOCK", "block"}, {0, NULL, NULL}};
		GType house_type_id;
		house_type_id = g_enum_register_static ("House", values);
		g_once_init_leave (&house_type_id__volatile, house_type_id);
	}
	return house_type_id__volatile;
}


void
coord_init (Coord *self,
            gint row,
            gint col)
{
	memset (self, 0, sizeof (Coord));
	(*self).row = row;
	(*self).col = col;
}


gint
coord_hash (Coord* coord)
{
	gint result = 0;
	Coord _tmp0_;
	gint _tmp1_;
	Coord _tmp2_;
	gint _tmp3_;
	g_return_val_if_fail (coord != NULL, 0);
	_tmp0_ = *coord;
	_tmp1_ = _tmp0_.row;
	_tmp2_ = *coord;
	_tmp3_ = _tmp2_.col;
	result = (_tmp1_ * 33) ^ _tmp3_;
	return result;
}


gboolean
coord_equal (Coord* a,
             Coord* b)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	Coord _tmp1_;
	gint _tmp2_;
	Coord _tmp3_;
	gint _tmp4_;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	_tmp1_ = *a;
	_tmp2_ = _tmp1_.row;
	_tmp3_ = *b;
	_tmp4_ = _tmp3_.row;
	if (_tmp2_ == _tmp4_) {
		Coord _tmp5_;
		gint _tmp6_;
		Coord _tmp7_;
		gint _tmp8_;
		_tmp5_ = *a;
		_tmp6_ = _tmp5_.col;
		_tmp7_ = *b;
		_tmp8_ = _tmp7_.col;
		_tmp0_ = _tmp6_ == _tmp8_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


Coord*
coord_dup (const Coord* self)
{
	Coord* dup;
	dup = g_new0 (Coord, 1);
	memcpy (dup, self, sizeof (Coord));
	return dup;
}


void
coord_free (Coord* self)
{
	g_free (self);
}


GType
coord_get_type (void)
{
	static volatile gsize coord_type_id__volatile = 0;
	if (g_once_init_enter (&coord_type_id__volatile)) {
		GType coord_type_id;
		coord_type_id = g_boxed_type_register_static ("Coord", (GBoxedCopyFunc) coord_dup, (GBoxedFreeFunc) coord_free);
		g_once_init_leave (&coord_type_id__volatile, coord_type_id);
	}
	return coord_type_id__volatile;
}


void
cell_init (Cell *self,
           Coord* coord,
           gint val)
{
	Coord _tmp0_;
	g_return_if_fail (coord != NULL);
	memset (self, 0, sizeof (Cell));
	_tmp0_ = *coord;
	(*self).coord = _tmp0_;
	(*self).val = val;
}


gint
cell_hash (Cell* cell)
{
	gint result = 0;
	Cell _tmp0_;
	Coord _tmp1_;
	Cell _tmp2_;
	gint _tmp3_;
	g_return_val_if_fail (cell != NULL, 0);
	_tmp0_ = *cell;
	_tmp1_ = _tmp0_.coord;
	_tmp2_ = *cell;
	_tmp3_ = _tmp2_.val;
	result = (coord_hash (&_tmp1_) * 33) ^ _tmp3_;
	return result;
}


gboolean
cell_equal (Cell* a,
            Cell* b)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	Cell _tmp1_;
	Coord _tmp2_;
	Cell _tmp3_;
	Coord _tmp4_;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	_tmp1_ = *a;
	_tmp2_ = _tmp1_.coord;
	_tmp3_ = *b;
	_tmp4_ = _tmp3_.coord;
	if (coord_equal (&_tmp2_, &_tmp4_)) {
		Cell _tmp5_;
		gint _tmp6_;
		Cell _tmp7_;
		gint _tmp8_;
		_tmp5_ = *a;
		_tmp6_ = _tmp5_.val;
		_tmp7_ = *b;
		_tmp8_ = _tmp7_.val;
		_tmp0_ = _tmp6_ == _tmp8_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


Cell*
cell_dup (const Cell* self)
{
	Cell* dup;
	dup = g_new0 (Cell, 1);
	memcpy (dup, self, sizeof (Cell));
	return dup;
}


void
cell_free (Cell* self)
{
	g_free (self);
}


GType
cell_get_type (void)
{
	static volatile gsize cell_type_id__volatile = 0;
	if (g_once_init_enter (&cell_type_id__volatile)) {
		GType cell_type_id;
		cell_type_id = g_boxed_type_register_static ("Cell", (GBoxedCopyFunc) cell_dup, (GBoxedFreeFunc) cell_free);
		g_once_init_leave (&cell_type_id__volatile, cell_type_id);
	}
	return cell_type_id__volatile;
}


gchar*
difficulty_category_to_string (DifficultyCategory self)
{
	gchar* result = NULL;
	switch (self) {
		case DIFFICULTY_CATEGORY_UNKNOWN:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup (_ ("Unknown Difficulty"));
			result = _tmp0_;
			return result;
		}
		case DIFFICULTY_CATEGORY_EASY:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup (_ ("Easy Difficulty"));
			result = _tmp1_;
			return result;
		}
		case DIFFICULTY_CATEGORY_MEDIUM:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup (_ ("Medium Difficulty"));
			result = _tmp2_;
			return result;
		}
		case DIFFICULTY_CATEGORY_HARD:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup (_ ("Hard Difficulty"));
			result = _tmp3_;
			return result;
		}
		case DIFFICULTY_CATEGORY_VERY_HARD:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup (_ ("Very Hard Difficulty"));
			result = _tmp4_;
			return result;
		}
		case DIFFICULTY_CATEGORY_CUSTOM:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup (_ ("Custom Puzzle"));
			result = _tmp5_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


gchar*
difficulty_category_to_untranslated_string (DifficultyCategory self)
{
	gchar* result = NULL;
	switch (self) {
		case DIFFICULTY_CATEGORY_UNKNOWN:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("Unknown Difficulty");
			result = _tmp0_;
			return result;
		}
		case DIFFICULTY_CATEGORY_EASY:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("Easy Difficulty");
			result = _tmp1_;
			return result;
		}
		case DIFFICULTY_CATEGORY_MEDIUM:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("Medium Difficulty");
			result = _tmp2_;
			return result;
		}
		case DIFFICULTY_CATEGORY_HARD:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("Hard Difficulty");
			result = _tmp3_;
			return result;
		}
		case DIFFICULTY_CATEGORY_VERY_HARD:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("Very Hard Difficulty");
			result = _tmp4_;
			return result;
		}
		case DIFFICULTY_CATEGORY_CUSTOM:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("Custom Puzzle");
			result = _tmp5_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


DifficultyCategory
difficulty_category_from_string (const gchar* input)
{
	DifficultyCategory result = 0;
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	static GQuark _tmp1_label4 = 0;
	static GQuark _tmp1_label5 = 0;
	g_return_val_if_fail (input != NULL, 0);
	_tmp0_ = input;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("Unknown Difficulty")))) {
		switch (0) {
			default:
			{
				result = DIFFICULTY_CATEGORY_UNKNOWN;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("Easy Difficulty")))) {
		switch (0) {
			default:
			{
				result = DIFFICULTY_CATEGORY_EASY;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("Medium Difficulty")))) {
		switch (0) {
			default:
			{
				result = DIFFICULTY_CATEGORY_MEDIUM;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("Hard Difficulty")))) {
		switch (0) {
			default:
			{
				result = DIFFICULTY_CATEGORY_HARD;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("Very Hard Difficulty")))) {
		switch (0) {
			default:
			{
				result = DIFFICULTY_CATEGORY_VERY_HARD;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label5) ? _tmp1_label5 : (_tmp1_label5 = g_quark_from_static_string ("Custom Puzzle")))) {
		switch (0) {
			default:
			{
				result = DIFFICULTY_CATEGORY_CUSTOM;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				g_warning ("sudoku-board.vala:637: Could not parse difficulty level. Falling back " \
"to Easy difficulty");
				result = DIFFICULTY_CATEGORY_EASY;
				return result;
			}
		}
	}
}


GType
difficulty_category_get_type (void)
{
	static volatile gsize difficulty_category_type_id__volatile = 0;
	if (g_once_init_enter (&difficulty_category_type_id__volatile)) {
		static const GEnumValue values[] = {{DIFFICULTY_CATEGORY_UNKNOWN, "DIFFICULTY_CATEGORY_UNKNOWN", "unknown"}, {DIFFICULTY_CATEGORY_EASY, "DIFFICULTY_CATEGORY_EASY", "easy"}, {DIFFICULTY_CATEGORY_MEDIUM, "DIFFICULTY_CATEGORY_MEDIUM", "medium"}, {DIFFICULTY_CATEGORY_HARD, "DIFFICULTY_CATEGORY_HARD", "hard"}, {DIFFICULTY_CATEGORY_VERY_HARD, "DIFFICULTY_CATEGORY_VERY_HARD", "very-hard"}, {DIFFICULTY_CATEGORY_CUSTOM, "DIFFICULTY_CATEGORY_CUSTOM", "custom"}, {0, NULL, NULL}};
		GType difficulty_category_type_id;
		difficulty_category_type_id = g_enum_register_static ("DifficultyCategory", values);
		g_once_init_leave (&difficulty_category_type_id__volatile, difficulty_category_type_id);
	}
	return difficulty_category_type_id__volatile;
}



