/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id: PDFNumsArrayTestCase.java 1233854 2012-01-20 10:39:42Z cbowditch $ */

package org.apache.fop.pdf;

import org.junit.Before;
import org.junit.Test;

import java.io.IOException;

/**
 * Test case for {@link PDFNumsArray}.
 */
public class PDFNumsArrayTestCase extends PDFObjectTestCase {
    private PDFNumsArray numsArray;
    private String expectedString = "[0 /Test#20name 1 10]";

    @Before
    public void setUp() {
        numsArray = new PDFNumsArray(parent);
        numsArray.put(0, new PDFName("Test name"));
        PDFNumber num = new PDFNumber();
        num.setNumber(10);
        numsArray.put(1, num);
        numsArray.setDocument(doc);

        pdfObjectUnderTest = numsArray;
    }

    /**
     * Test output() - ensure that this object is properly outputted to the PDF document.
     * @throws IOException if an I/O error occurs
     */
    @Test
    public void testOutput() throws IOException {
        testOutputStreams(expectedString, numsArray);
    }
}
