%%
%% %CopyrightBegin%
%% 
%% Copyright Ericsson AB 2004-2009. All Rights Reserved.
%% 
%% Licensed under the Apache License, Version 2.0 (the "License");
%% you may not use this file except in compliance with the License.
%% You may obtain a copy of the License at
%%
%%     http://www.apache.org/licenses/LICENSE-2.0
%%
%% Unless required by applicable law or agreed to in writing, software
%% distributed under the License is distributed on an "AS IS" BASIS,
%% WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%% See the License for the specific language governing permissions and
%% limitations under the License.
%% 
%% %CopyrightEnd%
%%
-module(otp_5151).

-export([?MODULE/0]).
-export([read_variables/1,read_variables_1/1,read_variables_2/1,
	 read_variables_3/1,read_variables_4/1]).

?MODULE() ->
    ok.

read_variables(Name) ->
    case file:consult(Name) of
	{ok,Vars} -> Vars;
	{error,Reason} ->
	    erlang:error({bad_installation,file:format_error(Reason)}, [Name])
    end.

read_variables_1(Name) ->
    case file:consult(Name) of
	{ok,Vars} -> Vars;
	{error,Reason} ->
	    erlang:error({bad_installation,file:format_error(Reason)})
    end.

read_variables_2(Name) ->
    case file:consult(Name) of
	{ok,Vars} -> Vars;
	{error,Reason} ->
	    erlang:error({bad_installation,file:format_error(Reason)}, [Name])
    end.

read_variables_3(Name) ->
    case file:consult(Name) of
	{ok,Vars} -> Vars;
	{error,Reason} ->
	    erlang:error({bad_installation,file:format_error(Reason)})
    end.

read_variables_4(Name) ->
    case file:consult(Name) of
	{ok,Vars} -> Vars;
	{error,Reason} ->
	    exit({bad_installation,file:format_error(Reason)})
    end.
