/* SPDX-License-Identifier: BSD-3-Clause
 * Copyright (c) 2016 - 2018 Cavium Inc.
 * All rights reserved.
 * www.cavium.com
 */

#ifndef __RT_DEFS_H__
#define __RT_DEFS_H__

/* Runtime array offsets */
#define DORQ_REG_PF_MAX_ICID_0_RT_OFFSET                            0
#define DORQ_REG_PF_MAX_ICID_1_RT_OFFSET                            1
#define DORQ_REG_PF_MAX_ICID_2_RT_OFFSET                            2
#define DORQ_REG_PF_MAX_ICID_3_RT_OFFSET                            3
#define DORQ_REG_PF_MAX_ICID_4_RT_OFFSET                            4
#define DORQ_REG_PF_MAX_ICID_5_RT_OFFSET                            5
#define DORQ_REG_PF_MAX_ICID_6_RT_OFFSET                            6
#define DORQ_REG_PF_MAX_ICID_7_RT_OFFSET                            7
#define DORQ_REG_VF_MAX_ICID_0_RT_OFFSET                            8
#define DORQ_REG_VF_MAX_ICID_1_RT_OFFSET                            9
#define DORQ_REG_VF_MAX_ICID_2_RT_OFFSET                            10
#define DORQ_REG_VF_MAX_ICID_3_RT_OFFSET                            11
#define DORQ_REG_VF_MAX_ICID_4_RT_OFFSET                            12
#define DORQ_REG_VF_MAX_ICID_5_RT_OFFSET                            13
#define DORQ_REG_VF_MAX_ICID_6_RT_OFFSET                            14
#define DORQ_REG_VF_MAX_ICID_7_RT_OFFSET                            15
#define DORQ_REG_VF_ICID_BIT_SHIFT_NORM_RT_OFFSET                   16
#define DORQ_REG_PF_WAKE_ALL_RT_OFFSET                              17
#define DORQ_REG_TAG1_ETHERTYPE_RT_OFFSET                           18
#define IGU_REG_PF_CONFIGURATION_RT_OFFSET                          19
#define IGU_REG_VF_CONFIGURATION_RT_OFFSET                          20
#define IGU_REG_ATTN_MSG_ADDR_L_RT_OFFSET                           21
#define IGU_REG_ATTN_MSG_ADDR_H_RT_OFFSET                           22
#define IGU_REG_LEADING_EDGE_LATCH_RT_OFFSET                        23
#define IGU_REG_TRAILING_EDGE_LATCH_RT_OFFSET                       24
#define CAU_REG_CQE_AGG_UNIT_SIZE_RT_OFFSET                         25
#define CAU_REG_SB_VAR_MEMORY_RT_OFFSET                             26
#define CAU_REG_SB_VAR_MEMORY_RT_SIZE                               736
#define CAU_REG_SB_ADDR_MEMORY_RT_OFFSET                            762
#define CAU_REG_SB_ADDR_MEMORY_RT_SIZE                              736
#define CAU_REG_PI_MEMORY_RT_OFFSET                                 1498
#define CAU_REG_PI_MEMORY_RT_SIZE                                   4416
#define PRS_REG_SEARCH_RESP_INITIATOR_TYPE_RT_OFFSET                5914
#define PRS_REG_TASK_ID_MAX_INITIATOR_PF_RT_OFFSET                  5915
#define PRS_REG_TASK_ID_MAX_INITIATOR_VF_RT_OFFSET                  5916
#define PRS_REG_TASK_ID_MAX_TARGET_PF_RT_OFFSET                     5917
#define PRS_REG_TASK_ID_MAX_TARGET_VF_RT_OFFSET                     5918
#define PRS_REG_SEARCH_TCP_RT_OFFSET                                5919
#define PRS_REG_SEARCH_FCOE_RT_OFFSET                               5920
#define PRS_REG_SEARCH_ROCE_RT_OFFSET                               5921
#define PRS_REG_ROCE_DEST_QP_MAX_VF_RT_OFFSET                       5922
#define PRS_REG_ROCE_DEST_QP_MAX_PF_RT_OFFSET                       5923
#define PRS_REG_SEARCH_OPENFLOW_RT_OFFSET                           5924
#define PRS_REG_SEARCH_NON_IP_AS_OPENFLOW_RT_OFFSET                 5925
#define PRS_REG_OPENFLOW_SUPPORT_ONLY_KNOWN_OVER_IP_RT_OFFSET       5926
#define PRS_REG_OPENFLOW_SEARCH_KEY_MASK_RT_OFFSET                  5927
#define PRS_REG_TAG_ETHERTYPE_0_RT_OFFSET                           5928
#define PRS_REG_LIGHT_L2_ETHERTYPE_EN_RT_OFFSET                     5929
#define SRC_REG_FIRSTFREE_RT_OFFSET                                 5930
#define SRC_REG_FIRSTFREE_RT_SIZE                                   2
#define SRC_REG_LASTFREE_RT_OFFSET                                  5932
#define SRC_REG_LASTFREE_RT_SIZE                                    2
#define SRC_REG_COUNTFREE_RT_OFFSET                                 5934
#define SRC_REG_NUMBER_HASH_BITS_RT_OFFSET                          5935
#define PSWRQ2_REG_CDUT_P_SIZE_RT_OFFSET                            5936
#define PSWRQ2_REG_CDUC_P_SIZE_RT_OFFSET                            5937
#define PSWRQ2_REG_TM_P_SIZE_RT_OFFSET                              5938
#define PSWRQ2_REG_QM_P_SIZE_RT_OFFSET                              5939
#define PSWRQ2_REG_SRC_P_SIZE_RT_OFFSET                             5940
#define PSWRQ2_REG_TSDM_P_SIZE_RT_OFFSET                            5941
#define PSWRQ2_REG_TM_FIRST_ILT_RT_OFFSET                           5942
#define PSWRQ2_REG_TM_LAST_ILT_RT_OFFSET                            5943
#define PSWRQ2_REG_QM_FIRST_ILT_RT_OFFSET                           5944
#define PSWRQ2_REG_QM_LAST_ILT_RT_OFFSET                            5945
#define PSWRQ2_REG_SRC_FIRST_ILT_RT_OFFSET                          5946
#define PSWRQ2_REG_SRC_LAST_ILT_RT_OFFSET                           5947
#define PSWRQ2_REG_CDUC_FIRST_ILT_RT_OFFSET                         5948
#define PSWRQ2_REG_CDUC_LAST_ILT_RT_OFFSET                          5949
#define PSWRQ2_REG_CDUT_FIRST_ILT_RT_OFFSET                         5950
#define PSWRQ2_REG_CDUT_LAST_ILT_RT_OFFSET                          5951
#define PSWRQ2_REG_TSDM_FIRST_ILT_RT_OFFSET                         5952
#define PSWRQ2_REG_TSDM_LAST_ILT_RT_OFFSET                          5953
#define PSWRQ2_REG_TM_NUMBER_OF_PF_BLOCKS_RT_OFFSET                 5954
#define PSWRQ2_REG_CDUT_NUMBER_OF_PF_BLOCKS_RT_OFFSET               5955
#define PSWRQ2_REG_CDUC_NUMBER_OF_PF_BLOCKS_RT_OFFSET               5956
#define PSWRQ2_REG_TM_VF_BLOCKS_RT_OFFSET                           5957
#define PSWRQ2_REG_CDUT_VF_BLOCKS_RT_OFFSET                         5958
#define PSWRQ2_REG_CDUC_VF_BLOCKS_RT_OFFSET                         5959
#define PSWRQ2_REG_TM_BLOCKS_FACTOR_RT_OFFSET                       5960
#define PSWRQ2_REG_CDUT_BLOCKS_FACTOR_RT_OFFSET                     5961
#define PSWRQ2_REG_CDUC_BLOCKS_FACTOR_RT_OFFSET                     5962
#define PSWRQ2_REG_VF_BASE_RT_OFFSET                                5963
#define PSWRQ2_REG_VF_LAST_ILT_RT_OFFSET                            5964
#define PSWRQ2_REG_DRAM_ALIGN_WR_RT_OFFSET                          5965
#define PSWRQ2_REG_DRAM_ALIGN_RD_RT_OFFSET                          5966
#define PSWRQ2_REG_ILT_MEMORY_RT_OFFSET                             5967
#define PSWRQ2_REG_ILT_MEMORY_RT_SIZE                               22000
#define PGLUE_REG_B_VF_BASE_RT_OFFSET                               27967
#define PGLUE_REG_B_MSDM_OFFSET_MASK_B_RT_OFFSET                    27968
#define PGLUE_REG_B_MSDM_VF_SHIFT_B_RT_OFFSET                       27969
#define PGLUE_REG_B_CACHE_LINE_SIZE_RT_OFFSET                       27970
#define PGLUE_REG_B_PF_BAR0_SIZE_RT_OFFSET                          27971
#define PGLUE_REG_B_PF_BAR1_SIZE_RT_OFFSET                          27972
#define PGLUE_REG_B_VF_BAR1_SIZE_RT_OFFSET                          27973
#define TM_REG_VF_ENABLE_CONN_RT_OFFSET                             27974
#define TM_REG_PF_ENABLE_CONN_RT_OFFSET                             27975
#define TM_REG_PF_ENABLE_TASK_RT_OFFSET                             27976
#define TM_REG_GROUP_SIZE_RESOLUTION_CONN_RT_OFFSET                 27977
#define TM_REG_GROUP_SIZE_RESOLUTION_TASK_RT_OFFSET                 27978
#define TM_REG_CONFIG_CONN_MEM_RT_OFFSET                            27979
#define TM_REG_CONFIG_CONN_MEM_RT_SIZE                              416
#define TM_REG_CONFIG_TASK_MEM_RT_OFFSET                            28395
#define TM_REG_CONFIG_TASK_MEM_RT_SIZE                              512
#define QM_REG_MAXPQSIZE_0_RT_OFFSET                                28907
#define QM_REG_MAXPQSIZE_1_RT_OFFSET                                28908
#define QM_REG_MAXPQSIZE_2_RT_OFFSET                                28909
#define QM_REG_MAXPQSIZETXSEL_0_RT_OFFSET                           28910
#define QM_REG_MAXPQSIZETXSEL_1_RT_OFFSET                           28911
#define QM_REG_MAXPQSIZETXSEL_2_RT_OFFSET                           28912
#define QM_REG_MAXPQSIZETXSEL_3_RT_OFFSET                           28913
#define QM_REG_MAXPQSIZETXSEL_4_RT_OFFSET                           28914
#define QM_REG_MAXPQSIZETXSEL_5_RT_OFFSET                           28915
#define QM_REG_MAXPQSIZETXSEL_6_RT_OFFSET                           28916
#define QM_REG_MAXPQSIZETXSEL_7_RT_OFFSET                           28917
#define QM_REG_MAXPQSIZETXSEL_8_RT_OFFSET                           28918
#define QM_REG_MAXPQSIZETXSEL_9_RT_OFFSET                           28919
#define QM_REG_MAXPQSIZETXSEL_10_RT_OFFSET                          28920
#define QM_REG_MAXPQSIZETXSEL_11_RT_OFFSET                          28921
#define QM_REG_MAXPQSIZETXSEL_12_RT_OFFSET                          28922
#define QM_REG_MAXPQSIZETXSEL_13_RT_OFFSET                          28923
#define QM_REG_MAXPQSIZETXSEL_14_RT_OFFSET                          28924
#define QM_REG_MAXPQSIZETXSEL_15_RT_OFFSET                          28925
#define QM_REG_MAXPQSIZETXSEL_16_RT_OFFSET                          28926
#define QM_REG_MAXPQSIZETXSEL_17_RT_OFFSET                          28927
#define QM_REG_MAXPQSIZETXSEL_18_RT_OFFSET                          28928
#define QM_REG_MAXPQSIZETXSEL_19_RT_OFFSET                          28929
#define QM_REG_MAXPQSIZETXSEL_20_RT_OFFSET                          28930
#define QM_REG_MAXPQSIZETXSEL_21_RT_OFFSET                          28931
#define QM_REG_MAXPQSIZETXSEL_22_RT_OFFSET                          28932
#define QM_REG_MAXPQSIZETXSEL_23_RT_OFFSET                          28933
#define QM_REG_MAXPQSIZETXSEL_24_RT_OFFSET                          28934
#define QM_REG_MAXPQSIZETXSEL_25_RT_OFFSET                          28935
#define QM_REG_MAXPQSIZETXSEL_26_RT_OFFSET                          28936
#define QM_REG_MAXPQSIZETXSEL_27_RT_OFFSET                          28937
#define QM_REG_MAXPQSIZETXSEL_28_RT_OFFSET                          28938
#define QM_REG_MAXPQSIZETXSEL_29_RT_OFFSET                          28939
#define QM_REG_MAXPQSIZETXSEL_30_RT_OFFSET                          28940
#define QM_REG_MAXPQSIZETXSEL_31_RT_OFFSET                          28941
#define QM_REG_MAXPQSIZETXSEL_32_RT_OFFSET                          28942
#define QM_REG_MAXPQSIZETXSEL_33_RT_OFFSET                          28943
#define QM_REG_MAXPQSIZETXSEL_34_RT_OFFSET                          28944
#define QM_REG_MAXPQSIZETXSEL_35_RT_OFFSET                          28945
#define QM_REG_MAXPQSIZETXSEL_36_RT_OFFSET                          28946
#define QM_REG_MAXPQSIZETXSEL_37_RT_OFFSET                          28947
#define QM_REG_MAXPQSIZETXSEL_38_RT_OFFSET                          28948
#define QM_REG_MAXPQSIZETXSEL_39_RT_OFFSET                          28949
#define QM_REG_MAXPQSIZETXSEL_40_RT_OFFSET                          28950
#define QM_REG_MAXPQSIZETXSEL_41_RT_OFFSET                          28951
#define QM_REG_MAXPQSIZETXSEL_42_RT_OFFSET                          28952
#define QM_REG_MAXPQSIZETXSEL_43_RT_OFFSET                          28953
#define QM_REG_MAXPQSIZETXSEL_44_RT_OFFSET                          28954
#define QM_REG_MAXPQSIZETXSEL_45_RT_OFFSET                          28955
#define QM_REG_MAXPQSIZETXSEL_46_RT_OFFSET                          28956
#define QM_REG_MAXPQSIZETXSEL_47_RT_OFFSET                          28957
#define QM_REG_MAXPQSIZETXSEL_48_RT_OFFSET                          28958
#define QM_REG_MAXPQSIZETXSEL_49_RT_OFFSET                          28959
#define QM_REG_MAXPQSIZETXSEL_50_RT_OFFSET                          28960
#define QM_REG_MAXPQSIZETXSEL_51_RT_OFFSET                          28961
#define QM_REG_MAXPQSIZETXSEL_52_RT_OFFSET                          28962
#define QM_REG_MAXPQSIZETXSEL_53_RT_OFFSET                          28963
#define QM_REG_MAXPQSIZETXSEL_54_RT_OFFSET                          28964
#define QM_REG_MAXPQSIZETXSEL_55_RT_OFFSET                          28965
#define QM_REG_MAXPQSIZETXSEL_56_RT_OFFSET                          28966
#define QM_REG_MAXPQSIZETXSEL_57_RT_OFFSET                          28967
#define QM_REG_MAXPQSIZETXSEL_58_RT_OFFSET                          28968
#define QM_REG_MAXPQSIZETXSEL_59_RT_OFFSET                          28969
#define QM_REG_MAXPQSIZETXSEL_60_RT_OFFSET                          28970
#define QM_REG_MAXPQSIZETXSEL_61_RT_OFFSET                          28971
#define QM_REG_MAXPQSIZETXSEL_62_RT_OFFSET                          28972
#define QM_REG_MAXPQSIZETXSEL_63_RT_OFFSET                          28973
#define QM_REG_BASEADDROTHERPQ_RT_OFFSET                            28974
#define QM_REG_BASEADDROTHERPQ_RT_SIZE                              128
#define QM_REG_PTRTBLOTHER_RT_OFFSET                                29102
#define QM_REG_PTRTBLOTHER_RT_SIZE                                  256
#define QM_REG_VOQCRDLINE_RT_OFFSET                                 29358
#define QM_REG_VOQCRDLINE_RT_SIZE                                   20
#define QM_REG_VOQINITCRDLINE_RT_OFFSET                             29378
#define QM_REG_VOQINITCRDLINE_RT_SIZE                               20
#define QM_REG_AFULLQMBYPTHRPFWFQ_RT_OFFSET                         29398
#define QM_REG_AFULLQMBYPTHRVPWFQ_RT_OFFSET                         29399
#define QM_REG_AFULLQMBYPTHRPFRL_RT_OFFSET                          29400
#define QM_REG_AFULLQMBYPTHRGLBLRL_RT_OFFSET                        29401
#define QM_REG_AFULLOPRTNSTCCRDMASK_RT_OFFSET                       29402
#define QM_REG_WRROTHERPQGRP_0_RT_OFFSET                            29403
#define QM_REG_WRROTHERPQGRP_1_RT_OFFSET                            29404
#define QM_REG_WRROTHERPQGRP_2_RT_OFFSET                            29405
#define QM_REG_WRROTHERPQGRP_3_RT_OFFSET                            29406
#define QM_REG_WRROTHERPQGRP_4_RT_OFFSET                            29407
#define QM_REG_WRROTHERPQGRP_5_RT_OFFSET                            29408
#define QM_REG_WRROTHERPQGRP_6_RT_OFFSET                            29409
#define QM_REG_WRROTHERPQGRP_7_RT_OFFSET                            29410
#define QM_REG_WRROTHERPQGRP_8_RT_OFFSET                            29411
#define QM_REG_WRROTHERPQGRP_9_RT_OFFSET                            29412
#define QM_REG_WRROTHERPQGRP_10_RT_OFFSET                           29413
#define QM_REG_WRROTHERPQGRP_11_RT_OFFSET                           29414
#define QM_REG_WRROTHERPQGRP_12_RT_OFFSET                           29415
#define QM_REG_WRROTHERPQGRP_13_RT_OFFSET                           29416
#define QM_REG_WRROTHERPQGRP_14_RT_OFFSET                           29417
#define QM_REG_WRROTHERPQGRP_15_RT_OFFSET                           29418
#define QM_REG_WRROTHERGRPWEIGHT_0_RT_OFFSET                        29419
#define QM_REG_WRROTHERGRPWEIGHT_1_RT_OFFSET                        29420
#define QM_REG_WRROTHERGRPWEIGHT_2_RT_OFFSET                        29421
#define QM_REG_WRROTHERGRPWEIGHT_3_RT_OFFSET                        29422
#define QM_REG_WRRTXGRPWEIGHT_0_RT_OFFSET                           29423
#define QM_REG_WRRTXGRPWEIGHT_1_RT_OFFSET                           29424
#define QM_REG_PQTX2PF_0_RT_OFFSET                                  29425
#define QM_REG_PQTX2PF_1_RT_OFFSET                                  29426
#define QM_REG_PQTX2PF_2_RT_OFFSET                                  29427
#define QM_REG_PQTX2PF_3_RT_OFFSET                                  29428
#define QM_REG_PQTX2PF_4_RT_OFFSET                                  29429
#define QM_REG_PQTX2PF_5_RT_OFFSET                                  29430
#define QM_REG_PQTX2PF_6_RT_OFFSET                                  29431
#define QM_REG_PQTX2PF_7_RT_OFFSET                                  29432
#define QM_REG_PQTX2PF_8_RT_OFFSET                                  29433
#define QM_REG_PQTX2PF_9_RT_OFFSET                                  29434
#define QM_REG_PQTX2PF_10_RT_OFFSET                                 29435
#define QM_REG_PQTX2PF_11_RT_OFFSET                                 29436
#define QM_REG_PQTX2PF_12_RT_OFFSET                                 29437
#define QM_REG_PQTX2PF_13_RT_OFFSET                                 29438
#define QM_REG_PQTX2PF_14_RT_OFFSET                                 29439
#define QM_REG_PQTX2PF_15_RT_OFFSET                                 29440
#define QM_REG_PQTX2PF_16_RT_OFFSET                                 29441
#define QM_REG_PQTX2PF_17_RT_OFFSET                                 29442
#define QM_REG_PQTX2PF_18_RT_OFFSET                                 29443
#define QM_REG_PQTX2PF_19_RT_OFFSET                                 29444
#define QM_REG_PQTX2PF_20_RT_OFFSET                                 29445
#define QM_REG_PQTX2PF_21_RT_OFFSET                                 29446
#define QM_REG_PQTX2PF_22_RT_OFFSET                                 29447
#define QM_REG_PQTX2PF_23_RT_OFFSET                                 29448
#define QM_REG_PQTX2PF_24_RT_OFFSET                                 29449
#define QM_REG_PQTX2PF_25_RT_OFFSET                                 29450
#define QM_REG_PQTX2PF_26_RT_OFFSET                                 29451
#define QM_REG_PQTX2PF_27_RT_OFFSET                                 29452
#define QM_REG_PQTX2PF_28_RT_OFFSET                                 29453
#define QM_REG_PQTX2PF_29_RT_OFFSET                                 29454
#define QM_REG_PQTX2PF_30_RT_OFFSET                                 29455
#define QM_REG_PQTX2PF_31_RT_OFFSET                                 29456
#define QM_REG_PQTX2PF_32_RT_OFFSET                                 29457
#define QM_REG_PQTX2PF_33_RT_OFFSET                                 29458
#define QM_REG_PQTX2PF_34_RT_OFFSET                                 29459
#define QM_REG_PQTX2PF_35_RT_OFFSET                                 29460
#define QM_REG_PQTX2PF_36_RT_OFFSET                                 29461
#define QM_REG_PQTX2PF_37_RT_OFFSET                                 29462
#define QM_REG_PQTX2PF_38_RT_OFFSET                                 29463
#define QM_REG_PQTX2PF_39_RT_OFFSET                                 29464
#define QM_REG_PQTX2PF_40_RT_OFFSET                                 29465
#define QM_REG_PQTX2PF_41_RT_OFFSET                                 29466
#define QM_REG_PQTX2PF_42_RT_OFFSET                                 29467
#define QM_REG_PQTX2PF_43_RT_OFFSET                                 29468
#define QM_REG_PQTX2PF_44_RT_OFFSET                                 29469
#define QM_REG_PQTX2PF_45_RT_OFFSET                                 29470
#define QM_REG_PQTX2PF_46_RT_OFFSET                                 29471
#define QM_REG_PQTX2PF_47_RT_OFFSET                                 29472
#define QM_REG_PQTX2PF_48_RT_OFFSET                                 29473
#define QM_REG_PQTX2PF_49_RT_OFFSET                                 29474
#define QM_REG_PQTX2PF_50_RT_OFFSET                                 29475
#define QM_REG_PQTX2PF_51_RT_OFFSET                                 29476
#define QM_REG_PQTX2PF_52_RT_OFFSET                                 29477
#define QM_REG_PQTX2PF_53_RT_OFFSET                                 29478
#define QM_REG_PQTX2PF_54_RT_OFFSET                                 29479
#define QM_REG_PQTX2PF_55_RT_OFFSET                                 29480
#define QM_REG_PQTX2PF_56_RT_OFFSET                                 29481
#define QM_REG_PQTX2PF_57_RT_OFFSET                                 29482
#define QM_REG_PQTX2PF_58_RT_OFFSET                                 29483
#define QM_REG_PQTX2PF_59_RT_OFFSET                                 29484
#define QM_REG_PQTX2PF_60_RT_OFFSET                                 29485
#define QM_REG_PQTX2PF_61_RT_OFFSET                                 29486
#define QM_REG_PQTX2PF_62_RT_OFFSET                                 29487
#define QM_REG_PQTX2PF_63_RT_OFFSET                                 29488
#define QM_REG_PQOTHER2PF_0_RT_OFFSET                               29489
#define QM_REG_PQOTHER2PF_1_RT_OFFSET                               29490
#define QM_REG_PQOTHER2PF_2_RT_OFFSET                               29491
#define QM_REG_PQOTHER2PF_3_RT_OFFSET                               29492
#define QM_REG_PQOTHER2PF_4_RT_OFFSET                               29493
#define QM_REG_PQOTHER2PF_5_RT_OFFSET                               29494
#define QM_REG_PQOTHER2PF_6_RT_OFFSET                               29495
#define QM_REG_PQOTHER2PF_7_RT_OFFSET                               29496
#define QM_REG_PQOTHER2PF_8_RT_OFFSET                               29497
#define QM_REG_PQOTHER2PF_9_RT_OFFSET                               29498
#define QM_REG_PQOTHER2PF_10_RT_OFFSET                              29499
#define QM_REG_PQOTHER2PF_11_RT_OFFSET                              29500
#define QM_REG_PQOTHER2PF_12_RT_OFFSET                              29501
#define QM_REG_PQOTHER2PF_13_RT_OFFSET                              29502
#define QM_REG_PQOTHER2PF_14_RT_OFFSET                              29503
#define QM_REG_PQOTHER2PF_15_RT_OFFSET                              29504
#define QM_REG_RLGLBLPERIOD_0_RT_OFFSET                             29505
#define QM_REG_RLGLBLPERIOD_1_RT_OFFSET                             29506
#define QM_REG_RLGLBLPERIODTIMER_0_RT_OFFSET                        29507
#define QM_REG_RLGLBLPERIODTIMER_1_RT_OFFSET                        29508
#define QM_REG_RLGLBLPERIODSEL_0_RT_OFFSET                          29509
#define QM_REG_RLGLBLPERIODSEL_1_RT_OFFSET                          29510
#define QM_REG_RLGLBLPERIODSEL_2_RT_OFFSET                          29511
#define QM_REG_RLGLBLPERIODSEL_3_RT_OFFSET                          29512
#define QM_REG_RLGLBLPERIODSEL_4_RT_OFFSET                          29513
#define QM_REG_RLGLBLPERIODSEL_5_RT_OFFSET                          29514
#define QM_REG_RLGLBLPERIODSEL_6_RT_OFFSET                          29515
#define QM_REG_RLGLBLPERIODSEL_7_RT_OFFSET                          29516
#define QM_REG_RLGLBLINCVAL_RT_OFFSET                               29517
#define QM_REG_RLGLBLINCVAL_RT_SIZE                                 256
#define QM_REG_RLGLBLUPPERBOUND_RT_OFFSET                           29773
#define QM_REG_RLGLBLUPPERBOUND_RT_SIZE                             256
#define QM_REG_RLGLBLCRD_RT_OFFSET                                  30029
#define QM_REG_RLGLBLCRD_RT_SIZE                                    256
#define QM_REG_RLGLBLENABLE_RT_OFFSET                               30285
#define QM_REG_RLPFPERIOD_RT_OFFSET                                 30286
#define QM_REG_RLPFPERIODTIMER_RT_OFFSET                            30287
#define QM_REG_RLPFINCVAL_RT_OFFSET                                 30288
#define QM_REG_RLPFINCVAL_RT_SIZE                                   16
#define QM_REG_RLPFUPPERBOUND_RT_OFFSET                             30304
#define QM_REG_RLPFUPPERBOUND_RT_SIZE                               16
#define QM_REG_RLPFCRD_RT_OFFSET                                    30320
#define QM_REG_RLPFCRD_RT_SIZE                                      16
#define QM_REG_RLPFENABLE_RT_OFFSET                                 30336
#define QM_REG_RLPFVOQENABLE_RT_OFFSET                              30337
#define QM_REG_WFQPFWEIGHT_RT_OFFSET                                30338
#define QM_REG_WFQPFWEIGHT_RT_SIZE                                  16
#define QM_REG_WFQPFUPPERBOUND_RT_OFFSET                            30354
#define QM_REG_WFQPFUPPERBOUND_RT_SIZE                              16
#define QM_REG_WFQPFCRD_RT_OFFSET                                   30370
#define QM_REG_WFQPFCRD_RT_SIZE                                     160
#define QM_REG_WFQPFENABLE_RT_OFFSET                                30530
#define QM_REG_WFQVPENABLE_RT_OFFSET                                30531
#define QM_REG_BASEADDRTXPQ_RT_OFFSET                               30532
#define QM_REG_BASEADDRTXPQ_RT_SIZE                                 512
#define QM_REG_TXPQMAP_RT_OFFSET                                    31044
#define QM_REG_TXPQMAP_RT_SIZE                                      512
#define QM_REG_WFQVPWEIGHT_RT_OFFSET                                31556
#define QM_REG_WFQVPWEIGHT_RT_SIZE                                  512
#define QM_REG_WFQVPCRD_RT_OFFSET                                   32068
#define QM_REG_WFQVPCRD_RT_SIZE                                     512
#define QM_REG_WFQVPMAP_RT_OFFSET                                   32580
#define QM_REG_WFQVPMAP_RT_SIZE                                     512
#define QM_REG_PTRTBLTX_RT_OFFSET                                   33092
#define QM_REG_PTRTBLTX_RT_SIZE                                     1024
#define QM_REG_WFQPFCRD_MSB_RT_OFFSET                               34116
#define QM_REG_WFQPFCRD_MSB_RT_SIZE                                 160
#define NIG_REG_TAG_ETHERTYPE_0_RT_OFFSET                           34276
#define NIG_REG_BRB_GATE_DNTFWD_PORT_RT_OFFSET                      34277
#define NIG_REG_OUTER_TAG_VALUE_LIST0_RT_OFFSET                     34278
#define NIG_REG_OUTER_TAG_VALUE_LIST1_RT_OFFSET                     34279
#define NIG_REG_OUTER_TAG_VALUE_LIST2_RT_OFFSET                     34280
#define NIG_REG_OUTER_TAG_VALUE_LIST3_RT_OFFSET                     34281
#define NIG_REG_LLH_FUNC_TAGMAC_CLS_TYPE_RT_OFFSET                  34282
#define NIG_REG_LLH_FUNC_TAG_EN_RT_OFFSET                           34283
#define NIG_REG_LLH_FUNC_TAG_EN_RT_SIZE                             4
#define NIG_REG_LLH_FUNC_TAG_VALUE_RT_OFFSET                        34287
#define NIG_REG_LLH_FUNC_TAG_VALUE_RT_SIZE                          4
#define NIG_REG_LLH_FUNC_FILTER_VALUE_RT_OFFSET                     34291
#define NIG_REG_LLH_FUNC_FILTER_VALUE_RT_SIZE                       32
#define NIG_REG_LLH_FUNC_FILTER_EN_RT_OFFSET                        34323
#define NIG_REG_LLH_FUNC_FILTER_EN_RT_SIZE                          16
#define NIG_REG_LLH_FUNC_FILTER_MODE_RT_OFFSET                      34339
#define NIG_REG_LLH_FUNC_FILTER_MODE_RT_SIZE                        16
#define NIG_REG_LLH_FUNC_FILTER_PROTOCOL_TYPE_RT_OFFSET             34355
#define NIG_REG_LLH_FUNC_FILTER_PROTOCOL_TYPE_RT_SIZE               16
#define NIG_REG_LLH_FUNC_FILTER_HDR_SEL_RT_OFFSET                   34371
#define NIG_REG_LLH_FUNC_FILTER_HDR_SEL_RT_SIZE                     16
#define NIG_REG_TX_EDPM_CTRL_RT_OFFSET                              34387
#define NIG_REG_PPF_TO_ENGINE_SEL_RT_OFFSET                         34388
#define NIG_REG_PPF_TO_ENGINE_SEL_RT_SIZE                           8
#define CDU_REG_CID_ADDR_PARAMS_RT_OFFSET                           34396
#define CDU_REG_SEGMENT0_PARAMS_RT_OFFSET                           34397
#define CDU_REG_SEGMENT1_PARAMS_RT_OFFSET                           34398
#define CDU_REG_PF_SEG0_TYPE_OFFSET_RT_OFFSET                       34399
#define CDU_REG_PF_SEG1_TYPE_OFFSET_RT_OFFSET                       34400
#define CDU_REG_PF_SEG2_TYPE_OFFSET_RT_OFFSET                       34401
#define CDU_REG_PF_SEG3_TYPE_OFFSET_RT_OFFSET                       34402
#define CDU_REG_PF_FL_SEG0_TYPE_OFFSET_RT_OFFSET                    34403
#define CDU_REG_PF_FL_SEG1_TYPE_OFFSET_RT_OFFSET                    34404
#define CDU_REG_PF_FL_SEG2_TYPE_OFFSET_RT_OFFSET                    34405
#define CDU_REG_PF_FL_SEG3_TYPE_OFFSET_RT_OFFSET                    34406
#define CDU_REG_VF_SEG_TYPE_OFFSET_RT_OFFSET                        34407
#define CDU_REG_VF_FL_SEG_TYPE_OFFSET_RT_OFFSET                     34408
#define PBF_REG_TAG_ETHERTYPE_0_RT_OFFSET                           34409
#define PBF_REG_BTB_SHARED_AREA_SIZE_RT_OFFSET                      34410
#define PBF_REG_YCMD_QS_NUM_LINES_VOQ0_RT_OFFSET                    34411
#define PBF_REG_BTB_GUARANTEED_VOQ0_RT_OFFSET                       34412
#define PBF_REG_BTB_SHARED_AREA_SETUP_VOQ0_RT_OFFSET                34413
#define PBF_REG_YCMD_QS_NUM_LINES_VOQ1_RT_OFFSET                    34414
#define PBF_REG_BTB_GUARANTEED_VOQ1_RT_OFFSET                       34415
#define PBF_REG_BTB_SHARED_AREA_SETUP_VOQ1_RT_OFFSET                34416
#define PBF_REG_YCMD_QS_NUM_LINES_VOQ2_RT_OFFSET                    34417
#define PBF_REG_BTB_GUARANTEED_VOQ2_RT_OFFSET                       34418
#define PBF_REG_BTB_SHARED_AREA_SETUP_VOQ2_RT_OFFSET                34419
#define PBF_REG_YCMD_QS_NUM_LINES_VOQ3_RT_OFFSET                    34420
#define PBF_REG_BTB_GUARANTEED_VOQ3_RT_OFFSET                       34421
#define PBF_REG_BTB_SHARED_AREA_SETUP_VOQ3_RT_OFFSET                34422
#define PBF_REG_YCMD_QS_NUM_LINES_VOQ4_RT_OFFSET                    34423
#define PBF_REG_BTB_GUARANTEED_VOQ4_RT_OFFSET                       34424
#define PBF_REG_BTB_SHARED_AREA_SETUP_VOQ4_RT_OFFSET                34425
#define PBF_REG_YCMD_QS_NUM_LINES_VOQ5_RT_OFFSET                    34426
#define PBF_REG_BTB_GUARANTEED_VOQ5_RT_OFFSET                       34427
#define PBF_REG_BTB_SHARED_AREA_SETUP_VOQ5_RT_OFFSET                34428
#define PBF_REG_YCMD_QS_NUM_LINES_VOQ6_RT_OFFSET                    34429
#define PBF_REG_BTB_GUARANTEED_VOQ6_RT_OFFSET                       34430
#define PBF_REG_BTB_SHARED_AREA_SETUP_VOQ6_RT_OFFSET                34431
#define PBF_REG_YCMD_QS_NUM_LINES_VOQ7_RT_OFFSET                    34432
#define PBF_REG_BTB_GUARANTEED_VOQ7_RT_OFFSET                       34433
#define PBF_REG_BTB_SHARED_AREA_SETUP_VOQ7_RT_OFFSET                34434
#define PBF_REG_YCMD_QS_NUM_LINES_VOQ8_RT_OFFSET                    34435
#define PBF_REG_BTB_GUARANTEED_VOQ8_RT_OFFSET                       34436
#define PBF_REG_BTB_SHARED_AREA_SETUP_VOQ8_RT_OFFSET                34437
#define PBF_REG_YCMD_QS_NUM_LINES_VOQ9_RT_OFFSET                    34438
#define PBF_REG_BTB_GUARANTEED_VOQ9_RT_OFFSET                       34439
#define PBF_REG_BTB_SHARED_AREA_SETUP_VOQ9_RT_OFFSET                34440
#define PBF_REG_YCMD_QS_NUM_LINES_VOQ10_RT_OFFSET                   34441
#define PBF_REG_BTB_GUARANTEED_VOQ10_RT_OFFSET                      34442
#define PBF_REG_BTB_SHARED_AREA_SETUP_VOQ10_RT_OFFSET               34443
#define PBF_REG_YCMD_QS_NUM_LINES_VOQ11_RT_OFFSET                   34444
#define PBF_REG_BTB_GUARANTEED_VOQ11_RT_OFFSET                      34445
#define PBF_REG_BTB_SHARED_AREA_SETUP_VOQ11_RT_OFFSET               34446
#define PBF_REG_YCMD_QS_NUM_LINES_VOQ12_RT_OFFSET                   34447
#define PBF_REG_BTB_GUARANTEED_VOQ12_RT_OFFSET                      34448
#define PBF_REG_BTB_SHARED_AREA_SETUP_VOQ12_RT_OFFSET               34449
#define PBF_REG_YCMD_QS_NUM_LINES_VOQ13_RT_OFFSET                   34450
#define PBF_REG_BTB_GUARANTEED_VOQ13_RT_OFFSET                      34451
#define PBF_REG_BTB_SHARED_AREA_SETUP_VOQ13_RT_OFFSET               34452
#define PBF_REG_YCMD_QS_NUM_LINES_VOQ14_RT_OFFSET                   34453
#define PBF_REG_BTB_GUARANTEED_VOQ14_RT_OFFSET                      34454
#define PBF_REG_BTB_SHARED_AREA_SETUP_VOQ14_RT_OFFSET               34455
#define PBF_REG_YCMD_QS_NUM_LINES_VOQ15_RT_OFFSET                   34456
#define PBF_REG_BTB_GUARANTEED_VOQ15_RT_OFFSET                      34457
#define PBF_REG_BTB_SHARED_AREA_SETUP_VOQ15_RT_OFFSET               34458
#define PBF_REG_YCMD_QS_NUM_LINES_VOQ16_RT_OFFSET                   34459
#define PBF_REG_BTB_GUARANTEED_VOQ16_RT_OFFSET                      34460
#define PBF_REG_BTB_SHARED_AREA_SETUP_VOQ16_RT_OFFSET               34461
#define PBF_REG_YCMD_QS_NUM_LINES_VOQ17_RT_OFFSET                   34462
#define PBF_REG_BTB_GUARANTEED_VOQ17_RT_OFFSET                      34463
#define PBF_REG_BTB_SHARED_AREA_SETUP_VOQ17_RT_OFFSET               34464
#define PBF_REG_YCMD_QS_NUM_LINES_VOQ18_RT_OFFSET                   34465
#define PBF_REG_BTB_GUARANTEED_VOQ18_RT_OFFSET                      34466
#define PBF_REG_BTB_SHARED_AREA_SETUP_VOQ18_RT_OFFSET               34467
#define PBF_REG_YCMD_QS_NUM_LINES_VOQ19_RT_OFFSET                   34468
#define PBF_REG_BTB_GUARANTEED_VOQ19_RT_OFFSET                      34469
#define PBF_REG_BTB_SHARED_AREA_SETUP_VOQ19_RT_OFFSET               34470
#define XCM_REG_CON_PHY_Q3_RT_OFFSET                                34471

#define RUNTIME_ARRAY_SIZE 34472

/* Init Callbacks */
#define DMAE_READY_CB                                               0

#endif /* __RT_DEFS_H__ */
