/*   -*- buffer-read-only: t -*- vi: set ro:
 *
 *  DO NOT EDIT THIS FILE   (functions.h)
 *
 *  It has been AutoGen-ed
 *  From the definitions    functions.def
 *  and the template file   functions.tpl
 */
/** \file functions.h
 *
 *  Tables of Text Functions for AutoGen
 *
 *  Copyright (C) 1992-2014 by Bruce Korb - all rights reserved
 *
 *  AutoGen is free software: you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  AutoGen is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  The 24 AutoGen macros are tagged with special attributes:
 *
 *  A - is invoked via an alias
 *
 *  U - is unnamed.  May *not* be explicitly invoked.  May not have
 *      have an alias.  These three are used by AutoGen for its purposes.
 *
 *  L - has a special load procedure defined
 *
 *  C - in context.  May be explicitly invoked in certain situations.
 *      For example, "ELSE" may only be specified within an "IF" block.
 *      Their load procedures are enabled by the block macro (e.g. IF),
 *      and disabled by the block ending macro (e.g. ENDIF).
 *      While disabled, the load procedure is the "Bogus" method.
 *
 *      If a function is neither has a special load procedure nor is
 *      situational, then the "Unknown" load method is applied.
 *
 *  R - has a special remove (unload) procedure
 *
 *  H - has a handler procedure defined.  Only these procedures should
 *      be encountered by the dispatcher during processing.
 *
 *  U L   H - BOGUS     Out-of-context or unknown functions are bogus.
 *    L   H - BREAK     Leave a FOR or WHILE macro
 *    L   H - CASE      Select one of several template blocks
 *  A L     - COMMENT   A block of comment to be ignored
 *    L   H - CONTINUE  Skip to end of a FOR or WHILE macro.
 *    L   H - DEBUG     Print debug message to trace output
 *    L R H - DEFINE    Define a user AutoGen macro
 *    C     - ELIF      Alternate Conditional Template Block
 *    C     - ELSE      Alternate Template Block
 *    C     - ENDDEF    Ends a macro definition.
 *    C     - ENDFOR    Terminates the @code{FOR} function template block
 *    C     - ENDIF     Terminate the @code{IF} Template Block
 *    C     - ENDWHILE  Terminate the @code{WHILE} Template Block
 *    C     - ESAC      Terminate the @code{CASE} Template Block
 *  A L   H - EXPR      Evaluate and emit an Expression
 *    L   H - FOR       Emit a template block multiple times
 *    L   H - IF        Conditionally Emit a Template Block
 *    L   H - INCLUDE   Read in and emit a template block
 *        H - INVOKE    Invoke a User Defined Macro
 *    L   H - RETURN    Leave an INVOKE-d (DEFINE) macro
 *  A C R   - SELECT    Selection block for CASE function
 *  U     H - TEXT      A block of text to be emitted.
 *  U L   H - UNKNOWN   Either a user macro or a value name.
 *    L   H - WHILE     Conditionally loop over a Template Block
 *
 * @addtogroup autogen
 * @{
 */
#ifndef AUTOGEN_FUNCTIONS_H_GUARD
#define AUTOGEN_FUNCTIONS_H_GUARD 1
/**
 * The number of native AutoGen functions, omitting the
 * comparison type / selection functions.
 */
#define FUNC_CT    24

/**
 *  Enumerate all the AutoGen macro types.
 */
typedef enum {
    FTYP_BOGUS,    FTYP_BREAK,    FTYP_CASE,     FTYP_COMMENT,  FTYP_CONTINUE,
    FTYP_DEBUG,    FTYP_DEFINE,   FTYP_ELIF,     FTYP_ELSE,     FTYP_ENDDEF,
    FTYP_ENDFOR,   FTYP_ENDIF,    FTYP_ENDWHILE, FTYP_ESAC,     FTYP_EXPR,
    FTYP_FOR,      FTYP_IF,       FTYP_INCLUDE,  FTYP_INVOKE,   FTYP_RETURN,
    FTYP_SELECT,   FTYP_TEXT,     FTYP_UNKNOWN,  FTYP_WHILE,

    FTYP_SELECT_COMPARE_FULL          = 0x8000,  /* *==* */
    FTYP_SELECT_COMPARE_SKP_START     = 0x8001,  /* *==  */
    FTYP_SELECT_COMPARE_SKP_END       = 0x8002,  /*  ==* */
    FTYP_SELECT_COMPARE               = 0x8003,  /*  ==  */

    FTYP_SELECT_EQUIVALENT_FULL       = 0x8004,  /* *=*  */
    FTYP_SELECT_EQUIVALENT_SKP_START  = 0x8005,  /* *=   */
    FTYP_SELECT_EQUIVALENT_SKP_END    = 0x8006,  /*  =*  */
    FTYP_SELECT_EQUIVALENT            = 0x8007,  /*  =   */

    FTYP_SELECT_MATCH_FULL            = 0x8008,  /* *~~* */
    FTYP_SELECT_MATCH_SKP_START       = 0x8009,  /* *~~  */
    FTYP_SELECT_MATCH_SKP_END         = 0x800A,  /*  ~~* */
    FTYP_SELECT_MATCH                 = 0x800B,  /*  ~~  */

    FTYP_SELECT_EQV_MATCH_FULL        = 0x800C,  /* *~*  */
    FTYP_SELECT_EQV_MATCH_SKP_START   = 0x800D,  /* *~   */
    FTYP_SELECT_EQV_MATCH_SKP_END     = 0x800E,  /*  ~*  */
    FTYP_SELECT_EQV_MATCH             = 0x800F,  /*  ~   */

    FTYP_SELECT_MATCH_ANYTHING        = 0x801C,  /*  *   */
    FTYP_SELECT_MATCH_EXISTENCE       = 0x801D,  /* +E   */
    FTYP_SELECT_MATCH_NONEXISTENCE    = 0x801E   /* !E   */
} mac_func_t;

/**
 *  The function processing procedures.
 */
hdlr_proc_t
    mFunc_Bogus,   mFunc_Break,   mFunc_Case,    mFunc_Debug,   mFunc_Define,
    mFunc_Expr,    mFunc_For,     mFunc_If,      mFunc_Include, mFunc_Invoke,
    mFunc_Return,  mFunc_Text,    mFunc_Unknown, mFunc_While;

/**
 *  Template Loading Functions.
 */
load_proc_t
    mLoad_Bogus,   mLoad_Case,    mLoad_Comment, mLoad_Debug,   mLoad_Define,
    mLoad_Ending,  mLoad_Expr,    mLoad_For,     mLoad_If,      mLoad_Leave,
    mLoad_Unknown, mLoad_While;

/* tpParse.c use only * * * * * * * * * * * * * * * */
/**
 *  Parsing function tables for load processing (template scanning phase).
 */
static load_proc_p_t const base_load_table[FUNC_CT] = {
    /* BOGUS    */ mLoad_Bogus,
    /* BREAK    */ mLoad_Leave,
    /* CASE     */ mLoad_Case,
    /* COMMENT  */ mLoad_Comment,
    /* CONTINUE */ mLoad_Leave,
    /* DEBUG    */ mLoad_Debug,
    /* DEFINE   */ mLoad_Define,
    /* ELIF     */ mLoad_Bogus    /*dynamic*/,
    /* ELSE     */ mLoad_Bogus    /*dynamic*/,
    /* ENDDEF   */ mLoad_Bogus    /*dynamic*/,
    /* ENDFOR   */ mLoad_Bogus    /*dynamic*/,
    /* ENDIF    */ mLoad_Bogus    /*dynamic*/,
    /* ENDWHILE */ mLoad_Bogus    /*dynamic*/,
    /* ESAC     */ mLoad_Bogus    /*dynamic*/,
    /* EXPR     */ mLoad_Expr,
    /* FOR      */ mLoad_For,
    /* IF       */ mLoad_If,
    /* INCLUDE  */ mLoad_Expr,
    /* INVOKE   */ mLoad_Unknown  /*default*/,
    /* RETURN   */ mLoad_Leave,
    /* SELECT   */ mLoad_Bogus    /*dynamic*/,
    /* TEXT     */ mLoad_Unknown  /*default*/,
    /* UNKNOWN  */ mLoad_Unknown,
    /* WHILE    */ mLoad_While
};

/**
 *  This global pointer is used to switch parsing tables.  The block
 *  functions (CASE, DEFINE, FOR, and IF) change this to point
 *  to their tables that include relevant additional functions.
 */
load_proc_p_t const * load_proc_table = base_load_table;

/**
 *  name-to-function type mapping table.
 *  This table must be sorted alphabetically by the content
 *  of the naming string.
 */
typedef struct fn_name_type fn_name_type_t;
struct fn_name_type {
    size_t        cmpLen;  //!< compare length (sans NUL)
    char const *  pName;   //!< ptr to name
    mac_func_t    fType;   //!< function type enum
};

/**
 *  Define all the strings that are used to determine the function enumeration
 *  number.  These are used in a table separated by aliases and sorted by these
 *  ASCII values.
 */
static char const zFnStrg[144] =
    "BREAK\0"    "CASE\0"     "#\0"        "CONTINUE\0" "DEBUG\0"
    "DEFINE\0"   "ELIF\0"     "ELSE\0"     "ENDDEF\0"   "ENDFOR\0"
    "ENDIF\0"    "ENDWHILE\0" "ESAC\0"     "-\0"        "?\0"
    "%\0"        ";\0"        "(\0"        "`\0"        "\"\0"
    "'\0"        ".\0"        "{\0"        "FOR\0"      "IF\0"
    "INCLUDE\0"  "INVOKE\0"   "RETURN\0"   "~\0"        "=\0"
    "*\0"        "!\0"        "+\0"        "WHILE\0";

/**
 *  The number of names by which the macros go.
 *  Some have multiple names (aliases, e.g. selection clauses).
 */
#define FUNC_ALIAS_LOW_INDEX    0
#define FUNC_ALIAS_HIGH_INDEX   15
#define FUNC_NAMES_LOW_INDEX    16
#define FUNC_NAMES_HIGH_INDEX   33
#define FUNCTION_NAME_CT        34

/* * * * * * * * tpParse.c use only * * * * * * * * * * * * * * */
/**
 *  The table separated by aliasing and then sorted by string content
 */
static fn_name_type_t const fn_name_types[FUNCTION_NAME_CT] = {
    {  1, zFnStrg +134, FTYP_SELECT },
    {  1, zFnStrg + 91, FTYP_EXPR },
    {  1, zFnStrg + 11, FTYP_COMMENT },
    {  1, zFnStrg + 83, FTYP_EXPR },
    {  1, zFnStrg + 93, FTYP_EXPR },
    {  1, zFnStrg + 87, FTYP_EXPR },
    {  1, zFnStrg +132, FTYP_SELECT },
    {  1, zFnStrg +136, FTYP_SELECT },
    {  1, zFnStrg + 79, FTYP_EXPR },
    {  1, zFnStrg + 95, FTYP_EXPR },
    {  1, zFnStrg + 85, FTYP_EXPR },
    {  1, zFnStrg +130, FTYP_SELECT },
    {  1, zFnStrg + 81, FTYP_EXPR },
    {  1, zFnStrg + 89, FTYP_EXPR },
    {  1, zFnStrg + 97, FTYP_EXPR },
    {  1, zFnStrg +128, FTYP_SELECT },

    {  5, zFnStrg +  0, FTYP_BREAK },
    {  4, zFnStrg +  6, FTYP_CASE },
    {  8, zFnStrg + 13, FTYP_CONTINUE },
    {  5, zFnStrg + 22, FTYP_DEBUG },
    {  6, zFnStrg + 28, FTYP_DEFINE },
    {  4, zFnStrg + 35, FTYP_ELIF },
    {  4, zFnStrg + 40, FTYP_ELSE },
    {  6, zFnStrg + 45, FTYP_ENDDEF },
    {  6, zFnStrg + 52, FTYP_ENDFOR },
    {  5, zFnStrg + 59, FTYP_ENDIF },
    {  8, zFnStrg + 65, FTYP_ENDWHILE },
    {  4, zFnStrg + 74, FTYP_ESAC },
    {  3, zFnStrg + 99, FTYP_FOR },
    {  2, zFnStrg +103, FTYP_IF },
    {  7, zFnStrg +106, FTYP_INCLUDE },
    {  6, zFnStrg +114, FTYP_INVOKE },
    {  6, zFnStrg +121, FTYP_RETURN },
    {  5, zFnStrg +138, FTYP_WHILE } };

static char const * const ag_fun_names[FUNC_CT] = {
    "Bogus",     zFnStrg+0,   zFnStrg+6,   "COMMENT",   zFnStrg+13,
    zFnStrg+22,  zFnStrg+28,  zFnStrg+35,  zFnStrg+40,  zFnStrg+45,
    zFnStrg+52,  zFnStrg+59,  zFnStrg+65,  zFnStrg+74,  "EXPR",
    zFnStrg+99,  zFnStrg+103, zFnStrg+106, zFnStrg+114, zFnStrg+121,
    "SELECT",    "Text",      "Unknown",   zFnStrg+138 };

/* * * * * * * * tpProcess.c use only * * * * * * * * * * * * * */
/**
 *  Template Processing Function Table
 *
 *  Pointers to the procedure to call when the function code
 *  is encountered.
 */
static hdlr_proc_p_t const load_procs[FUNC_CT] = {
    /* BOGUS    */ mFunc_Bogus,
    /* BREAK    */ mFunc_Break,
    /* CASE     */ mFunc_Case,
    /* COMMENT  */ mFunc_Bogus,
    /* CONTINUE */ mFunc_Break,
    /* DEBUG    */ mFunc_Debug,
    /* DEFINE   */ mFunc_Define,
    /* ELIF     */ mFunc_Bogus,
    /* ELSE     */ mFunc_Bogus,
    /* ENDDEF   */ mFunc_Bogus,
    /* ENDFOR   */ mFunc_Bogus,
    /* ENDIF    */ mFunc_Bogus,
    /* ENDWHILE */ mFunc_Bogus,
    /* ESAC     */ mFunc_Bogus,
    /* EXPR     */ mFunc_Expr,
    /* FOR      */ mFunc_For,
    /* IF       */ mFunc_If,
    /* INCLUDE  */ mFunc_Include,
    /* INVOKE   */ mFunc_Invoke,
    /* RETURN   */ mFunc_Return,
    /* SELECT   */ mFunc_Bogus,
    /* TEXT     */ mFunc_Text,
    /* UNKNOWN  */ mFunc_Unknown,
    /* WHILE    */ mFunc_While
};

/* * * * * * * * * * tpLoad.c use only * * * * * * * * * * * * * */
/**
 *  Template Unloading Function Table
 *
 *  Pointers to the procedure to call when the function code
 *  is encountered in a template being unloaded.
 */
unload_proc_t mUnload_Define, mUnload_Select;

static unload_proc_p_t const unload_procs[FUNC_CT] = {
    NULL,           NULL,           NULL,           NULL,
    NULL,           NULL,           mUnload_Define, NULL,
    NULL,           NULL,           NULL,           NULL,
    NULL,           NULL,           NULL,           NULL,
    NULL,           NULL,           NULL,           NULL,
    mUnload_Select, NULL,           NULL,           NULL };

#define FUNCTION_CKSUM 0x9B56

#endif /* AUTOGEN_FUNCTIONS_H_GUARD */
/** @} */
/* end of functions.h */
