\name{SliceImageFilter}
\alias{SliceImageFilter}
\title{SliceImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Slices an image based on a starting index and a stopping index, and a
step size.
SliceImageFilter}
\details{
This class is designed to facilitate the implementation of extended
sliced based indexing into images.
The input and output image must be of the same dimension.
The input parameters are a starting and stopping index as well as a
stepping size. The starting index indicates the first pixels to be
used and for each dimension the index is incremented by the step until
the index is equal to or "beyond" the stopping index. If the step is
negative then the image will be reversed in the dimension, and the
stopping index is expected to be less then the starting index. If the
stopping index is already beyond the starting index then an image of
size zero will be returned.
The output image's starting index is always zero. The origin is the
physical location of the starting index. The output directions cosine
matrix is that of the input but with sign changes matching that of the
step's sign.
In certain combinations such as with start=1, and step>1 while the
physical location of the center of the pixel remains the same, the
extent (edge to edge space) of the output image will be beyond the
extent of the original image.
See:
Slice for the procedural interface
itk::SliceImageFilter for the Doxygen on the original ITK class.
SliceImageFilter}
%C++ includes: sitkSliceImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{std::string GetName() const:}{
Name of this class
}
\item{std::vector< int32_t > GetStart() const:}{
Set/Get the first index extracted from the input image
}
\item{std::vector< int > GetStep() const:}{
Set/Get the stride of indexes extracted An exception will be generated
if 0.
}
\item{std::vector< int32_t > GetStop() const:}{
Set/Get the excluded end of the range
}
\item{Self SetStart(std::vector< int32_t > Start):}{
Set/Get the first index extracted from the input image
}
\item{Self SetStep(int value):}{
Set the values of the Step vector all to value
}
\item{Self SetStep(std::vector< int > Step):}{
Set/Get the stride of indexes extracted An exception will be generated
if 0.
}
\item{Self SetStop(std::vector< int32_t > Stop):}{
Set/Get the excluded end of the range
}
\item{ SliceImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~SliceImageFilter():}{
Destructor
}
}
}
