/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import uk.ac.manchester.cs.owl.owlapi.OWLClassAxiomImpl;

public class OWLSubClassOfAxiomImpl
extends OWLClassAxiomImpl
implements OWLSubClassOfAxiom {
    private static final long serialVersionUID = 40000L;
    @Nonnull
    private final OWLClassExpression subClass;
    @Nonnull
    private final OWLClassExpression superClass;

    public OWLSubClassOfAxiomImpl(@Nonnull OWLClassExpression subClass, @Nonnull OWLClassExpression superClass, @Nonnull Collection<? extends OWLAnnotation> annotations) {
        super(annotations);
        this.subClass = OWLAPIPreconditions.checkNotNull(subClass, "subClass cannot be null");
        this.superClass = OWLAPIPreconditions.checkNotNull(superClass, "superClass cannot be null");
    }

    @Override
    public OWLSubClassOfAxiom getAnnotatedAxiom(@Nonnull Set<OWLAnnotation> annotations) {
        return new OWLSubClassOfAxiomImpl(this.subClass, this.superClass, this.mergeAnnos(annotations));
    }

    @Override
    public OWLSubClassOfAxiom getAxiomWithoutAnnotations() {
        if (!this.isAnnotated()) {
            return this;
        }
        return new OWLSubClassOfAxiomImpl(this.subClass, this.superClass, NO_ANNOTATIONS);
    }

    @Override
    public OWLClassExpression getSubClass() {
        return this.subClass;
    }

    @Override
    public OWLClassExpression getSuperClass() {
        return this.superClass;
    }

    @Override
    public boolean isGCI() {
        return this.subClass.isAnonymous();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof OWLSubClassOfAxiom)) {
            return false;
        }
        OWLSubClassOfAxiom other = (OWLSubClassOfAxiom)obj;
        return other.getSubClass().equals(this.subClass) && other.getSuperClass().equals(this.superClass);
    }

    @Override
    public void accept(OWLAxiomVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void accept(OWLObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLAxiomVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public AxiomType<?> getAxiomType() {
        return AxiomType.SUBCLASS_OF;
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        OWLSubClassOfAxiom other = (OWLSubClassOfAxiom)object;
        int diff = this.subClass.compareTo(other.getSubClass());
        if (diff != 0) {
            return diff;
        }
        return this.superClass.compareTo(other.getSuperClass());
    }
}

