/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.deprecation;

import com.google.common.base.Preconditions;
import java.awt.BorderLayout;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JPanel;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.conf.valueset.LabelledValue;
import org.protege.editor.owl.model.conf.valueset.ValueSetComponent;
import org.protege.editor.owl.ui.AbstractOWLWizardPanel;
import org.protege.editor.owl.ui.deprecation.DeprecateEntityWizardState;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLDataFactory;

public class DeprecationCodePage
extends AbstractOWLWizardPanel {
    public static final String ID = "DeprecationCodePage";
    private final DeprecateEntityWizardState wizardState;
    private final ValueSetComponent component = new ValueSetComponent();

    public DeprecationCodePage(@Nonnull OWLEditorKit owlEditorKit, @Nonnull DeprecateEntityWizardState wizardState) {
        super(ID, "Deprecation code", owlEditorKit);
        this.setInstructions("<b>Please select a reason for the deprecation</b>");
        this.wizardState = (DeprecateEntityWizardState)Preconditions.checkNotNull((Object)wizardState);
        JPanel contentHolder = new JPanel(new BorderLayout());
        contentHolder.add(this.component);
        this.setContent(contentHolder);
    }

    public void aboutToDisplayPanel() {
        this.wizardState.getDeprecationProfile().ifPresent(profile -> profile.getDeprecationCode().ifPresent(code -> {
            List<LabelledValue> values = code.getValueSet().getLabelledValues(this.getOWLModelManager());
            this.component.setValues(values);
            for (int i = 0; i < values.size(); ++i) {
                LabelledValue v = values.get(i);
                Optional<OWLAnnotationValue> annoValue = v.toOWLAnnotationValue(this.getOwlDataFactory());
                if (!annoValue.equals(this.wizardState.getDeprecationCode())) continue;
                this.component.setSelectedIndex(i);
                break;
            }
        }));
    }

    private OWLDataFactory getOwlDataFactory() {
        return this.getOWLModelManager().getOWLDataFactory();
    }

    public void aboutToHidePanel() {
        this.wizardState.setDeprecationCode(null);
        this.component.getSelectedValue().flatMap(v -> v.toOWLAnnotationValue(this.getOwlDataFactory())).ifPresent(this.wizardState::setDeprecationCode);
    }

    @Nullable
    public Object getBackPanelDescriptor() {
        return "DeprecationReason";
    }

    @Nullable
    public Object getNextPanelDescriptor() {
        return "DeprecationReplacementEntityPage";
    }
}

