/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.tree;

import com.amazon.randomcutforest.store.IndexIntervalManager;
import com.amazon.randomcutforest.tree.AbstractNodeStore;
import com.amazon.randomcutforest.tree.BoundingBox;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Stack;

public class NodeStoreLarge
extends AbstractNodeStore {
    private final int[] parentIndex;
    private final int[] leftIndex;
    private final int[] rightIndex;
    public final int[] cutDimension;
    private final int[] mass;

    public NodeStoreLarge(AbstractNodeStore.Builder builder) {
        super(builder);
        this.mass = new int[this.capacity];
        Arrays.fill(this.mass, 0);
        if (builder.storeParent) {
            this.parentIndex = new int[this.capacity];
            Arrays.fill(this.parentIndex, this.capacity);
        } else {
            this.parentIndex = null;
        }
        if (builder.leftIndex == null) {
            this.leftIndex = new int[this.capacity];
            this.rightIndex = new int[this.capacity];
            this.cutDimension = new int[this.capacity];
            Arrays.fill(this.leftIndex, this.capacity);
            Arrays.fill(this.rightIndex, this.capacity);
        } else {
            int i;
            this.leftIndex = Arrays.copyOf(builder.leftIndex, builder.leftIndex.length);
            this.rightIndex = Arrays.copyOf(builder.rightIndex, builder.rightIndex.length);
            this.cutDimension = Arrays.copyOf(builder.cutDimension, builder.cutDimension.length);
            BitSet bits = new BitSet(this.capacity);
            if (builder.root != Null) {
                bits.set(builder.root);
            }
            for (i = 0; i < this.leftIndex.length; ++i) {
                if (!this.isInternal(this.leftIndex[i])) continue;
                bits.set(this.leftIndex[i]);
                if (this.parentIndex == null) continue;
                this.parentIndex[this.leftIndex[i]] = i;
            }
            for (i = 0; i < this.rightIndex.length; ++i) {
                if (!this.isInternal(this.rightIndex[i])) continue;
                bits.set(this.rightIndex[i]);
                if (this.parentIndex == null) continue;
                this.parentIndex[this.rightIndex[i]] = i;
            }
            this.freeNodeManager = new IndexIntervalManager(this.capacity, this.capacity, bits);
        }
    }

    @Override
    public int addNode(Stack<int[]> pathToRoot, float[] point, long sequenceIndex, int pointIndex, int childIndex, int cutDimension, float cutValue, BoundingBox box) {
        int parentIndex;
        int index = this.freeNodeManager.takeIndex();
        this.cutValue[index] = cutValue;
        this.cutDimension[index] = (byte)cutDimension;
        if (this.leftOf(cutValue, cutDimension, point)) {
            this.leftIndex[index] = pointIndex + this.capacity + 1;
            this.rightIndex[index] = childIndex;
        } else {
            this.rightIndex[index] = pointIndex + this.capacity + 1;
            this.leftIndex[index] = childIndex;
        }
        this.mass[index] = (this.getMass(childIndex) + 1) % (this.capacity + 1);
        this.addLeaf(pointIndex, sequenceIndex);
        int n = parentIndex = pathToRoot.size() == 0 ? Null : ((int[])pathToRoot.lastElement())[0];
        if (this.parentIndex != null) {
            this.parentIndex[index] = parentIndex;
            if (!this.isLeaf(childIndex)) {
                this.parentIndex[childIndex] = index;
            }
        }
        this.addBox(index, point, box);
        if (parentIndex != Null) {
            this.spliceEdge(parentIndex, childIndex, index);
            this.manageAncestorsAdd(pathToRoot, point, this.pointStoreView);
        }
        if (this.pointSum != null) {
            this.recomputePointSum(index);
        }
        return index;
    }

    @Override
    public int getLeftIndex(int index) {
        return this.leftIndex[index];
    }

    @Override
    public int getRightIndex(int index) {
        return this.rightIndex[index];
    }

    @Override
    public void setRoot(int index) {
        if (!this.isLeaf(index) && this.parentIndex != null) {
            this.parentIndex[index] = this.capacity;
        }
    }

    @Override
    protected void decreaseMassOfInternalNode(int node) {
        this.mass[node] = (this.mass[node] + this.capacity) % (this.capacity + 1);
    }

    @Override
    protected void increaseMassOfInternalNode(int node) {
        this.mass[node] = (this.mass[node] + 1) % (this.capacity + 1);
    }

    @Override
    public void deleteInternalNode(int index) {
        int idx;
        this.leftIndex[index] = this.capacity;
        this.rightIndex[index] = this.capacity;
        if (this.parentIndex != null) {
            this.parentIndex[index] = this.capacity;
        }
        if (this.pointSum != null) {
            this.invalidatePointSum(index);
        }
        if ((idx = this.translate(index)) != Integer.MAX_VALUE) {
            this.rangeSumData[idx] = 0.0;
        }
        this.freeNodeManager.releaseIndex(index);
    }

    @Override
    public int getMass(int index) {
        return this.isLeaf(index) ? this.getLeafMass(index) : (this.mass[index] != 0 ? this.mass[index] : this.capacity + 1);
    }

    @Override
    public void spliceEdge(int parent, int node, int newNode) {
        assert (!this.isLeaf(newNode));
        if (node == this.leftIndex[parent]) {
            this.leftIndex[parent] = newNode;
        } else {
            this.rightIndex[parent] = newNode;
        }
        if (this.parentIndex != null && this.isInternal(node)) {
            this.parentIndex[node] = newNode;
        }
    }

    @Override
    public void replaceParentBySibling(int grandParent, int parent, int node) {
        int sibling = this.getSibling(node, parent);
        if (parent == this.leftIndex[grandParent]) {
            this.leftIndex[grandParent] = sibling;
        } else {
            this.rightIndex[grandParent] = sibling;
        }
        if (this.parentIndex != null && this.isInternal(sibling)) {
            this.parentIndex[sibling] = grandParent;
        }
    }

    @Override
    public int getCutDimension(int index) {
        return this.cutDimension[index];
    }

    @Override
    public int[] getCutDimension() {
        return Arrays.copyOf(this.cutDimension, this.cutDimension.length);
    }

    @Override
    public int[] getLeftIndex() {
        return Arrays.copyOf(this.leftIndex, this.leftIndex.length);
    }

    @Override
    public int[] getRightIndex() {
        return Arrays.copyOf(this.rightIndex, this.rightIndex.length);
    }

    @Override
    public void addToPartialTree(Stack<int[]> pathToRoot, float[] point, int pointIndex) {
        int node = ((int[])pathToRoot.lastElement())[0];
        if (this.leftOf(node, point)) {
            this.leftIndex[node] = pointIndex + this.capacity + 1;
        } else {
            this.rightIndex[node] = pointIndex + this.capacity + 1;
        }
        this.manageAncestorsAdd(pathToRoot, point, this.pointStoreView);
    }
}

